/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.video;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.util.Log;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.view.GestureDetectorCompat;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.layer.SeatLayer;
import com.baijiayun.groupclassui.util.FECompatUtil;
import com.baijiayun.groupclassui.window.BaseTitledWindow;
import com.baijiayun.groupclassui.window.video.VideoWindow;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livecore.models.LPPlayerViewUpdateModel;
import com.baijiayun.livecore.models.imodels.IMediaModel;
import com.baijiayun.liveuibase.base.BaseWindow;
import com.baijiayun.liveuibase.utils.ShadowUtil;
import java.lang.ref.WeakReference;

public class VideoContainerWindow
extends BaseTitledWindow {
    private final String TAG = VideoWindow.class.getCanonicalName();
    private FrameLayout flContainer;
    private VideoWindow videoWindow;
    private IMediaModel iMediaModel;
    private WeakReference<SeatLayer> seatLayerWeakReference;
    private boolean isJoinBlackboard;
    public static final float PRESS_SCALE_RATIO = 1.2f;
    public static final float JOIN_BLACKBOARD_RATIO = 1.7f;
    public static final float ONE2ONE_PRESS_SCALE_RATIO = 1.1f;
    public static final float ONE2ONE_JOIN_SCALE_RATIO_PAD = 1.3f;
    private float startScale;
    private float endScale;

    public VideoContainerWindow(Context context, @NonNull VideoWindow videoWindow) {
        this(context, videoWindow, true);
    }

    public VideoContainerWindow(Context context, @NonNull VideoWindow videoWindow, boolean isJoinBlackboard) {
        super(context);
        this.videoWindow = videoWindow;
        this.isJoinBlackboard = isJoinBlackboard;
        this.showTopContainer(false);
        if (isJoinBlackboard) {
            this.showScaleIcon(this.isAdmin());
            videoWindow.setJoinBlackboard(true);
            this.boundView = ShadowUtil.setViewBoundShadow((View)this.view, (int)UtilsKt.getDp((int)8), (int)Color.parseColor((String)"#000F0F0F"), (int)Color.parseColor((String)"#0C0F0F0F"), (ShadowUtil)ShadowUtil.Create());
        } else {
            this.showScaleIcon(false);
        }
        this.initView();
        this.initListener();
        if (this.iRouter.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE) {
            ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.$.id(R.id.window_video_container_to_seat_placeholder).view().getLayoutParams();
            layoutParams.matchConstraintPercentWidth = 0.5f;
            layoutParams.matchConstraintPercentHeight = 0.5f;
            this.startScale = 1.1f;
            this.endScale = 1.1f;
            if (DisplayUtils.isPad((Context)context)) {
                this.endScale = 1.3f;
            }
            ((TextView)this.$.id(R.id.window_video_resume_button).view()).setTextSize(2, 12.0f);
        } else {
            this.startScale = 1.2f;
            this.endScale = 1.7f;
        }
    }

    @Override
    protected void onCreateContentView(Context context) {
        this.setNeedShowShadow(false);
        this.dragScaleRelativeLayout.setForceNotConsume(true);
        LayoutInflater.from((Context)context).inflate(R.layout.bjy_group_window_video_container, (ViewGroup)this.rlContentContainer);
    }

    @Override
    public void maxInSync() {
        super.maxInSync();
        this.ivMaxSync.setVisibility(8);
        this.dragScaleRelativeLayout.setVisibility(0);
        this.showBoundView(false);
    }

    @Override
    public void resetInSync() {
        super.resetInSync();
        this.ivMaxSync.setVisibility(8);
        this.dragScaleRelativeLayout.setVisibility(0);
        this.showBoundView(true);
    }

    @Override
    public void maxInFull() {
        super.maxInFull();
        this.ivMaxFull.setVisibility(8);
        this.dragScaleRelativeLayout.setVisibility(0);
        this.showBoundView(false);
    }

    @Override
    public void resetInFull() {
        super.resetInFull();
        this.ivMaxFull.setVisibility(8);
        this.dragScaleRelativeLayout.setVisibility(0);
        if (!this.isMaxInSync) {
            this.showBoundView(true);
        }
    }

    @Override
    public void minInSync() {
        this.dragScaleRelativeLayout.setVisibility(8);
        this.isMinInSync = true;
        if (this.isMaxInFull) {
            this.iRouter.getSubjectByKey(EventKey.SetFullScreenWindowOff).onNext((Object)this);
        }
    }

    private void showBoundView(boolean show) {
        if (this.boundView != null && this.boundView.getShadowView() != null) {
            this.boundView.getShadowView().setVisibility(show ? 0 : 8);
        }
    }

    @Override
    public void resetMinInSync() {
        this.dragScaleRelativeLayout.setVisibility(0);
        this.isMinInSync = false;
    }

    private void initView() {
        if (this.videoWindow.getView() == null) {
            return;
        }
        this.flContainer = (FrameLayout)this.$.id(R.id.window_video_container_fl).view();
        if (this.videoWindow.getView() != null && this.videoWindow.getView().getParent() != null) {
            ((ViewGroup)this.videoWindow.getView().getParent()).removeAllViews();
        }
        this.flContainer.addView(this.videoWindow.getView(), new ViewGroup.LayoutParams(-1, -1));
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void initListener() {
        this.setOnSingleTapListener(e -> {
            if (!this.isJoinBlackboard) {
                return;
            }
            if (this.videoWindow != null && this.videoWindow.isShowMenu() && this.isJoinedBlackboard() && this.videoWindow.getView() != null) {
                this.videoWindow.showMenu((int)e.getRawX() + UtilsKt.getDp((int)40), (int)e.getRawY() + UtilsKt.getDp((int)2));
            }
            if (!this.isAdmin()) {
                return;
            }
            this.iRouter.getSubjectByKey(EventKey.StickVideoWindow).onNext((Object)this.getPlayerPosition());
        });
        this.setOnWindowRepositionListener(new BaseWindow.OnWindowRepositionListener(){

            public void onWindowMove(int x, int y) {
                VideoContainerWindow.this.iRouter.getSubjectByKey(EventKey.MoveVideoWindow).onNext((Object)VideoContainerWindow.this.getPlayerPosition());
            }

            public void OnWindowScale(int newWidth, int newHeight) {
                VideoContainerWindow.this.iRouter.getSubjectByKey(EventKey.MoveVideoWindow).onNext((Object)VideoContainerWindow.this.getPlayerPosition());
            }
        });
        this.ivClose.setOnClickListener(v -> {
            if (!this.isAdmin()) {
                return;
            }
            this.iRouter.getSubjectByKey(EventKey.CloseVideoWindow).onNext((Object)this.videoWindow.getMediaId());
        });
        this.$.id(R.id.window_video_resume_button).view().setOnClickListener(v -> this.iRouter.getSubjectByKey(EventKey.RemoveAllBlackboardVideoWindow).onNext((Object)false));
        this.$.id(R.id.window_video_container_back_to_seat).clicked(v -> {
            if (!this.isAdmin()) {
                return;
            }
            this.iRouter.getSubjectByKey(EventKey.CloseVideoWindow).onNext((Object)this.videoWindow.getMediaId());
        });
        if (!this.isJoinBlackboard) {
            GestureListener gestureListener = new GestureListener(this);
            GestureDetectorCompat gestureDetector = new GestureDetectorCompat(this.getView().getContext(), (GestureDetector.OnGestureListener)gestureListener);
            this.getView().setOnTouchListener((v, event) -> {
                if (this.seatLayerWeakReference == null) {
                    return true;
                }
                SeatLayer seatLayer = (SeatLayer)this.seatLayerWeakReference.get();
                switch (event.getAction()) {
                    case 2: {
                        if (!gestureListener.isLongPress) {
                            return true;
                        }
                        if (seatLayer.getDragLayer() == null) break;
                        seatLayer.getDragLayer().scrollVideo(event.getRawX(), event.getRawY());
                        break;
                    }
                    case 1: {
                        if (!gestureListener.isLongPress) break;
                        gestureListener.isLongPress = false;
                        if (seatLayer.getDragLayer() == null) break;
                        seatLayer.getDragLayer().scrollEndEnlarge(this.endScale);
                        break;
                    }
                }
                if (seatLayer.isBoardLayout()) {
                    gestureDetector.onTouchEvent(event);
                }
                return true;
            });
        }
    }

    public VideoWindow getVideoWindow() {
        return this.videoWindow;
    }

    public void backToSeat(VideoWindow videoWindow) {
        if (videoWindow.getView() == null) {
            return;
        }
        this.videoWindow = videoWindow;
        if (videoWindow.getView().getParent() != null) {
            ((ViewGroup)videoWindow.getView().getParent()).removeAllViews();
        }
        this.flContainer.addView(videoWindow.getView(), new ViewGroup.LayoutParams(-1, -1));
        videoWindow.setJoinBlackboard(false);
        if (this.isAdmin()) {
            this.$.id(R.id.window_video_container_back_to_seat).visibility(8);
            this.$.id(R.id.window_video_container_to_seat_placeholder).visibility(8);
        }
        this.$.id(R.id.window_video_container_seat_name).gone();
    }

    public void showPlaceholder() {
        if (this.iMediaModel.getUser().getUserId().equals(this.iRouter.getLiveRoom().getCurrentUser().getUserId()) && this.iMediaModel.getUser().getType() == LPConstants.LPUserType.Teacher) {
            this.$.id(R.id.window_video_container_back_to_seat).visibility(0);
        } else {
            this.$.id(R.id.window_video_container_to_seat_placeholder).visibility(0);
            this.$.id(R.id.window_video_container_seat_name).visible();
        }
    }

    public void initMediaModel(IMediaModel iMediaModel) {
        this.videoWindow.setMediaModel(iMediaModel);
        this.iMediaModel = iMediaModel;
        this.$.id(R.id.window_video_container_seat_name).text((CharSequence)this.context.getString(R.string.bjysc_seat_placeholder_tip, new Object[]{UtilsKt.getEncodePhoneNumber((String)iMediaModel.getUser().getName())}));
    }

    public void setMediaModel(IMediaModel iMediaModel) {
        this.iMediaModel = iMediaModel;
    }

    public IMediaModel getMediaModel() {
        return this.iMediaModel;
    }

    public void bindToSeat(SeatLayer seatLayer) {
        this.seatLayerWeakReference = new WeakReference<SeatLayer>(seatLayer);
    }

    public boolean isJoinedBlackboard() {
        return this.videoWindow != null && this.videoWindow.isJoinBlackboard();
    }

    public void showResumeButton() {
        if (this.$.id(R.id.window_video_resume_button).view().getVisibility() != 0) {
            this.$.id(R.id.window_video_resume_button).view().setVisibility(0);
        }
    }

    public void hideResumeButton() {
        if (this.$.id(R.id.window_video_resume_button).view().getVisibility() != 8) {
            this.$.id(R.id.window_video_resume_button).view().setVisibility(8);
        }
    }

    @Override
    public void onDestroy() {
        if (this.videoWindow != null) {
            this.videoWindow.onDestroy();
        }
        this.videoWindow = null;
        super.onDestroy();
    }

    @Override
    protected LPPlayerViewUpdateModel.PlayerPosition getPlayerPosition() {
        LPPlayerViewUpdateModel.PlayerPosition playerPosition = super.getPlayerPosition();
        playerPosition.id = FECompatUtil.getIOSMediaIdFromMediaId(this.videoWindow.getMediaId());
        return playerPosition;
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        WeakReference<VideoContainerWindow> containerWindowWeakReference;
        boolean isLongPress = false;

        GestureListener(VideoContainerWindow videoContainerWindow2) {
            this.containerWindowWeakReference = new WeakReference<VideoContainerWindow>(videoContainerWindow2);
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (VideoContainerWindow.this.videoWindow != null && VideoContainerWindow.this.videoWindow.isShowMenu() && !VideoContainerWindow.this.isJoinedBlackboard()) {
                VideoContainerWindow.this.videoWindow.showMenu((int)e.getRawX() + UtilsKt.getDp((int)40), (int)e.getRawY() + UtilsKt.getDp((int)2));
            }
            return true;
        }

        public void onLongPress(MotionEvent e) {
            super.onLongPress(e);
            Log.d((String)VideoContainerWindow.this.TAG, (String)"onLongPress: start....");
            if (VideoContainerWindow.this.videoWindow != null && VideoContainerWindow.this.videoWindow.isJoinBlackboard()) {
                return;
            }
            if (VideoContainerWindow.this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student || VideoContainerWindow.this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Assistant) {
                return;
            }
            this.isLongPress = true;
            SeatLayer seatLayer = (SeatLayer)VideoContainerWindow.this.seatLayerWeakReference.get();
            if (seatLayer.getDragLayer() != null) {
                VideoContainerWindow videoContainerWindow = (VideoContainerWindow)this.containerWindowWeakReference.get();
                seatLayer.getDragLayer().startEnlarge(VideoContainerWindow.this.startScale, videoContainerWindow, e.getRawX(), e.getRawY());
            }
        }
    }
}

