/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.toolbox.quiz;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.widget.ProgressBar;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.window.InteractiveBaseWindow;
import com.baijiayun.groupclassui.window.toolbox.quiz.QuizContract;
import com.baijiayun.groupclassui.window.toolbox.quiz.QuizPresenter;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.LPJsonModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.widgets.dialog.CommonDialog;
import com.baijiayun.livebase.widgets.view.webview.BJWebViewImpl;
import com.baijiayun.livecore.LiveSDK;
import com.baijiayun.livecore.utils.CommonUtils;
import com.tencent.smtt.export.external.interfaces.WebResourceError;
import com.tencent.smtt.export.external.interfaces.WebResourceRequest;
import com.tencent.smtt.sdk.WebChromeClient;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class QuizWindow
extends InteractiveBaseWindow
implements QuizContract.View {
    private static final String ARGS_TYPE = "1";
    private static final String WINDOW_NAME = "bjlapp";
    private IUserModel currentUserInfo;
    private String quizId;
    private String roomId;
    private String roomToken;
    private List<LPJsonModel> signalList;
    private boolean isShow;
    private boolean isUrlLoaded;
    private boolean isLoadFailed = false;
    private boolean isDestroyed = false;
    private QuizContract.Presenter presenter;
    private Context context;
    private CompositeDisposable disposables;
    private CommonDialog closeDialog;
    private BJWebViewImpl mWebView;

    public QuizWindow(Context context, boolean isShow, LPJsonModel jsonModel) {
        super(context);
        this.context = context;
        this.isShow = isShow;
        this.isUrlLoaded = false;
        this.disposables = new CompositeDisposable();
        this.presenter = new QuizPresenter(this);
        this.setBasePresenter(this.presenter);
        this.presenter.getCurrentUser();
        this.roomToken = TextUtils.isEmpty((CharSequence)this.presenter.getRoomToken()) ? "" : this.presenter.getRoomToken();
        this.setAllowTouch(true);
        if (this.signalList == null) {
            this.signalList = new ArrayList<LPJsonModel>();
        } else {
            this.signalList.clear();
        }
        this.onArrived(jsonModel);
        this.initView();
    }

    protected void initView() {
        this.$.id(R.id.rl_close).clicked(v -> this.showCloseDlg());
        this.$.id(R.id.rl_refresh).clicked(v -> {
            WebView webView = (WebView)this.$.id(R.id.base_webview).view();
            webView.reload();
        });
        this.initWebClient();
        this.loadUrl();
    }

    private void showCloseDlg() {
        this.closeDialog = new CommonDialog(this.context, CommonDialog.ChoiceMode.Double_Blue).setMainDisplayText(this.getString(R.string.quiz_dialog_close_tip)).setNegative(this.getString(R.string.bjysc_cancel), (dialog, which) -> dialog.dismiss()).setPositive(this.getString(R.string.bjy_base_browser_close_btn_close), (dialog, which) -> {
            dialog.dismiss();
            if (this.presenter != null) {
                this.presenter.dismissDlg(this.isShow);
            }
        });
        this.closeDialog.show();
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "JavascriptInterface"})
    private void initWebClient() {
        this.mWebView = (BJWebViewImpl)this.$.id(R.id.base_webview).view();
        this.mWebView.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_light_gray));
        this.mWebView.enableJavaScript((Object)this, WINDOW_NAME);
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                if (QuizWindow.this.isDestroyed) {
                    return;
                }
                ((ProgressBar)QuizWindow.this.$.id(R.id.pb_web_view_quiz).view()).setProgress(newProgress);
                super.onProgressChanged(view, newProgress);
            }
        });
        this.mWebView.setWebViewClient((WebViewClient)new BJWebViewImpl.BJWebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                if (QuizWindow.this.isDestroyed) {
                    return;
                }
                QuizWindow.this.$.id(R.id.pb_web_view_quiz).visible();
                QuizWindow.this.setCloseBtnStatus(QuizWindow.this.isShow);
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                if (QuizWindow.this.isDestroyed) {
                    return;
                }
                QuizWindow.this.isUrlLoaded = true;
                QuizWindow.this.$.id(R.id.pb_web_view_quiz).gone();
                if (!QuizWindow.this.isLoadFailed) {
                    QuizWindow.this.setCloseBtnStatus(QuizWindow.this.isShow);
                }
                QuizWindow.this.isLoadFailed = false;
                QuizWindow.this.callJsInQueue();
            }

            @TargetApi(value=23)
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                if (error.getErrorCode() != -11) {
                    QuizWindow.this.$.id(R.id.pb_web_view_quiz).gone();
                    QuizWindow.this.setCloseBtnStatus(QuizWindow.this.isShow);
                    QuizWindow.this.isLoadFailed = true;
                }
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                if (errorCode != -11) {
                    QuizWindow.this.$.id(R.id.pb_web_view_quiz).gone();
                    QuizWindow.this.setCloseBtnStatus(QuizWindow.this.isShow);
                    QuizWindow.this.isLoadFailed = true;
                }
            }
        });
    }

    public void setCloseBtnStatus(boolean isShow) {
        if (this.presenter == null) {
            return;
        }
        this.$.id(R.id.rl_close).visibility(isShow ? 0 : 4);
        this.$.id(R.id.rl_refresh).visibility(4);
    }

    private void loadUrl() {
        try {
            this.roomToken = URLEncoder.encode(this.roomToken, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String params = "?userNumber=" + this.currentUserInfo.getNumber() + "&userName=" + CommonUtils.encodeUTF8((String)this.currentUserInfo.getName()) + "&quizId=" + this.quizId + "&roomId=" + this.roomId + "&token=" + this.roomToken + "&argType=" + ARGS_TYPE + "&userGroup=" + this.currentUserInfo.getGroup() + "&skin=dark";
        String host = LPConstants.HOSTS_WEB[LiveSDK.getDeployType().getType()];
        String url = host.concat("m/quiz/student").concat(params);
        LPLogger.i((String)(this.getClass().getSimpleName() + " : " + url));
        ((WebView)this.$.id(R.id.base_webview).view()).loadUrl(url);
    }

    @Override
    public void onArrived(LPJsonModel jsonModel) {
        String key = jsonModel.data.get("message_type").getAsString();
        this.quizId = !jsonModel.data.has("quiz_id") ? "" : jsonModel.data.get("quiz_id").getAsString();
        this.roomId = !jsonModel.data.has("class_id") ? "" : jsonModel.data.get("class_id").getAsString();
        this.signalList.add(jsonModel);
    }

    @Override
    public void onEndArrived(LPJsonModel jsonModel) {
        String key = jsonModel.data.get("message_type").getAsString();
        if (!"quiz_end".equals(key)) {
            return;
        }
        this.signalList.add(jsonModel);
        if (this.isUrlLoaded) {
            this.callJs(jsonModel.data.toString());
        }
    }

    @Override
    public void onGetCurrentUser(IUserModel userModel) {
        this.currentUserInfo = userModel;
    }

    private void callJsInQueue() {
        if (this.signalList != null && this.signalList.size() > 0) {
            for (LPJsonModel jsonModel : this.signalList) {
                this.callJs(jsonModel.data.toString());
            }
        }
    }

    @Override
    public void onDestroy() {
        this.mWebView.destroy();
        if (this.closeDialog != null) {
            this.closeDialog.dismiss();
        }
        this.isDestroyed = true;
        if (this.signalList != null) {
            this.signalList.clear();
        }
        RxUtils.dispose((Disposable)this.disposables);
        super.onDestroy();
    }

    @JavascriptInterface
    public void close() {
        if (this.presenter.checkRouterNull()) {
            return;
        }
        this.presenter.dismissDlg(this.isShow);
    }

    @JavascriptInterface
    public void sendMessage(String json) {
        if (!TextUtils.isEmpty((CharSequence)json)) {
            this.presenter.submitAnswer(json);
        }
    }

    private void callJs(String json) {
        ((WebView)this.$.id(R.id.base_webview).view()).loadUrl("javascript:bjlapp.receivedMessage(" + json + ")");
    }

    public void setPresenter(QuizContract.Presenter presenter2) {
    }

    protected View onCreateView(Context context) {
        return View.inflate((Context)context, (int)R.layout.bjy_group_window_quiz, null);
    }
}

