/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.status;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.window.InteractiveBaseWindow;
import com.baijiayun.groupclassui.window.status.NetworkPopuwindow;
import com.baijiayun.groupclassui.window.status.StatusBarContract;
import com.baijiayun.groupclassui.window.status.StatusBarPresenter;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.ThemeDataUtil;

public class StatusBarWindow
extends InteractiveBaseWindow
implements StatusBarContract.View {
    private StatusBarContract.Presenter presenter;
    private NetworkPopuwindow networkPopuwindow;

    public StatusBarWindow(Context context) {
        super(context);
        this.presenter = new StatusBarPresenter(this, context);
        this.$.id(R.id.container_status_bar_setting).clicked(v -> this.presenter.setting());
        this.$.id(R.id.container_status_bar_close).clicked(v -> this.presenter.exit());
        this.$.id(R.id.container_status_bar_help).clicked(v -> this.presenter.help());
        this.$.id(R.id.container_status_bar_class_signal).clicked(v -> this.showNetworkStatePanel());
        this.$.id(R.id.container_status_bar_network_status).clicked(v -> this.showNetworkStatePanel());
        this.$.id(R.id.container_status_bar_report).clicked(v -> this.presenter.report());
        this.showResetStatusBarText();
        this.presenter.setRouter(this.iRouter);
        if (this.iRouter.getLiveRoom().isAudition()) {
            this.$.id(R.id.container_status_bar_setting).gone();
            this.$.id(R.id.container_status_bar_report).gone();
            this.$.id(R.id.container_status_bar_help).gone();
        }
    }

    private void showNetworkStatePanel() {
        if (this.networkPopuwindow == null) {
            this.networkPopuwindow = new NetworkPopuwindow(this.context, this.iRouter);
        }
        this.networkPopuwindow.show(this.$.id(R.id.container_status_bar_class_signal).view());
    }

    protected View onCreateView(Context context) {
        return LayoutInflater.from((Context)context).inflate(R.layout.bjy_group_window_status_bar, null);
    }

    @Override
    public void showDownLinkLossRate(double downLossRate, LPConstants.MediaNetworkQuality downLinkNetStatus) {
    }

    @Override
    public void showUpLinkLossRate(double upLossRate, LPConstants.MediaNetworkQuality upLinkNetStatus) {
    }

    @Override
    public void showUpVideoBitrate(double videoBitrate, LPConstants.MediaNetworkQuality videoNetWorkQuality) {
    }

    @Override
    public void showUpAudioBitrate(double audioBitrate, LPConstants.MediaNetworkQuality audioNetWorkQuality) {
    }

    @Override
    public void showDownVideoBitrate(double videoBitrate, LPConstants.MediaNetworkQuality videoNetWorkQuality) {
    }

    @Override
    public void showDownAudioBitrate(double audioBitrate, LPConstants.MediaNetworkQuality audioNetWorkQuality) {
    }

    @Override
    public void updateWorstNetworkQuality(LPConstants.MediaNetworkQuality quality1, LPConstants.MediaNetworkQuality quality2) {
        if (quality1 == null && quality2 == null) {
            this.showResetStatusBarText();
            return;
        }
        if (quality1 == null) {
            this.updateNetworkStatusLabel(quality2);
            return;
        }
        if (quality2 == null) {
            this.updateNetworkStatusLabel(quality1);
            return;
        }
        if (quality1.getQuality() > quality2.getQuality()) {
            this.updateNetworkStatusLabel(quality1);
        } else {
            this.updateNetworkStatusLabel(quality2);
        }
    }

    @Override
    public void showClassName(String className) {
        this.$.id(R.id.container_status_bar_class_name).text((CharSequence)className);
    }

    @Override
    public void showClassTime(String classTime) {
        TextView tvClassTime = (TextView)this.$.id(R.id.container_status_bar_class_time).view();
        tvClassTime.setText((CharSequence)classTime);
        tvClassTime.setTextColor(classTime.startsWith(this.context.getString(R.string.bjysc_status_bar_distance_from_class)) || classTime.startsWith(this.context.getString(R.string.bjysc_status_bar_overtime)) ? ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_warning_color) : ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_main_text_color));
    }

    public void setPresenter(StatusBarContract.Presenter presenter2) {
    }

    @Override
    public boolean onRoomStatusChange(boolean isActive) {
        boolean isWindowInit = super.onRoomStatusChange(isActive);
        if (isWindowInit) {
            if (isActive) {
                if (this.presenter != null) {
                    this.presenter.subscribe();
                }
            } else if (this.presenter != null) {
                this.presenter.unSubscribe();
                this.showResetStatusBarText();
            }
        }
        return true;
    }

    @Override
    public void showResetStatusBarText() {
        ((TextView)this.$.id(R.id.container_status_bar_network_status).text((CharSequence)"--").view()).setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_net_unknown));
        this.showClassTime(this.context.getString(R.string.bjysc_status_bar_class_time));
        ((ImageView)this.$.id(R.id.container_status_bar_class_signal).view()).setColorFilter(ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_net_unknown));
    }

    private void updateNetworkStatusLabel(LPConstants.MediaNetworkQuality quality) {
        switch (quality) {
            case EXCELLENT: {
                this.$.id(R.id.container_status_bar_network_status).textColor(R.color.bjysc_net_good).text(R.string.bjysc_net_good);
                ((ImageView)this.$.id(R.id.container_status_bar_class_signal).view()).setColorFilter(ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_net_good));
                break;
            }
            case GOOD: {
                this.$.id(R.id.container_status_bar_network_status).textColor(R.color.bjysc_net_normal).text(R.string.bjysc_net_normal);
                ((ImageView)this.$.id(R.id.container_status_bar_class_signal).view()).setColorFilter(ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_net_normal));
                break;
            }
            case BAD: {
                this.$.id(R.id.container_status_bar_network_status).textColor(R.color.bjysc_net_bad).text(R.string.bjysc_net_bad);
                ((ImageView)this.$.id(R.id.container_status_bar_class_signal).view()).setColorFilter(ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_net_bad));
                break;
            }
            case TERRIBLE: {
                this.$.id(R.id.container_status_bar_network_status).textColor(R.color.bjysc_net_terrible).text(R.string.bjysc_net_terrible);
                ((ImageView)this.$.id(R.id.container_status_bar_class_signal).view()).setColorFilter(ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_net_terrible));
                break;
            }
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.presenter.destroy();
    }
}

