/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.coursewaremanage;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.groupclassui.global.RouterListener;
import com.baijiayun.groupclassui.window.IRoomStatusListener;
import com.baijiayun.groupclassui.window.ppt.PPTWindow;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.widgets.dialog.CommonDialog;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.LPDocModel;
import com.baijiayun.livecore.models.LPDocViewElementModel;
import com.baijiayun.livecore.models.LPDocViewUpdateModel;
import com.baijiayun.livecore.models.LPUploadDocModel;
import com.baijiayun.livecore.models.LPUploadHomeworkUserModel;
import com.baijiayun.livecore.models.courseware.LPMediaCoursewareModel;
import com.baijiayun.livecore.models.file.cloudfile.LPCloudFileModel;
import com.baijiayun.livecore.models.roomresponse.LPAllowUploadHomeworkModel;
import com.baijiayun.liveuibase.utils.ToastUtil;
import com.baijiayun.liveuibase.widgets.courseware.BaseCourseWareContract;
import com.baijiayun.liveuibase.widgets.courseware.BaseCourseWareFragment;
import com.baijiayun.liveuibase.widgets.courseware.CourseManagePresenter;
import com.baijiayun.liveuibase.widgets.courseware.ICourseWareViewListener;
import com.baijiayun.liveuibase.widgets.courseware.models.UploadDocModel;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class CourseManageWindow
extends BaseCourseWareFragment
implements LifecycleObserver,
IRoomStatusListener {
    private Lifecycle lifecycle;
    private IRouter iRouter;
    private final CompositeDisposable compositeDisposable = new CompositeDisposable();
    int nowDocPosIndex = 0;
    private AtomicBoolean isWindowInit;
    private AtomicBoolean lateCallRoomStatusChange;

    protected void initChildData() {
        this.isWindowInit = new AtomicBoolean(false);
        this.lateCallRoomStatusChange = new AtomicBoolean(false);
        if (this.context instanceof RouterListener) {
            this.iRouter = ((RouterListener)this.context).getRouter();
            this.lifecycle = ((RouterListener)this.context).getLifecycle();
            this.lifecycle.addObserver((LifecycleObserver)this);
            ((RouterListener)this.context).addRoomStatusListener(this);
        }
        this.contentView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                CourseManageWindow.this.isWindowInit.set(true);
                if (CourseManageWindow.this.lateCallRoomStatusChange.get()) {
                    CourseManageWindow.this.onRoomStatusChange(true);
                    CourseManageWindow.this.lateCallRoomStatusChange.set(false);
                }
            }

            public void onViewDetachedFromWindow(View v) {
            }
        });
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container2, @Nullable Bundle savedInstanceState) {
        View view = super.onCreateView(inflater, container2, savedInstanceState);
        this.presenter.subscribe(this.iRouter.getLiveRoom());
        return view;
    }

    protected ICourseWareViewListener initCourseWareViewListener() {
        return new ICourseWareViewListener(){

            public void onClose() {
                CourseManageWindow.this.iRouter.getSubjectByKey(EventKey.CoursewareManageEnable).onNext((Object)false);
            }

            public void onPlayImg(LPUploadDocModel uploadDocModel) {
                CourseManageWindow.this.iRouter.getSubjectByKey(EventKey.GraphBitmapEnable).onNext((Object)uploadDocModel);
            }

            public void onReminderMsg(String msg) {
                CourseManageWindow.this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)msg);
            }

            public void onDeleteDoc(String fid, boolean isReUpload) {
                if (!isReUpload) {
                    new CommonDialog(CourseManageWindow.this.context, CommonDialog.ChoiceMode.Double_Red).setMainDisplayText(CourseManageWindow.this.context.getString(R.string.base_course_manage_delete_doc_reminder)).setPositive(CourseManageWindow.this.context.getString(R.string.base_course_manage_delete_confirm), (dialog, which) -> CourseManageWindow.this.iRouter.getLiveRoom().getDocListVM().deleteDocument(fid)).setNegative(CourseManageWindow.this.context.getString(R.string.base_cancel), null).show();
                } else {
                    CourseManageWindow.this.iRouter.getLiveRoom().getDocListVM().deleteDocument(fid);
                }
            }

            public void onDeleteMediaCourseware(String fid) {
                new CommonDialog(CourseManageWindow.this.context, CommonDialog.ChoiceMode.Double_Red).setMainDisplayText(CourseManageWindow.this.context.getString(R.string.base_course_manage_delete_doc_reminder)).setPositive(CourseManageWindow.this.context.getString(R.string.base_course_manage_delete_confirm), (dialog, which) -> CourseManageWindow.this.compositeDisposable.add(CourseManageWindow.this.iRouter.getLiveRoom().getDocListVM().requestDeleteMediaCourseware(fid).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {}))).setNegative(CourseManageWindow.this.context.getString(R.string.base_cancel), null).show();
            }

            public void onDeleteCloudFile(LPCloudFileModel cloudFileModel) {
                new CommonDialog(CourseManageWindow.this.context, CommonDialog.ChoiceMode.Double_Red).setMainDisplayText(CourseManageWindow.this.context.getString(R.string.base_course_manage_delete_doc_reminder)).setPositive(CourseManageWindow.this.context.getString(R.string.base_course_manage_delete_confirm), (dialog, which) -> CourseManageWindow.this.iRouter.getLiveRoom().getCloudFileVM().deleteCloudFile(cloudFileModel.getFileId())).setNegative(CourseManageWindow.this.context.getString(R.string.base_cancel), null).show();
            }

            public void onDeleteHomework(String homeworkId) {
                new CommonDialog(CourseManageWindow.this.context, CommonDialog.ChoiceMode.Double_Red).setMainDisplayText(CourseManageWindow.this.context.getString(R.string.base_course_manage_delete_homework_reminder)).setPositive(CourseManageWindow.this.context.getString(R.string.base_course_manage_delete_confirm), (dialog, which) -> CourseManageWindow.this.presenter.deleteHomework(homeworkId, LPUploadHomeworkUserModel.copyData((IUserModel)CourseManageWindow.this.iRouter.getLiveRoom().getCurrentUser()))).setNegative(CourseManageWindow.this.context.getString(R.string.base_cancel), null).show();
            }

            public void onRemindHomeworkSupport() {
                new CommonDialog(CourseManageWindow.this.context, CommonDialog.ChoiceMode.Double_Blue).setMainDisplayText(CourseManageWindow.this.context.getString(R.string.base_course_manage_homework_support_remind_text)).setPositive(CourseManageWindow.this.context.getString(R.string.base_has_know), null).setNegative(CourseManageWindow.this.context.getString(R.string.base_do_not_remind), (dialog, which) -> CourseManageWindow.this.homeworkRemindStatus = BaseCourseWareFragment.HomeworkRemindStatus.DO_NOT_REMIND).show();
            }

            public void onCancelTransfer(UploadDocModel uploadDocModel) {
                new CommonDialog(CourseManageWindow.this.context, CommonDialog.ChoiceMode.Double_Red).setMainDisplayText(CourseManageWindow.this.context.getString(R.string.base_course_manage_cancel_transfer_reminder)).setPositive(CourseManageWindow.this.context.getString(R.string.base_course_manage_delete_confirm), (dialog, which) -> CourseManageWindow.this.presenter.deleteTranslating(uploadDocModel)).setNegative(CourseManageWindow.this.context.getString(R.string.base_cancel), null).show();
            }

            public void onUpdateAllowUploadHomework(boolean isAllow) {
                CourseManageWindow.this.iRouter.getLiveRoom().getDocListVM().requestUpdateAllowUploadHomework(new LPAllowUploadHomeworkModel(isAllow));
            }

            public void requestLoadNextPage(String keyword) {
                CourseManageWindow.this.iRouter.getLiveRoom().getDocListVM().requestNextPageHomework(keyword);
            }
        };
    }

    protected BaseCourseWareContract.BaseCourseWarePresenter initPresenter() {
        return new CourseManagePresenter((BaseCourseWareContract.BaseCourseWareView)this){

            public boolean playDoc(LPDocModel docModel) {
                ConcurrentLinkedQueue<PPTWindow> pptWindows = CourseManageWindow.this.iRouter.getQueueByKey(EventKey.PPTWindows, PPTWindow.class);
                if (pptWindows.size() >= 15) {
                    CourseManageWindow.this.showToast(CourseManageWindow.this.getString(R.string.bjysc_doc_count_out_of_limit));
                    return false;
                }
                LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
                lpDocViewUpdateModel.docId = docModel.docId;
                lpDocViewUpdateModel.action = "add";
                LPDocViewElementModel lpDocViewElementModel = new LPDocViewElementModel();
                lpDocViewElementModel.docId = docModel.docId;
                lpDocViewElementModel.max = 0;
                lpDocViewElementModel.full = 0;
                lpDocViewElementModel.width = "0.33";
                lpDocViewElementModel.height = String.valueOf(docModel.height / docModel.width * 0.66f);
                ArrayList<LPDocViewElementModel> allDocList = new ArrayList<LPDocViewElementModel>(CourseManageWindow.this.iRouter.getListByKey(EventKey.AllDocViewList, LPDocViewElementModel.class));
                if (allDocList.size() == 0) {
                    CourseManageWindow.this.nowDocPosIndex = 0;
                }
                lpDocViewElementModel.x = String.valueOf(0.0125 * (double)CourseManageWindow.this.nowDocPosIndex++);
                lpDocViewElementModel.y = "0";
                boolean hasAdd = false;
                for (LPDocViewElementModel elementModel : allDocList) {
                    if (!docModel.docId.equals(elementModel.docId)) continue;
                    hasAdd = true;
                    break;
                }
                if (!hasAdd) {
                    allDocList.add(lpDocViewElementModel);
                    lpDocViewUpdateModel.all = allDocList;
                    CourseManageWindow.this.iRouter.setObjectByKey(EventKey.AllDocViewList, allDocList);
                    CourseManageWindow.this.iRouter.getLiveRoom().getDocListVM().requestDocViewUpdate(lpDocViewUpdateModel);
                }
                CourseManageWindow.this.sendSwitchSignal(lpDocViewElementModel);
                return true;
            }

            public void playMediaCourseware(LPMediaCoursewareModel toPlayMedia) {
                if (CourseManageWindow.this.iRouter.getLiveRoom().getOnlineUserVM().getActiveUserList().contains(CourseManageWindow.this.iRouter.getLiveRoom().getCurrentUser())) {
                    CourseManageWindow.this.iRouter.getSubjectByKey(EventKey.openMediaPlayerWindow).onNext((Object)toPlayMedia);
                } else {
                    new ToastUtil(CourseManageWindow.this.context).setText(CourseManageWindow.this.context.getString(R.string.bjy_group_play_media_require_on_stage)).show();
                }
            }

            public void playBds(LPDocModel bdsModel) {
                new CommonDialog(CourseManageWindow.this.context, CommonDialog.ChoiceMode.Double_Blue).setMainDisplayText(CourseManageWindow.this.context.getString(R.string.bjy_group_open_bds_tip)).setPositive(CourseManageWindow.this.context.getString(R.string.bjysc_confirm), (dialog, which) -> CourseManageWindow.this.iRouter.getSubjectByKey(EventKey.BdsRepaint).onNext((Object)bdsModel.docId)).setNegative(CourseManageWindow.this.context.getString(R.string.bjysc_cancel), null).show();
            }

            public void previewDoc(LPDocModel docModel) {
                ConcurrentLinkedQueue<PPTWindow> pptWindows = CourseManageWindow.this.iRouter.getQueueByKey(EventKey.PPTWindows, PPTWindow.class);
                if (pptWindows.size() >= 15) {
                    CourseManageWindow.this.showToast(CourseManageWindow.this.getString(R.string.bjysc_doc_count_out_of_limit));
                } else {
                    CourseManageWindow.this.iRouter.getSubjectByKey(EventKey.DocPreview).onNext((Object)docModel);
                }
            }
        };
    }

    private void sendSwitchSignal(LPDocViewElementModel elementModel) {
        PPTWindow topWindow;
        ConcurrentLinkedQueue<PPTWindow> pptWindows = this.iRouter.getQueueByKey(EventKey.PPTWindows, PPTWindow.class);
        if (pptWindows == null || pptWindows.isEmpty()) {
            return;
        }
        PPTWindow maxPPTWindow = this.iRouter.getValueByKey(EventKey.MaxScreenPPTWindow, PPTWindow.class);
        PPTWindow fullPPTWindow = this.iRouter.getValueByKey(EventKey.FullScreenPPTWindow, PPTWindow.class);
        if (maxPPTWindow == null && fullPPTWindow == null) {
            return;
        }
        boolean isFull = fullPPTWindow != null;
        PPTWindow pPTWindow = topWindow = isFull ? fullPPTWindow : maxPPTWindow;
        if (TextUtils.equals((CharSequence)topWindow.getId(), (CharSequence)elementModel.docId)) {
            return;
        }
        List<LPDocViewElementModel> allDocList = this.iRouter.getListByKey(EventKey.AllDocViewList, LPDocViewElementModel.class);
        LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
        lpDocViewUpdateModel.docId = topWindow.getRealDocId();
        lpDocViewUpdateModel.action = "normal";
        String string2 = lpDocViewUpdateModel.nextAction = isFull ? "full" : "max";
        if (allDocList != null && !allDocList.isEmpty() && !topWindow.isPreviewPPT()) {
            for (LPDocViewElementModel model : allDocList) {
                if (!model.docId.equals(lpDocViewUpdateModel.docId)) continue;
                model.max = 0;
                model.full = 0;
                lpDocViewUpdateModel.all = allDocList;
                this.iRouter.getLiveRoom().getDocListVM().requestDocViewUpdate(lpDocViewUpdateModel);
                break;
            }
        }
        elementModel.max = !isFull ? 1 : 0;
        elementModel.full = isFull ? 1 : 0;
        LPDocViewUpdateModel docViewUpdateModel = new LPDocViewUpdateModel();
        docViewUpdateModel.docId = elementModel.docId;
        docViewUpdateModel.action = lpDocViewUpdateModel.nextAction;
        if (allDocList == null) {
            allDocList = new ArrayList<LPDocViewElementModel>();
        }
        boolean hasAdd = false;
        for (LPDocViewElementModel viewElementModel : allDocList) {
            if (!elementModel.docId.equals(viewElementModel.docId)) continue;
            viewElementModel.max = elementModel.max;
            viewElementModel.full = elementModel.full;
            hasAdd = true;
            break;
        }
        if (!hasAdd) {
            allDocList.add(elementModel);
        }
        docViewUpdateModel.all = allDocList;
        this.iRouter.getLiveRoom().getDocListVM().requestDocViewUpdate(docViewUpdateModel);
        if (isFull && !topWindow.isPreviewPPT()) {
            lpDocViewUpdateModel.nextAction = "";
            if (!allDocList.isEmpty()) {
                for (LPDocViewElementModel model : allDocList) {
                    if (!model.docId.equals(lpDocViewUpdateModel.docId)) continue;
                    model.max = 0;
                    model.full = 0;
                    lpDocViewUpdateModel.all = allDocList;
                    this.iRouter.getLiveRoom().getDocListVM().requestDocViewUpdate(lpDocViewUpdateModel);
                    break;
                }
            }
        }
    }

    protected LiveRoom getLiveRoom() {
        if (this.iRouter == null) {
            return null;
        }
        return this.iRouter.getLiveRoom();
    }

    @Override
    public boolean onRoomStatusChange(boolean isActive) {
        if (isActive) {
            if (this.isWindowInit.get()) {
                this.subscribe();
            } else {
                this.lateCallRoomStatusChange.set(true);
            }
        } else {
            this.unSubscribe();
            this.lateCallRoomStatusChange.set(false);
        }
        return true;
    }

    private void subscribe() {
        if (this.context instanceof RouterListener && this.iRouter == null) {
            this.iRouter = ((RouterListener)this.context).getRouter();
            this.presenter.subscribe(this.iRouter.getLiveRoom());
        }
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.UploadPPTPath).ofType(Map.class).filter(map -> map.size() == 1).subscribe(arg_0 -> ((CourseManageWindow)this).onUpload(arg_0)));
    }

    private void unSubscribe() {
        this.courseWareAdapter.onRoomLoseConnect();
        this.compositeDisposable.clear();
        if (this.presenter != null) {
            this.presenter.unSubscribe();
        }
        this.iRouter = null;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, @NotNull MotionEvent event) {
        return true;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy() {
        super.onDestroy();
        this.presenter.destroy();
        this.unSubscribe();
    }

    public View getView() {
        return this.contentView;
    }
}

