/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window;

import android.content.Context;
import android.view.View;
import androidx.annotation.UiThread;
import com.baijiayun.groupclassui.base.BaseGroupPresenter;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.groupclassui.global.RouterListener;
import com.baijiayun.groupclassui.window.IRoomStatusListener;
import com.baijiayun.liveuibase.base.BaseWindow;
import com.baijiayun.liveuibase.base.ILayer;

public abstract class InteractiveBaseWindow
extends BaseWindow
implements IRoomStatusListener {
    protected IRouter iRouter;
    protected BaseGroupPresenter basePresenter;
    protected boolean isWindowInit;
    private boolean laterCallback;
    private boolean isRoomActive;
    private View.OnAttachStateChangeListener onAttachStateChangeListener;

    @UiThread
    public InteractiveBaseWindow(final Context context) {
        super(context);
        this.onAttachStateChangeListener = new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                if (context instanceof RouterListener) {
                    ((RouterListener)context).addRoomStatusListener(InteractiveBaseWindow.this);
                }
                InteractiveBaseWindow.this.isWindowInit = true;
                if (InteractiveBaseWindow.this.laterCallback) {
                    InteractiveBaseWindow.this.onRoomStatusChange(InteractiveBaseWindow.this.isRoomActive);
                    InteractiveBaseWindow.this.laterCallback = false;
                }
            }

            public void onViewDetachedFromWindow(View v) {
                if (context instanceof RouterListener) {
                    ((RouterListener)context).removeRoomStatusListener(InteractiveBaseWindow.this);
                }
            }
        };
        this.view.addOnAttachStateChangeListener(this.onAttachStateChangeListener);
    }

    protected void doOnCreateView(Context context) {
        super.doOnCreateView(context);
        if (context instanceof RouterListener) {
            this.iRouter = ((RouterListener)context).getRouter();
        }
    }

    protected void setBasePresenter(BaseGroupPresenter presenter2) {
        this.basePresenter = presenter2;
        presenter2.setRouter(this.iRouter);
        this.basePresenter.subscribe();
    }

    protected boolean isAdmin() {
        return this.iRouter != null && (this.iRouter.getLiveRoom().isTeacherOrAssistant() || this.iRouter.getLiveRoom().isGroupTeacherOrAssistant());
    }

    protected boolean canBringToForeground() {
        return this.isAdmin();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.basePresenter != null) {
            this.basePresenter.destroy();
            this.basePresenter = null;
        }
        if (this.view != null) {
            this.view.removeOnAttachStateChangeListener(this.onAttachStateChangeListener);
        }
        this.isWindowInit = false;
    }

    protected void unSubscribe() {
        super.unSubscribe();
        if (this.basePresenter != null) {
            this.basePresenter.destroy();
            this.basePresenter = null;
        }
    }

    public String getId() {
        return "";
    }

    @Override
    public boolean onRoomStatusChange(boolean isActive) {
        if (this.isWindowInit) {
            if (!isActive) {
                this.unSubscribe();
            }
        } else {
            this.laterCallback = true;
        }
        this.isRoomActive = isActive;
        return this.isWindowInit;
    }

    public void moveTo(ILayer layer) {
        super.moveTo(layer);
    }

    public void moveTo(int x, int y, int z) {
        super.moveTo(x, y, z);
    }
}

