/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.studyreport;

import android.content.Context;
import android.os.Bundle;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.fragment.app.Fragment;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.toast.ToastCompat;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.studyreport.StudyReportListDialog;
import com.baijiayun.groupclassui.util.IntentDataHolder;
import com.baijiayun.livebase.widgets.dialog.preview.PictureWatcherFragment;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.LPStudyReportModel;
import com.baijiayun.livecore.models.studyreport.LPBlackboardInfoModel;
import com.baijiayun.liveuibase.widgets.StudyReportDetailFragment;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class StudyReportActivity
extends AppCompatActivity {
    private LiveRoom liveRoom;
    private Disposable disposableOfRequestStudyReport;
    private Disposable disposableOfGetReportStatus;
    private Disposable disposableOfStudyReportList;
    private Disposable disposableOfBlackboardImgList;
    private List<LPStudyReportModel> lpStudyReportModelList;
    private FrameLayout detailContainer;
    private ImageView closeIv;
    private TextView reportNameTv;
    private ImageView preStudyReportIv;
    private ImageView nextStudyReportIv;
    private TextView studyReportTitleTv;
    private RelativeLayout studyReportBottomRl;
    private TextView studyReportClassNameTv;
    private TextView studyReportDateTv;
    private TextView studyReportStatusMessageTv;
    private TextView reloadStudyReportTv;
    private AppCompatImageView closeStudyReportIv;
    private StudyReportListDialog studyReportListDialog;
    private LPStudyReportModel currStudyReport;
    private StudyReportListDialog.ReportItemClickListener reportItemClickListener;
    private SimpleDateFormat simpleDateFormat;
    private StudyReportDetailFragment studyReportDetailFragment;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        boolean isTabletDevice;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.bjy_activity_loading_study_report);
        this.studyReportClassNameTv = (TextView)this.findViewById(R.id.bjy_group_loading_study_report_room_name);
        this.studyReportDateTv = (TextView)this.findViewById(R.id.bjy_group_loading_study_report_date);
        this.studyReportStatusMessageTv = (TextView)this.findViewById(R.id.bjy_group_study_report_status_message);
        this.reloadStudyReportTv = (TextView)this.findViewById(R.id.bjy_group_reload_study_report_text);
        this.closeStudyReportIv = (AppCompatImageView)this.findViewById(R.id.bjy_group_close_study_report_image);
        boolean bl = isTabletDevice = (this.getResources().getConfiguration().screenLayout & 0xF) >= 3;
        if (!isTabletDevice) {
            this.setRequestedOrientation(1);
        } else {
            this.setRequestedOrientation(0);
        }
        this.liveRoom = (LiveRoom)IntentDataHolder.getInstance().getData("liveroom");
        this.studyReportClassNameTv.setText((CharSequence)this.liveRoom.getRoomInfo().title);
        this.simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        this.studyReportDateTv.setText((CharSequence)this.simpleDateFormat.format(new Date()));
        this.requestStudyReportTaskNo();
        this.reloadStudyReportTv.setOnClickListener(v -> {
            this.requestStudyReportTaskNo();
            this.studyReportStatusMessageTv.setText(R.string.bjy_group_study_report_loading_words);
        });
        this.closeStudyReportIv.setOnClickListener(v -> this.finish());
    }

    private void requestStudyReportTaskNo() {
        this.disposableOfRequestStudyReport = this.liveRoom.requestStudyReport().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(taskNo -> this.getReportStatus((String)taskNo), throwable -> ToastCompat.showToast((Context)this, (CharSequence)throwable.getMessage(), (int)0));
    }

    private void getReportStatus(String taskNo) {
        this.disposableOfGetReportStatus = Observable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).flatMap(aLong -> this.liveRoom.getTaskStateSegment(taskNo)).subscribe(status -> {
            switch (status) {
                case -1: {
                    RxUtils.dispose((Disposable)this.disposableOfGetReportStatus);
                    this.studyReportStatusMessageTv.setText((CharSequence)this.getString(R.string.bjy_group_study_report_not_exist));
                    this.reloadStudyReportTv.setVisibility(0);
                    break;
                }
                case 3: {
                    RxUtils.dispose((Disposable)this.disposableOfGetReportStatus);
                    this.getStudyReport();
                    break;
                }
                case 4: {
                    RxUtils.dispose((Disposable)this.disposableOfGetReportStatus);
                    this.studyReportStatusMessageTv.setText((CharSequence)this.getString(R.string.bjy_group_get_study_report_fail));
                    this.reloadStudyReportTv.setVisibility(0);
                    break;
                }
            }
        });
    }

    private void getStudyReport() {
        this.disposableOfStudyReportList = this.liveRoom.getStudyReportList().subscribe(lpStudyReportModelList -> {
            if (lpStudyReportModelList.isEmpty()) {
                this.studyReportStatusMessageTv.setText(R.string.bjy_group_get_study_report_fail);
                this.reloadStudyReportTv.setVisibility(0);
                return;
            }
            this.lpStudyReportModelList = lpStudyReportModelList;
            this.currStudyReport = (LPStudyReportModel)lpStudyReportModelList.get(0);
            this.initStudyReportView();
            this.initListener();
        }, throwable -> ToastCompat.showToast((Context)this, (CharSequence)throwable.getMessage(), (int)0));
    }

    private Context getContext() {
        return this;
    }

    private void initStudyReportView() {
        this.setContentView(R.layout.activity_expression_reportion);
        this.detailContainer = (FrameLayout)this.findViewById(R.id.detail_container);
        this.closeIv = (ImageView)this.findViewById(R.id.iv_exp_close);
        this.reportNameTv = (TextView)this.findViewById(R.id.tv_exp_name);
        this.preStudyReportIv = (ImageView)this.findViewById(R.id.iv_exp_left);
        this.nextStudyReportIv = (ImageView)this.findViewById(R.id.iv_exp_right);
        this.studyReportTitleTv = (TextView)this.findViewById(R.id.tv_exp_title);
        this.studyReportBottomRl = (RelativeLayout)this.findViewById(R.id.rl_exp_bottom);
        this.reportNameTv.setText((CharSequence)this.currStudyReport.userName);
        this.studyReportTitleTv.setText((CharSequence)String.format("%s\u7684\u5b66\u60c5\u62a5\u544a", this.currStudyReport.userName));
        if (this.studyReportDetailFragment == null) {
            this.studyReportDetailFragment = StudyReportDetailFragment.Companion.newInstance(this.currStudyReport.reportUrl, this.currStudyReport.reportNo);
            this.studyReportDetailFragment.setIsShowToolbar(false);
            this.studyReportDetailFragment.setShowImageListener(new StudyReportDetailFragment.ShowBlackboardImageListener(){

                public void requestImageAndShow(@Nullable String reportNumber) {
                    StudyReportActivity.this.disposableOfBlackboardImgList = StudyReportActivity.this.liveRoom.getBlackboardImgList(reportNumber).subscribe(lpStudyReportInfo -> {
                        if (lpStudyReportInfo.imgList.size() == 0) {
                            return;
                        }
                        ArrayList<String> imgUrls = new ArrayList<String>();
                        for (LPBlackboardInfoModel lpBlackboardInfoModel : lpStudyReportInfo.imgList) {
                            imgUrls.add(lpBlackboardInfoModel.url);
                        }
                        PictureWatcherFragment pictureWatcherFragment = PictureWatcherFragment.Companion.newInstance(imgUrls, 0, true, lpStudyReportInfo.whiteboardUrl, R.style.BJYGroupDialogStyle);
                        pictureWatcherFragment.show(StudyReportActivity.this.getSupportFragmentManager(), PictureWatcherFragment.class.getName());
                    }, throwable -> ToastCompat.showToast((Context)StudyReportActivity.this.getContext(), (CharSequence)throwable.getMessage(), (int)0));
                }
            });
        }
        this.getSupportFragmentManager().beginTransaction().replace(R.id.detail_container, (Fragment)this.studyReportDetailFragment).commitAllowingStateLoss();
    }

    private void initListener() {
        this.closeIv.setOnClickListener(v -> this.finish());
        this.preStudyReportIv.setOnClickListener(v -> {
            if (this.lpStudyReportModelList.indexOf(this.currStudyReport) == 0) {
                ToastCompat.showToast((Context)this, (CharSequence)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u4e2a\u5b66\u751f\u4e86\u54e6", (int)0);
                return;
            }
            this.currStudyReport = this.lpStudyReportModelList.get(this.lpStudyReportModelList.indexOf(this.currStudyReport) - 1);
            this.updateUI(this.currStudyReport);
        });
        this.nextStudyReportIv.setOnClickListener(v -> {
            if (this.lpStudyReportModelList.indexOf(this.currStudyReport) == this.lpStudyReportModelList.size() - 1) {
                ToastCompat.showToast((Context)this, (CharSequence)"\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u4e2a\u5b66\u751f\u4e86\u54e6", (int)0);
                return;
            }
            this.currStudyReport = this.lpStudyReportModelList.get(this.lpStudyReportModelList.indexOf(this.currStudyReport) + 1);
            this.updateUI(this.currStudyReport);
        });
        this.studyReportBottomRl.setOnClickListener(v -> {
            if (this.studyReportListDialog == null) {
                this.studyReportListDialog = new StudyReportListDialog((Context)this, this.reportItemClickListener);
                this.studyReportListDialog.setLayout(this.detailContainer.getWidth(), -2);
            }
            if (!this.studyReportListDialog.isShowing()) {
                this.studyReportListDialog.setCurrReportItem(this.currStudyReport).setAllReport(this.lpStudyReportModelList).show();
            }
        });
        this.reportItemClickListener = this::updateUI;
    }

    private void updateUI(LPStudyReportModel lpStudyReportModel) {
        if (!this.currStudyReport.userNumber.equals(lpStudyReportModel.userNumber)) {
            this.currStudyReport = lpStudyReportModel;
        }
        this.studyReportTitleTv.setText((CharSequence)String.format("%s\u7684\u5b66\u60c5\u62a5\u544a", lpStudyReportModel.userName));
        this.reportNameTv.setText((CharSequence)lpStudyReportModel.userName);
        if (this.studyReportDetailFragment != null) {
            this.studyReportDetailFragment.updateReportUrl(lpStudyReportModel.reportUrl, lpStudyReportModel.reportNo);
        }
    }

    public void onBackPressed() {
        if (this.studyReportDetailFragment != null && this.studyReportDetailFragment.canGoBack()) {
            this.studyReportDetailFragment.goBack();
        } else {
            super.onBackPressed();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        RxUtils.dispose((Disposable)this.disposableOfRequestStudyReport);
        RxUtils.dispose((Disposable)this.disposableOfGetReportStatus);
        RxUtils.dispose((Disposable)this.disposableOfStudyReportList);
        RxUtils.dispose((Disposable)this.disposableOfBlackboardImgList);
    }
}

