/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.layer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.layer.BaseLayerOfProfessionalClass;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import com.baijiayun.liveuibase.utils.ShadowUtil;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;

public class ReminderLayer
extends BaseLayerOfProfessionalClass {
    private Disposable disposableOfUserIn;
    private Disposable disposableOfUserOut;
    private Disposable disposableOfMessage;
    private Disposable disposableOfErrorMessage;
    private Disposable disposableOfUpdateBlackboardPage;
    private Disposable BBPageShowTimer;
    private Disposable disposableOfClassStart;
    private Disposable disposableOfSpeakApplyResResult;
    private LinearLayout reminderContainer;
    private FrameLayout bbPage;
    private TextView pageText;
    private LinearLayout containerClassStart;
    private LinearLayout interactiveClassStartClass;
    private boolean isShowWeakNetworkReminder = false;
    private boolean isInit;
    String preReconnectMessage = null;

    public ReminderLayer(@NonNull Context context) {
        super(context);
    }

    public ReminderLayer(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ReminderLayer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void init() {
        super.init();
        LinearLayout constraintLayout = (LinearLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.bjy_group_window_reminder, null);
        this.reminderContainer = (LinearLayout)constraintLayout.findViewById(R.id.window_reminder_content);
        this.addView((View)constraintLayout);
        this.addBlackboardPageView();
    }

    @Override
    public boolean onRoomStatusChange(boolean isRoomActive) {
        boolean isLayerInit = super.onRoomStatusChange(isRoomActive);
        if (isLayerInit && isRoomActive) {
            if (!this.isInit) {
                this.initListener();
            }
            this.subscribe();
        }
        return true;
    }

    public void showStartClassButton() {
        if (this.router.getLiveRoom().getStudyRoomVM().isStudyRoom()) {
            return;
        }
        if (this.containerClassStart == null) {
            return;
        }
        UtilsKt.removeViewFromParent((View)this.containerClassStart);
        this.addView((View)this.containerClassStart);
    }

    private boolean isShowClassStart() {
        return !this.router.getLiveRoom().getStudyRoomVM().isStudyRoom() && (this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher || this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Assistant && this.router.getLiveRoom().getPartnerConfig().enableAssistantStartClass == 1);
    }

    private void initListener() {
        this.isInit = true;
        if (this.isShowClassStart()) {
            this.containerClassStart = (LinearLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.bjy_group_item_start_class, null);
            this.interactiveClassStartClass = (LinearLayout)this.containerClassStart.findViewById(R.id.bjysc_start_class);
            Context context = this.interactiveClassStartClass.getContext();
            this.interactiveClassStartClass.setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context, (int)R.attr.base_theme_live_product_color)).cornerRadius(UtilsKt.getDp((int)4)).build());
            this.interactiveClassStartClass.setOnClickListener(v -> {
                if (this.router.getLiveRoom().getRecorder() == null || this.router.getLiveRoom().getPlayer() == null) {
                    return;
                }
                this.router.getLiveRoom().requestClassStart();
                this.router.getSubjectByKey(EventKey.CheckSyncPreviewDoc).onNext((Object)true);
                if (this.containerClassStart.getParent() instanceof ViewGroup) {
                    ((ViewGroup)this.containerClassStart.getParent()).removeView((View)this.containerClassStart);
                }
            });
        }
        if (this.isShowClassStart() && !this.router.getLiveRoom().isClassStarted()) {
            this.showStartClassButton();
        }
        this.disposableOfMessage = this.router.getSubjectByKey(EventKey.ReminderMessage).ofType(String.class).observeOn(AndroidSchedulers.mainThread()).subscribe(this::addMessage);
        this.disposableOfErrorMessage = this.router.getSubjectByKey(EventKey.ReminderErrorMessage).ofType(String.class).observeOn(AndroidSchedulers.mainThread()).subscribe(this::addErrorMessage);
        this.disposableOfUpdateBlackboardPage = this.router.getSubjectByKey(EventKey.ReminderBlackboardPage).ofType(Float.class).subscribe(y -> {
            NumberFormat format = NumberFormat.getNumberInstance();
            format.setMaximumFractionDigits(1);
            int totalPage = this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE ? this.router.getLiveRoom().getPartnerConfig().live1v1BlackboardPages : this.router.getLiveRoom().getPartnerConfig().liveBlackboardPages;
            String s = format.format(y.floatValue() * (float)(totalPage - 1) + 1.0f) + "/" + totalPage;
            this.pageText.setText((CharSequence)s);
            this.bbPage.setBackground(this.getContext().getResources().getDrawable(R.drawable.bg_view_blackboard_page));
            this.bbPage.setVisibility(this.router.getLiveRoom().getSmallClassTemplateType() != LPConstants.SmallClassTemplateType.ONEONONE ? 0 : 8);
            if (this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE) {
                this.bbPage.setVisibility(8);
                if (this.router.getLiveRoom().getPartnerConfig().live1v1BlackboardPages > 1) {
                    this.bbPage.setVisibility(0);
                }
            } else {
                this.bbPage.setVisibility(0);
            }
            RxUtils.dispose((Disposable)this.BBPageShowTimer);
            this.BBPageShowTimer = Observable.timer((long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> this.bbPage.setVisibility(8));
        });
    }

    private void subscribe() {
        if (BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
            this.disposableOfSpeakApplyResResult = this.router.getLiveRoom().getSpeakQueueVM().getObservableOfSpeakApplyResResult().observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaControlModel -> {
                if (!iMediaControlModel.isApplyAgreed()) {
                    this.addMessage(this.getContext().getString(R.string.bjysc_speak_apply_res_result));
                }
            });
        }
        this.disposableOfClassStart = this.router.getLiveRoom().getObservableOfClassStart().filter(integer -> this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher || this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Assistant).subscribe(integer -> {
            if (this.containerClassStart != null && this.containerClassStart.getParent() != null) {
                ((ViewGroup)this.containerClassStart.getParent()).removeView((View)this.containerClassStart);
            }
        });
        this.disposableOfUserIn = this.router.getLiveRoom().getOnlineUserVM().getObservableOfUserIn().filter(iUserInModel -> this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher).subscribe(iUserInModel -> {
            String message = iUserInModel.getUser().getName() + "  " + this.getContext().getString(R.string.bjysc_enter_room);
            this.addMessage(message);
        });
        this.disposableOfUserOut = this.router.getLiveRoom().getOnlineUserVM().getObservableOfUserOut().filter(iUserInModel -> this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher).subscribe(userModel -> this.addMessage(userModel.getName() + "  " + this.getContext().getString(R.string.bjysc_leave_room)));
    }

    private void addBlackboardPageView() {
        if (this.bbPage == null) {
            this.bbPage = new FrameLayout(this.getContext());
        }
        if (this.pageText == null) {
            this.pageText = new TextView(this.getContext());
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(UtilsKt.getDp((int)60), UtilsKt.getDp((int)20));
        layoutParams.gravity = 49;
        this.bbPage.setVisibility(8);
        layoutParams.topMargin = UtilsKt.getDp((int)24);
        this.bbPage.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        FrameLayout.LayoutParams textLayoutParams = new FrameLayout.LayoutParams(-2, -2);
        textLayoutParams.gravity = 17;
        this.pageText.setTextSize(12.0f);
        this.pageText.setTextColor(-1);
        this.bbPage.addView((View)this.pageText, (ViewGroup.LayoutParams)textLayoutParams);
        this.addView((View)this.bbPage);
    }

    private void addMessage(String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        if (message.startsWith(this.getContext().getString(R.string.reconnecting))) {
            if (!TextUtils.isEmpty((CharSequence)this.preReconnectMessage) && this.reminderContainer.getChildCount() > 0) {
                this.reminderContainer.removeViewAt(0);
            }
            this.reminderContainer.addView((View)this.newLabel(message, true), 0);
            this.preReconnectMessage = message;
            return;
        }
        if (this.reminderContainer.getChildCount() >= 3) {
            this.reminderContainer.removeViewAt(this.reminderContainer.getChildCount() - 1);
        }
        if (this.isShowWeakNetworkReminder) {
            this.reminderContainer.addView((View)this.newLabel(message, false), 1);
        } else {
            this.reminderContainer.addView((View)this.newLabel(message, false), 0);
        }
    }

    private void addErrorMessage(String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        if (this.reminderContainer.getChildCount() >= 3) {
            this.reminderContainer.removeViewAt(this.reminderContainer.getChildCount() - 1);
        }
        this.reminderContainer.addView((View)this.newLabel(message, true), 0);
    }

    @SuppressLint(value={"CheckResult"})
    private RelativeLayout newLabel(String message, boolean isRedBg) {
        RelativeLayout label = new RelativeLayout(this.getContext());
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(this.getContext().getResources().getDimensionPixelSize(R.dimen.bjysc_remind_label_width), this.getContext().getResources().getDimensionPixelSize(R.dimen.bjysc_remind_label_height));
        lp.setMargins(0, 0, 0, 8);
        label.setLayoutParams((ViewGroup.LayoutParams)lp);
        if (isRedBg) {
            label.setBackground(this.getContext().getResources().getDrawable(R.drawable.ic_window_reminder_red_bg));
        } else {
            label.setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_brand_container_color)).cornerRadius(this.getContext().getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
        }
        label.setOnClickListener(v -> this.removeLabel((View)label, message));
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)message);
        textView.setTextSize(12.0f);
        textView.setTextColor(isRedBg ? -1 : ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_window_main_text_color));
        RelativeLayout.LayoutParams tp = new RelativeLayout.LayoutParams(-1, -1);
        textView.setLayoutParams((ViewGroup.LayoutParams)tp);
        tp.setMarginStart(UtilsKt.getDp((int)10));
        tp.setMarginEnd(UtilsKt.getDp((int)10));
        textView.setSingleLine(true);
        textView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
        textView.setGravity(17);
        textView.setTextAlignment(4);
        label.addView((View)textView);
        Observable.timer((long)3L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> this.removeLabel((View)label, message));
        ShadowUtil.setViewBoundShadow((View)label);
        return label;
    }

    private void removeLabel(View label, String message) {
        if (label.getParent() instanceof ViewGroup && !this.getContext().getString(R.string.bjysc_network_reminder).equals(message)) {
            ViewGroup viewGroup = (ViewGroup)label.getParent();
            viewGroup.removeView(label);
        }
    }

    private void unSubscribe() {
        RxUtils.dispose((Disposable)this.disposableOfUserIn);
        RxUtils.dispose((Disposable)this.disposableOfUserOut);
        RxUtils.dispose((Disposable)this.disposableOfMessage);
        RxUtils.dispose((Disposable)this.disposableOfErrorMessage);
        RxUtils.dispose((Disposable)this.disposableOfUpdateBlackboardPage);
        RxUtils.dispose((Disposable)this.BBPageShowTimer);
        RxUtils.dispose((Disposable)this.disposableOfClassStart);
        RxUtils.dispose((Disposable)this.disposableOfSpeakApplyResResult);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.unSubscribe();
        this.removeAllViews();
        if (this.bbPage != null) {
            this.bbPage.removeAllViews();
            this.bbPage = null;
        }
    }
}

