/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.toolbox.timer;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.media.SoundPool;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.window.InteractiveBaseWindow;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.LPTimerModel;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;

public class StudentTimerWindow
extends InteractiveBaseWindow {
    private Disposable disposableOfTimerStart;
    private Disposable disposableOfInterval;
    private long remainSeconds;
    private long timeDuration;
    private Drawable normalDrawable;
    private Drawable warningDrawable;
    private final TextView tvTimer;
    private SoundPool soundPool;

    public StudentTimerWindow(Context context, LPTimerModel lpTimerModel) {
        super(context);
        this.timeDuration = this.remainSeconds = lpTimerModel.value.duration;
        this.tvTimer = (TextView)this.$.id(R.id.student_timer_main_text).view();
        this.initDrawable();
        this.init();
    }

    private void initDrawable() {
        this.normalDrawable = ThemeDataUtil.getCommonWindowBg((Context)this.context);
        this.warningDrawable = new DrawableBuilder().solidColor(ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_warning_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build();
        this.tvTimer.setBackground(this.normalDrawable);
    }

    protected View onCreateView(Context context) {
        this.setNeedShowShadow(true);
        return LayoutInflater.from((Context)context).inflate(R.layout.bjy_group_window_timer_student, null);
    }

    private void init() {
        this.setAllowTouch(true);
        this.setTimer(this.remainSeconds);
        this.showViewState(this.remainSeconds != 60L);
        if (this.remainSeconds > 0L) {
            this.startInterval();
        }
        this.disposableOfTimerStart = this.iRouter.getLiveRoom().getToolBoxVM().getObservableOfTimerStart().observeOn(AndroidSchedulers.mainThread()).subscribe(lpTimerModel -> {
            this.timeDuration = this.remainSeconds = lpTimerModel.value.duration;
            this.setTimer(this.remainSeconds);
            this.showViewState(this.remainSeconds != 60L);
            this.startInterval();
        });
    }

    private void startInterval() {
        RxUtils.dispose((Disposable)this.disposableOfInterval);
        this.disposableOfInterval = Observable.interval((long)1L, (long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            if (this.remainSeconds > 0L) {
                --this.remainSeconds;
                this.setTimer(this.remainSeconds);
                if (this.remainSeconds <= 60L && this.timeDuration >= 60L) {
                    this.showViewState(false);
                }
            } else {
                RxUtils.dispose((Disposable)this.disposableOfInterval);
                if (this.soundPool != null) {
                    this.soundPool.release();
                }
                this.soundPool = UtilsKt.playAudio((Context)this.context, (int)R.raw.timer_end);
                this.showViewState(false);
            }
        });
    }

    private void setTimer(long remainSeconds) {
        long min = remainSeconds / 60L;
        long second = remainSeconds % 60L;
        String minStr = min > 9L ? String.valueOf(min) : "0" + min;
        String secStr = second > 9L ? String.valueOf(second) : "0" + second;
        this.tvTimer.setText((CharSequence)String.format("%s : %s", minStr, secStr));
    }

    private void showViewState(boolean isNormal) {
        this.tvTimer.setBackground(isNormal ? this.normalDrawable : this.warningDrawable);
        this.tvTimer.setTextColor(isNormal ? ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_main_text_color) : ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_live_white));
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RxUtils.dispose((Disposable)this.disposableOfTimerStart);
        RxUtils.dispose((Disposable)this.disposableOfInterval);
        if (this.soundPool != null) {
            this.soundPool.release();
        }
    }
}

