/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.toolbox.randomselect;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListView;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.drawable.LayerDrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.widget.AutoScrollAdapter;
import com.baijiayun.groupclassui.window.BaseTitledWindow;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.LPRandomSelectValueModel;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class RandomSelectWindow
extends BaseTitledWindow {
    private AutoScrollAdapter autoScrollAdapter;
    private boolean isOnMission = false;
    private int targetIndex = -1;

    public RandomSelectWindow(Context context) {
        super(context);
        this.initUi(context);
    }

    private void initUi(Context context) {
        this.title(context.getResources().getString(R.string.bjysc_tool_box_random_select));
        this.allowTouch = true;
        ListView lvNames = (ListView)this.$.id(R.id.bjysc_random_select_names_container).view();
        this.autoScrollAdapter = AutoScrollAdapter.initListView((AbsListView)lvNames, context);
        this.autoScrollAdapter.setMaxNum(3);
        this.autoScrollAdapter.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context, (int)R.attr.base_theme_window_assistant_text_color), ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context, (int)R.attr.base_theme_window_main_text_color));
        this.autoScrollAdapter.setOnAutoScrollListener(() -> {
            if (this.isDestroy()) {
                return;
            }
            this.isOnMission = false;
            this.$.id(R.id.bjysc_random_select_operate_btn).visible();
        });
        this.$.id(R.id.bjysc_random_select_operate_btn).clicked(v -> this.iRouter.getSubjectByKey(EventKey.OpenRandomSelectWindow).onNext((Object)new LPRandomSelectValueModel()));
        this.setCanScale(false);
        this.showScaleIcon(false);
        this.showClose(false);
        this.showFull(false);
        this.showSync(false);
        this.hideContentMask();
        this.initDrawable();
    }

    public void initValues(@NotNull LPRandomSelectValueModel randomSelectValueModel) {
        ArrayList<String> names = new ArrayList<String>();
        this.targetIndex = -1;
        for (int i = 0; i < randomSelectValueModel.nameList.length; ++i) {
            names.add(randomSelectValueModel.nameList[i]);
            String selectName = randomSelectValueModel.selectUser.name;
            if (selectName == null || !selectName.equals(randomSelectValueModel.nameList[i])) continue;
            this.targetIndex = i;
            break;
        }
        if (this.targetIndex == -1) {
            names.add(randomSelectValueModel.selectUser.name);
            this.targetIndex = names.size() - 1;
        }
        this.autoScrollAdapter.initValues(names);
    }

    public void startMission() {
        if (!this.isOnMission) {
            this.$.id(R.id.bjysc_random_select_operate_btn).invisible();
            this.isOnMission = true;
            this.view.postDelayed(() -> this.autoScrollAdapter.updateSelect(this.targetIndex), 100L);
        }
    }

    private void initDrawable() {
        this.$.id(R.id.bjysc_random_select_border_container).view().setBackground((Drawable)new LayerDrawableBuilder().add(new DrawableBuilder().solidColor(0).cornerRadius(UtilsKt.getDp((int)8)).strokeColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_bg_color)).strokeWidth(UtilsKt.getDp((int)8)).build()).add(new DrawableBuilder().solidColor(0).cornerRadius(UtilsKt.getDp((int)8)).strokeColor(ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_bg_stroke)).strokeWidth(1).build()).build());
    }

    @Override
    public boolean onRoomStatusChange(boolean isActive) {
        boolean isWindowInit = super.onRoomStatusChange(isActive);
        if (isWindowInit) {
            if (isActive) {
                this.subscribe();
            } else {
                this.onDestroy();
            }
        }
        return true;
    }

    private void subscribe() {
    }

    @Override
    protected void onCreateContentView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.bjysc_window_random_select, (ViewGroup)this.rlContentContainer);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }
}

