/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.bottommenu;

import android.content.Context;
import android.text.TextUtils;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.groupclassui.user.UserStatus;
import com.baijiayun.groupclassui.window.bottommenu.BottomMenuContract;
import com.baijiayun.groupclassui.window.bottommenu.SpeakApplyStatus;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.listener.OnSpeakApplyCountDownListener;
import com.baijiayun.livecore.models.roomresponse.LPResCloudRecordModel;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;

public class BottomMenuPresenter
implements BottomMenuContract.Presenter {
    private IRouter iRouter;
    private BottomMenuContract.View view;
    private Context context;
    private Disposable disposableOfChat;
    private Disposable disposableOfFloatChat;
    private Disposable disposableOfUserList;
    private Disposable disposableOfCloudRecord;
    private Disposable disposableOfMuteAll;
    private Disposable disposableOfForbidHandsUp;
    private Disposable disposableOfMsgReceived;
    private Disposable disposableOfRoomLayoutSwitch;
    private Disposable disposableOfUserRemove;
    private Disposable disposableOfSpeakResponse;
    private Disposable disposableOfMicOn;
    private Disposable disposableOfCameraOn;
    private Disposable disposableOfCloudRecordAllowed;
    private Disposable disposableOfUserAdd;
    private Disposable disposableOfCloudRecordProcess;
    private Disposable disposableOfSpeakApplyDeny;
    private Disposable disposableOfSpeakApply;
    private Disposable disposableOfSpeakResponseNoFilter;
    private Disposable disposableOfStatusTutor;
    private Disposable disposableOfBonusPointsAdd;
    private CompositeDisposable compositeDisposable = new CompositeDisposable();
    private LPConstants.RoomLayoutMode currLayoutCategory = LPConstants.RoomLayoutMode.BOARD;
    private LPResCloudRecordModel cloudRecordStatus = new LPResCloudRecordModel(LPConstants.CloudRecordStatus.Stopped.getStatus());
    private SpeakApplyStatus speakApplyStatus = SpeakApplyStatus.None;
    private boolean isFirstCallRecordStatus = true;
    private int hansUpCount;
    private boolean isMediaCoursewarePlaying;

    BottomMenuPresenter(BottomMenuContract.View view, Context context) {
        this.view = view;
        this.context = context;
    }

    public void subscribe() {
        this.disposableOfChat = this.iRouter.getSubjectByKey(EventKey.DisplayChat).ofType(Boolean.class).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> this.view.showChatWindowShowingStatus((boolean)aBoolean));
        this.disposableOfFloatChat = this.iRouter.getSubjectByKey(EventKey.DisplayFloatChat).ofType(Boolean.class).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> this.view.showFloatChatWindowShowingStatus((boolean)aBoolean));
        this.disposableOfUserList = this.iRouter.getSubjectByKey(EventKey.DisplayUserList).ofType(UserStatus.class).observeOn(AndroidSchedulers.mainThread()).subscribe(userStatus -> {
            this.view.showUserListWindowShowingStatus(userStatus != UserStatus.Close);
            if (userStatus != UserStatus.Close) {
                this.view.hideHandsUpCount();
            }
        });
        if (BaseUtilsKt.isAdmin((LiveRoom)this.iRouter.getLiveRoom())) {
            this.disposableOfCloudRecord = this.iRouter.getLiveRoom().getObservableOfCloudRecordStatus().observeOn(AndroidSchedulers.mainThread()).subscribe(recordStatus -> {
                this.cloudRecordStatus = recordStatus;
                if (this.isFirstCallRecordStatus && this.cloudRecordStatus.status == LPConstants.CloudRecordStatus.Recording.getStatus()) {
                    this.isFirstCallRecordStatus = false;
                    this.view.showCloudRecordHint();
                }
                this.view.showRecordingStatus(this.cloudRecordStatus);
            });
            this.cloudRecordStatus = this.iRouter.getLiveRoom().getCloudRecordStatus();
            if (this.isFirstCallRecordStatus && this.cloudRecordStatus.status == LPConstants.CloudRecordStatus.Recording.getStatus()) {
                this.isFirstCallRecordStatus = false;
                if (this.iRouter.getLiveRoom().canCloudRecord()) {
                    this.view.showCloudRecordHint();
                }
            }
            this.view.showRecordingStatus(this.cloudRecordStatus);
            this.view.showCloudRecordButton(this.showCloudRecord());
        }
        this.disposableOfForbidHandsUp = this.iRouter.getLiveRoom().getObservableOfForbidRaiseHand().observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
            this.iRouter.getSubjectByKey(EventKey.ForbidHandsUp).onNext(aBoolean);
            if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student && this.speakApplyStatus == SpeakApplyStatus.Speaking) {
                this.view.showSpeakApplyDisable();
            } else {
                this.view.showForbidHandsUpStatus((boolean)aBoolean);
            }
        });
        this.view.showForbidHandsUpStatus(this.iRouter.getLiveRoom().getForbidRaiseHandStatus());
        this.disposableOfRoomLayoutSwitch = this.iRouter.getLiveRoom().getObservableOfRoomLayoutSwitch().observeOn(AndroidSchedulers.mainThread()).subscribe(integer -> {
            this.currLayoutCategory = integer;
            this.view.showGalleryModel(integer == LPConstants.RoomLayoutMode.GALLERY);
        });
        this.currLayoutCategory = this.iRouter.getLiveRoom().getCurrentRoomLayout();
        this.view.showGalleryModel(this.currLayoutCategory == LPConstants.RoomLayoutMode.GALLERY);
        this.disposableOfSpeakResponse = this.iRouter.getLiveRoom().getSpeakQueueVM().getObservableOfSpeakResponse().filter(iMediaControlModel -> iMediaControlModel.getUser().getUserId().equals(this.iRouter.getLiveRoom().getCurrentUser().getUserId()) && !BaseUtilsKt.isAdmin((LiveRoom)this.iRouter.getLiveRoom())).observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaControlModel -> {
            if (iMediaControlModel.isApplyAgreed()) {
                this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.context.getString(R.string.bjysc_speak_apply_agree));
                this.view.showSpeakApplyNormal();
            } else {
                this.speakApplyStatus = SpeakApplyStatus.None;
                if (!iMediaControlModel.getSenderUserId().equals(this.iRouter.getLiveRoom().getCurrentUser().getUserId())) {
                    this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.context.getString(R.string.bjysc_speak_apply_disagree));
                    this.view.showSpeakApplyNormal();
                }
            }
        });
        this.disposableOfSpeakApply = this.iRouter.getLiveRoom().getSpeakQueueVM().getObservableOfSpeakApply().observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaModel -> {
            ++this.hansUpCount;
            Object userStatus = this.iRouter.getSubjectByKey(EventKey.DisplayUserList).getValue();
            if (null == userStatus || userStatus == UserStatus.Close) {
                this.view.showHandsUpRemind(this.hansUpCount, iMediaModel.getUser().getName());
            }
        });
        this.disposableOfSpeakResponseNoFilter = this.iRouter.getLiveRoom().getSpeakQueueVM().getObservableOfSpeakResponse().observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaControlModel -> {
            Object userStatus;
            if (this.hansUpCount >= 1) {
                --this.hansUpCount;
            }
            if (null != (userStatus = this.iRouter.getSubjectByKey(EventKey.DisplayUserList).getValue()) && userStatus != UserStatus.Close) {
                return;
            }
            if (this.hansUpCount > 0) {
                this.view.showHandsUpRemind(this.hansUpCount, iMediaControlModel.getUser().getName());
            } else {
                this.view.hideHandsUpCount();
            }
        });
        this.disposableOfSpeakApplyDeny = this.iRouter.getLiveRoom().getSpeakQueueVM().getObservableOfSpeakApplyDeny().observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaModel -> {
            this.speakApplyStatus = SpeakApplyStatus.None;
            this.iRouter.getLiveRoom().getSpeakQueueVM().cancelSpeakApply();
            this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.context.getString(R.string.bjysc_closed_by_server));
            this.view.showSpeakApplyNormal();
        });
        this.disposableOfMicOn = this.iRouter.getLiveRoom().getRecorder().getObservableOfMicOn().observeOn(AndroidSchedulers.mainThread()).subscribe(isMicOn -> {
            this.view.showMicStatus((boolean)isMicOn);
            if (this.iRouter.getLiveRoom().getCurrentUser().getType() != LPConstants.LPUserType.Student) {
                return;
            }
            this.speakApplyStatus = isMicOn != false ? SpeakApplyStatus.Speaking : SpeakApplyStatus.None;
            if (this.iRouter.getLiveRoom().getForbidRaiseHandStatus() || isMicOn.booleanValue()) {
                this.view.showSpeakApplyDisable();
            } else {
                this.view.showSpeakApplyNormal();
            }
        });
        this.disposableOfCameraOn = this.iRouter.getLiveRoom().getRecorder().getObservableOfCameraOn().observeOn(AndroidSchedulers.mainThread()).subscribe(isCameraOn -> this.view.showCameraStatus((boolean)isCameraOn));
        this.disposableOfUserRemove = this.iRouter.getLiveRoom().getOnlineUserVM().getPublishSubjectOfActiveUserRemove().observeOn(AndroidSchedulers.mainThread()).filter(lpResRoomUserInModel -> this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student).subscribe(lpResRoomUserInModel -> {
            if (this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode().isGalleryLayout() && TextUtils.equals((CharSequence)lpResRoomUserInModel.user.userId, (CharSequence)this.iRouter.getLiveRoom().getCurrentUser().getUserId()) && !this.iRouter.getLiveRoom().getForbidRaiseHandStatus()) {
                this.view.showSpeakApplyNormal();
            }
        });
        this.disposableOfUserAdd = this.iRouter.getLiveRoom().getOnlineUserVM().getPublishSubjectOfActiveUserAdd().observeOn(AndroidSchedulers.mainThread()).filter(lpResRoomUserInModel -> this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student).subscribe(lpResRoomUserInModel -> {
            if (this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode().isGalleryLayout() && (TextUtils.equals((CharSequence)lpResRoomUserInModel.user.userId, (CharSequence)this.iRouter.getLiveRoom().getCurrentUser().getUserId()) || this.iRouter.getLiveRoom().getForbidRaiseHandStatus())) {
                this.view.showSpeakApplyDisable();
            }
        });
        this.disposableOfMsgReceived = this.iRouter.getSubjectByKey(EventKey.ChatMessageReceived).ofType(Boolean.class).subscribe(aBoolean -> this.view.showChatWindowRedPoint((boolean)aBoolean));
        this.disposableOfMuteAll = this.iRouter.getLiveRoom().getObservableOfQuickMuteAllStudentMic().observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> this.view.showMuteAllStateChange((boolean)aBoolean));
        this.disposableOfStatusTutor = this.iRouter.getSubjectByKey(EventKey.StudyStatusTutor).filter(o -> BaseUtilsKt.isAdmin((LiveRoom)this.iRouter.getLiveRoom())).ofType(String.class).subscribe(s -> this.view.showUserListStatus(TextUtils.isEmpty((CharSequence)s)));
        this.disposableOfBonusPointsAdd = this.iRouter.getLiveRoom().getToolBoxVM().getObservableOfBonusPointsAdd().observeOn(AndroidSchedulers.mainThread()).subscribe(integer -> this.view.showBonusPointsAdd((Integer)integer));
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.openMediaPlayerWindow).observeOn(AndroidSchedulers.mainThread()).subscribe(window -> {
            this.isMediaCoursewarePlaying = true;
        }));
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.closeMediaPlayerWindow).observeOn(AndroidSchedulers.mainThread()).subscribe(o -> {
            this.isMediaCoursewarePlaying = false;
        }));
    }

    public void unSubscribe() {
    }

    @Override
    public void navigateToGalleryMode() {
        this.iRouter.getLiveRoom().requestRoomLayoutSwitch(this.currLayoutCategory == LPConstants.RoomLayoutMode.GALLERY ? LPConstants.RoomLayoutMode.BOARD : LPConstants.RoomLayoutMode.GALLERY);
    }

    @Override
    public void changeRecordStatus() {
        if (this.cloudRecordStatus.status == LPConstants.CloudRecordStatus.Stopped.getStatus()) {
            this.disposableOfCloudRecordAllowed = this.iRouter.getLiveRoom().requestPlaybackProcessStatus().throttleFirst(1L, TimeUnit.SECONDS).subscribeOn(AndroidSchedulers.mainThread()).subscribe(lpPlaybackProcessStatusModel -> {
                if (lpPlaybackProcessStatusModel.status == 0) {
                    this.iRouter.getLiveRoom().requestCloudRecord(LPConstants.CloudRecordStatus.Recording);
                } else if (lpPlaybackProcessStatusModel.status == 1) {
                    if (lpPlaybackProcessStatusModel.isLongTermClass()) {
                        this.view.showCloudRecordRestartDialog();
                    } else {
                        this.iRouter.getLiveRoom().requestCloudRecord(LPConstants.CloudRecordStatus.Recording);
                    }
                } else if (lpPlaybackProcessStatusModel.status == 2) {
                    if (lpPlaybackProcessStatusModel.isLongTermClass()) {
                        this.iRouter.getLiveRoom().requestCloudRecord(LPConstants.CloudRecordStatus.Recording);
                    } else {
                        this.view.showShortTermClassAlreadyHasPlayback();
                    }
                }
            });
        } else {
            this.stopCloudRecord();
        }
    }

    @Override
    public void changeForbidHandsUpStatus() {
        Object object = this.iRouter.getSubjectByKey(EventKey.ForbidHandsUp).getValue();
        this.iRouter.getLiveRoom().requestForbidRaiseHand(null == object || object.equals(false));
    }

    @Override
    public void navigateToUserList() {
        Object object = this.iRouter.getSubjectByKey(EventKey.DisplayUserList).getValue();
        if (null == object || object == UserStatus.Close) {
            this.iRouter.getSubjectByKey(EventKey.DisplayUserList).onNext((Object)UserStatus.UserList);
        } else {
            this.iRouter.getSubjectByKey(EventKey.DisplayUserList).onNext((Object)UserStatus.Close);
        }
    }

    @Override
    public void navigateToChat() {
        Object object = this.iRouter.getSubjectByKey(EventKey.DisplayChat).getValue();
        this.iRouter.getSubjectByKey(EventKey.DisplayChat).onNext((Object)(null == object || object.equals(false) ? 1 : 0));
    }

    @Override
    public void navigateToHomework() {
        this.iRouter.getSubjectByKey(EventKey.CoursewareManageEnable).onNext((Object)true);
    }

    @Override
    public void navigateToEyeCare(boolean enableEyeCare) {
        this.iRouter.getSubjectByKey(EventKey.DisplayEyeCare).onNext((Object)enableEyeCare);
    }

    @Override
    public void speakApply() {
        if (!this.iRouter.getLiveRoom().isClassStarted()) {
            this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.context.getString(R.string.bjysc_closed_class_not_start_error));
            this.view.showSpeakApplyNormal();
            return;
        }
        if (this.speakApplyStatus == SpeakApplyStatus.None) {
            this.iRouter.getLiveRoom().getSpeakQueueVM().requestSpeakApply(new OnSpeakApplyCountDownListener(){

                public void onTimeOut() {
                    BottomMenuPresenter.this.speakApplyStatus = SpeakApplyStatus.None;
                    BottomMenuPresenter.this.iRouter.getLiveRoom().getSpeakQueueVM().cancelSpeakApply();
                    if (BottomMenuPresenter.this.iRouter.getLiveRoom().getForbidRaiseHandStatus()) {
                        BottomMenuPresenter.this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)BottomMenuPresenter.this.context.getString(R.string.bjysc_forbid_send_message));
                        BottomMenuPresenter.this.view.showSpeakApplyDisable();
                    } else {
                        BottomMenuPresenter.this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)BottomMenuPresenter.this.context.getString(R.string.bjysc_speak_apply_disagree));
                        BottomMenuPresenter.this.view.showSpeakApplyNormal();
                    }
                }

                public void onTimeCountDown(int counter, int timeOut) {
                    if (BottomMenuPresenter.this.iRouter.getLiveRoom().getForbidRaiseHandStatus()) {
                        BottomMenuPresenter.this.speakApplyStatus = SpeakApplyStatus.None;
                        BottomMenuPresenter.this.iRouter.getLiveRoom().getSpeakQueueVM().cancelSpeakApply();
                        BottomMenuPresenter.this.view.showSpeakApplyDisable();
                    } else {
                        BottomMenuPresenter.this.view.showSpeakApplyCountDown(timeOut - counter, timeOut);
                    }
                }
            });
            this.speakApplyStatus = SpeakApplyStatus.Applying;
        } else if (this.speakApplyStatus == SpeakApplyStatus.Applying) {
            this.speakApplyStatus = SpeakApplyStatus.None;
            this.iRouter.getLiveRoom().getSpeakQueueVM().cancelSpeakApply();
            this.view.showSpeakApplyNormal();
        }
    }

    @Override
    public void stopCloudRecord() {
        this.cloudRecordStatus.status = LPConstants.CloudRecordStatus.Stopped.getStatus();
        this.iRouter.getLiveRoom().requestCloudRecord(LPConstants.CloudRecordStatus.Stopped);
    }

    @Override
    public void pauseCloudRecord() {
        this.cloudRecordStatus.status = LPConstants.CloudRecordStatus.Paused.getStatus();
        this.iRouter.getLiveRoom().requestCloudRecord(LPConstants.CloudRecordStatus.Paused);
    }

    @Override
    public void startNewCloudRecord() {
        this.disposableOfCloudRecordProcess = this.iRouter.getLiveRoom().requestCloudRecordStartProcessing().subscribeOn(AndroidSchedulers.mainThread()).subscribe(c -> {
            RxUtils.dispose((Disposable)this.disposableOfCloudRecordProcess);
            this.iRouter.getLiveRoom().requestCloudRecord(LPConstants.CloudRecordStatus.Recording);
        });
    }

    @Override
    public void continueCloudRecord() {
        this.iRouter.getLiveRoom().requestCloudRecord(LPConstants.CloudRecordStatus.Recording);
    }

    @Override
    public LPResCloudRecordModel getCloudRecordStatus() {
        return this.cloudRecordStatus;
    }

    @Override
    public void quickMuteAllStudentMic(boolean mute) {
        this.iRouter.getLiveRoom().quickMuteAllStudentMic(mute);
    }

    @Override
    public void exit() {
        this.iRouter.getSubjectByKey(EventKey.CloseDialog).onNext((Object)true);
    }

    @Override
    public boolean showCloudRecord() {
        return this.iRouter.getLiveRoom().canCloudRecord() && !this.iRouter.getLiveRoom().getStudyRoomVM().isStudyRoom() && !this.iRouter.getLiveRoom().getPartnerConfig().disableRecordStatus();
    }

    @Override
    public boolean isMediaCoursewarePlaying() {
        return this.isMediaCoursewarePlaying;
    }

    @Override
    public void navigateToBonusPoints() {
        this.iRouter.getSubjectByKey(EventKey.ShowBonusPointWindow).onNext((Object)true);
    }

    @Override
    public void setRouter(IRouter router) {
        this.iRouter = router;
    }

    public void destroy() {
        RxUtils.dispose((Disposable)this.disposableOfChat);
        RxUtils.dispose((Disposable)this.disposableOfFloatChat);
        RxUtils.dispose((Disposable)this.disposableOfUserList);
        RxUtils.dispose((Disposable)this.disposableOfCloudRecord);
        RxUtils.dispose((Disposable)this.disposableOfForbidHandsUp);
        RxUtils.dispose((Disposable)this.disposableOfMsgReceived);
        RxUtils.dispose((Disposable)this.disposableOfRoomLayoutSwitch);
        RxUtils.dispose((Disposable)this.disposableOfSpeakResponse);
        RxUtils.dispose((Disposable)this.disposableOfMicOn);
        RxUtils.dispose((Disposable)this.disposableOfCameraOn);
        RxUtils.dispose((Disposable)this.disposableOfCloudRecordAllowed);
        RxUtils.dispose((Disposable)this.disposableOfSpeakApplyDeny);
        RxUtils.dispose((Disposable)this.disposableOfSpeakApply);
        RxUtils.dispose((Disposable)this.disposableOfSpeakResponseNoFilter);
        RxUtils.dispose((Disposable)this.disposableOfMuteAll);
        RxUtils.dispose((Disposable)this.disposableOfUserRemove);
        RxUtils.dispose((Disposable)this.disposableOfUserAdd);
        RxUtils.dispose((Disposable)this.disposableOfStatusTutor);
        RxUtils.dispose((Disposable)this.disposableOfBonusPointsAdd);
        this.iRouter = null;
        this.view = null;
        this.context = null;
    }
}

