/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.groupclassui.window.BaseTitledWindow;

public abstract class BaseFixedRatioTitledWindow
extends BaseTitledWindow {
    private float y2x_ratio;

    protected BaseFixedRatioTitledWindow(Context context) {
        super(context);
    }

    public void setWindowLayoutParams(ViewGroup.LayoutParams layoutParams) {
        this.minSize = UtilsKt.getDp((int)(layoutParams.width > layoutParams.height ? DEFAULT_MIN_SIZE : 150));
        this.otherSizeRatio = layoutParams.width > layoutParams.height ? (float)layoutParams.width / (float)layoutParams.height : -((float)layoutParams.height / (float)layoutParams.width);
        this.y2x_ratio = this.otherSizeRatio < 0.0f ? -this.otherSizeRatio : 1.0f / this.otherSizeRatio;
    }

    @Override
    protected void handleScaleTouchEvent(View v, MotionEvent event) {
        int x = (int)event.getX();
        switch (event.getAction()) {
            case 0: {
                this.downX = x;
                ViewGroup.LayoutParams layoutParams = this.dragScaleRelativeLayout.getLayoutParams();
                this.downWidth = layoutParams.width;
                this.downHeight = layoutParams.height;
                if (v.getParent() == null || !(v.getParent() instanceof ViewGroup)) break;
                ViewGroup viewGroup = (ViewGroup)v.getParent();
                this.measuredParentHeight = viewGroup.getMeasuredHeight();
                this.measuredParentWidth = viewGroup.getMeasuredWidth();
                break;
            }
            case 2: {
                int width;
                int height;
                int offX = x - this.downX;
                int offY = Math.round((float)(x - this.downX) * this.y2x_ratio);
                if (v.getLeft() + this.downWidth + offX >= this.measuredParentWidth || v.getTop() + this.downHeight + offY >= this.measuredParentHeight) {
                    offX = Math.min(this.measuredParentWidth - v.getLeft() - this.downWidth, Math.round((float)(this.measuredParentHeight - v.getTop() - this.downHeight) / this.y2x_ratio));
                    offY = Math.round((float)offX * this.y2x_ratio);
                }
                if (this.otherSizeRatio > 0.0f) {
                    height = Math.max(this.downHeight + offY, this.minSize);
                    width = Math.max(this.downWidth + offX, (int)((float)this.minSize * this.otherSizeRatio));
                } else {
                    height = Math.max(this.downHeight + offY, (int)((float)this.minSize * -this.otherSizeRatio));
                    width = Math.max(this.downWidth + offX, this.minSize);
                }
                this.scaleTo(width, height);
                if (this.onWindowRepositionListener == null) break;
                this.onWindowRepositionListener.OnWindowScale(width, height);
                break;
            }
            case 1: {
                this.scaling = false;
                break;
            }
        }
    }
}

