/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

public class DragRelativeLayout
extends RelativeLayout {
    private final int DRAG_DISTANCE_PX = 50;
    private int lastX;
    private int lastY;
    private int screenWidth;
    private int screenHeight;
    private int width;
    private int height;
    private int left;
    private int top;
    private int right;
    private int bottom;
    private int downX;
    private int downY;
    private boolean isDragEnable = true;
    private boolean error = true;
    private boolean isDown = false;
    private OnUpdateLayoutParamsListener onUpdateLayoutParamsListener;
    private int fWidth;
    private int fHeight;
    private final int moveJudgeUnitHold = 50;
    private final int moveJudgeUnitMoving = 1;
    private int moveJudgeUnit = 50;

    public DragRelativeLayout(Context context) {
        this(context, null);
    }

    public DragRelativeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DragRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.screenWidth = dm.widthPixels;
        this.screenHeight = dm.heightPixels;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.width = this.getMeasuredWidth();
        this.height = this.getMeasuredHeight();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
    }

    public void setDragEnable(boolean isEnable) {
        this.isDragEnable = isEnable;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.isDragEnable) {
            return super.onInterceptTouchEvent(ev);
        }
        int action = ev.getAction();
        switch (action) {
            case 0: {
                this.lastX = (int)ev.getRawX();
                this.lastY = (int)ev.getRawY();
                this.downX = this.lastX;
                this.downY = this.lastY;
                if (!this.isDown) {
                    this.isDown = true;
                    if (this.onUpdateLayoutParamsListener != null) {
                        this.onUpdateLayoutParamsListener.onActionDown();
                    }
                }
                if (!this.error) break;
                this.error = false;
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.width, -2);
                layoutParams.leftMargin = this.getLeft();
                layoutParams.topMargin = this.getTop();
                layoutParams.rightMargin = 0;
                layoutParams.bottomMargin = 0;
                this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                break;
            }
            case 2: {
                int dx = (int)ev.getRawX() - this.lastX;
                int dy = (int)ev.getRawY() - this.lastY;
                if (this.fWidth == 0) {
                    this.fWidth = this.screenWidth;
                }
                if (this.fHeight == 0) {
                    this.fHeight = this.screenHeight;
                }
                if (Math.abs(dx) < this.moveJudgeUnit && Math.abs(dy) < this.moveJudgeUnit) break;
                this.moveJudgeUnit = 1;
                int left = this.getLeft() + dx;
                int top = this.getTop() + dy;
                int right = this.getRight() + dx;
                int bottom = this.getBottom() + dy;
                if (left < 0) {
                    left = 0;
                    right = left + this.getWidth();
                }
                if (right > this.fWidth) {
                    right = this.fWidth;
                    left = right - this.getWidth();
                }
                if (top < 0) {
                    top = 0;
                    bottom = top + this.getHeight();
                }
                if (bottom > this.fHeight) {
                    bottom = this.fHeight;
                    top = bottom - this.getHeight();
                }
                this.layout(left, top, right, bottom);
                this.left = left;
                this.top = top;
                this.right = right;
                this.bottom = bottom;
                this.lastX = (int)ev.getRawX();
                this.lastY = (int)ev.getRawY();
                break;
            }
            case 1: {
                this.isDown = false;
                this.moveJudgeUnit = 50;
                if (this.onUpdateLayoutParamsListener != null) {
                    this.onUpdateLayoutParamsListener.onUpdateLayoutParams(this.left, this.top, this.right, this.bottom);
                }
                if (Math.abs(this.lastX - this.downX) < 50 && Math.abs(this.lastY - this.downY) < 50) break;
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.width, -2);
                layoutParams.leftMargin = this.left;
                layoutParams.topMargin = this.top;
                layoutParams.rightMargin = 0;
                layoutParams.bottomMargin = 0;
                this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                return true;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public void setDragParams(int width, int height) {
        this.fWidth = width;
        this.fHeight = height;
    }

    public void setOnUpdateLayoutParamsListener(OnUpdateLayoutParamsListener listener) {
        this.onUpdateLayoutParamsListener = listener;
    }

    public static interface OnUpdateLayoutParamsListener {
        public void onUpdateLayoutParams(int var1, int var2, int var3, int var4);

        public void onActionDown();
    }
}

