/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.container;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.PointF;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Pair;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.CheckBox;
import android.widget.FrameLayout;
import android.widget.TextView;
import android_serialport_api.XYDataPacket;
import android_serialport_api.ZXYBDeviceInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import com.baijiayun.bjyrtcengine.Defines.BJYRtcCommon;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.query.QueryPlus;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.container.ShapePaint;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.global.GroupClassActivity;
import com.baijiayun.groupclassui.layer.BaseLayerOfProfessionalClass;
import com.baijiayun.groupclassui.layer.BlackboardLayer;
import com.baijiayun.groupclassui.layer.DocumentLayer;
import com.baijiayun.groupclassui.layer.VideoLayer;
import com.baijiayun.groupclassui.model.NotifyAwardModel;
import com.baijiayun.groupclassui.model.PlayerViewActionModel;
import com.baijiayun.groupclassui.model.SbbCloseWindowEvent;
import com.baijiayun.groupclassui.util.FECompatUtil;
import com.baijiayun.groupclassui.window.BaseTitledWindow;
import com.baijiayun.groupclassui.window.blackboard.BlackboardListener;
import com.baijiayun.groupclassui.window.blackboard.BlackboardScrollView;
import com.baijiayun.groupclassui.window.coursewaremanage.MediaCoursewarePlayerWindow;
import com.baijiayun.groupclassui.window.group.GroupAwardWindow;
import com.baijiayun.groupclassui.window.ppt.PPTTabLayer;
import com.baijiayun.groupclassui.window.ppt.PPTWindow;
import com.baijiayun.groupclassui.window.toolbar.DrawLineMode;
import com.baijiayun.groupclassui.window.toolbar.ToolbarWindow;
import com.baijiayun.groupclassui.window.toolbox.browser.BrowserWindow2;
import com.baijiayun.groupclassui.window.toolbox.quiz.QuizWindow;
import com.baijiayun.groupclassui.window.toolbox.randomselect.RandomSelectWindow;
import com.baijiayun.groupclassui.window.toolbox.smallblackboard.SbbUtils;
import com.baijiayun.groupclassui.window.toolbox.smallblackboard.SmallBlackboardStatus;
import com.baijiayun.groupclassui.window.toolbox.smallblackboard.SmallBlackboardWindow;
import com.baijiayun.groupclassui.window.toolbox.timer.StudentTimerWindow;
import com.baijiayun.groupclassui.window.toolbox.timer.TeacherTimerWindow;
import com.baijiayun.groupclassui.window.toolbox.turntable.TurntableWindow;
import com.baijiayun.groupclassui.window.video.VideoContainerWindow;
import com.baijiayun.groupclassui.window.video.VideoWindow;
import com.baijiayun.livebase.base.BasePresenter;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.GroupItem;
import com.baijiayun.livebase.models.LPJsonModel;
import com.baijiayun.livebase.models.LPUserModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.FileUtils;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livebase.widgets.dialog.CommonDialog;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.listener.OnPhoneRollCallListener;
import com.baijiayun.livecore.models.LPAnswerModel;
import com.baijiayun.livecore.models.LPDocModel;
import com.baijiayun.livecore.models.LPDocViewElementModel;
import com.baijiayun.livecore.models.LPDocViewUpdateModel;
import com.baijiayun.livecore.models.LPDocumentModel;
import com.baijiayun.livecore.models.LPGroupAwardModel;
import com.baijiayun.livecore.models.LPGroupItem;
import com.baijiayun.livecore.models.LPMotionEvent;
import com.baijiayun.livecore.models.LPPlayerViewUpdateModel;
import com.baijiayun.livecore.models.LPRandomSelectValueModel;
import com.baijiayun.livecore.models.LPRoomRollCallResultModel;
import com.baijiayun.livecore.models.LPSnippetPullReqModel;
import com.baijiayun.livecore.models.LPSnippetPullResModel;
import com.baijiayun.livecore.models.LPSnippetSubmitModel;
import com.baijiayun.livecore.models.LPTimerModel;
import com.baijiayun.livecore.models.LPTurntableModel;
import com.baijiayun.livecore.models.LPUploadDocModel;
import com.baijiayun.livecore.models.LPWebPageInfoModel;
import com.baijiayun.livecore.models.courseware.LPMediaCoursewareModel;
import com.baijiayun.livecore.models.imodels.IMediaModel;
import com.baijiayun.livecore.ppt.PPTView;
import com.baijiayun.livecore.ppt.whiteboard.LaserShapeLayer;
import com.baijiayun.livecore.ppt.whiteboard.shape.BitmapShape;
import com.baijiayun.livecore.utils.LPJsonUtils;
import com.baijiayun.livecore.utils.LPMediaIdUtils;
import com.baijiayun.liveuibase.base.BaseTitleWindow2;
import com.baijiayun.liveuibase.base.BaseUIConstant;
import com.baijiayun.liveuibase.base.BaseWindow;
import com.baijiayun.liveuibase.base.IWindow;
import com.baijiayun.liveuibase.base.RouterListener;
import com.baijiayun.liveuibase.toolbox.answerer.AdminAnswererWindow;
import com.baijiayun.liveuibase.toolbox.answerer.AnswererWindow;
import com.baijiayun.liveuibase.toolbox.browser.BrowserWindow;
import com.baijiayun.liveuibase.toolbox.browser.Tuple;
import com.baijiayun.liveuibase.toolbox.responder.ResponderRobButton;
import com.baijiayun.liveuibase.toolbox.responder.ResponderWindow;
import com.baijiayun.liveuibase.toolbox.rollcall.AdminRollCallWindow;
import com.baijiayun.liveuibase.toolbox.rollcall.RollCallDialogContract;
import com.baijiayun.liveuibase.toolbox.rollcall.RollCallDialogPresenter;
import com.baijiayun.liveuibase.toolbox.rollcall.RollCallWindow;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import com.baijiayun.liveuibase.utils.ToastUtil;
import com.baijiayun.liveuibase.widgets.popupwindow.BaseAutoArrangePopupWindow;
import com.baijiayun.liveuibase.widgets.toolbar.BaseDrawWidthSettingWindow;
import com.baijiayun.liveuibase.widgets.toolbar.BaseGraphMenuWindow;
import com.baijiayun.liveuibase.widgets.toolbar.ColorSelectData;
import com.baijiayun.liveuibase.widgets.toolbar.WidthSelectData;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;

public class SyncContainer
extends BaseLayerOfProfessionalClass {
    private final String TAG = SyncContainer.class.getSimpleName();
    private Disposable subscriptionOfDocDel;
    private Disposable subscriptionOfSelectMode;
    private Disposable subscriptionOfDrawLineMode;
    private ConcurrentLinkedQueue<PPTWindow> pptWindows;
    private BrowserWindow2 browserWindow;
    private ConcurrentLinkedQueue<VideoContainerWindow> videoWindows;
    private ConcurrentLinkedQueue<SmallBlackboardWindow> smallBlackboardWindows;
    private BaseWindow studentTimerWindow;
    private BaseWindow teacherTimerWindow;
    private BaseWindow studentAnswererWindow;
    private BaseWindow teacherAnswererWindow;
    private BaseWindow randomSelectWindow;
    private BaseWindow rollCallWindow;
    private BaseWindow adminRollCallWindow;
    private BaseWindow turntableWindow;
    private QuizWindow quizWindow;
    private ConcurrentHashMap<String, LPPlayerViewUpdateModel> cachedViewPositions;
    private BaseLayerOfProfessionalClass documentLayer;
    private BaseLayerOfProfessionalClass blackboardLayer;
    private BaseLayerOfProfessionalClass smallBlackboardLayer;
    private BaseLayerOfProfessionalClass browserLayer;
    private BaseLayerOfProfessionalClass toolBoxLayer;
    private BaseLayerOfProfessionalClass randomSelectLayer;
    private PPTTabLayer pptTabLayer;
    private VideoLayer videoLayer;
    private LaserShapeLayer laserShapeLayer;
    private BaseTitledWindow maximumWindow;
    private final ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
    private ShapePaint shapePaint;
    private final Set<IUserModel> sbbAllUserSet = new HashSet<IUserModel>();
    private LPPlayerViewUpdateModel mediaCachePlayerUpdateModel = new LPPlayerViewUpdateModel();
    private final LPMotionEvent lpMotionEvent = new LPMotionEvent();
    LPDocumentModel mPreviewDocModel = null;
    private boolean pptAuth;
    private int selfWidth;
    private int selfHeight;
    private float writingBoardRatio = 1.0f;
    private PPTWindow destPPTWindow;
    private MediaCoursewarePlayerWindow mediaPlayerWindow;
    private RollCallDialogPresenter rollCallDialogPresenter;
    private List<LPDocViewElementModel> webpageUpdateModeList = new ArrayList<LPDocViewElementModel>();
    private LPDocViewUpdateModel webpageUpdateModel;
    private Boolean isCheckNotRemind = false;
    private Dialog remindDialog;
    private boolean isQuizSolution = false;
    private String bitmapShapeId;
    private static final int DEFAULT_SHAPE_COLOR = Color.parseColor((String)"#FF1e5eff");
    private static final float DEFAULT_SHAPE_WIDTH = 2.0f;
    private LPConstants.ShapeType lastCustomShapeType = LPConstants.ShapeType.StraightLine;
    private int shapeStrokeWidthIndex;
    private int shapeColorIndex;
    private static final int[] graphStrokeWidthArray = new int[]{0, 2, 4, 6};
    private boolean hasDrawingAuth;
    private BrowserWindow.BrowserChangeListener browserChangeListener = new BrowserWindow.BrowserChangeListener(){

        public void onOpenBrowser(boolean isOpen) {
            SyncContainer.this.router.getSubjectByKey(EventKey.OpenBrowserWindow).onNext((Object)isOpen);
        }

        public void onCloseBrowser() {
            SyncContainer.this.router.getSubjectByKey(EventKey.CloseBrowserDialog).onNext((Object)true);
        }

        public void onRepositionWebpage(Tuple tuple) {
            SyncContainer.this.router.getSubjectByKey(EventKey.RepositionWebpage).onNext((Object)tuple);
        }

        public void onOpenWebpage(BrowserWindow window) {
            SyncContainer.this.router.getSubjectByKey(EventKey.AddWebpage).onNext((Object)window);
        }

        public void onMaxInSync(BaseTitleWindow2 window) {
            SyncContainer.this.router.getSubjectByKey(EventKey.SetMaximumWindowOn).onNext((Object)window);
        }

        public void onResetMaxInSync(BaseTitleWindow2 window) {
            SyncContainer.this.router.getSubjectByKey(EventKey.SetMaximumWindowOff).onNext((Object)window);
        }

        public void onMinInSync(BaseTitleWindow2 window) {
            SyncContainer.this.router.getSubjectByKey(EventKey.MinimizeWindowOn).onNext((Object)window);
        }

        public void onResetMinInSync(BaseTitleWindow2 window) {
            SyncContainer.this.router.getSubjectByKey(EventKey.MinimizeWindowOff).onNext((Object)window);
        }

        public void onMaxInFull(BaseTitleWindow2 window) {
            SyncContainer.this.router.getSubjectByKey(EventKey.SetFullScreenWindowOn).onNext((Object)window);
        }

        public void onResetInFull(BaseTitleWindow2 window) {
            SyncContainer.this.router.getSubjectByKey(EventKey.SetFullScreenWindowOff).onNext((Object)window);
        }
    };
    private final Runnable webpageRunnable = () -> {
        this.browserWindow = new BrowserWindow2(this.getContext());
        this.browserWindow.setBrowserChangeListener(this.browserChangeListener);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams((int)this.getResources().getDimension(R.dimen.bjy_base_default_browser_width), (int)this.getResources().getDimension(R.dimen.bjy_base_default_browser_height));
        layoutParams.leftMargin = (this.getWidth() - layoutParams.width) / 2;
        layoutParams.topMargin = (this.getHeight() - layoutParams.height) / 2;
        this.browserLayer.addWindow((IWindow)this.browserWindow, layoutParams);
        if (this.webpageUpdateModel != null) {
            this.handleWebpageUpdate(this.webpageUpdateModel);
        }
    };
    private PointF lastTimerPosition;
    private long[] lastTimerSetting;
    private boolean isOpenSbb;
    private Disposable responderButtonDelayDisposable;
    private GroupAwardWindow groupAwardWindow;
    private LPSnippetPullResModel snippetPullResModel;
    private ResponderWindow responderWindow;
    private boolean isFirstCalledHandleVideoWindowPosition = false;
    private View responderPrepareView;
    private ResponderRobButton responderRobButton;
    Disposable responderIntervalDisposable;
    Disposable responderButtonDisposable;

    public SyncContainer(@NonNull Context context) {
        super(context);
        this.initBlackboardLayer();
    }

    public SyncContainer(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs, 0);
        this.initBlackboardLayer();
    }

    public SyncContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initBlackboardLayer();
    }

    private void initBlackboardLayer() {
        this.blackboardLayer = new BlackboardLayer(this.getContext());
        this.addView((View)this.blackboardLayer.getViewGroup());
        this.shapePaint = new ShapePaint(DEFAULT_SHAPE_COLOR, 2.0f);
        ((BlackboardLayer)this.blackboardLayer).setShapePaint(this.shapePaint);
    }

    private void initSyncContainer() {
        this.documentLayer = new DocumentLayer(this.getContext());
        this.pptTabLayer = new PPTTabLayer(this.getContext());
        this.smallBlackboardLayer = new BaseLayerOfProfessionalClass(this.getContext());
        this.browserLayer = new BaseLayerOfProfessionalClass(this.getContext());
        this.randomSelectLayer = new BaseLayerOfProfessionalClass(this.getContext());
        this.videoLayer = new VideoLayer(this.getContext());
        this.laserShapeLayer = new LaserShapeLayer(this.getContext());
        this.toolBoxLayer = new BaseLayerOfProfessionalClass(this.getContext());
        this.addView((View)this.documentLayer.getViewGroup());
        if (BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
            this.addView((View)this.pptTabLayer.getViewGroup());
        }
        this.addView((View)this.laserShapeLayer, this.lp);
        this.addView((View)this.videoLayer.getViewGroup());
        this.addView((View)this.randomSelectLayer);
        this.addView((View)this.browserLayer.getViewGroup());
        this.addView((View)this.smallBlackboardLayer.getViewGroup());
        this.addView((View)this.toolBoxLayer.getViewGroup());
        this.pptTabLayer.show(false);
        this.router.setObjectByKey(EventKey.PPTTabLayer, this.pptTabLayer);
        this.laserShapeLayer.setOnChangeLaserShapeListener(info -> {
            if (this.pptWindows == null) {
                return;
            }
            for (PPTWindow pptWindow : this.getPPTWindows()) {
                if (pptWindow.isMaxInFull()) {
                    info.isFull = true;
                    pptWindow.getPPTView().getPPTPagePositionInfo(info);
                    continue;
                }
                if (!pptWindow.isMaxInSync() || info.isFull) continue;
                pptWindow.getPPTView().getPPTPagePositionInfo(info);
            }
        });
    }

    @Override
    public boolean onRoomStatusChange(boolean isRoomActive) {
        boolean isLayerInit = super.onRoomStatusChange(isRoomActive);
        if (isLayerInit && !isRoomActive) {
            this.isFirstCalledHandleVideoWindowPosition = false;
            this.removeAndDestroy(this.documentLayer);
            this.removeAndDestroy(this.smallBlackboardLayer);
            this.removeAndDestroy(this.browserLayer);
            this.removeAndDestroy(this.randomSelectLayer);
            this.removeAndDestroy(this.videoLayer);
            this.removeAndDestroy(this.toolBoxLayer);
            this.destroyToolBox();
            this.clearVideoWindows();
            this.clearPPTWindows();
            this.dismissAdminRollCallWindow();
            this.dismissRollCallWindow();
            if (this.shapePaint != null) {
                this.shapePaint.removeAllListener();
            }
            if (this.laserShapeLayer != null) {
                this.removeView((View)this.laserShapeLayer);
                this.laserShapeLayer.onDestroy();
            }
            if (this.pptTabLayer != null) {
                UtilsKt.removeViewFromParent((View)this.pptTabLayer);
            }
            if (this.randomSelectWindow != null) {
                this.randomSelectLayer.removeWindow((IWindow)this.randomSelectWindow);
                this.randomSelectWindow.onDestroy();
                this.randomSelectWindow = null;
            }
            this.removeAndDestroy(this.randomSelectLayer);
            this.mPreviewDocModel = null;
            if (this.mediaPlayerWindow != null) {
                this.mediaPlayerWindow.onDestroy();
                this.mediaPlayerWindow = null;
            }
        }
        return true;
    }

    public void initView() {
        if (this.selfWidth != 0) {
            this.router.setObjectByKey(EventKey.FullScreenWidth, this.selfWidth);
        }
        ((BlackboardLayer)this.blackboardLayer).initView();
        this.initSyncContainer();
        this.subscribe();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.selfWidth = this.getMeasuredWidth();
        this.selfHeight = this.getMeasuredHeight();
        if (this.router != null) {
            this.router.setObjectByKey(EventKey.FullScreenWidth, this.selfWidth);
        }
    }

    private void subscribe() {
        if (this.router.getLiveRoom() != null) {
            this.initPPT();
            this.initBrowser();
            this.initVideo();
            this.initTimer();
            this.initAnswerer();
            this.initQuiz();
            this.router.setObjectByKey(EventKey.AllSnippetViewList, new ArrayList());
            this.startSbbObservable();
            this.startResponderObservable();
            this.startMediaCoursewareObservable();
            this.startOtherObservable();
        }
    }

    private void initQuiz() {
        this.compositeDisposable.add(this.router.getLiveRoom().getQuizVM().getObservableOfQuizStart().observeOn(AndroidSchedulers.mainThread()).subscribe(jsonModel -> {
            if (this.router.getLiveRoom().getCurrentUser().getType() != LPConstants.LPUserType.Teacher) {
                this.onQuizArrived((LPJsonModel)jsonModel, false);
            }
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getQuizVM().getObservableOfQuizRes().observeOn(AndroidSchedulers.mainThread()).subscribe(jsonModel -> {
            if (this.router.getLiveRoom().getCurrentUser().getType() != LPConstants.LPUserType.Teacher && jsonModel != null && jsonModel.data != null) {
                boolean endFlag;
                String quizId = "";
                if (jsonModel.data.has("quiz_id")) {
                    quizId = jsonModel.data.get("quiz_id").getAsString();
                }
                boolean solutionStatus = !jsonModel.data.has("solution") || jsonModel.data.getAsJsonObject("solution").entrySet().isEmpty() || jsonModel.data.getAsJsonObject("solution").isJsonNull();
                boolean bl = endFlag = jsonModel.data.get("end_flag").getAsInt() == 1;
                if (!TextUtils.isEmpty((CharSequence)quizId) && solutionStatus && !endFlag) {
                    this.onQuizArrived((LPJsonModel)jsonModel, false);
                }
            }
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getQuizVM().getObservableOfQuizEnd().observeOn(AndroidSchedulers.mainThread()).subscribe(jsonModel -> {
            if (this.router.getLiveRoom().getCurrentUser().getType() != LPConstants.LPUserType.Teacher) {
                this.onQuizEndArrived((LPJsonModel)jsonModel);
            }
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getQuizVM().getObservableOfQuizSolution().observeOn(AndroidSchedulers.mainThread()).subscribe(jsonModel -> {
            if (this.router.getLiveRoom().getCurrentUser().getType() != LPConstants.LPUserType.Teacher) {
                this.onQuizArrived((LPJsonModel)jsonModel, true);
            }
        }));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.CloseQuizDialog).observeOn(AndroidSchedulers.mainThread()).subscribe(o -> {
            boolean b = (Boolean)o;
            if (b ^ this.isQuizSolution) {
                return;
            }
            if (this.quizWindow != null) {
                if (this.toolBoxLayer != null) {
                    this.toolBoxLayer.removeWindow((IWindow)this.quizWindow);
                }
                this.quizWindow.onDestroy();
                this.quizWindow = null;
            }
        }));
    }

    private FrameLayout.LayoutParams getQuizParams() {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.getContext().getResources().getDimensionPixelSize(R.dimen.bjysc_quiz_width), this.getContext().getResources().getDimensionPixelSize(R.dimen.bjysc_quiz_height));
        layoutParams.gravity = 17;
        return layoutParams;
    }

    private void onQuizEndArrived(LPJsonModel jsonModel) {
        if (this.quizWindow != null) {
            this.quizWindow.onEndArrived(jsonModel);
        }
    }

    private void onQuizArrived(LPJsonModel jsonModel, boolean isShow) {
        this.isQuizSolution = isShow;
        if (this.quizWindow != null) {
            if (this.toolBoxLayer != null) {
                this.toolBoxLayer.removeWindow((IWindow)this.quizWindow);
            }
            this.quizWindow.onDestroy();
        }
        this.quizWindow = new QuizWindow(this.getContext(), isShow, jsonModel);
        if (this.toolBoxLayer != null) {
            this.toolBoxLayer.addWindow((IWindow)this.quizWindow, this.getQuizParams());
        }
    }

    private void initPPT() {
        this.pptAuth = BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom());
        this.pptWindows = new ConcurrentLinkedQueue();
        this.laserShapeLayer.setLiveRoom(this.router.getLiveRoom());
        this.compositeDisposable.add(this.router.getLiveRoom().getDocListVM().getObservableOfDocAll().observeOn(AndroidSchedulers.mainThread()).subscribe(allModel -> {
            LPDocumentModel previewDocModel = null;
            boolean checkNowPreviewExist = false;
            for (LPDocumentModel docModel : allModel.docList) {
                boolean checkTimeAndDocId;
                if ("0".equals(docModel.id) && docModel.extraModel != null) {
                    this.getBlackboardLayer().scrollTo(Float.parseFloat(docModel.extraModel.scrollTop));
                    this.showBlackboardPage(Float.parseFloat(docModel.extraModel.scrollTop));
                }
                checkNowPreviewExist = checkNowPreviewExist || this.mPreviewDocModel != null && TextUtils.equals((CharSequence)this.mPreviewDocModel.getDocId(), (CharSequence)docModel.getDocId());
                boolean isAPIDoc = docModel.lastModified != 0;
                if (!isAPIDoc || !FileUtils.checkPreviewFileValid((String)docModel.ext)) continue;
                boolean bl = checkTimeAndDocId = previewDocModel == null;
                if (!checkTimeAndDocId) {
                    boolean bl2 = checkTimeAndDocId = previewDocModel.lastModified < docModel.lastModified;
                }
                if (!checkTimeAndDocId && previewDocModel.lastModified == docModel.lastModified) {
                    boolean bl3 = checkTimeAndDocId = Integer.parseInt(docModel.getDocId()) > Integer.parseInt(previewDocModel.getDocId());
                }
                if (!checkTimeAndDocId) continue;
                previewDocModel = docModel;
            }
            if (!checkNowPreviewExist && this.mPreviewDocModel != null) {
                this.removeAndDestroyPPTView(this.mPreviewDocModel.getDocId() + "_preview");
            }
            this.handlePreviewDoc(previewDocModel);
        }, throwable -> {}));
        this.compositeDisposable.add(this.router.getLiveRoom().getDocListVM().getObservableOfDocUpdate().observeOn(AndroidSchedulers.mainThread()).subscribe(docModel -> {
            if (docModel.docUpdateExtraModel == null || docModel.docId == null) {
                return;
            }
            if ("0".equals(docModel.docId)) {
                this.getBlackboardLayer().scrollTo(Float.parseFloat(docModel.docUpdateExtraModel.scrollTop));
                this.showBlackboardPage(Float.parseFloat(docModel.docUpdateExtraModel.scrollTop));
            }
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getObservableOfClassStart().observeOn(AndroidSchedulers.mainThread()).subscribe(integer -> {
            if (this.mPreviewDocModel != null) {
                this.removeAndDestroyPPTView(this.mPreviewDocModel.id + "_preview");
            }
        }));
        this.subscriptionOfDocDel = this.router.getLiveRoom().getDocListVM().getObservableOfDocDelete().filter(s -> !TextUtils.isEmpty((CharSequence)s)).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> {
            for (PPTWindow pptWindow : this.pptWindows) {
                if (!s.equals(pptWindow.getRealDocId())) continue;
                this.documentLayer.removeWindow((IWindow)pptWindow);
                this.pptWindows.remove(pptWindow);
                pptWindow.onDestroy();
                List<LPDocViewElementModel> allDocList = this.router.getListByKey(EventKey.AllDocViewList, LPDocViewElementModel.class);
                for (LPDocViewElementModel model : allDocList) {
                    if (!model.docId.equals(s)) continue;
                    allDocList.remove(model);
                    break;
                }
                this.router.setObjectByKey(EventKey.AllDocViewList, allDocList);
                break;
            }
            this.refreshPPTWindowCache();
            this.pptTabLayer.refreshTabs();
        });
        Disposable disposableOfDocViewUpdate = this.router.getLiveRoom().getDocListVM().getObservableOfDocViewUpdate().filter(lpDocViewUpdateModel -> TextUtils.isEmpty((CharSequence)lpDocViewUpdateModel.nextAction) || lpDocViewUpdateModel.isFromCache).observeOn(AndroidSchedulers.mainThread()).subscribe(lpDocViewUpdateModel -> {
            boolean needInsertNew;
            if (lpDocViewUpdateModel.all == null) {
                return;
            }
            ArrayList<LPDocViewElementModel> tempList = new ArrayList<LPDocViewElementModel>();
            for (LPDocViewElementModel elementModel : lpDocViewUpdateModel.all) {
                if (!this.checkStoreContainsPPT(elementModel)) continue;
                tempList.add(elementModel);
            }
            lpDocViewUpdateModel.all = tempList;
            this.router.setObjectByKey(EventKey.AllDocViewList, lpDocViewUpdateModel.all);
            boolean bl = needInsertNew = this.pptWindows.isEmpty() || this.pptWindows.size() == 1 && ((PPTWindow)this.pptWindows.toArray()[0]).getId().contains("_preview");
            if (needInsertNew) {
                PPTWindow fullPPTWindow;
                PPTWindow topWindow;
                PPTWindow maxPPTWindow = null;
                boolean hasMaxOrFullPPTWindow = false;
                for (LPDocViewElementModel elementModel : lpDocViewUpdateModel.all) {
                    PPTWindow pptWindow = this.newPPTWindow(elementModel);
                    if (elementModel.full == 1) {
                        hasMaxOrFullPPTWindow = true;
                        pptWindow.maxInFull(true);
                        continue;
                    }
                    if (elementModel.max != 1) continue;
                    hasMaxOrFullPPTWindow = true;
                    maxPPTWindow = pptWindow;
                }
                if (maxPPTWindow != null) {
                    maxPPTWindow.maxInSync(true);
                }
                if (this.pptWindows.size() > 1 && lpDocViewUpdateModel.isFromCache) {
                    ArrayList<PPTWindow> tempWindows = new ArrayList<PPTWindow>(this.pptWindows);
                    Collections.sort(tempWindows, (o1, o2) -> {
                        if (o1.isPreviewPPT()) {
                            return 1;
                        }
                        if (o2.isPreviewPPT()) {
                            return -1;
                        }
                        return (int)(o1.getRealDocIdWithNum() - o2.getRealDocIdWithNum());
                    });
                    this.pptWindows.clear();
                    this.pptWindows.addAll(tempWindows);
                }
                PPTWindow pPTWindow = topWindow = (fullPPTWindow = this.router.getValueByKey(EventKey.FullScreenPPTWindow, PPTWindow.class)) != null ? fullPPTWindow : maxPPTWindow;
                if (topWindow != null && !this.pptWindows.isEmpty() && lpDocViewUpdateModel.isFromCache) {
                    PPTWindow previewPPTWindow = null;
                    for (PPTWindow pptWindow : this.pptWindows) {
                        if (!pptWindow.isPreviewPPT()) continue;
                        previewPPTWindow = pptWindow;
                        break;
                    }
                    if (previewPPTWindow != null && previewPPTWindow.isPreviewPPT() && previewPPTWindow != topWindow) {
                        topWindow.switchTab(previewPPTWindow);
                    }
                }
                if (!hasMaxOrFullPPTWindow) {
                    this.checkExistTopPreviewPPTWindow();
                }
                return;
            }
            switch (lpDocViewUpdateModel.action) {
                case "add": {
                    this.addPPTView((LPDocViewUpdateModel)lpDocViewUpdateModel);
                    break;
                }
                case "remove": {
                    this.removeAndDestroyPPTView(lpDocViewUpdateModel.docId);
                    break;
                }
                case "stick": {
                    PPTWindow topPPTWindow;
                    if (this.router.getLiveRoom().getCurrentUser().getUserId().equals(lpDocViewUpdateModel.userId)) {
                        return;
                    }
                    if (this.router.getValueByKey(EventKey.SetFullScreenWindowOn, Boolean.class, false).booleanValue()) {
                        return;
                    }
                    PPTWindow maxPPTWindow = this.router.getValueByKey(EventKey.MaxScreenPPTWindow, PPTWindow.class);
                    PPTWindow fullPPTWindow = this.router.getValueByKey(EventKey.FullScreenPPTWindow, PPTWindow.class);
                    PPTWindow pPTWindow = topPPTWindow = fullPPTWindow != null ? fullPPTWindow : maxPPTWindow;
                    if (topPPTWindow != null && topPPTWindow.isPreviewPPT()) break;
                    this.bringToFront(lpDocViewUpdateModel.docId);
                    break;
                }
                case "normal": {
                    this.backToNormal(lpDocViewUpdateModel.docId);
                    break;
                }
                case "max": {
                    this.maximumWindow(lpDocViewUpdateModel.docId);
                    break;
                }
                case "full": {
                    this.fullscreenWindow(lpDocViewUpdateModel.docId);
                    break;
                }
                case "reposition": {
                    if (this.router.getLiveRoom().getCurrentUser().getUserId().equals(lpDocViewUpdateModel.userId)) {
                        return;
                    }
                    this.repositionWindow((LPDocViewUpdateModel)lpDocViewUpdateModel);
                    break;
                }
            }
            this.laserShapeLayer.bringToFront();
        });
        Disposable disposableOfWebpageUpdate = this.router.getLiveRoom().getToolBoxVM().getObservableOfWebpageUpdate().observeOn(AndroidSchedulers.mainThread()).subscribe(this::handleWebpageUpdate);
        Disposable disposableOfAuthPaintColor = this.router.getLiveRoom().getObservableOfAuthPaintColor().observeOn(AndroidSchedulers.mainThread()).subscribe(map -> {
            if (this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher) {
                return;
            }
            if (this.router.getValueByKey(EventKey.IsChangedPaintColor, Boolean.class, false).booleanValue()) {
                return;
            }
            for (String paintColor : map.keySet()) {
                if (!this.router.getLiveRoom().getCurrentUser().getNumber().equals(map.get(paintColor))) continue;
                this.router.getSubjectByKey(EventKey.DrawColorAllChange).onNext((Object)paintColor);
                this.shapePaint.setShapeColor(new ColorSelectData(BaseUIConstant.SelectSrc.Graph, Color.parseColor((String)paintColor)));
                this.shapePaint.setShapeColor(new ColorSelectData(BaseUIConstant.SelectSrc.Text, Color.parseColor((String)paintColor)));
                this.shapePaint.setShapeColor(new ColorSelectData(BaseUIConstant.SelectSrc.Brush, Color.parseColor((String)paintColor)));
                this.shapePaint.setShapeColor(new ColorSelectData(BaseUIConstant.SelectSrc.Marker, Color.parseColor((String)paintColor)));
                break;
            }
            if (!ToolbarWindow.preColorCache.isEmpty()) {
                for (BaseUIConstant.SelectSrc selectSrc : ToolbarWindow.preColorCache.keySet()) {
                    Integer color2 = ToolbarWindow.preColorCache.get(selectSrc);
                    if (color2 == null) continue;
                    this.shapePaint.setShapeColor(new ColorSelectData(selectSrc, color2.intValue()));
                }
            }
        });
        Disposable disposableOfCloseWindow = this.router.getSubjectByKey(EventKey.ClosePPTWindow).ofType(Tuple.class).subscribe(tuple -> {
            this.updateToolbarWindow();
            UtilsKt.removeViewFromParent((View)this.laserShapeLayer);
            this.addView((View)this.laserShapeLayer, this.lp);
            if (tuple.docId.contains("_preview")) {
                this.removeAndDestroyPPTView(tuple.docId);
                return;
            }
            List<LPDocViewElementModel> allDocList = this.getAllDocList();
            if (allDocList == null || allDocList.size() == 0) {
                return;
            }
            LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
            lpDocViewUpdateModel.docId = tuple.docId;
            lpDocViewUpdateModel.action = "remove";
            if (this.router.getValueByKey(EventKey.AllDocViewList, ArrayList.class) == null) {
                return;
            }
            for (LPDocViewElementModel elementModel : allDocList) {
                if (!elementModel.docId.equals(tuple.docId)) continue;
                allDocList.remove(elementModel);
                lpDocViewUpdateModel.all = allDocList;
                this.router.getLiveRoom().getDocListVM().requestDocViewUpdate(lpDocViewUpdateModel);
                break;
            }
        });
        Disposable disposableOfRepositionWindow = this.router.getSubjectByKey(EventKey.RepositionPPTWindow).ofType(Tuple.class).filter(tuple -> tuple.docId != null).throttleLast(1L, TimeUnit.SECONDS).subscribe(tuple -> {
            block3: {
                LPDocViewUpdateModel lpDocViewUpdateModel;
                List<LPDocViewElementModel> allDocList;
                block4: {
                    allDocList = this.getAllDocList();
                    if (allDocList == null || allDocList.isEmpty()) {
                        return;
                    }
                    lpDocViewUpdateModel = new LPDocViewUpdateModel();
                    lpDocViewUpdateModel.docId = tuple.docId;
                    lpDocViewUpdateModel.action = "reposition";
                    if (!tuple.action.equals("move")) break block4;
                    for (LPDocViewElementModel elementModel : allDocList) {
                        if (!elementModel.docId.equals(tuple.docId)) continue;
                        elementModel.x = String.valueOf((float)tuple.width / (float)this.getWidth());
                        elementModel.y = String.valueOf((float)tuple.height / (float)this.getHeight());
                        lpDocViewUpdateModel.all = allDocList;
                        this.router.getLiveRoom().getDocListVM().requestDocViewUpdate(lpDocViewUpdateModel);
                        break block3;
                    }
                    break block3;
                }
                if (!tuple.action.equals("scale")) break block3;
                for (LPDocViewElementModel elementModel : allDocList) {
                    if (!elementModel.docId.equals(tuple.docId)) continue;
                    elementModel.width = String.valueOf((float)tuple.width / (float)this.getWidth());
                    elementModel.height = String.valueOf((float)tuple.height / (float)this.getHeight());
                    lpDocViewUpdateModel.all = allDocList;
                    this.router.getLiveRoom().getDocListVM().requestDocViewUpdate(lpDocViewUpdateModel);
                    break;
                }
            }
        });
        Disposable disposableOfAddWebpage = this.router.getSubjectByKey(EventKey.AddWebpage).ofType(BrowserWindow2.class).subscribe(window -> {
            LPDocViewUpdateModel lpWebpageUpdateModel = new LPDocViewUpdateModel();
            lpWebpageUpdateModel.docId = window.getId();
            lpWebpageUpdateModel.userId = this.router.getLiveRoom().getCurrentUser().getUserId();
            if (window.isAdd) {
                LPDocViewElementModel lpDocViewElementModel = new LPDocViewElementModel();
                lpDocViewElementModel.docId = window.getId();
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)window.getView().getLayoutParams();
                lpDocViewElementModel.x = String.valueOf((float)layoutParams.leftMargin / (float)this.getWidth());
                lpDocViewElementModel.y = String.valueOf((float)layoutParams.topMargin / (float)this.getHeight());
                lpDocViewElementModel.width = String.valueOf((float)window.getView().getWidth() / (float)this.getWidth());
                lpDocViewElementModel.height = String.valueOf((float)window.getView().getHeight() / (float)this.getHeight());
                lpDocViewElementModel.full = window.isMaxInFull() ? 1 : 0;
                lpDocViewElementModel.max = window.isMaxInSync() ? 1 : 0;
                ArrayList<LPDocViewElementModel> all = new ArrayList<LPDocViewElementModel>();
                all.add(lpDocViewElementModel);
                lpWebpageUpdateModel.action = "add";
                lpWebpageUpdateModel.all = all;
                this.webpageUpdateModeList = all;
            } else {
                this.webpageUpdateModeList.clear();
                lpWebpageUpdateModel.action = "remove";
                lpWebpageUpdateModel.all = new ArrayList();
            }
            this.router.getLiveRoom().getToolBoxVM().requestWebpageUpdate(lpWebpageUpdateModel);
        });
        Disposable disposableOfRepositionWebpage = this.router.getSubjectByKey(EventKey.RepositionWebpage).ofType(Tuple.class).throttleLast(1L, TimeUnit.SECONDS).subscribe(tuple -> {
            block3: {
                LPDocViewUpdateModel lpDocViewUpdateModel;
                block4: {
                    if (this.webpageUpdateModeList.isEmpty()) {
                        return;
                    }
                    lpDocViewUpdateModel = new LPDocViewUpdateModel();
                    lpDocViewUpdateModel.docId = tuple.docId;
                    lpDocViewUpdateModel.userId = this.router.getLiveRoom().getCurrentUser().getUserId();
                    lpDocViewUpdateModel.action = "reposition";
                    if (!tuple.action.equals("move")) break block4;
                    for (LPDocViewElementModel elementModel : this.webpageUpdateModeList) {
                        if (!TextUtils.equals((CharSequence)elementModel.docId, (CharSequence)tuple.docId)) continue;
                        elementModel.x = String.valueOf((float)tuple.width / (float)this.getWidth());
                        elementModel.y = String.valueOf((float)tuple.height / (float)this.getHeight());
                        lpDocViewUpdateModel.all = this.webpageUpdateModeList;
                        this.router.getLiveRoom().getToolBoxVM().requestWebpageUpdate(lpDocViewUpdateModel);
                        break block3;
                    }
                    break block3;
                }
                if (!tuple.action.equals("scale")) break block3;
                for (LPDocViewElementModel elementModel : this.webpageUpdateModeList) {
                    if (!TextUtils.equals((CharSequence)elementModel.docId, (CharSequence)tuple.docId)) continue;
                    elementModel.width = String.valueOf((float)tuple.width / (float)this.getWidth());
                    elementModel.height = String.valueOf((float)tuple.height / (float)this.getHeight());
                    lpDocViewUpdateModel.all = this.webpageUpdateModeList;
                    this.router.getLiveRoom().getToolBoxVM().requestWebpageUpdate(lpDocViewUpdateModel);
                    break;
                }
            }
        });
        Disposable disposableOfResetToolbarMode = this.router.getSubjectByKey(EventKey.ResetToolbarStatus).ofType(Boolean.class).subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                this.shapePaint.setPPtEditMode(LPConstants.PPTEditMode.Normal);
            } else {
                this.shapePaint.setPPtEditMode(LPConstants.PPTEditMode.PPTTouchMode);
            }
            this.showTitleFooter();
            ((BlackboardScrollView)this.getBlackboardLayer().getBlackImageWindow().getView()).setScrollEnable(true);
            this.getBlackboardLayer().getBlackImageWindow().getWhiteboardView().invalidateTextBoundary();
        });
        this.subscriptionOfSelectMode = this.router.getSubjectByKey(EventKey.SelectModeEnable).ofType(Boolean.class).subscribe(aBoolean -> {
            this.shapePaint.setPPtEditMode(LPConstants.PPTEditMode.SelectMode);
            this.hideTitleFooter();
            ((BlackboardScrollView)this.getBlackboardLayer().getBlackImageWindow().getView()).setScrollEnable(aBoolean == false);
        });
        this.subscriptionOfDrawLineMode = this.router.getSubjectByKey(EventKey.DrawLineModeEnable).filter(data -> data instanceof List && ((List)data).get(0) instanceof DrawLineMode).filter(drawLineMode -> drawLineMode != DrawLineMode.NONE).subscribe(data -> {
            DrawLineMode drawLineMode = (DrawLineMode)((Object)((Object)((List)data).get(0)));
            this.shapePaint.setPPtEditMode(LPConstants.PPTEditMode.ShapeMode);
            if (drawLineMode != DrawLineMode.NONE) {
                if (drawLineMode == DrawLineMode.MARKER_MODE) {
                    this.shapePaint.setShapeType(BaseUIConstant.SelectSrc.Marker, LPConstants.ShapeType.MarkerDoodle);
                } else {
                    this.shapePaint.setShapeType(BaseUIConstant.SelectSrc.Brush, LPConstants.ShapeType.Doodle);
                }
                this.router.getSubjectByKey(EventKey.DrawTextEnable).onNext((Object)false);
                this.router.getSubjectByKey(EventKey.LaserDrawEnable).onNext((Object)false);
            }
            this.hideTitleFooter();
            ((BlackboardScrollView)this.getBlackboardLayer().getBlackImageWindow().getView()).setScrollEnable(false);
        });
        Disposable disposableGraphDraw = this.router.getSubjectByKey(EventKey.GraphDrawEnable).ofType(BaseGraphMenuWindow.OnShapeChangeModel.class).filter(model -> !model.isInitDrawable()).subscribe(model -> {
            this.shapePaint.setPPtEditMode(LPConstants.PPTEditMode.ShapeMode);
            this.shapePaint.setShapeType(BaseUIConstant.SelectSrc.Graph, model.getShapeType());
            this.lastCustomShapeType = model.getShapeType();
            this.hideTitleFooter();
            if (this.getBlackboardLayer().getBlackImageWindow() != null) {
                ((BlackboardScrollView)this.getBlackboardLayer().getBlackImageWindow().getView()).setScrollEnable(false);
            }
        });
        Disposable disposableStrokeWidth = this.router.getSubjectByKey(EventKey.DrawWidthChange).ofType(WidthSelectData.class).subscribe(widthSelectData -> this.shapePaint.setDoodleStrokeWidth((WidthSelectData)widthSelectData));
        Disposable disposableCustomGraphWidth = this.router.getSubjectByKey(EventKey.CustomGraphWidthChange).ofType(WidthSelectData.class).subscribe(widthSelectData -> this.shapePaint.setCustomStrokeWidth(widthSelectData.getWidth()));
        Disposable disposableOfCustomGraphMenuEnable = this.router.getSubjectByKey(EventKey.GraphMenuEnable).filter(view -> view instanceof View).subscribe(view -> {
            this.shapePaint.setPPtEditMode(LPConstants.PPTEditMode.ShapeMode);
            this.shapePaint.setShapeType(BaseUIConstant.SelectSrc.Graph, this.lastCustomShapeType);
            this.hideTitleFooter();
            ((BlackboardScrollView)this.getBlackboardLayer().getBlackImageWindow().getView()).setScrollEnable(false);
        });
        Disposable disposableEraseMode = this.router.getSubjectByKey(EventKey.GraphSelectEraseMode).ofType(Boolean.class).subscribe(aBoolean -> {
            for (PPTWindow pptWindow : this.getPPTWindows()) {
                pptWindow.getPPTView().eraseShapes();
            }
            this.getBlackboardLayer().getBlackImageWindow().eraseShapes();
            for (SmallBlackboardWindow smallBlackboardWindow : this.smallBlackboardWindows) {
                smallBlackboardWindow.eraseShapes();
            }
        });
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.GraphEraseMode).ofType(Boolean.class).subscribe(aBoolean -> {
            LPConstants.PPTEditMode pptEditMode;
            if (aBoolean.booleanValue()) {
                pptEditMode = LPConstants.PPTEditMode.EraserMode;
                this.hideTitleFooter();
            } else {
                pptEditMode = LPConstants.PPTEditMode.Normal;
                this.showTitleFooter();
            }
            if (this.shapePaint != null) {
                this.shapePaint.setPPtEditMode(pptEditMode);
            }
            for (PPTWindow pptWindow : this.getPPTWindows()) {
                pptWindow.getPPTView().setPPTEditMode(pptEditMode);
            }
            this.getBlackboardLayer().getBlackImageWindow().setPPTEditMode(pptEditMode);
            ((BlackboardScrollView)this.getBlackboardLayer().getBlackImageWindow().getView()).setScrollEnable(aBoolean == false);
            for (SmallBlackboardWindow smallBlackboardWindow : this.smallBlackboardWindows) {
                smallBlackboardWindow.setPPTEditMode(pptEditMode);
            }
            this.router.getSubjectByKey(EventKey.DrawTextEnable).onNext((Object)false);
        }));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.GraphEraseAll).ofType(Boolean.class).subscribe(aBoolean -> {
            if (this.isCheckNotRemind.booleanValue()) {
                this.getBlackboardLayer().getBlackImageWindow().eraseAll();
            } else {
                if (this.remindDialog == null) {
                    this.initRemindDialog();
                }
                this.remindDialog.show();
            }
        }));
        Disposable disposableDrawColorSetting = this.router.getSubjectByKey(EventKey.DrawColorChange).ofType(ColorSelectData.class).subscribe(data -> this.shapePaint.setShapeColor((ColorSelectData)data));
        Disposable disposableTextEdit = this.router.getSubjectByKey(EventKey.DrawTextEnable).filter(aBoolean -> aBoolean instanceof Boolean && (Boolean)aBoolean != false).subscribe(aBoolean -> {
            this.shapePaint.setPPtEditMode(LPConstants.PPTEditMode.ShapeMode);
            this.shapePaint.setShapeType(BaseUIConstant.SelectSrc.Text, LPConstants.ShapeType.Text);
            this.hideTitleFooter();
        });
        Disposable disposableOfTextSend = this.router.getSubjectByKey(EventKey.DrawTextSend).ofType(HashMap.class).subscribe(map -> {
            if (!Objects.equals(map.get("end"), "true")) {
                this.shapePaint.sendTextConfirmed((String)map.get("beforeText"), (String)map.get("afterText"));
            } else {
                this.invalidateTextBoundary();
            }
        });
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.ClearEditText).subscribe(o -> this.invalidateTextBoundary()));
        Disposable disposableOfTextSizeChange = this.router.getSubjectByKey(EventKey.DrawTextSizeChange).ofType(Integer.class).subscribe(integer -> this.shapePaint.setTextSize((int)integer));
        Disposable disposableOfBitmapShape = this.router.getSubjectByKey(EventKey.GraphBitmapEnable).ofType(LPUploadDocModel.class).subscribe(lpUploadDocModel -> {
            float ratio = (float)lpUploadDocModel.width / (float)lpUploadDocModel.height;
            if (lpUploadDocModel.width > this.getWidth() / 2) {
                lpUploadDocModel.width = this.getWidth() / 2;
                lpUploadDocModel.height = (int)((float)lpUploadDocModel.width / ratio);
            }
            this.getBlackboardLayer().getBlackImageWindow().getWhiteboardView().sendBitmapShape(lpUploadDocModel, this.getBlackboardLayer().getBlackImageWindow().getView().getScrollY());
        });
        Disposable bitmapShapeSelectedDisposable = this.router.getSubjectByKey(EventKey.BitmapShapeSelected).ofType(BitmapShape.class).subscribe(bitmapShape -> {
            this.bitmapShapeId = bitmapShape.id;
        });
        Disposable disposableOfBitmapShapeLayerSwitch = this.router.getSubjectByKey(EventKey.BitmapShapeLayerSwitch).ofType(Integer.class).subscribe(integer -> {
            if (TextUtils.isEmpty((CharSequence)this.bitmapShapeId)) {
                return;
            }
            this.getBlackboardLayer().getBlackImageWindow().getWhiteboardView().switchBitmapLayer(this.bitmapShapeId, integer.intValue());
        });
        Disposable disposableOfBitmapShapeScale = this.router.getSubjectByKey(EventKey.BitmapShapeScale).ofType(Integer.class).subscribe(progress -> {
            if (TextUtils.isEmpty((CharSequence)this.bitmapShapeId)) {
                return;
            }
            float scale = (float)progress.intValue() / 50.0f;
            this.getBlackboardLayer().getBlackImageWindow().getWhiteboardView().scaleBitmapShape(this.bitmapShapeId, scale);
        });
        Disposable disposableOfBitmapShapeErase = this.router.getSubjectByKey(EventKey.BitmapShapeErase).ofType(Boolean.class).subscribe(aBoolean -> {
            if (TextUtils.isEmpty((CharSequence)this.bitmapShapeId)) {
                return;
            }
            this.getBlackboardLayer().getBlackImageWindow().eraseBitmapShape(this.bitmapShapeId);
        });
        Disposable disposableOfH5DocumentDelete = this.router.getSubjectByKey(EventKey.CoursewareH5DocumentDeleteConfirm).ofType(List.class).subscribe(list -> {
            for (Object object : list) {
                this.router.getSubjectByKey(EventKey.ClosePPTWindow).onNext((Object)new Tuple((String)object, true));
            }
        });
        Disposable disposableOfLaserShape = this.router.getSubjectByKey(EventKey.LaserDrawEnable).ofType(Boolean.class).subscribe(aBoolean -> {
            if (this.laserShapeLayer != null) {
                this.laserShapeLayer.enableDrawLaser(aBoolean.booleanValue());
            }
        });
        Disposable disposableOfFullScreenOn = this.router.getSubjectByKey(EventKey.SetFullScreenWindowOn).filter(c -> this.router.getValueByKey(EventKey.SetFullScreenWindowOn, Boolean.class, false) == false).subscribe(window -> {
            if (window instanceof PPTWindow) {
                this.router.getSubjectByKey(EventKey.LaserLayerFullScreen).onNext((Object)this.laserShapeLayer);
                PPTWindow pptWindow = (PPTWindow)window;
                this.pptTabLayer.show(true);
                this.pptTabLayer.refreshTabs();
                this.pptTabLayer.refreshBtn(true);
                if (pptWindow.getId().contains("_preview")) {
                    this.addToFullCache();
                    return;
                }
                String docId = ((PPTWindow)window).getRealDocId();
                if (((PPTWindow)window).isReceiveOrder()) {
                    return;
                }
                List<LPDocViewElementModel> allDocList = this.getAllDocList();
                LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
                lpDocViewUpdateModel.docId = docId;
                lpDocViewUpdateModel.action = "full";
                if (allDocList == null || allDocList.isEmpty()) {
                    return;
                }
                for (LPDocViewElementModel elementModel : allDocList) {
                    if (!elementModel.docId.equals(lpDocViewUpdateModel.docId)) continue;
                    elementModel.full = 1;
                    lpDocViewUpdateModel.all = allDocList;
                    this.router.getLiveRoom().getDocListVM().requestDocViewUpdate(lpDocViewUpdateModel);
                    break;
                }
            }
            if (window instanceof BrowserWindow2) {
                if (window != this.browserWindow || this.browserWindow == null) {
                    return;
                }
                if (this.browserWindow.isReceiveOrder()) {
                    return;
                }
                if (this.webpageUpdateModeList.isEmpty()) {
                    return;
                }
                LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
                lpDocViewUpdateModel.docId = this.browserWindow.getId();
                lpDocViewUpdateModel.userId = this.router.getLiveRoom().getCurrentUser().getUserId();
                lpDocViewUpdateModel.action = "full";
                for (LPDocViewElementModel elementModel : this.webpageUpdateModeList) {
                    if (!TextUtils.equals((CharSequence)elementModel.docId, (CharSequence)lpDocViewUpdateModel.docId)) continue;
                    elementModel.full = 1;
                    lpDocViewUpdateModel.all = this.webpageUpdateModeList;
                    this.router.getLiveRoom().getToolBoxVM().requestWebpageUpdate(lpDocViewUpdateModel);
                    break;
                }
                this.browserLayer.removeWindow((IWindow)this.browserWindow);
                this.browserWindow = null;
            }
            if (window instanceof MediaCoursewarePlayerWindow) {
                Set<LPPlayerViewUpdateModel.PlayerPosition> allSet = this.router.getSetByKey(EventKey.AllPlayerViewList, LPPlayerViewUpdateModel.PlayerPosition.class);
                LPPlayerViewUpdateModel model = new LPPlayerViewUpdateModel();
                model.action = LPConstants.LPPlayerAction.FULL;
                model.id = model.mediaId = FECompatUtil.getIOSMediaIdFromMediaId(FECompatUtil.getMediaId(this.router.getLiveRoom().getCurrentUser().getUserId(), LPConstants.MediaSourceType.Media.getValue()));
                for (LPPlayerViewUpdateModel.PlayerPosition playerPosition : allSet) {
                    if (!playerPosition.id.equals(model.id)) continue;
                    playerPosition.full = 1;
                    model.all = allSet;
                    this.router.getLiveRoom().getMediaVM().requestPlayerViewUpdate(model);
                    break;
                }
            }
        });
        Disposable disposableOfFullScreenOff = this.router.getSubjectByKey(EventKey.SetFullScreenWindowOff).ofType(BaseWindow.class).subscribe(baseTitledWindow -> {
            block13: {
                block14: {
                    if (baseTitledWindow instanceof PPTWindow) {
                        PPTWindow pptWindow;
                        if (BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
                            UtilsKt.removeViewFromParent((View)this.pptTabLayer);
                            int index = this.indexOfChild((View)this.documentLayer) + 1;
                            this.addView((View)this.pptTabLayer, index);
                            this.pptTabLayer.refreshBtn(false);
                        }
                        if ((pptWindow = (PPTWindow)baseTitledWindow).isPreviewPPT() && !pptWindow.isReceiveOrder()) {
                            pptWindow.maxInSync();
                            this.addToMaxCache();
                        }
                        String docId = pptWindow.getRealDocId();
                        if (!pptWindow.isReceiveOrder() && !pptWindow.isPreviewPPT()) {
                            List<LPDocViewElementModel> allDocList = this.getAllDocList();
                            LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
                            lpDocViewUpdateModel.docId = docId;
                            lpDocViewUpdateModel.action = "max";
                            if (allDocList != null && !allDocList.isEmpty()) {
                                Iterator<LPDocViewElementModel> iterator = allDocList.iterator();
                                while (iterator.hasNext()) {
                                    LPDocViewElementModel elementModel = iterator.next();
                                    if (!elementModel.docId.equals(lpDocViewUpdateModel.docId)) continue;
                                    elementModel.full = 0;
                                    elementModel.max = 1;
                                    lpDocViewUpdateModel.all = allDocList;
                                    this.router.getLiveRoom().getDocListVM().requestDocViewUpdate(lpDocViewUpdateModel);
                                    break;
                                }
                            }
                        }
                    }
                    UtilsKt.removeViewFromParent((View)this.laserShapeLayer);
                    UtilsKt.removeViewFromParent((View)baseTitledWindow.getView());
                    if (baseTitledWindow.getView() != null && baseTitledWindow instanceof PPTWindow) {
                        this.documentLayer.addWindow((IWindow)baseTitledWindow, baseTitledWindow.getView().getLayoutParams());
                    }
                    this.laserShapeLayer.setDocInfo("0", 0);
                    this.addView((View)this.laserShapeLayer, this.lp);
                    if (!(baseTitledWindow instanceof VideoContainerWindow) && !(baseTitledWindow instanceof MediaCoursewarePlayerWindow)) break block14;
                    this.videoLayer.addWindow((IWindow)baseTitledWindow, ((BaseTitledWindow)baseTitledWindow).getLastLayoutParams());
                    Set<LPPlayerViewUpdateModel.PlayerPosition> allSet = this.router.getSetByKey(EventKey.AllPlayerViewList, LPPlayerViewUpdateModel.PlayerPosition.class);
                    LPPlayerViewUpdateModel model = new LPPlayerViewUpdateModel();
                    model.id = model.mediaId = FECompatUtil.getIOSMediaIdFromMediaId(FECompatUtil.getMediaId(this.router.getLiveRoom().getCurrentUser().getUserId(), LPConstants.MediaSourceType.Media.getValue()));
                    for (LPPlayerViewUpdateModel.PlayerPosition playerPosition : allSet) {
                        if (!playerPosition.id.equals(model.id)) continue;
                        playerPosition.full = 0;
                        model.action = playerPosition.max == 1 ? LPConstants.LPPlayerAction.MAX : LPConstants.LPPlayerAction.NORMAL;
                        model.all = allSet;
                        this.router.getLiveRoom().getMediaVM().requestPlayerViewUpdate(model);
                        break block13;
                    }
                    break block13;
                }
                if (!(baseTitledWindow instanceof BrowserWindow2)) break block13;
                this.browserLayer.removeAllViews();
                this.browserWindow = (BrowserWindow2)((Object)baseTitledWindow);
                if (this.browserWindow.isMaxInSync()) {
                    this.browserLayer.addWindow((IWindow)baseTitledWindow);
                } else {
                    this.browserLayer.addWindow((IWindow)baseTitledWindow, this.browserWindow.getLayoutParamsSmall());
                }
                if (this.browserWindow.isReceiveOrder()) {
                    return;
                }
                if (this.webpageUpdateModeList.isEmpty()) {
                    return;
                }
                LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
                lpDocViewUpdateModel.docId = this.browserWindow.getId();
                lpDocViewUpdateModel.userId = this.router.getLiveRoom().getCurrentUser().getUserId();
                lpDocViewUpdateModel.action = this.browserWindow.isMaxInSync() ? "max" : "normal";
                for (LPDocViewElementModel elementModel : this.webpageUpdateModeList) {
                    if (!TextUtils.equals((CharSequence)elementModel.docId, (CharSequence)lpDocViewUpdateModel.docId)) continue;
                    FrameLayout.LayoutParams layoutParamsSmall = (FrameLayout.LayoutParams)this.browserWindow.getLayoutParamsSmall();
                    elementModel.full = 0;
                    elementModel.max = this.browserWindow.isMaxInSync() ? 1 : 0;
                    elementModel.width = String.valueOf((float)layoutParamsSmall.width / (float)this.getWidth());
                    elementModel.height = String.valueOf((float)layoutParamsSmall.height / (float)this.getHeight());
                    elementModel.x = String.valueOf((float)layoutParamsSmall.leftMargin / (float)this.getWidth());
                    elementModel.y = String.valueOf((float)layoutParamsSmall.topMargin / (float)this.getHeight());
                    lpDocViewUpdateModel.all = this.webpageUpdateModeList;
                    this.router.getLiveRoom().getToolBoxVM().requestWebpageUpdate(lpDocViewUpdateModel);
                    break;
                }
            }
        });
        Disposable disposableOfMaximumWindowOn = this.router.getSubjectByKey(EventKey.SetMaximumWindowOn).subscribe(c -> {
            block18: {
                block20: {
                    block19: {
                        this.updateToolbarWindow();
                        if (!(c instanceof BaseTitledWindow)) break block19;
                        this.maximumWindow = (BaseTitledWindow)c;
                        this.maximumWindow.bringToForeground();
                        if (c instanceof PPTWindow) {
                            this.pptTabLayer.show(true);
                            this.pptTabLayer.refreshTabs();
                            this.pptTabLayer.refreshBtn(false);
                            if (((PPTWindow)c).getId().contains("_preview")) {
                                this.addToMaxCache();
                                return;
                            }
                            if (!BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
                                return;
                            }
                            BaseTitledWindow baseWindow = (BaseTitledWindow)c;
                            String docId = baseWindow.getId();
                            if (baseWindow.isReceiveOrder()) {
                                return;
                            }
                            List<LPDocViewElementModel> allDocList = this.getAllDocList();
                            LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
                            lpDocViewUpdateModel.docId = docId;
                            lpDocViewUpdateModel.action = "max";
                            if (allDocList == null || allDocList.isEmpty()) {
                                return;
                            }
                            for (LPDocViewElementModel elementModel : allDocList) {
                                if (!elementModel.docId.equals(lpDocViewUpdateModel.docId)) continue;
                                elementModel.max = 1;
                                lpDocViewUpdateModel.all = allDocList;
                                this.router.getLiveRoom().getDocListVM().requestDocViewUpdate(lpDocViewUpdateModel);
                                break;
                            }
                        }
                        if (c instanceof SmallBlackboardWindow) {
                            if (!BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
                                return;
                            }
                            LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
                            lpDocViewUpdateModel.docId = ((BaseTitledWindow)c).getId();
                            lpDocViewUpdateModel.action = "max";
                            List<LPDocViewElementModel> allDocList = this.router.getListByKey(EventKey.AllSnippetViewList, LPDocViewElementModel.class);
                            if (allDocList == null || allDocList.isEmpty()) {
                                return;
                            }
                            for (LPDocViewElementModel elementModel : allDocList) {
                                if (!elementModel.docId.equals(lpDocViewUpdateModel.docId)) continue;
                                elementModel.max = 1;
                                lpDocViewUpdateModel.all = allDocList;
                                this.router.getLiveRoom().getToolBoxVM().requestSnippetViewUpdate(lpDocViewUpdateModel);
                                break;
                            }
                        }
                        if (!(c instanceof MediaCoursewarePlayerWindow)) break block18;
                        Set<LPPlayerViewUpdateModel.PlayerPosition> allSet = this.router.getSetByKey(EventKey.AllPlayerViewList, LPPlayerViewUpdateModel.PlayerPosition.class);
                        LPPlayerViewUpdateModel model = new LPPlayerViewUpdateModel();
                        model.action = LPConstants.LPPlayerAction.MAX;
                        model.id = model.mediaId = FECompatUtil.getIOSMediaIdFromMediaId(FECompatUtil.getMediaId(this.router.getLiveRoom().getCurrentUser().getUserId(), LPConstants.MediaSourceType.Media.getValue()));
                        for (LPPlayerViewUpdateModel.PlayerPosition playerPosition : allSet) {
                            if (!playerPosition.id.equals(model.id)) continue;
                            playerPosition.max = 1;
                            model.all = allSet;
                            this.router.getLiveRoom().getMediaVM().requestPlayerViewUpdate(model);
                            break block18;
                        }
                        break block18;
                    }
                    if (!(c instanceof Boolean)) break block20;
                    if (!(this.maximumWindow instanceof PPTWindow)) break block18;
                    ((PPTWindow)this.maximumWindow).resetInSync(false);
                    break block18;
                }
                if (c instanceof VideoWindow) {
                    Set<LPPlayerViewUpdateModel.PlayerPosition> allSet = this.router.getSetByKey(EventKey.AllPlayerViewList, LPPlayerViewUpdateModel.PlayerPosition.class);
                    LPPlayerViewUpdateModel model = new LPPlayerViewUpdateModel();
                    model.action = LPConstants.LPPlayerAction.MAX;
                    model.id = model.mediaId = FECompatUtil.getIOSMediaIdFromMediaId(((VideoWindow)c).getMediaId());
                    for (LPPlayerViewUpdateModel.PlayerPosition playerPosition : allSet) {
                        if (!playerPosition.id.equals(model.id)) continue;
                        playerPosition.max = 1;
                        model.all = allSet;
                        this.router.getLiveRoom().getMediaVM().requestPlayerViewUpdate(model);
                        break;
                    }
                } else if (c instanceof BrowserWindow2) {
                    BrowserWindow2 baseWindow = (BrowserWindow2)((Object)((Object)c));
                    if (baseWindow.isReceiveOrder()) {
                        return;
                    }
                    if (this.webpageUpdateModeList.isEmpty()) {
                        return;
                    }
                    LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
                    lpDocViewUpdateModel.docId = baseWindow.getId();
                    lpDocViewUpdateModel.userId = this.router.getLiveRoom().getCurrentUser().getUserId();
                    lpDocViewUpdateModel.action = "max";
                    for (LPDocViewElementModel elementModel : this.webpageUpdateModeList) {
                        if (!TextUtils.equals((CharSequence)elementModel.docId, (CharSequence)lpDocViewUpdateModel.docId)) continue;
                        elementModel.max = 1;
                        lpDocViewUpdateModel.all = this.webpageUpdateModeList;
                        this.router.getLiveRoom().getToolBoxVM().requestWebpageUpdate(lpDocViewUpdateModel);
                        break;
                    }
                }
            }
        });
        Disposable disposableOfMaximumWindowOff = this.router.getSubjectByKey(EventKey.SetMaximumWindowOff).subscribe(window -> {
            Object baseWindow;
            if (window instanceof PPTWindow) {
                this.updateToolbarWindow();
                this.pptTabLayer.show(false);
                if (((PPTWindow)window).isPreviewPPT() && !((PPTWindow)window).isReceiveOrder()) {
                    this.backToNormalCache();
                    ((PPTWindow)window).bringToForeground();
                    return;
                }
                baseWindow = (BaseTitledWindow)window;
                String docId = baseWindow.getId();
                if (baseWindow.isReceiveOrder() || !BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
                    return;
                }
                List<LPDocViewElementModel> allDocList = this.getAllDocList();
                LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
                lpDocViewUpdateModel.docId = docId;
                lpDocViewUpdateModel.action = "normal";
                if (allDocList == null || allDocList.isEmpty()) {
                    return;
                }
                for (LPDocViewElementModel elementModel : allDocList) {
                    if (!elementModel.docId.equals(lpDocViewUpdateModel.docId)) continue;
                    elementModel.max = 0;
                    lpDocViewUpdateModel.all = allDocList;
                    this.router.getLiveRoom().getDocListVM().requestDocViewUpdate(lpDocViewUpdateModel);
                    break;
                }
            }
            if (window instanceof SmallBlackboardWindow) {
                this.updateToolbarWindow();
                if (BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
                    LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
                    lpDocViewUpdateModel.docId = ((SmallBlackboardWindow)window).getId();
                    lpDocViewUpdateModel.action = "normal";
                    List<LPDocViewElementModel> allDocList = this.router.getListByKey(EventKey.AllSnippetViewList, LPDocViewElementModel.class);
                    if (allDocList == null || allDocList.isEmpty()) {
                        return;
                    }
                    for (LPDocViewElementModel elementModel : allDocList) {
                        if (!elementModel.docId.equals(lpDocViewUpdateModel.docId)) continue;
                        elementModel.max = 0;
                        lpDocViewUpdateModel.all = allDocList;
                        this.router.getLiveRoom().getToolBoxVM().requestSnippetViewUpdate(lpDocViewUpdateModel);
                        break;
                    }
                }
            }
            if (window instanceof MediaCoursewarePlayerWindow) {
                LPPlayerViewUpdateModel playerViewUpdateModel = new LPPlayerViewUpdateModel();
                playerViewUpdateModel.id = FECompatUtil.getIOSMediaIdFromMediaId(FECompatUtil.getMediaId(this.router.getLiveRoom().getCurrentUser().getUserId(), LPConstants.MediaSourceType.Media.getValue()));
                playerViewUpdateModel.action = LPConstants.LPPlayerAction.NORMAL;
                Set<LPPlayerViewUpdateModel.PlayerPosition> allSet = this.router.getSetByKey(EventKey.AllPlayerViewList, LPPlayerViewUpdateModel.PlayerPosition.class);
                for (LPPlayerViewUpdateModel.PlayerPosition playerPosition : allSet) {
                    if (!playerPosition.id.equals(playerViewUpdateModel.id)) continue;
                    playerPosition.max = 0;
                    playerViewUpdateModel.all = allSet;
                    this.router.getLiveRoom().getMediaVM().requestPlayerViewUpdate(playerViewUpdateModel);
                    break;
                }
            }
            if (window instanceof VideoWindow) {
                Set<LPPlayerViewUpdateModel.PlayerPosition> allSet = this.router.getSetByKey(EventKey.AllPlayerViewList, LPPlayerViewUpdateModel.PlayerPosition.class);
                LPPlayerViewUpdateModel model = new LPPlayerViewUpdateModel();
                model.action = LPConstants.LPPlayerAction.NORMAL;
                model.id = model.mediaId = FECompatUtil.getIOSMediaIdFromMediaId(((VideoWindow)window).getMediaId());
                for (LPPlayerViewUpdateModel.PlayerPosition playerPosition : allSet) {
                    if (!playerPosition.id.equals(model.id)) continue;
                    playerPosition.max = 0;
                    model.all = allSet;
                    this.router.getLiveRoom().getMediaVM().requestPlayerViewUpdate(model);
                    break;
                }
            }
            if (window instanceof BrowserWindow2) {
                baseWindow = (BrowserWindow2)((Object)((Object)window));
                if (baseWindow.isReceiveOrder()) {
                    return;
                }
                if (this.webpageUpdateModeList.isEmpty()) {
                    return;
                }
                LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
                lpDocViewUpdateModel.action = "normal";
                lpDocViewUpdateModel.docId = baseWindow.getId();
                lpDocViewUpdateModel.userId = this.router.getLiveRoom().getCurrentUser().getUserId();
                for (LPDocViewElementModel elementModel : this.webpageUpdateModeList) {
                    if (!TextUtils.equals((CharSequence)elementModel.docId, (CharSequence)lpDocViewUpdateModel.docId)) continue;
                    FrameLayout.LayoutParams layoutParamsSmall = (FrameLayout.LayoutParams)baseWindow.getLayoutParamsSmall();
                    elementModel.max = 0;
                    elementModel.width = String.valueOf((float)layoutParamsSmall.width / (float)this.getWidth());
                    elementModel.height = String.valueOf((float)layoutParamsSmall.height / (float)this.getHeight());
                    elementModel.x = String.valueOf((float)layoutParamsSmall.leftMargin / (float)this.getWidth());
                    elementModel.y = String.valueOf((float)layoutParamsSmall.topMargin / (float)this.getHeight());
                    lpDocViewUpdateModel.all = this.webpageUpdateModeList;
                    this.router.getLiveRoom().getToolBoxVM().requestWebpageUpdate(lpDocViewUpdateModel);
                    break;
                }
            }
        });
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.MinimizeWindowOn).observeOn(AndroidSchedulers.mainThread()).subscribe(window -> {
            if (window instanceof SmallBlackboardWindow) {
                for (SmallBlackboardWindow sbbWindow : this.smallBlackboardWindows) {
                    if (!sbbWindow.getId().equals(((SmallBlackboardWindow)window).getId())) continue;
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(UtilsKt.getDp((int)120), UtilsKt.getDp((int)30));
                    layoutParams.gravity = 8388691;
                    layoutParams.bottomMargin = (int)((float)DisplayUtils.getNavigationBarHeight((Activity)((AppCompatActivity)this.getContext())) + this.getContext().getResources().getDimension(R.dimen.bjysc_bottom_menu_window_margin_bottom));
                    layoutParams.leftMargin = UtilsKt.getDp((int)10);
                    if (sbbWindow.getView() == null) break;
                    sbbWindow.getView().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    break;
                }
            }
            if (window == this.browserWindow) {
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(UtilsKt.getDp((int)120), UtilsKt.getDp((int)30));
                layoutParams.gravity = 8388691;
                layoutParams.bottomMargin = (int)((float)DisplayUtils.getNavigationBarHeight((Activity)((AppCompatActivity)this.getContext())) + this.getContext().getResources().getDimension(R.dimen.bjysc_bottom_menu_window_margin_bottom));
                layoutParams.leftMargin = UtilsKt.getDp((int)10);
                if (this.browserWindow.getView() != null) {
                    this.browserWindow.getView().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                }
            }
        }));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.MinimizeWindowOff).ofType(BaseTitledWindow.class).observeOn(AndroidSchedulers.mainThread()).subscribe(window -> {
            if (window instanceof SmallBlackboardWindow) {
                List<SmallBlackboardWindow> cacheSmallBlackboardWindows = this.router.getListByKey(EventKey.MinimizeWindows, SmallBlackboardWindow.class);
                for (SmallBlackboardWindow smallBlackboardWindow : cacheSmallBlackboardWindows) {
                    if (smallBlackboardWindow.getView() == null) continue;
                    if (window != smallBlackboardWindow) {
                        smallBlackboardWindow.resetMinInSyncWithoutEvent();
                    }
                    smallBlackboardWindow.resetMinSbbOwner();
                    smallBlackboardWindow.getView().setLayoutParams(smallBlackboardWindow.getLastLayoutParams());
                }
                cacheSmallBlackboardWindows.clear();
                this.router.setObjectByKey(EventKey.MinimizeWindows, cacheSmallBlackboardWindows);
            } else if (window instanceof MediaCoursewarePlayerWindow) {
                if (window.getView() != null) {
                    window.getView().setLayoutParams(window.getLastLayoutParams());
                }
                LPPlayerViewUpdateModel playerViewUpdateModel = new LPPlayerViewUpdateModel();
                playerViewUpdateModel.id = FECompatUtil.getIOSMediaIdFromMediaId(FECompatUtil.getMediaId(this.router.getLiveRoom().getCurrentUser().getUserId(), LPConstants.MediaSourceType.Media.getValue()));
                playerViewUpdateModel.action = window.isMaxInSync() ? LPConstants.LPPlayerAction.MAX : LPConstants.LPPlayerAction.NORMAL;
                Set<LPPlayerViewUpdateModel.PlayerPosition> allSet = this.router.getSetByKey(EventKey.AllPlayerViewList, LPPlayerViewUpdateModel.PlayerPosition.class);
                for (LPPlayerViewUpdateModel.PlayerPosition playerPosition : allSet) {
                    if (!playerPosition.id.equals(playerViewUpdateModel.id)) continue;
                    playerPosition.max = window.isMaxInSync() ? 1 : 0;
                    playerPosition.full = 0;
                    playerViewUpdateModel.all = allSet;
                    this.router.getLiveRoom().getMediaVM().requestPlayerViewUpdate(playerViewUpdateModel);
                    break;
                }
            }
        }));
        Disposable disposableOfPPTWindowBringToFront = this.router.getSubjectByKey(EventKey.PPTWindowBringToFront).ofType(String.class).subscribe(docId -> {
            if (!BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom()) || docId != null && docId.contains("_preview")) {
                return;
            }
            LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
            lpDocViewUpdateModel.docId = docId;
            lpDocViewUpdateModel.action = "stick";
            List<LPDocViewElementModel> allDocList = this.router.getListByKey(EventKey.AllDocViewList, LPDocViewElementModel.class);
            if (docId == null || allDocList == null || allDocList.isEmpty()) {
                return;
            }
            for (LPDocViewElementModel elementModel : allDocList) {
                if (!elementModel.docId.equals(docId)) continue;
                allDocList.remove(elementModel);
                allDocList.add(elementModel);
                lpDocViewUpdateModel.all = allDocList;
                this.router.getLiveRoom().getDocListVM().requestDocViewUpdate(lpDocViewUpdateModel);
                break;
            }
        });
        Disposable disposableOfPPTAuth = this.router.getLiveRoom().getDocListVM().getPublishSubjectOfStudentPPTAuth().filter(strings -> this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student).observeOn(AndroidSchedulers.mainThread()).subscribe(userNumbers -> {
            if (userNumbers.contains(this.router.getLiveRoom().getCurrentUser().getNumber())) {
                for (PPTWindow pptWindow : this.pptWindows) {
                    pptWindow.setPPTAuthView(true);
                }
            } else {
                for (PPTWindow pptWindow : this.pptWindows) {
                    pptWindow.setPPTAuthView(false);
                }
            }
            this.shapePaint.setPPtEditMode(LPConstants.PPTEditMode.Normal);
        });
        Disposable disposableOfDrawAuth = this.router.getLiveRoom().getSpeakQueueVM().getPublishSubjectOfStudentDrawingAuth().observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
            if (this.hasDrawingAuth && aBoolean.booleanValue()) {
                return;
            }
            this.hasDrawingAuth = aBoolean;
            this.router.getSubjectByKey(EventKey.ResetToolbarStatus).onNext((Object)true);
        });
        Disposable disposableOfActiveUserRemove = this.router.getLiveRoom().getOnlineUserVM().getPublishSubjectOfActiveUserRemove().filter(lpResRoomUserInModel -> lpResRoomUserInModel.getUser().getNumber().equals(this.router.getLiveRoom().getCurrentUser().getNumber()) && lpResRoomUserInModel.getUser().getType() == LPConstants.LPUserType.Student).observeOn(AndroidSchedulers.mainThread()).subscribe(lpResRoomUserInModel -> {
            for (PPTWindow pptWindow : this.pptWindows) {
                pptWindow.setPPTAuthView(false);
            }
            this.router.getSubjectByKey(EventKey.ResetToolbarStatus).onNext((Object)true);
        });
        this.compositeDisposable.add(this.router.getLiveRoom().getDocListVM().getPublishSubjectOfStudentPPTAuth().filter(strings -> !BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())).subscribe(userNumbers -> {
            this.pptAuth = userNumbers.contains(this.router.getLiveRoom().getCurrentUser().getNumber());
        }));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.CheckSyncPreviewDoc).subscribe(ignore -> {
            if (this.mPreviewDocModel == null) {
                return;
            }
            Object docModel = null;
            for (Object model : this.router.getLiveRoom().getDocListVM().getDocList()) {
                if (!((LPDocModel)model).docId.equals(this.mPreviewDocModel.id)) continue;
                docModel = model;
                break;
            }
            if (docModel == null) {
                return;
            }
            PPTWindow tempPPTWindow = null;
            for (PPTWindow pPTWindow : this.pptWindows) {
                if (!TextUtils.equals((CharSequence)pPTWindow.getId(), (CharSequence)this.mPreviewDocModel.id)) continue;
                tempPPTWindow = pPTWindow;
                break;
            }
            if (tempPPTWindow != null) {
                PPTWindow previewPPTWindow = null;
                for (PPTWindow pptWindow : this.pptWindows) {
                    if (!pptWindow.isPreviewPPT()) continue;
                    previewPPTWindow = pptWindow;
                    break;
                }
                if (previewPPTWindow != null) {
                    previewPPTWindow.switchTab(tempPPTWindow);
                }
                return;
            }
            LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
            lpDocViewUpdateModel.docId = ((LPDocModel)docModel).docId;
            lpDocViewUpdateModel.action = "add";
            LPDocViewElementModel lPDocViewElementModel = new LPDocViewElementModel();
            lPDocViewElementModel.docId = ((LPDocModel)docModel).docId;
            lPDocViewElementModel.max = 1;
            lPDocViewElementModel.full = 0;
            lPDocViewElementModel.width = "0.33";
            lPDocViewElementModel.height = String.valueOf(((LPDocModel)docModel).height / ((LPDocModel)docModel).width * 0.66f);
            ArrayList<LPDocViewElementModel> allDocList = new ArrayList<LPDocViewElementModel>(this.router.getListByKey(EventKey.AllDocViewList, LPDocViewElementModel.class));
            lPDocViewElementModel.x = String.valueOf(0.0125 * (double)allDocList.size());
            lPDocViewElementModel.y = "0";
            for (LPDocViewElementModel elementModel : allDocList) {
                if (!((LPDocModel)docModel).docId.equals(elementModel.docId)) continue;
                return;
            }
            allDocList.add(lPDocViewElementModel);
            lpDocViewUpdateModel.all = allDocList;
            this.router.getLiveRoom().getDocListVM().requestDocViewUpdate(lpDocViewUpdateModel);
            this.removeAndDestroyPPTView(this.mPreviewDocModel.id + "_preview");
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getZXYBVM().getObservableOfConnectStatus().observeOn(AndroidSchedulers.mainThread()).subscribe(zxybConnectStatus -> {
            ZXYBDeviceInfo connectedDevice;
            if (zxybConnectStatus == LPConstants.ZXYBConnectStatus.CONNECT_STATUS_SUCCESS && (connectedDevice = this.router.getLiveRoom().getZXYBVM().getConnectedDevice()) != null) {
                this.calculateWritingBoardRatio(connectedDevice.maxX, connectedDevice.maxY);
            }
        }));
        ZXYBDeviceInfo connectedDevice = this.router.getLiveRoom().getZXYBVM().getConnectedDevice();
        if (connectedDevice != null) {
            this.calculateWritingBoardRatio(connectedDevice.maxX, connectedDevice.maxY);
        }
        this.compositeDisposable.add(this.router.getLiveRoom().getZXYBVM().getObservableOfXYDataPacket().observeOn(AndroidSchedulers.mainThread()).subscribe(xyDataPacket -> {
            ZXYBDeviceInfo device = this.router.getLiveRoom().getZXYBVM().getConnectedDevice();
            if (device != null) {
                xyDataPacket.tx = xyDataPacket.x * this.writingBoardRatio;
                xyDataPacket.ty = xyDataPacket.y * this.writingBoardRatio;
                if (this.laserShapeLayer != null && this.laserShapeLayer.isEnableDrawLaser()) {
                    this.lpMotionEvent.setXyDataPacket(xyDataPacket);
                    this.laserShapeLayer.onTouchEvent(this.lpMotionEvent);
                }
                if (xyDataPacket.penStatus == 1) {
                    PPTWindow maxPPTWindow = this.router.getValueByKey(EventKey.MaxScreenPPTWindow, PPTWindow.class);
                    PPTWindow fullPPTWindow = this.router.getValueByKey(EventKey.FullScreenPPTWindow, PPTWindow.class);
                    PPTWindow pPTWindow = this.destPPTWindow = fullPPTWindow != null ? fullPPTWindow : maxPPTWindow;
                    if (this.destPPTWindow != null) {
                        this.destPPTWindow.setOnTouchEvent((XYDataPacket)xyDataPacket);
                    } else {
                        for (PPTWindow pptWindow : this.pptWindows) {
                            if (!pptWindow.contains(xyDataPacket.tx, xyDataPacket.ty)) continue;
                            if (this.destPPTWindow == null) {
                                this.destPPTWindow = pptWindow;
                                continue;
                            }
                            int index = this.getIndexOfParentView(this.destPPTWindow.getView());
                            int index1 = this.getIndexOfParentView(pptWindow.getView());
                            if (index1 <= index) continue;
                            this.destPPTWindow = pptWindow;
                        }
                        if (this.destPPTWindow != null) {
                            this.destPPTWindow.setOnTouchEvent((XYDataPacket)xyDataPacket);
                        } else {
                            this.getBlackboardLayer().getBlackImageWindow().setOnTouchEvent((XYDataPacket)xyDataPacket);
                        }
                    }
                } else {
                    if (this.destPPTWindow != null) {
                        this.destPPTWindow.setOnTouchEvent((XYDataPacket)xyDataPacket);
                    } else {
                        this.getBlackboardLayer().getBlackImageWindow().setOnTouchEvent((XYDataPacket)xyDataPacket);
                    }
                    if (xyDataPacket.penStatus == 4 || xyDataPacket.penStatus == 3) {
                        this.destPPTWindow = null;
                    }
                }
            }
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getZXYBVM().getObservableOfSoftKey().observeOn(AndroidSchedulers.mainThread()).subscribe(this::doSoftKeyCallBack));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.BdsRepaint).ofType(String.class).observeOn(AndroidSchedulers.mainThread()).subscribe(docId -> ((BlackboardLayer)this.blackboardLayer).getBlackImageWindow().bdsRepaintShape((String)docId)));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.DocPreview).ofType(LPDocModel.class).observeOn(AndroidSchedulers.mainThread()).subscribe(previewDocModel -> {
            this.router.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getContext().getString(R.string.bjy_group_doc_preview_tip));
            boolean hasMax = false;
            boolean hasFull = false;
            boolean hasAdd = false;
            for (PPTWindow ppt : this.pptWindows) {
                if (TextUtils.equals((CharSequence)ppt.getId(), (CharSequence)(previewDocModel.docId + "_preview"))) {
                    hasAdd = true;
                }
                if (ppt.isMaxInFull()) {
                    hasFull = true;
                }
                if (!ppt.isMaxInSync()) continue;
                hasMax = true;
            }
            if (hasAdd) {
                return;
            }
            LPDocViewUpdateModel mockDocViewUpdateModel = new LPDocViewUpdateModel();
            mockDocViewUpdateModel.action = "add";
            LPDocViewElementModel elementModel = new LPDocViewElementModel();
            elementModel.docId = previewDocModel.docId + "_preview";
            elementModel.full = hasFull ? 1 : 0;
            elementModel.max = hasMax ? 1 : 0;
            elementModel.width = "0.3333";
            elementModel.height = String.valueOf(previewDocModel.height / previewDocModel.width * 0.66f);
            elementModel.x = "0";
            elementModel.y = "0";
            ArrayList<LPDocViewElementModel> elementModels = new ArrayList<LPDocViewElementModel>();
            elementModels.add(elementModel);
            mockDocViewUpdateModel.all = elementModels;
            mockDocViewUpdateModel.docId = previewDocModel.docId + "_preview";
            mockDocViewUpdateModel.userId = "-1";
            this.addPPTView(mockDocViewUpdateModel);
        }));
        this.compositeDisposable.add(disposableGraphDraw);
        this.compositeDisposable.add(disposableStrokeWidth);
        this.compositeDisposable.add(disposableCustomGraphWidth);
        this.compositeDisposable.add(disposableEraseMode);
        this.compositeDisposable.add(disposableDrawColorSetting);
        this.compositeDisposable.add(disposableOfCustomGraphMenuEnable);
        this.compositeDisposable.add(disposableTextEdit);
        this.compositeDisposable.add(disposableOfTextSend);
        this.compositeDisposable.add(disposableOfTextSizeChange);
        this.compositeDisposable.add(disposableOfBitmapShape);
        this.compositeDisposable.add(bitmapShapeSelectedDisposable);
        this.compositeDisposable.add(disposableOfBitmapShapeLayerSwitch);
        this.compositeDisposable.add(disposableOfBitmapShapeScale);
        this.compositeDisposable.add(disposableOfBitmapShapeErase);
        this.compositeDisposable.add(disposableOfLaserShape);
        this.compositeDisposable.add(disposableOfMaximumWindowOff);
        this.compositeDisposable.add(disposableOfMaximumWindowOn);
        this.compositeDisposable.add(disposableOfDocViewUpdate);
        this.compositeDisposable.add(disposableOfAuthPaintColor);
        this.compositeDisposable.add(disposableOfCloseWindow);
        this.compositeDisposable.add(disposableOfRepositionWindow);
        this.compositeDisposable.add(disposableOfPPTWindowBringToFront);
        this.compositeDisposable.add(disposableOfFullScreenOn);
        this.compositeDisposable.add(disposableOfFullScreenOff);
        this.compositeDisposable.add(disposableOfResetToolbarMode);
        this.compositeDisposable.add(disposableOfPPTAuth);
        this.compositeDisposable.add(disposableOfDrawAuth);
        this.compositeDisposable.add(disposableOfActiveUserRemove);
        this.compositeDisposable.add(disposableOfH5DocumentDelete);
        this.compositeDisposable.add(disposableOfWebpageUpdate);
        this.compositeDisposable.add(disposableOfRepositionWebpage);
        this.compositeDisposable.add(disposableOfAddWebpage);
    }

    private void initRemindDialog() {
        View remindView = View.inflate((Context)this.getContext(), (int)R.layout.bjy_base_ppt_clear_all_dialog, null);
        this.remindDialog = new Dialog(this.getContext());
        this.remindDialog.setContentView(remindView);
        this.remindDialog.setCancelable(true);
        this.remindDialog.setCanceledOnTouchOutside(true);
        WindowManager.LayoutParams layoutParams = this.remindDialog.getWindow().getAttributes();
        layoutParams.dimAmount = 0.5f;
        layoutParams.flags |= 2;
        layoutParams.width = UtilsKt.getDp((int)420);
        layoutParams.height = UtilsKt.getDp((int)230);
        layoutParams.gravity = 17;
        this.remindDialog.getWindow().setAttributes(layoutParams);
        TextView confirmTv = (TextView)remindView.findViewById(R.id.dialog_confirm_tv);
        confirmTv.setBackground(ThemeDataUtil.getDrawableProductButtonBg((Context)this.getContext()));
        confirmTv.setOnClickListener(v -> {
            this.getBlackboardLayer().getBlackImageWindow().eraseAll();
            this.remindDialog.dismiss();
        });
        CheckBox remindCb = (CheckBox)remindView.findViewById(R.id.dialog_not_remind_cb);
        remindCb.setOnCheckedChangeListener((buttonView, isChecked) -> {
            this.isCheckNotRemind = isChecked;
        });
        remindView.findViewById(R.id.dialog_not_remind_tv).setOnClickListener(v -> remindCb.setChecked(!remindCb.isChecked()));
    }

    private void handleWebpageUpdate(LPDocViewUpdateModel lpDocViewUpdateModel) {
        LPLogger.d((String)this.TAG, (String)("handleWebpageUpdate:" + LPJsonUtils.toString((Object)lpDocViewUpdateModel)));
        if (lpDocViewUpdateModel.all == null) {
            return;
        }
        this.webpageUpdateModeList = lpDocViewUpdateModel.all;
        LPDocViewElementModel model = null;
        for (LPDocViewElementModel e : lpDocViewUpdateModel.all) {
            if (!TextUtils.equals((CharSequence)lpDocViewUpdateModel.docId, (CharSequence)e.docId)) continue;
            model = e;
            break;
        }
        if (model == null || this.browserWindow == null) {
            this.webpageUpdateModel = lpDocViewUpdateModel;
            return;
        }
        this.webpageUpdateModel = null;
        if (!lpDocViewUpdateModel.isFromCache && this.router.getLiveRoom().getCurrentUser().getUserId().equals(lpDocViewUpdateModel.userId)) {
            return;
        }
        switch (lpDocViewUpdateModel.action) {
            case "add": {
                this.addWebpage(lpDocViewUpdateModel);
                break;
            }
            case "normal": {
                if (lpDocViewUpdateModel.isFromCache) {
                    this.addWebpage(lpDocViewUpdateModel);
                }
                this.backToNormalWebpage();
                break;
            }
            case "max": {
                this.maximumWebpage();
                break;
            }
            case "min": {
                this.minimumWebpage();
                break;
            }
            case "full": {
                this.fullscreenWebpage();
                break;
            }
            case "reposition": {
                this.repositionWebpage(lpDocViewUpdateModel);
                break;
            }
        }
    }

    private void calculateWritingBoardRatio(int maxX, int maxY) {
        this.post(() -> {
            if (this.router != null && this.selfWidth != 0 && this.selfHeight != 0) {
                this.writingBoardRatio = 1.0f * (float)maxX / (float)maxY > 1.0f * (float)this.selfWidth / (float)this.selfHeight ? 1.0f * (float)this.selfHeight / (float)maxY : 1.0f * (float)this.selfWidth / (float)maxX;
            }
        });
    }

    private PPTWindow getTopPPTWindow() {
        PPTWindow tempPPTWindow;
        if (this.pptWindows == null || this.pptWindows.isEmpty()) {
            return null;
        }
        PPTWindow maxPPTWindow = this.router.getValueByKey(EventKey.MaxScreenPPTWindow, PPTWindow.class);
        PPTWindow fullPPTWindow = this.router.getValueByKey(EventKey.FullScreenPPTWindow, PPTWindow.class);
        PPTWindow pPTWindow = tempPPTWindow = fullPPTWindow != null ? fullPPTWindow : maxPPTWindow;
        if (tempPPTWindow != null) {
            return tempPPTWindow;
        }
        int childCount = this.documentLayer.getChildCount();
        View topView = this.documentLayer.getChildAt(childCount - 1);
        for (PPTWindow pptWindow : this.pptWindows) {
            if (pptWindow.getView() != topView) continue;
            return pptWindow;
        }
        return null;
    }

    public void doSoftKeyCallBack(int keyCode) {
        switch (keyCode) {
            case 101: {
                break;
            }
            case 102: {
                PPTWindow tempPPTWindow = this.getTopPPTWindow();
                if (tempPPTWindow != null && this.pptWindows != null && !this.pptWindows.isEmpty()) {
                    tempPPTWindow.gotoPrevPage();
                    break;
                }
                this.getBlackboardLayer().getBlackImageWindow().gotoPrevPage();
                break;
            }
            case 103: {
                PPTWindow tempPPTWindowNext = this.getTopPPTWindow();
                if (tempPPTWindowNext != null && this.pptWindows != null && !this.pptWindows.isEmpty()) {
                    tempPPTWindowNext.gotoNextPage();
                    break;
                }
                this.getBlackboardLayer().getBlackImageWindow().gotoNextPage();
                break;
            }
            case 104: {
                break;
            }
            case 105: {
                break;
            }
            case 106: {
                break;
            }
            case 107: {
                break;
            }
            case 108: {
                break;
            }
            case 109: {
                if (this.shapePaint.getPPtEditMode() != LPConstants.PPTEditMode.ShapeMode) {
                    return;
                }
                if (this.getContext() instanceof GroupClassActivity) {
                    ((GroupClassActivity)this.getContext()).checkColorIndex(this.shapeColorIndex);
                }
                this.shapeColorIndex = (this.shapeColorIndex + 1) % BaseAutoArrangePopupWindow.colorIds.length;
                break;
            }
            case 110: {
                if (this.shapePaint.getPPtEditMode() != LPConstants.PPTEditMode.ShapeMode) {
                    return;
                }
                float brushStrokeWidth = BaseDrawWidthSettingWindow.pencilPaintSize[this.shapeStrokeWidthIndex];
                float markerStrokeWidth = BaseDrawWidthSettingWindow.markerPaintSize[this.shapeStrokeWidthIndex];
                float graphStrokeWidth = graphStrokeWidthArray[this.shapeStrokeWidthIndex];
                if (this.getContext() instanceof GroupClassActivity) {
                    ((GroupClassActivity)this.getContext()).checkIndex(this.shapeStrokeWidthIndex);
                }
                if (this.shapePaint.getShapeType() == LPConstants.ShapeType.Doodle) {
                    this.shapePaint.setDoodleStrokeWidth(new WidthSelectData(BaseUIConstant.SelectSrc.Brush, brushStrokeWidth));
                } else if (this.shapePaint.getShapeType() == LPConstants.ShapeType.MarkerDoodle) {
                    this.shapePaint.setDoodleStrokeWidth(new WidthSelectData(BaseUIConstant.SelectSrc.Marker, markerStrokeWidth));
                }
                this.shapePaint.setCustomStrokeWidth(graphStrokeWidth);
                this.shapeStrokeWidthIndex = (this.shapeStrokeWidthIndex + 1) % 4;
                break;
            }
            case 111: {
                break;
            }
            case 112: {
                break;
            }
        }
        if (this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher || this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Assistant || this.router.getLiveRoom().getSpeakQueueVM().getDrawingAuth()) {
            this.router.getSubjectByKey(EventKey.ZXYBSoftKey).onNext((Object)keyCode);
        }
    }

    private int getIndexOfParentView(@Nullable View child) {
        if (child == null) {
            return -1;
        }
        ViewParent parent = child.getParent();
        if (!(parent instanceof ViewGroup)) {
            return -1;
        }
        ViewGroup parentView = (ViewGroup)parent;
        return parentView.indexOfChild(child);
    }

    private void handlePreviewDoc(LPDocumentModel previewDocModel) {
        if (this.router.getLiveRoom().getPartnerConfig().enablePreOpenDoc != 1 || this.router.getLiveRoom().isClassStarted() || previewDocModel == null) {
            return;
        }
        if (this.mPreviewDocModel != null) {
            if (TextUtils.equals((CharSequence)previewDocModel.getDocId(), (CharSequence)this.mPreviewDocModel.getDocId())) {
                return;
            }
            this.removeAndDestroyPPTView(this.mPreviewDocModel.id + "_preview");
        }
        this.mPreviewDocModel = previewDocModel;
        LPDocViewUpdateModel mockDocViewUpdateModel = new LPDocViewUpdateModel();
        mockDocViewUpdateModel.action = "max";
        LPDocViewElementModel elementModel = new LPDocViewElementModel();
        elementModel.docId = previewDocModel.id + "_preview";
        elementModel.full = 0;
        elementModel.max = 1;
        elementModel.x = "0";
        elementModel.y = "0";
        elementModel.width = "0.3333";
        elementModel.height = String.valueOf(previewDocModel.pageInfoModel.height / previewDocModel.pageInfoModel.width * 0.66f);
        ArrayList<LPDocViewElementModel> elementModels = new ArrayList<LPDocViewElementModel>();
        elementModels.add(elementModel);
        mockDocViewUpdateModel.all = elementModels;
        mockDocViewUpdateModel.docId = previewDocModel.id + "_preview";
        mockDocViewUpdateModel.userId = "-1";
        this.addPPTView(mockDocViewUpdateModel);
    }

    public List<LPDocViewElementModel> getAllDocList() {
        return this.router.getListByKey(EventKey.AllDocViewList, LPDocViewElementModel.class);
    }

    private void hideTitleFooter() {
        for (PPTWindow pptWindow : this.getPPTWindows()) {
            pptWindow.hideTitleFooter();
        }
        this.pptTabLayer.show(false);
    }

    private void showTitleFooter() {
        PPTWindow maxPPTWindow = this.router.getValueByKey(EventKey.MaxScreenPPTWindow, PPTWindow.class);
        PPTWindow fullPPTWindow = this.router.getValueByKey(EventKey.FullScreenPPTWindow, PPTWindow.class);
        boolean hasPPTMaxOrFull = !this.pptWindows.isEmpty() && this.pptWindows.size() > 1 && (maxPPTWindow != null || fullPPTWindow != null);
        for (PPTWindow pptWindow : this.getPPTWindows()) {
            pptWindow.showTitleFooter();
            pptWindow.getPPTView().invalidateCurrentPage();
            if (!hasPPTMaxOrFull) continue;
            pptWindow.hideTitle();
        }
        this.pptTabLayer.show(true);
    }

    private void initBrowser() {
        Disposable disposableOfPublishBrowser = this.router.getSubjectByKey(EventKey.OpenBrowserWindow).ofType(Boolean.class).subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                if (this.browserWindow != null) {
                    return;
                }
                this.addNewWebPage();
            } else {
                this.browserLayer.removeWindow((IWindow)this.browserWindow);
                if (this.browserWindow != null) {
                    this.browserWindow.clearBroadcastCache();
                    this.browserWindow.onDestroy();
                    this.browserWindow = null;
                }
            }
        });
        Disposable disposableOfCloseBrowser = this.router.getSubjectByKey(EventKey.CloseBrowserWindow).ofType(Boolean.class).subscribe(aBoolean -> {
            this.browserLayer.removeWindow((IWindow)this.browserWindow);
            if (this.browserWindow != null) {
                LPWebPageInfoModel webPageInfoModel = new LPWebPageInfoModel();
                webPageInfoModel.status = 0;
                webPageInfoModel.id = this.browserWindow.getId();
                webPageInfoModel.actionType = 0;
                this.router.getLiveRoom().getToolBoxVM().requestOpenWebPage(webPageInfoModel);
                this.browserWindow.isAdd = false;
                this.router.getSubjectByKey(EventKey.AddWebpage).onNext((Object)this.browserWindow);
                this.browserWindow.clearBroadcastCache();
                this.browserWindow.onDestroy();
                this.browserWindow = null;
            }
        });
        Disposable disposableOfRandomSelect = this.router.getSubjectByKey(EventKey.OpenRandomSelectWindow).mergeWith((ObservableSource)this.router.getLiveRoom().getObservableOfRandomSelect()).observeOn(AndroidSchedulers.mainThread()).ofType(LPRandomSelectValueModel.class).subscribe(randomSelectValueModel -> {
            if (randomSelectValueModel.nameList != null) {
                if (this.randomSelectWindow == null) {
                    this.randomSelectWindow = new RandomSelectWindow(this.getContext());
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(UtilsKt.getDp((int)460), UtilsKt.getDp((int)240));
                    layoutParams.gravity = 17;
                    this.randomSelectLayer.addWindow((IWindow)this.randomSelectWindow, layoutParams);
                }
                ((RandomSelectWindow)this.randomSelectWindow).initValues((LPRandomSelectValueModel)randomSelectValueModel);
                ((RandomSelectWindow)this.randomSelectWindow).startMission();
            } else {
                this.randomSelectLayer.removeWindow((IWindow)this.randomSelectWindow);
                this.randomSelectWindow.onDestroy();
                this.randomSelectWindow = null;
            }
        });
        Disposable disposableOfWebPageInfo = this.router.getLiveRoom().getToolBoxVM().getObservableOfWebPageInfo().observeOn(AndroidSchedulers.mainThread()).subscribe(webPageInfoModel -> {
            if (webPageInfoModel.isOpenStatus()) {
                if (this.browserWindow == null) {
                    this.addNewWebPage();
                }
            } else {
                if (TextUtils.equals((CharSequence)this.router.getLiveRoom().getCurrentUser().getUserId(), (CharSequence)webPageInfoModel.userId)) {
                    return;
                }
                this.browserLayer.removeWindow((IWindow)this.browserWindow);
                if (this.browserWindow != null) {
                    this.browserWindow.onDestroy();
                    this.browserWindow = null;
                }
            }
        });
        Disposable disposableOfPresenterChange = this.router.getLiveRoom().getSpeakQueueVM().getObservableOfPresenterChange().observeOn(AndroidSchedulers.mainThread()).subscribe(s -> {
            if (TextUtils.isEmpty((CharSequence)s) && this.browserWindow != null && this.browserWindow.isMediaPublish()) {
                this.browserLayer.removeWindow((IWindow)this.browserWindow);
                if (this.browserWindow != null) {
                    this.browserWindow.onDestroy();
                    this.browserWindow = null;
                }
            }
        });
        Disposable disposableOfCloseDuplicateStream = this.router.getSubjectByKey(EventKey.CloseDuplicateStream).ofType(String.class).subscribe(s -> {
            VideoContainerWindow videoWindowWrapper = null;
            for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
                if (!videoContainerWindow.getVideoWindow().getMediaId().equals(s)) continue;
                videoWindowWrapper = videoContainerWindow;
                break;
            }
            if (videoWindowWrapper != null) {
                this.videoLayer.removeWindow((IWindow)videoWindowWrapper);
                this.videoWindows.remove(videoWindowWrapper);
                videoWindowWrapper.onDestroy();
            }
        });
        LPWebPageInfoModel webPageInfo = this.router.getLiveRoom().getToolBoxVM().getWebPageInfo();
        if (webPageInfo != null && webPageInfo.isOpenStatus()) {
            this.addNewWebPage();
        }
        this.compositeDisposable.add(disposableOfRandomSelect);
        this.compositeDisposable.add(disposableOfPublishBrowser);
        this.compositeDisposable.add(disposableOfCloseBrowser);
        this.compositeDisposable.add(disposableOfWebPageInfo);
        this.compositeDisposable.add(disposableOfPresenterChange);
    }

    private void addNewWebPage() {
        this.post(this.webpageRunnable);
    }

    private void destroyToolBox() {
        this.destroyTeacherTimer();
        this.destroyStudentTimer();
        this.destroyTeacherAnswerer();
        this.destroyStudentAnswerer();
        this.removeGroupAwardWindow();
        if (this.browserWindow != null) {
            this.browserWindow.onDestroy();
            this.browserWindow = null;
        }
        this.cancelResponder();
        if (this.responderRobButton != null) {
            this.toolBoxLayer.removeView((View)this.responderRobButton);
        }
    }

    private void initTimer() {
        this.compositeDisposable.add(this.router.getLiveRoom().getToolBoxVM().getObservableOfTimerStart().observeOn(AndroidSchedulers.mainThread()).subscribe(lpTimerModel -> {
            if (!BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
                this.initStudentTimer((LPTimerModel)lpTimerModel);
            } else {
                this.initTeacherTimer((LPTimerModel)lpTimerModel);
            }
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getToolBoxVM().getObservableOfTimerRevoke().observeOn(AndroidSchedulers.mainThread()).subscribe(lpDataUserModel -> {
            if (!BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
                this.destroyStudentTimer();
            }
        }));
        this.router.getLiveRoom().getToolBoxVM().requestTimerCache();
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.TeacherTimerWindow).ofType(Boolean.class).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                this.initTeacherTimer(null);
            } else {
                this.destroyTeacherTimer();
            }
        }));
    }

    private void initAnswerer() {
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.StudentAnswererWindow).ofType(Boolean.class).subscribe(aBoolean -> {
            if (!aBoolean.booleanValue()) {
                this.destroyStudentAnswerer();
            }
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getToolBoxVM().getObservableOfAnswerStart().observeOn(AndroidSchedulers.mainThread()).subscribe(lpAnswererModel -> {
            if (!BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
                this.initStudentAnswerer((LPAnswerModel)lpAnswererModel);
            } else if (!lpAnswererModel.isVote) {
                this.initTeacherAnswerer((LPAnswerModel)lpAnswererModel);
            }
        }));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.TeacherAnswererWindow).ofType(Boolean.class).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                this.initTeacherAnswerer(new LPAnswerModel());
            } else if (this.teacherAnswererWindow != null) {
                this.toolBoxLayer.removeWindow((IWindow)this.teacherAnswererWindow);
            }
        }));
    }

    private void initStudentTimer(LPTimerModel lpAnswererModel) {
        if (this.studentTimerWindow == null) {
            this.studentTimerWindow = new StudentTimerWindow(this.getContext(), lpAnswererModel);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.getResources().getDimensionPixelSize(R.dimen.bjysc_student_timer_root_width), this.getResources().getDimensionPixelSize(R.dimen.bjysc_student_timer_root_height));
            if (this.lastTimerPosition == null) {
                layoutParams.leftMargin = layoutParams.topMargin = this.getResources().getDimensionPixelSize(R.dimen.bjysc_student_timer_default_margin);
            } else {
                layoutParams.leftMargin = (int)this.lastTimerPosition.x;
                layoutParams.topMargin = (int)this.lastTimerPosition.y;
            }
            layoutParams.gravity = 48;
            this.toolBoxLayer.addWindow((IWindow)this.studentTimerWindow, layoutParams);
        }
    }

    private void destroyStudentTimer() {
        if (this.studentTimerWindow != null) {
            this.lastTimerPosition = new PointF(this.studentTimerWindow.getView().getX(), this.studentTimerWindow.getView().getY());
        }
        this.destroyToolBoxWindow(this.studentTimerWindow);
        this.studentTimerWindow = null;
    }

    private void initTeacherTimer(LPTimerModel lpTimerModel) {
        if (this.teacherTimerWindow == null) {
            if (lpTimerModel == null) {
                this.teacherTimerWindow = new TeacherTimerWindow(this.getContext());
                ((TeacherTimerWindow)this.teacherTimerWindow).recoverTimerSetting(this.lastTimerSetting);
            } else {
                this.teacherTimerWindow = new TeacherTimerWindow(this.getContext(), lpTimerModel);
            }
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(UtilsKt.getDp((int)280), UtilsKt.getDp((int)180));
            if (this.lastTimerPosition == null) {
                layoutParams.gravity = 17;
            } else {
                layoutParams.leftMargin = (int)this.lastTimerPosition.x;
                layoutParams.topMargin = (int)this.lastTimerPosition.y;
            }
            this.toolBoxLayer.addWindow((IWindow)this.teacherTimerWindow, layoutParams);
        }
    }

    private void destroyTeacherTimer() {
        if (this.teacherTimerWindow != null) {
            this.lastTimerPosition = new PointF(this.teacherTimerWindow.getView().getX(), this.teacherTimerWindow.getView().getY());
            this.lastTimerSetting = ((TeacherTimerWindow)this.teacherTimerWindow).getLastTimerSetting();
        }
        this.destroyToolBoxWindow(this.teacherTimerWindow);
        this.teacherTimerWindow = null;
    }

    private void initStudentAnswerer(LPAnswerModel lpAnswerModel) {
        if (this.studentAnswererWindow == null) {
            this.studentAnswererWindow = new AnswererWindow(this.getContext(), lpAnswerModel);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
            layoutParams.gravity = 0x800033;
            layoutParams.topMargin = UtilsKt.getDp((int)12);
            layoutParams.leftMargin = UtilsKt.getDp((int)12);
            this.toolBoxLayer.addWindow((IWindow)this.studentAnswererWindow, layoutParams);
        }
    }

    private void destroyStudentAnswerer() {
        this.destroyToolBoxWindow(this.studentAnswererWindow);
        this.studentAnswererWindow = null;
    }

    private void initTeacherAnswerer(LPAnswerModel newModel) {
        if (this.teacherAnswererWindow == null) {
            this.teacherAnswererWindow = TextUtils.isEmpty((CharSequence)newModel.messageType) ? new AdminAnswererWindow(this.getContext()) : new AdminAnswererWindow(this.getContext(), newModel);
        }
        if (this.toolBoxLayer.indexOfChild(this.teacherAnswererWindow.getView()) == -1) {
            int width = (int)this.getResources().getDimension(R.dimen.bjysc_default_answer_teacher_width);
            if (this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE) {
                width = (int)this.getResources().getDimension(R.dimen.bjysc_default_answer_teacher_width_oneonone);
            }
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(width, -2);
            layoutParams.gravity = 17;
            this.toolBoxLayer.addWindow((IWindow)this.teacherAnswererWindow, layoutParams);
        }
    }

    private void destroyTeacherAnswerer() {
        this.destroyToolBoxWindow(this.teacherAnswererWindow);
        this.teacherAnswererWindow = null;
    }

    private void destroyToolBoxWindow(BaseWindow window) {
        if (window != null) {
            this.toolBoxLayer.removeWindow((IWindow)window);
            window.onDestroy();
        }
    }

    private void initVideo() {
        this.videoWindows = new ConcurrentLinkedQueue();
        this.cachedViewPositions = new ConcurrentHashMap();
        Disposable disposableOfClassEnd = this.router.getLiveRoom().getObservableOfClassEnd().observeOn(AndroidSchedulers.mainThread()).filter(integer -> integer == 0).subscribe(integer -> this.destroyToolBox());
        Disposable disposableOfUserOut = this.router.getLiveRoom().getOnlineUserVM().getObservableOfUserOut().mergeWith((ObservableSource)this.router.getLiveRoom().getOnlineUserVM().getPublishSubjectOfActiveUserRemove().map(lpResRoomUserInModel -> lpResRoomUserInModel.user)).observeOn(AndroidSchedulers.mainThread()).subscribe(userModel -> {
            if (this.router.getLiveRoom().getTeacherUser() == null || !TextUtils.equals((CharSequence)userModel.getUserId(), (CharSequence)this.router.getLiveRoom().getTeacherUser().getUserId())) {
                this.removeVideoWindow(userModel.getUserId());
            }
            if (!BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
                return;
            }
            Set<LPPlayerViewUpdateModel.PlayerPosition> all = this.router.getSetByKey(EventKey.AllPlayerViewList, LPPlayerViewUpdateModel.PlayerPosition.class);
            if (all == null || all.isEmpty()) {
                return;
            }
            String mediaId = null;
            for (LPPlayerViewUpdateModel.PlayerPosition playerPosition : all) {
                if (!playerPosition.id.equals(userModel.getUserId())) continue;
                mediaId = playerPosition.mediaId;
                all.remove(playerPosition);
                break;
            }
            LPPlayerViewUpdateModel model = new LPPlayerViewUpdateModel();
            model.action = LPConstants.LPPlayerAction.REMOVE;
            model.id = userModel.getUserId();
            model.mediaId = mediaId;
            model.all = all;
            this.router.getLiveRoom().getMediaVM().requestPlayerViewUpdate(model);
        });
        Disposable disposableOfPlayerViewUpdate = this.router.getLiveRoom().getMediaVM().getObservableOfPlayerViewUpdate().observeOn(AndroidSchedulers.mainThread()).subscribe(this::handleVideoWindowPosition);
        this.compositeDisposable.add(this.router.getLiveRoom().getOnlineUserVM().getPublishSubjectOfActiveUserRemove().observeOn(AndroidSchedulers.mainThread()).subscribe(lpResRoomUserInModel -> this.removeVideoWindow(lpResRoomUserInModel.user.userId)));
        Disposable disposableOfCloseVideoWindow = this.router.getSubjectByKey(EventKey.CloseVideoWindow).ofType(String.class).subscribe(this::requestVideoWindowRemove);
        Disposable disposableOfPlayerViewAdd = this.router.getSubjectByKey(EventKey.PlayerViewAdd).ofType(PlayerViewActionModel.class).subscribe(model -> this.post(() -> this.addVideoWindow((PlayerViewActionModel)model)));
        Disposable disposableOfStickVideoWindow = this.router.getSubjectByKey(EventKey.StickVideoWindow).ofType(LPPlayerViewUpdateModel.PlayerPosition.class).subscribe(playerPosition -> {
            Set<LPPlayerViewUpdateModel.PlayerPosition> allList = this.router.getSetByKey(EventKey.AllPlayerViewList, LPPlayerViewUpdateModel.PlayerPosition.class);
            if (null == allList) {
                return;
            }
            for (LPPlayerViewUpdateModel.PlayerPosition position : allList) {
                if (!position.id.equals(playerPosition.id)) continue;
                allList.remove(position);
                allList.add((LPPlayerViewUpdateModel.PlayerPosition)playerPosition);
                this.router.setObjectByKey(EventKey.AllPlayerViewList, allList);
                break;
            }
            LPPlayerViewUpdateModel model = new LPPlayerViewUpdateModel();
            model.id = playerPosition.id;
            model.mediaId = playerPosition.mediaId;
            model.action = LPConstants.LPPlayerAction.STICK;
            model.all = allList;
            this.router.getLiveRoom().getMediaVM().requestPlayerViewUpdate(model);
        });
        Disposable disposableOfMoveVideoWindow = this.router.getSubjectByKey(EventKey.MoveVideoWindow).ofType(LPPlayerViewUpdateModel.PlayerPosition.class).throttleLast(1L, TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(playerPosition -> {
            Set<LPPlayerViewUpdateModel.PlayerPosition> allList = this.router.getSetByKey(EventKey.AllPlayerViewList, LPPlayerViewUpdateModel.PlayerPosition.class);
            if (null == allList) {
                return;
            }
            this.bringVideoToFront(playerPosition.id);
            for (LPPlayerViewUpdateModel.PlayerPosition position : allList) {
                if (!position.id.equals(playerPosition.id)) continue;
                allList.remove(position);
                allList.add((LPPlayerViewUpdateModel.PlayerPosition)playerPosition);
                this.router.setObjectByKey(EventKey.AllPlayerViewList, allList);
                break;
            }
            LPPlayerViewUpdateModel model = new LPPlayerViewUpdateModel();
            model.id = playerPosition.id;
            model.action = LPConstants.LPPlayerAction.REPOSITION;
            model.all = allList;
            this.router.getLiveRoom().getMediaVM().requestPlayerViewUpdate(model);
        });
        Observable observableOfActiveUserTeacherExtStream = this.router.getLiveRoom().getSpeakQueueVM().getObservableOfActiveUsers().flatMap(Observable::fromIterable).filter(iMediaModel -> iMediaModel.getExtraStreams() != null).flatMap(iMediaModel -> Observable.fromIterable((Iterable)iMediaModel.getExtraStreams()));
        Disposable disposableOfMediaPublish = this.router.getLiveRoom().getSpeakQueueVM().getObservableOfMediaPublish().mergeWith((ObservableSource)observableOfActiveUserTeacherExtStream).filter(iMediaModel -> {
            if (iMediaModel.getUser().getType() == LPConstants.LPUserType.Teacher || this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE) {
                return iMediaModel.getMediaSourceType() != LPConstants.MediaSourceType.MainCamera;
            }
            return iMediaModel.getMediaSourceType() != LPConstants.MediaSourceType.MainCamera && iMediaModel.getMediaSourceType() != LPConstants.MediaSourceType.MainScreenShare;
        }).filter(iMediaModel -> this.router.getLiveRoom().getToolBoxVM().getWebPageInfo() == null || !this.router.getLiveRoom().getToolBoxVM().getWebPageInfo().isScreenShare || iMediaModel.getMediaSourceType() != LPConstants.MediaSourceType.MainScreenShare).observeOn(AndroidSchedulers.mainThread()).subscribe(this::handleExtStream);
        this.compositeDisposable.add(this.router.getLiveRoom().getMediaVM().getObservableOfCloudVideo().observeOn(AndroidSchedulers.mainThread()).subscribe(this::handleVideoWindow));
        this.compositeDisposable.add(this.router.getLiveRoom().getObservableOfRoomLayoutSwitch().map(layoutMode -> layoutMode == LPConstants.RoomLayoutMode.GALLERY).mergeWith((ObservableSource)this.router.getLiveRoom().getStudyRoomVM().getObservableOfStudyRoomSwitch().map(LPConstants.StudyRoomMode::isGalleryLayout)).filter(aBoolean -> aBoolean).observeOn(AndroidSchedulers.mainThread()).subscribe(isGalleryLayout -> {
            if (this.router.getValueByKey(EventKey.AllPlayerViewList, Set.class) == null) {
                return;
            }
            Boolean isReEnterRoom = this.router.getValueByKey(EventKey.StudyReEnterRoom, Boolean.class);
            if (isReEnterRoom != null && isReEnterRoom.booleanValue()) {
                return;
            }
            HashSet<LPPlayerViewUpdateModel.PlayerPosition> playerPositionList = new HashSet<LPPlayerViewUpdateModel.PlayerPosition>(this.router.getSetByKey(EventKey.AllPlayerViewList, LPPlayerViewUpdateModel.PlayerPosition.class));
            LPPlayerViewUpdateModel model = new LPPlayerViewUpdateModel();
            model.action = LPConstants.LPPlayerAction.REMOVE;
            for (LPPlayerViewUpdateModel.PlayerPosition playerPosition : playerPositionList) {
                model.all = playerPositionList;
                model.id = playerPosition.id;
                model.mediaId = playerPosition.mediaId;
                this.handleVideoWindowPosition(model, true);
            }
        }));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.PlayerViewHide).ofType(VideoWindow.class).subscribe(videoWindow -> {
            for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
                if (videoContainerWindow.getVideoWindow() != videoWindow) continue;
                videoContainerWindow.getView().setVisibility(videoWindow.isShowWindow() ? 0 : 8);
                return;
            }
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getOnlineUserVM().getObservableOfOnGroupItem().subscribe(lpGroupItems -> {
            this.updateGroupAwardInfo();
            if (lpGroupItems.size() > 0) {
                this.cancelGroup();
                this.setGroup(this.router.getLiveRoom().getOnlineUserVM().getGroupList());
            } else {
                this.cancelGroup();
                for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
                    videoContainerWindow.getVideoWindow().setGroupItem(new GroupItem(0));
                }
            }
        }));
        this.compositeDisposable.add(disposableOfClassEnd);
        this.compositeDisposable.add(disposableOfUserOut);
        this.compositeDisposable.add(disposableOfPlayerViewUpdate);
        this.compositeDisposable.add(disposableOfPlayerViewAdd);
        this.compositeDisposable.add(disposableOfCloseVideoWindow);
        this.compositeDisposable.add(disposableOfStickVideoWindow);
        this.compositeDisposable.add(disposableOfMoveVideoWindow);
        this.compositeDisposable.add(disposableOfMediaPublish);
    }

    private void cancelGroup() {
        for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
            videoContainerWindow.getVideoWindow().clearGroupColor();
        }
    }

    private void setGroup(List<LPGroupItem> groups) {
        HashMap<String, VideoContainerWindow> speakNums = new HashMap<String, VideoContainerWindow>();
        for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
            if (videoContainerWindow.getMediaModel() == null) continue;
            speakNums.put(videoContainerWindow.getMediaModel().getUser().getNumber(), videoContainerWindow);
        }
        int count = 0;
        for (LPGroupItem lpGroupItem : groups) {
            count += lpGroupItem.count;
        }
        if (count == 0) {
            for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
                videoContainerWindow.getVideoWindow().setGroupItem(new GroupItem(0));
            }
        }
        for (LPGroupItem lpGroupItem : groups) {
            List userModelList = lpGroupItem.userModelList;
            for (LPUserModel lpUserModel : userModelList) {
                VideoContainerWindow videoContainerWindow;
                GroupItem groupItemModel = lpGroupItem.groupItemModel;
                if (groupItemModel == null || !speakNums.containsKey(lpUserModel.number) || (videoContainerWindow = (VideoContainerWindow)speakNums.remove(lpUserModel.number)) == null) continue;
                if (groupItemModel.id != 0) {
                    videoContainerWindow.getVideoWindow().setGroupColor(groupItemModel.color, groupItemModel.id);
                }
                if (this.router.getLiveRoom().getOnlineUserVM().isMediaGroup()) {
                    videoContainerWindow.getVideoWindow().setGroupItem(groupItemModel);
                    continue;
                }
                if (groupItemModel.id != 0) continue;
                videoContainerWindow.getVideoWindow().setGroupItem(groupItemModel);
            }
        }
        for (VideoContainerWindow videoContainerWindow : speakNums.values()) {
            if (videoContainerWindow == null) continue;
            videoContainerWindow.getVideoWindow().setGroupItem(new GroupItem(0));
        }
    }

    private void startSbbObservable() {
        this.smallBlackboardWindows = new ConcurrentLinkedQueue();
        this.router.getLiveRoom().getToolBoxVM().requestSnippetPullAllReq();
        this.compositeDisposable.add(this.router.getLiveRoom().getToolBoxVM().getObservableOfSnippetPullAllRes().flatMap(Observable::fromIterable).observeOn(AndroidSchedulers.mainThread()).subscribe(lpSnippetPullResModel -> {
            LPSnippetPullReqModel lpSnippetPullReqModel = new LPSnippetPullReqModel(lpSnippetPullResModel.id);
            this.router.getLiveRoom().getToolBoxVM().requestSnippetPullReq(lpSnippetPullReqModel);
        }));
        Disposable sbbOpenWindowDisposable = this.router.getSubjectByKey(EventKey.SbbOpenWindow).subscribe(o -> {
            int childCount = this.smallBlackboardLayer.getChildCount();
            if (childCount >= 10) {
                this.router.getSubjectByKey(EventKey.ReminderErrorMessage).onNext((Object)this.getContext().getString(R.string.bjy_group_sbb_out_of_max_limit));
                return;
            }
            this.isOpenSbb = true;
            if (BaseUtilsKt.isTeacher((IUserModel)this.router.getLiveRoom().getCurrentUser())) {
                SmallBlackboardWindow sbbWindow = this.initSmallBlackboardView("s_0_" + System.currentTimeMillis());
                this.smallBlackboardWindows.add(sbbWindow);
                sbbWindow.init();
            }
        });
        Disposable snippetPullResDisposable = this.router.getLiveRoom().getToolBoxVM().getObservableOfSnippetPullRes().observeOn(AndroidSchedulers.mainThread()).subscribe(this::showSmallBlackboardWindow);
        Disposable disposableOfSnippetViewUpdate = this.router.getLiveRoom().getToolBoxVM().getObservableOfSnippetViewUpdate().observeOn(AndroidSchedulers.mainThread()).subscribe(lpDocViewUpdateModel -> {
            this.router.setObjectByKey(EventKey.AllSnippetViewList, lpDocViewUpdateModel.all);
            switch (lpDocViewUpdateModel.action) {
                case "add": {
                    this.addSmallBlackboardView((LPDocViewUpdateModel)lpDocViewUpdateModel);
                    break;
                }
                case "remove": {
                    this.removeAndDestroyBlackboardView(lpDocViewUpdateModel.docId);
                    break;
                }
                case "stick": {
                    if (this.router.getLiveRoom().getCurrentUser().getUserId().equals(lpDocViewUpdateModel.userId)) {
                        return;
                    }
                    this.sbbBringToFront(lpDocViewUpdateModel.docId);
                    break;
                }
                case "normal": {
                    if (this.router.getLiveRoom().getCurrentUser().getUserId().equals(lpDocViewUpdateModel.userId)) {
                        return;
                    }
                    this.sbbBackToNormal(lpDocViewUpdateModel.docId);
                    break;
                }
                case "max": {
                    if (this.router.getLiveRoom().getCurrentUser().getUserId().equals(lpDocViewUpdateModel.userId)) {
                        return;
                    }
                    this.sbbMaximumWindow(lpDocViewUpdateModel.docId);
                    break;
                }
                case "full": {
                    if (this.router.getLiveRoom().getCurrentUser().getUserId().equals(lpDocViewUpdateModel.userId)) {
                        return;
                    }
                    this.sbbFullscreenWindow(lpDocViewUpdateModel.docId);
                    break;
                }
                case "reposition": {
                    if (this.router.getLiveRoom().getCurrentUser().getUserId().equals(lpDocViewUpdateModel.userId)) {
                        return;
                    }
                    this.sbbRepositionWindow((LPDocViewUpdateModel)lpDocViewUpdateModel);
                    break;
                }
                case "rename": {
                    this.showSbbWindowName((LPDocViewUpdateModel)lpDocViewUpdateModel);
                    break;
                }
            }
        });
        Disposable disposableOfSnippetViewUpdateCache = this.router.getLiveRoom().getToolBoxVM().getObservableOfSnippetViewUpdateCache().observeOn(AndroidSchedulers.mainThread()).subscribe(viewUpdateModel -> {
            this.router.setObjectByKey(EventKey.AllSnippetViewList, viewUpdateModel.all);
            boolean isTeacherInPublishStatus = false;
            for (LPDocViewElementModel elementModel : viewUpdateModel.all) {
                boolean continueFlag = false;
                if (elementModel.docId.contains("0_s_0")) {
                    isTeacherInPublishStatus = true;
                }
                for (SmallBlackboardWindow window : this.smallBlackboardWindows) {
                    if (!elementModel.docId.equals(window.getId())) continue;
                    continueFlag = true;
                    break;
                }
                if (continueFlag) continue;
                SmallBlackboardWindow smallBlackboardWindow = this.initSmallBlackboardView(true, elementModel.docId, Float.parseFloat(elementModel.x), Float.parseFloat(elementModel.y), Float.parseFloat(elementModel.width), Float.parseFloat(elementModel.height));
                LPSnippetPullResModel pullResModel = new LPSnippetPullResModel();
                pullResModel.id = elementModel.docId;
                smallBlackboardWindow.initStatus(pullResModel, SmallBlackboardStatus.PUBLISH_TO_ALL);
                if (elementModel.full == 1) {
                    smallBlackboardWindow.maxInFull();
                } else if (elementModel.max == 1) {
                    smallBlackboardWindow.maxInSync();
                }
                this.smallBlackboardWindows.add(smallBlackboardWindow);
            }
            if (this.isOpenSbb && BaseUtilsKt.isTeacher((IUserModel)this.router.getLiveRoom().getCurrentUser()) && this.snippetPullResModel != null && this.snippetPullResModel.userSubmittedList != null) {
                block2: for (SmallBlackboardWindow window : this.smallBlackboardWindows) {
                    for (IUserModel userModel : this.snippetPullResModel.userSubmittedList) {
                        if (!userModel.getNumber().equals(window.getId())) continue;
                        this.snippetPullResModel.userSubmittedList.remove(userModel);
                        continue block2;
                    }
                }
                this.snippetPullResModel.isTeacherInPublishStatus = isTeacherInPublishStatus;
                SmallBlackboardWindow sbbWindow = this.initSmallBlackboardView(this.snippetPullResModel.id);
                sbbWindow.cursor = SbbUtils.getLastUserNumber(this.snippetPullResModel);
                sbbWindow.initStatus(this.snippetPullResModel, SmallBlackboardStatus.ALL_COMMITTED);
                this.smallBlackboardWindows.add(sbbWindow);
                this.snippetPullResModel = null;
            }
            this.showSbbWindowName((LPDocViewUpdateModel)viewUpdateModel);
        });
        Disposable disposableOfAddSbbWindow = this.router.getSubjectByKey(EventKey.SbbAddWindow).ofType(LPSnippetSubmitModel.class).filter(lpSnippetSubmitModel -> lpSnippetSubmitModel.from != null).subscribe(lpSnippetSubmitModel -> {
            List<LPDocViewElementModel> allDocList = this.router.getListByKey(EventKey.AllSnippetViewList, LPDocViewElementModel.class);
            if (allDocList == null) {
                allDocList = new ArrayList<LPDocViewElementModel>();
            }
            String id2 = lpSnippetSubmitModel.from.getNumber() + "_" + lpSnippetSubmitModel.id;
            for (LPDocViewElementModel docViewElementModel : allDocList) {
                if (!docViewElementModel.docId.equals(id2)) continue;
                return;
            }
            LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
            lpDocViewUpdateModel.docId = id2;
            lpDocViewUpdateModel.action = "add";
            LPDocViewElementModel elementModel = new LPDocViewElementModel();
            elementModel.docId = id2;
            elementModel.full = 0;
            elementModel.height = String.valueOf(this.getResources().getDimension(R.dimen.bjysc_default_sbb_height) / (float)this.getHeight());
            elementModel.width = String.valueOf(this.getResources().getDimension(R.dimen.bjysc_default_sbb_width) / (float)this.getWidth());
            elementModel.max = 0;
            elementModel.x = "0";
            elementModel.y = "0";
            elementModel.name = "";
            allDocList.add(elementModel);
            lpDocViewUpdateModel.all = allDocList;
            this.sbbAllUserSet.add((IUserModel)lpSnippetSubmitModel.from);
            this.router.getLiveRoom().getToolBoxVM().requestSnippetViewUpdate(lpDocViewUpdateModel);
        });
        Disposable disposableOfRemoveSbbWindow = this.router.getSubjectByKey(EventKey.SbbCloseWindow).ofType(SbbCloseWindowEvent.class).subscribe(closeWindowEvent -> {
            this.removeAndDestroyBlackboardView(closeWindowEvent.windowId);
            LPLogger.d((String)"yjm", (String)("sbbCloseWindow " + closeWindowEvent.windowId + ", broadcast=" + closeWindowEvent.shouldSendBroadcast));
            if (closeWindowEvent.shouldSendBroadcast) {
                LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
                lpDocViewUpdateModel.docId = closeWindowEvent.windowId;
                lpDocViewUpdateModel.action = "remove";
                if (this.router.getValueByKey(EventKey.AllSnippetViewList, ArrayList.class) == null) {
                    return;
                }
                List<LPDocViewElementModel> allDocList = this.router.getListByKey(EventKey.AllSnippetViewList, LPDocViewElementModel.class);
                for (LPDocViewElementModel elementModel : allDocList) {
                    if (!elementModel.docId.equals(closeWindowEvent.windowId)) continue;
                    allDocList.remove(elementModel);
                    lpDocViewUpdateModel.all = allDocList;
                    this.router.getLiveRoom().getToolBoxVM().requestSnippetViewUpdate(lpDocViewUpdateModel);
                    break;
                }
            }
        });
        Disposable disposableOfRepositionSbbWindow = this.router.getSubjectByKey(EventKey.SbbRepositionWindow).ofType(Tuple.class).throttleLast(1L, TimeUnit.SECONDS).subscribe(tuple -> {
            block3: {
                List<LPDocViewElementModel> allDocList;
                LPDocViewUpdateModel viewUpdateModel;
                block4: {
                    viewUpdateModel = new LPDocViewUpdateModel();
                    viewUpdateModel.docId = tuple.docId;
                    viewUpdateModel.action = "reposition";
                    allDocList = this.router.getListByKey(EventKey.AllSnippetViewList, LPDocViewElementModel.class);
                    if (tuple.docId == null || allDocList == null || allDocList.isEmpty()) {
                        return;
                    }
                    if (!tuple.action.equals("move")) break block4;
                    for (LPDocViewElementModel elementModel : allDocList) {
                        if (!elementModel.docId.equals(tuple.docId)) continue;
                        elementModel.x = String.valueOf((float)tuple.width / (float)this.getWidth());
                        elementModel.y = String.valueOf((float)tuple.height / (float)this.getHeight());
                        viewUpdateModel.all = allDocList;
                        this.router.getLiveRoom().getToolBoxVM().requestSnippetViewUpdate(viewUpdateModel);
                        break block3;
                    }
                    break block3;
                }
                if (!tuple.action.equals("scale")) break block3;
                for (LPDocViewElementModel elementModel : allDocList) {
                    if (!elementModel.docId.equals(tuple.docId)) continue;
                    elementModel.width = String.valueOf((float)tuple.width / (float)this.getWidth());
                    elementModel.height = String.valueOf((float)tuple.height / (float)this.getHeight());
                    viewUpdateModel.all = allDocList;
                    this.router.getLiveRoom().getToolBoxVM().requestSnippetViewUpdate(viewUpdateModel);
                    break;
                }
            }
        });
        Disposable disposableOfSbbWindowBringToFront = this.router.getSubjectByKey(EventKey.SbbBringToFront).ofType(String.class).subscribe(docId -> {
            if (!BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
                return;
            }
            LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
            lpDocViewUpdateModel.docId = docId;
            lpDocViewUpdateModel.action = "stick";
            List<LPDocViewElementModel> allDocList = this.router.getListByKey(EventKey.AllSnippetViewList, LPDocViewElementModel.class);
            if (docId == null || allDocList == null || allDocList.isEmpty()) {
                return;
            }
            for (LPDocViewElementModel elementModel : allDocList) {
                if (!elementModel.docId.equals(docId)) continue;
                allDocList.remove(elementModel);
                allDocList.add(elementModel);
                lpDocViewUpdateModel.all = allDocList;
                this.router.getLiveRoom().getToolBoxVM().requestSnippetViewUpdate(lpDocViewUpdateModel);
                break;
            }
        });
        Disposable snippetShowNameDisposable = this.router.getSubjectByKey(EventKey.SbbShowName).ofType(SmallBlackboardWindow.class).subscribe(window -> {
            if (BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
                LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
                lpDocViewUpdateModel.docId = window.getId();
                lpDocViewUpdateModel.action = "rename";
                List<LPDocViewElementModel> allDocList = this.router.getListByKey(EventKey.AllSnippetViewList, LPDocViewElementModel.class);
                if (allDocList == null || allDocList.isEmpty()) {
                    return;
                }
                String number = "";
                int index = window.getId().indexOf("_");
                if (index != -1) {
                    number = window.getId().substring(0, index);
                }
                for (LPDocViewElementModel elementModel : allDocList) {
                    if (!elementModel.docId.equals(lpDocViewUpdateModel.docId)) continue;
                    if (window.shouldShowOwnerName()) {
                        for (IUserModel userModel : this.sbbAllUserSet) {
                            LPLogger.e((String)"yjm", (String)("userModel= " + userModel.getNumber() + ", elementModel.docId=" + elementModel.docId));
                            if (!userModel.getNumber().equals(number)) continue;
                            elementModel.name = userModel.getName();
                            break;
                        }
                    } else {
                        elementModel.name = "";
                    }
                    lpDocViewUpdateModel.all = allDocList;
                    this.router.getLiveRoom().getToolBoxVM().requestSnippetViewUpdate(lpDocViewUpdateModel);
                    break;
                }
            }
        });
        Disposable snippetPublishDisposable = this.router.getLiveRoom().getToolBoxVM().getObservableOfSnippetPublish().observeOn(AndroidSchedulers.mainThread()).subscribe(snippetPublishModel -> {
            if (snippetPublishModel.operate == 1 && this.router.getLiveRoom().getCurrentUser().getType() != LPConstants.LPUserType.Teacher) {
                snippetPublishModel.toAll = snippetPublishModel.toUserList == null || snippetPublishModel.toUserList.isEmpty();
                LPSnippetPullResModel pullResModel = new LPSnippetPullResModel();
                pullResModel.isActive = true;
                pullResModel.duration = snippetPublishModel.duration;
                pullResModel.timeStart = System.currentTimeMillis() / 1000L;
                pullResModel.id = snippetPublishModel.id;
                pullResModel.toAll = snippetPublishModel.toAll;
                this.showSmallBlackboardWindow(pullResModel);
            }
        });
        this.compositeDisposable.add(snippetPullResDisposable);
        this.compositeDisposable.add(disposableOfSnippetViewUpdate);
        this.compositeDisposable.add(disposableOfRepositionSbbWindow);
        this.compositeDisposable.add(disposableOfSbbWindowBringToFront);
        this.compositeDisposable.add(disposableOfRemoveSbbWindow);
        this.compositeDisposable.add(disposableOfAddSbbWindow);
        this.compositeDisposable.add(snippetPublishDisposable);
        this.compositeDisposable.add(snippetShowNameDisposable);
        this.compositeDisposable.add(sbbOpenWindowDisposable);
        this.compositeDisposable.add(disposableOfSnippetViewUpdateCache);
    }

    private void startResponderObservable() {
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.Responder).ofType(Boolean.class).filter(aBoolean -> BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())).subscribe(this::showResponderWindow));
        this.compositeDisposable.add(this.router.getLiveRoom().getToolBoxVM().getObservableOfAnswerRacerEnd().observeOn(AndroidSchedulers.mainThread()).subscribe(lpAnswerRacerEndModel -> {
            if (lpAnswerRacerEndModel.isRevoke) {
                this.cancelResponder();
                this.toolBoxLayer.removeView((View)this.responderRobButton);
                this.router.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getContext().getString(R.string.responder_cancel));
            } else if (!BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
                if (lpAnswerRacerEndModel.winner != null) {
                    if (lpAnswerRacerEndModel.winner.equals((Object)this.router.getLiveRoom().getCurrentUser())) {
                        this.responderRobButton.changeRobButtonStatus(ResponderRobButton.RobButtonState.ROBED);
                    } else {
                        this.responderRobButton.changeRobButtonStatus(ResponderRobButton.RobButtonState.ROB_FAIL);
                    }
                } else {
                    this.router.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getContext().getString(R.string.responder_nobody_rob_student));
                }
                this.responderButtonDelayDisposable = Observable.just((Object)"").delay(3L, TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(s -> this.toolBoxLayer.removeView((View)this.responderRobButton));
                this.compositeDisposable.add(this.responderButtonDelayDisposable);
                this.cancelResponder();
            }
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getToolBoxVM().getObservableOfAnswerRacerStart().observeOn(AndroidSchedulers.mainThread()).subscribe(lpAnswerRacerStartModel -> {
            RxUtils.dispose((Disposable)this.responderButtonDelayDisposable);
            if (BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
                this.showResponderWindow(true);
                this.responderWindow.changeStatus(ResponderWindow.ResponderStatus.PUBLISHING, "");
            } else if (lpAnswerRacerStartModel.prepareTime > 0) {
                this.showResponderPrepare(lpAnswerRacerStartModel.prepareTime);
            } else {
                this.showResponderButton();
            }
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getToolBoxVM().getObservableOfComponentDestroy().filter(lpComponentDestroyModel -> BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())).observeOn(AndroidSchedulers.mainThread()).subscribe(lpComponentDestroyModel -> {
            if (LPConstants.ComponentType.Responder.getComponentType().equals(lpComponentDestroyModel.value.component)) {
                this.showResponderWindow(false);
            } else if (LPConstants.ComponentType.Answerer.getComponentType().equals(lpComponentDestroyModel.value.component)) {
                if (this.teacherAnswererWindow != null) {
                    this.toolBoxLayer.removeWindow((IWindow)this.teacherAnswererWindow);
                }
            } else if (LPConstants.ComponentType.Timer.getComponentType().equals(lpComponentDestroyModel.value.component) && !TextUtils.equals((CharSequence)this.router.getLiveRoom().getCurrentUser().getUserId(), (CharSequence)lpComponentDestroyModel.userId)) {
                this.destroyTeacherTimer();
            }
        }));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.ShowAwardTransfer).ofType(NotifyAwardModel.class).subscribe(notifyAwardModel -> {
            VideoContainerWindow matchVideoWindow = null;
            for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
                IUserModel userModel = videoContainerWindow.getVideoWindow().getUserModel();
                if (userModel == null || !userModel.getNumber().equals(notifyAwardModel.userModel.getNumber())) continue;
                matchVideoWindow = videoContainerWindow;
                break;
            }
            if (matchVideoWindow != null) {
                if (notifyAwardModel.awardCount > 0) {
                    matchVideoWindow.getVideoWindow().setAwardCount(notifyAwardModel.awardCount);
                }
                int[] location = new int[2];
                matchVideoWindow.getView().getLocationOnScreen(location);
                location[0] = location[0] + matchVideoWindow.getView().getMeasuredWidth() / 2;
                location[1] = location[1] + matchVideoWindow.getView().getMeasuredHeight() / 2;
                notifyAwardModel.endPointLocation = location;
            }
            this.router.getSubjectByKey(EventKey.ShowAward).onNext(notifyAwardModel);
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getToolBoxVM().getObservableOfGroupInfoAward().observeOn(AndroidSchedulers.mainThread()).flatMap(lpGroupInfoAwardModel -> Observable.fromIterable((Iterable)lpGroupInfoAwardModel.groups)).filter(groupsBean -> groupsBean.group == this.router.getLiveRoom().getCurrentUser().getGroup()).filter(groupsBean -> groupsBean.count > 0).subscribe(groupsBean -> this.initGroupAwardWindow()));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.GroupAward).ofType(LPGroupAwardModel.class).subscribe(lpGroupAwardModel -> {
            if (lpGroupAwardModel.group == this.router.getLiveRoom().getCurrentUser().getGroup()) {
                this.initGroupAwardWindow();
            } else {
                this.updateGroupAwardInfo();
            }
        }));
    }

    private void initGroupAwardWindow() {
        Integer groupAwardCount = (Integer)this.router.getLiveRoom().getToolBoxVM().getAwardGroupMap().get(this.router.getLiveRoom().getCurrentUser().getGroup());
        if (groupAwardCount == null || groupAwardCount <= 0) {
            return;
        }
        if (this.groupAwardWindow == null) {
            this.groupAwardWindow = new GroupAwardWindow(this.getContext());
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
            layoutParams.topMargin = this.getContext().getResources().getDimensionPixelSize(R.dimen.bjysc_remind_label_height);
            this.toolBoxLayer.addWindow((IWindow)this.groupAwardWindow, layoutParams);
        }
        this.groupAwardWindow.setGroupAwardCount(groupAwardCount);
        this.groupAwardWindow.updateGroupAwardContent();
    }

    private void removeGroupAwardWindow() {
        if (this.groupAwardWindow != null) {
            this.toolBoxLayer.removeWindow((IWindow)this.groupAwardWindow);
            this.groupAwardWindow.dismissInfoWindow();
            this.groupAwardWindow = null;
        }
    }

    private void updateGroupAwardInfo() {
        Integer groupAwardCount = (Integer)this.router.getLiveRoom().getToolBoxVM().getAwardGroupMap().get(this.router.getLiveRoom().getCurrentUser().getGroup());
        if (this.router.getLiveRoom().getCurrentUser().getGroup() == 0 || groupAwardCount == null || groupAwardCount <= 0) {
            this.removeGroupAwardWindow();
            return;
        }
        if (this.groupAwardWindow != null) {
            this.groupAwardWindow.setGroupAwardCount(groupAwardCount);
        } else {
            this.initGroupAwardWindow();
        }
        this.groupAwardWindow.updateGroupAwardContent();
    }

    private boolean containsSbb(String windowId) {
        if (this.smallBlackboardWindows == null || this.smallBlackboardWindows.isEmpty()) {
            return false;
        }
        for (SmallBlackboardWindow smallBlackboardWindow : this.smallBlackboardWindows) {
            if (!TextUtils.equals((CharSequence)windowId, (CharSequence)smallBlackboardWindow.getId())) continue;
            return true;
        }
        return false;
    }

    private void showSmallBlackboardWindow(LPSnippetPullResModel snippetPullResModel) {
        boolean isTeacher = BaseUtilsKt.isTeacher((IUserModel)this.router.getLiveRoom().getCurrentUser());
        String id2 = snippetPullResModel.id;
        if (snippetPullResModel.isActive) {
            if (isTeacher) {
                if (!this.containsSbb(snippetPullResModel.id)) {
                    SmallBlackboardWindow sbbWindow = this.initSmallBlackboardView(id2);
                    sbbWindow.cursor = SbbUtils.getLastUserNumber(snippetPullResModel);
                    this.smallBlackboardWindows.add(sbbWindow);
                    sbbWindow.initStatus(snippetPullResModel, SmallBlackboardStatus.TEACHER_REVIEW);
                }
            } else {
                boolean hasParticipated = false;
                boolean hasCommit = false;
                String currentUserNumber = this.router.getLiveRoom().getCurrentUser().getNumber();
                if (snippetPullResModel.userSubmittedList != null) {
                    for (LPUserModel userModel : snippetPullResModel.userSubmittedList) {
                        if (!userModel.getNumber().equals(currentUserNumber)) continue;
                        hasCommit = true;
                        break;
                    }
                }
                if (!hasCommit && snippetPullResModel.userParticipatedList != null) {
                    for (LPUserModel userModel : snippetPullResModel.userParticipatedList) {
                        if (!userModel.getNumber().equals(currentUserNumber)) continue;
                        hasParticipated = true;
                        break;
                    }
                }
                if (hasCommit) {
                    return;
                }
                SmallBlackboardWindow sbbWindow = this.initSmallBlackboardView(id2);
                this.smallBlackboardWindows.add(sbbWindow);
                sbbWindow.setToAll(snippetPullResModel.toAll);
                sbbWindow.initStatus(snippetPullResModel, SmallBlackboardStatus.STUDENT_WRITING);
                if (!hasParticipated) {
                    LPSnippetSubmitModel participateModel = new LPSnippetSubmitModel();
                    participateModel.id = id2;
                    participateModel.from = (LPUserModel)this.router.getLiveRoom().getCurrentUser();
                    participateModel.isActive = true;
                    this.router.getLiveRoom().getToolBoxVM().requestSnippetParticipate(participateModel);
                }
            }
        } else if (!isTeacher) {
            this.router.getLiveRoom().getToolBoxVM().requestSnippetViewUpdateCache();
        }
    }

    private SmallBlackboardWindow initSmallBlackboardView(String id2) {
        float ssbWidth = this.getResources().getDimension(R.dimen.bjysc_default_sbb_width);
        float ssbHeight = this.getResources().getDimension(R.dimen.bjysc_default_sbb_height);
        if (this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE) {
            ssbWidth -= (float)UtilsKt.getDp((int)100);
            ssbHeight -= (float)UtilsKt.getDp((int)50);
        }
        float width = ssbWidth / (float)this.getWidth();
        float height = ssbHeight / (float)this.getHeight();
        return this.initSmallBlackboardView(false, id2, ((float)this.getWidth() - ssbWidth) / 2.0f / (float)this.getWidth(), ((float)this.getHeight() - ssbHeight) / 2.0f / (float)this.getHeight(), width, height);
    }

    private SmallBlackboardWindow initSmallBlackboardView(boolean isPublishAll, String id2, float x, float y, float width, float height) {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams((int)((float)this.getWidth() * width), (int)((float)this.getHeight() * height));
        int defaultMargin = UtilsKt.getDp((int)10);
        int childCount = this.smallBlackboardLayer.getChildCount();
        layoutParams.topMargin = (int)(y * (float)this.getHeight()) + defaultMargin * childCount;
        layoutParams.leftMargin = (int)(x * (float)this.getWidth()) + defaultMargin * childCount;
        SmallBlackboardWindow smallBlackboardWindow = new SmallBlackboardWindow(this.getContext(), this.shapePaint, isPublishAll, true);
        smallBlackboardWindow.setCurrentLayer(id2);
        smallBlackboardWindow.setWindowLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.smallBlackboardLayer.addWindow((IWindow)smallBlackboardWindow, layoutParams);
        if (!BaseUtilsKt.isTeacher((IUserModel)this.router.getLiveRoom().getCurrentUser())) {
            int count = this.router.getValueByKey(EventKey.SbbWindowCount, Integer.class, 0);
            this.router.setObjectByKey(EventKey.SbbWindowCount, count + 1);
        }
        return smallBlackboardWindow;
    }

    private PPTWindow newPPTWindow(LPDocViewElementModel model) {
        if (model == null) {
            return null;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams((int)((float)this.getWidth() * Float.parseFloat(model.width)), (int)((float)this.getHeight() * Float.parseFloat(model.height)));
        layoutParams.topMargin = (int)(Float.parseFloat(model.y) * (float)this.getHeight());
        layoutParams.leftMargin = (int)(Float.parseFloat(model.x) * (float)this.getWidth());
        if (this.pptAuth) {
            this.shapePaint.setPPtEditMode(this.shapePaint.getPPtEditMode());
        }
        PPTWindow pptWindow = new PPTWindow(this.getContext(), model.docId, this.shapePaint, this.router.getLiveRoom().getCurrentUser().getType());
        pptWindow.setWindowLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.pptWindows.add(pptWindow);
        this.refreshPPTWindowCache();
        this.documentLayer.addWindow((IWindow)pptWindow, layoutParams);
        return pptWindow;
    }

    private void refreshPPTWindowCache() {
        if (this.router == null) {
            return;
        }
        this.router.setObjectByKey(EventKey.PPTWindows, this.pptWindows);
    }

    private void handleExtStream(IMediaModel iMediaModel) {
        switch (iMediaModel.getMediaSourceType()) {
            case MainScreenShare: 
            case ExtCamera: 
            case ExtScreenShare: {
                this.handleVideoWindow(iMediaModel);
                break;
            }
            case Media: {
                if (!iMediaModel.isAudioOn() && !iMediaModel.isVideoOn()) {
                    this.videoLayer.hideMusicPlayIcon();
                    this.handleVideoWindow(iMediaModel);
                    break;
                }
                if (iMediaModel.isVideoOn()) {
                    this.handleVideoWindow(iMediaModel);
                    break;
                }
                this.videoLayer.showMusicPlayIcon();
                this.router.getLiveRoom().getPlayer().playAVClose(iMediaModel.getMediaId());
                this.router.getLiveRoom().getPlayer().playAudio(iMediaModel.getMediaId());
                break;
            }
        }
    }

    private void handleVideoWindow(IMediaModel iMediaModel) {
        BaseTitledWindow videoWindowWrapper = null;
        for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
            if (!videoContainerWindow.getVideoWindow().getMediaId().equals(iMediaModel.getMediaId())) continue;
            videoWindowWrapper = videoContainerWindow;
            break;
        }
        if (iMediaModel.isVideoOn()) {
            this.videoLayer.hideMusicPlayIcon();
            if (videoWindowWrapper == null) {
                FrameLayout.LayoutParams layoutParams;
                VideoWindow videoWindow = VideoWindow.newInstance(this.getContext(), this.router);
                videoWindow.setAspectRatio(LPConstants.LPAspectRatio.Fit);
                videoWindowWrapper = new VideoContainerWindow(this.getContext(), videoWindow, true);
                ((VideoContainerWindow)videoWindowWrapper).initMediaModel(iMediaModel);
                if (this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE) {
                    ((VideoContainerWindow)videoWindowWrapper).getVideoWindow().setBottomVisibility(8);
                    ((VideoContainerWindow)videoWindowWrapper).getVideoWindow().setAwardTvVisibility(8);
                } else {
                    ((VideoContainerWindow)videoWindowWrapper).getVideoWindow().setBottomVisibility(4);
                }
                int measuredWidth = this.getMeasuredWidth();
                int measuredHeight = this.getMeasuredHeight();
                float ration = 1.7777778f;
                if (iMediaModel.getMediaSourceType() == LPConstants.MediaSourceType.ExtScreenShare || iMediaModel.getMediaSourceType() == LPConstants.MediaSourceType.MainScreenShare) {
                    layoutParams = new FrameLayout.LayoutParams(-1, -1);
                } else {
                    int height = measuredHeight == 0 ? -1 : (int)((double)measuredHeight * 0.7);
                    int width = measuredWidth == 0 ? -1 : (int)((float)height * ration);
                    layoutParams = new FrameLayout.LayoutParams(width, height);
                    if (measuredHeight != 0) {
                        layoutParams.leftMargin = (measuredWidth - width) / 2;
                        layoutParams.topMargin = (measuredHeight - height) / 2;
                    }
                }
                this.videoLayer.addWindow((IWindow)videoWindowWrapper, layoutParams);
                ((VideoContainerWindow)videoWindowWrapper).getVideoWindow().changeVideoState(iMediaModel);
                this.videoWindows.add((VideoContainerWindow)videoWindowWrapper);
                if (this.cachedViewPositions.containsKey(iMediaModel.getMediaId())) {
                    this.handleVideoWindowPosition(this.cachedViewPositions.get(iMediaModel.getMediaId()));
                    this.cachedViewPositions.remove(iMediaModel.getMediaId());
                }
                if (iMediaModel.getMediaSourceType() == LPConstants.MediaSourceType.Media && this.mediaCachePlayerUpdateModel.action != LPConstants.LPPlayerAction.REMOVE) {
                    this.handleVideoWindowPosition(this.mediaCachePlayerUpdateModel, true);
                }
                if (iMediaModel.getMediaSourceType() == LPConstants.MediaSourceType.ExtCamera && iMediaModel.getUser().getType() == LPConstants.LPUserType.Student && BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
                    this.router.getSubjectByKey(EventKey.VideoWindowToBlackboard).onNext((Object)((VideoContainerWindow)videoWindowWrapper).getVideoWindow());
                }
            } else {
                if (videoWindowWrapper.isMinInSync()) {
                    this.videoLayer.showMusicPlayIcon();
                }
                ((VideoContainerWindow)videoWindowWrapper).initMediaModel(iMediaModel);
                ((VideoContainerWindow)videoWindowWrapper).getVideoWindow().setAspectRatio(LPConstants.LPAspectRatio.Fit);
                ((VideoContainerWindow)videoWindowWrapper).getVideoWindow().changeVideoState(iMediaModel);
                if (this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE) {
                    ((VideoContainerWindow)videoWindowWrapper).getVideoWindow().setBottomVisibility(8);
                    ((VideoContainerWindow)videoWindowWrapper).getVideoWindow().setAwardTvVisibility(8);
                }
            }
        } else if (!iMediaModel.isAudioOn()) {
            if (videoWindowWrapper == null) {
                this.router.getLiveRoom().getPlayer().playAVClose(iMediaModel.getMediaId());
            } else {
                this.videoLayer.removeWindow((IWindow)videoWindowWrapper);
                this.videoWindows.remove(videoWindowWrapper);
                ((VideoContainerWindow)videoWindowWrapper).onDestroy();
                if (this.mediaCachePlayerUpdateModel.action == LPConstants.LPPlayerAction.FULL) {
                    this.router.getSubjectByKey(EventKey.RemoveFullScreenWindow).onNext((Object)true);
                }
            }
        }
        SparseArray groupMap = this.router.getLiveRoom().getOnlineUserVM().getGroupMap();
        LPGroupItem lpGroupItem = (LPGroupItem)groupMap.get(iMediaModel.getUser().getGroup());
        if (lpGroupItem == null) {
            lpGroupItem = new LPGroupItem(0);
        }
        if (lpGroupItem.groupItemModel == null) {
            lpGroupItem.groupItemModel = new GroupItem(0);
        }
        if (videoWindowWrapper != null && ((VideoContainerWindow)videoWindowWrapper).getVideoWindow() != null) {
            if (lpGroupItem.groupItemModel != null && lpGroupItem.id != 0) {
                ((VideoContainerWindow)videoWindowWrapper).getVideoWindow().setGroupColor(lpGroupItem.groupItemModel.color, lpGroupItem.id);
            }
            if (lpGroupItem.groupItemModel != null && this.router.getLiveRoom().getOnlineUserVM().isMediaGroup()) {
                ((VideoContainerWindow)videoWindowWrapper).getVideoWindow().setGroupItem(lpGroupItem.groupItemModel);
            }
            videoWindowWrapper.getView().setVisibility(((VideoContainerWindow)videoWindowWrapper).getVideoWindow().isShowWindow() ? 0 : 8);
        }
    }

    private void handleVideoWindowPosition(LPPlayerViewUpdateModel playerViewUpdateModel) {
        this.handleVideoWindowPosition(playerViewUpdateModel, false);
        if (!this.isFirstCalledHandleVideoWindowPosition) {
            this.isFirstCalledHandleVideoWindowPosition = true;
            for (LPPlayerViewUpdateModel.PlayerPosition position : playerViewUpdateModel.all) {
                if (position.id.endsWith("0") || playerViewUpdateModel.id.equals(position.id)) continue;
                LPPlayerViewUpdateModel item = new LPPlayerViewUpdateModel();
                item.all = playerViewUpdateModel.all;
                item.id = position.id;
                item.action = LPConstants.LPPlayerAction.REPOSITION;
                item.from = playerViewUpdateModel.from;
                item.mediaId = position.mediaId;
                this.handleVideoWindowPosition(item, false);
            }
        }
    }

    private void handleVideoWindowPosition(LPPlayerViewUpdateModel playerViewUpdateModel, boolean fakeBroadCast) {
        block15: {
            block17: {
                String mediaId;
                block16: {
                    if (null == playerViewUpdateModel) {
                        LPLogger.e((String)this.TAG, (String)"player_view_update: not found player_view_update action....");
                        return;
                    }
                    if (null != playerViewUpdateModel.action) break block15;
                    mediaId = FECompatUtil.getMediaIdFromFEUserId(playerViewUpdateModel.id);
                    if (!this.videoWindows.isEmpty()) break block16;
                    if (!playerViewUpdateModel.id.endsWith("2")) break block17;
                    this.mediaCachePlayerUpdateModel = playerViewUpdateModel;
                    break block17;
                }
                for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
                    VideoWindow videoWindow = videoContainerWindow.getVideoWindow();
                    if (!FECompatUtil.isTargetWindow(videoWindow, mediaId)) continue;
                    videoContainerWindow.minInSync();
                    this.videoLayer.showMusicPlayIcon();
                    new ToastUtil(this.getContext()).setText("\u8001\u5e08\u5df2\u6536\u8d77\u64ad\u653e\u5668").show();
                    break;
                }
            }
            return;
        }
        if (playerViewUpdateModel.id.endsWith("2")) {
            this.mediaCachePlayerUpdateModel = playerViewUpdateModel;
        }
        switch (playerViewUpdateModel.action) {
            case REMOVE: {
                this.removeVideoWindow(playerViewUpdateModel.id);
                break;
            }
            case STICK: {
                if (this.router.getLiveRoom().getCurrentUser().getUserId().equals(playerViewUpdateModel.from) || UtilsKt.isEmptySet((Set)playerViewUpdateModel.all)) {
                    return;
                }
                if (this.repositionVideoWindow(playerViewUpdateModel)) {
                    this.bringVideoToFront(playerViewUpdateModel.id);
                    break;
                }
                String mediaId = FECompatUtil.getMediaIdFromFEUserId(playerViewUpdateModel.id);
                this.cachedViewPositions.put(mediaId, playerViewUpdateModel);
                break;
            }
            case ADD: 
            case REPOSITION: {
                if (this.router.getLiveRoom().getCurrentUser().getUserId().equals(playerViewUpdateModel.from) || UtilsKt.isEmptySet((Set)playerViewUpdateModel.all)) {
                    return;
                }
                if (this.repositionVideoWindow(playerViewUpdateModel)) break;
                String mediaId = FECompatUtil.getMediaIdFromFEUserId(playerViewUpdateModel.id);
                this.cachedViewPositions.put(mediaId, playerViewUpdateModel);
                break;
            }
            case MAX: {
                if (this.maximumVideoWindow(playerViewUpdateModel)) break;
                String mediaId = FECompatUtil.getMediaIdFromFEUserId(playerViewUpdateModel.id);
                this.cachedViewPositions.put(mediaId, playerViewUpdateModel);
                break;
            }
            case FULL: {
                if (this.fulledVideoWindow(playerViewUpdateModel)) break;
                String mediaId = FECompatUtil.getMediaIdFromFEUserId(playerViewUpdateModel.id);
                this.cachedViewPositions.put(mediaId, playerViewUpdateModel);
                break;
            }
            case NORMAL: {
                if (this.normalVideoWindow(playerViewUpdateModel)) break;
                String mediaId = FECompatUtil.getMediaIdFromFEUserId(playerViewUpdateModel.id);
                this.cachedViewPositions.put(mediaId, playerViewUpdateModel);
            }
        }
        if (!fakeBroadCast) {
            this.router.setObjectByKey(EventKey.AllPlayerViewList, playerViewUpdateModel.all);
        }
    }

    private void addSmallBlackboardView(@NonNull LPDocViewUpdateModel lpDocViewUpdateModel) {
        for (LPDocViewElementModel model : lpDocViewUpdateModel.all) {
            if (!model.docId.equals(lpDocViewUpdateModel.docId)) continue;
            SmallBlackboardWindow blackboardWindow = this.initSmallBlackboardView(true, model.docId, Float.parseFloat(model.x), Float.parseFloat(model.y), Float.parseFloat(model.width), Float.parseFloat(model.height));
            LPSnippetPullResModel resModel = new LPSnippetPullResModel();
            resModel.id = lpDocViewUpdateModel.docId;
            resModel.isActive = true;
            blackboardWindow.initStatus(resModel, SmallBlackboardStatus.PUBLISH_TO_ALL);
            if (model.full == 1) {
                blackboardWindow.maxInFull();
            } else if (model.max == 1) {
                blackboardWindow.maxInSync();
            }
            this.smallBlackboardWindows.add(blackboardWindow);
            break;
        }
    }

    private void removeAndDestroyBlackboardView(@NonNull String docId) {
        Iterator<SmallBlackboardWindow> iterator = this.smallBlackboardWindows.iterator();
        while (iterator.hasNext()) {
            SmallBlackboardWindow window = iterator.next();
            LPLogger.d((String)this.TAG, (String)("removeAndDestroyBlackboardView " + window.getId() + ", toRemove=" + docId));
            if (!docId.equals(window.getId())) continue;
            iterator.remove();
            window.onDestroy();
            break;
        }
    }

    private void addPPTView(@NonNull LPDocViewUpdateModel lpDocViewUpdateModel) {
        PPTWindow pptWindow = null;
        for (LPDocViewElementModel model : lpDocViewUpdateModel.all) {
            if (!model.docId.equals(lpDocViewUpdateModel.docId)) continue;
            pptWindow = this.newPPTWindow(model);
            if (model.full == 1) {
                pptWindow.maxInFull(true);
                break;
            }
            if (model.max != 1) break;
            pptWindow.maxInSync(true);
            break;
        }
        if (pptWindow != null && pptWindow.isPreviewPPT()) {
            PPTWindow fullPPTWindow = this.router.getValueByKey(EventKey.FullScreenPPTWindow, PPTWindow.class);
            if (fullPPTWindow != null) {
                fullPPTWindow.switchTab(pptWindow);
            }
            return;
        }
        if (pptWindow == null || pptWindow.isMaxInSync() || pptWindow.isMaxInFull() || pptWindow.isPreviewPPT()) {
            return;
        }
        this.checkExistTopPreviewPPTWindow();
    }

    private void addWebpage(@NonNull LPDocViewUpdateModel lpDocViewUpdateModel) {
        if (this.browserWindow == null) {
            this.browserWindow = new BrowserWindow2(this.getContext());
            this.browserWindow.setBrowserChangeListener(this.browserChangeListener);
        }
        for (LPDocViewElementModel model : lpDocViewUpdateModel.all) {
            if (!TextUtils.equals((CharSequence)model.docId, (CharSequence)lpDocViewUpdateModel.docId)) continue;
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(Math.round(Float.parseFloat(model.width) * (float)this.getWidth()), Math.round(Float.parseFloat(model.height) * (float)this.getHeight()));
            layoutParams.leftMargin = Math.round(Float.parseFloat(model.x) * (float)this.getWidth());
            layoutParams.topMargin = Math.round(Float.parseFloat(model.y) * (float)this.getHeight());
            this.browserLayer.removeAllViews();
            this.browserLayer.addWindow((IWindow)this.browserWindow, layoutParams);
            if (model.full == 1) {
                this.browserWindow.setReceiveOrder(true);
                this.browserWindow.maxInFull();
                break;
            }
            if (model.max != 1) break;
            this.browserWindow.setReceiveOrder(true);
            this.browserWindow.maxInSync();
            break;
        }
    }

    private void checkExistTopPreviewPPTWindow() {
        PPTWindow topPPTWindow;
        PPTWindow fullPPTWindow = this.router.getValueByKey(EventKey.FullScreenPPTWindow, PPTWindow.class);
        PPTWindow maxPPTWindow = this.router.getValueByKey(EventKey.MaxScreenPPTWindow, PPTWindow.class);
        PPTWindow pPTWindow = topPPTWindow = fullPPTWindow != null ? fullPPTWindow : maxPPTWindow;
        if (topPPTWindow == null || !topPPTWindow.isPreviewPPT()) {
            return;
        }
        if (topPPTWindow.isMaxInFull()) {
            this.addToFullCache();
        } else if (topPPTWindow.isMaxInSync()) {
            this.addToMaxCache();
        }
        if (BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
            this.pptTabLayer.refreshTabs();
        }
    }

    private boolean checkStoreContainsPPT(LPDocViewElementModel elementModel) {
        List docStoreList = this.router.getLiveRoom().getDocListVM().getDocList();
        if (docStoreList == null || docStoreList.size() == 0 || elementModel == null) {
            return false;
        }
        for (LPDocModel docModel : docStoreList) {
            if (docModel.docId == null || !docModel.docId.equals(elementModel.docId)) continue;
            return true;
        }
        return false;
    }

    private void removeAndDestroyPPTView(@NonNull String docId) {
        ArrayList<PPTWindow> arrayList;
        PPTWindow destPPTWindow;
        ArrayList<LPDocViewElementModel> allDocList;
        int status = 0;
        for (PPTWindow pPTWindow : this.pptWindows) {
            ViewGroup viewGroup;
            if (!docId.equals(pPTWindow.getId())) continue;
            if (pPTWindow.isMaxInFull()) {
                pPTWindow.resetInFull(true);
                status += 2;
            }
            if (pPTWindow.isMaxInSync()) {
                pPTWindow.resetInSync(true);
                ++status;
            }
            if ((viewGroup = pPTWindow.getParentViewGroup()) != null) {
                viewGroup.removeView(pPTWindow.getView());
            }
            this.pptWindows.remove(pPTWindow);
            pPTWindow.onDestroy();
            this.updateToolbarWindow();
            break;
        }
        if (!(allDocList = new ArrayList<LPDocViewElementModel>(this.router.getListByKey(EventKey.AllDocViewList, LPDocViewElementModel.class))).isEmpty()) {
            for (LPDocViewElementModel elementModel : allDocList) {
                if (!TextUtils.equals((CharSequence)elementModel.docId, (CharSequence)docId)) continue;
                allDocList.remove(elementModel);
                this.router.setObjectByKey(EventKey.AllDocViewList, allDocList);
                break;
            }
        }
        this.refreshPPTWindowCache();
        if (this.pptWindows.size() >= 1 && (destPPTWindow = (PPTWindow)(arrayList = new ArrayList<PPTWindow>(this.pptWindows)).get(arrayList.size() - 1)).isPreviewPPT()) {
            if ((status & 2) == 2) {
                destPPTWindow.maxInFull();
            } else if ((status & 1) == 1) {
                destPPTWindow.maxInSync();
            }
        }
        this.pptTabLayer.refreshTabs();
    }

    private void sbbBringToFront(@NonNull String docId) {
        for (SmallBlackboardWindow window : this.smallBlackboardWindows) {
            if (!docId.equals(window.getId())) continue;
            window.bringToForeground();
        }
    }

    private void bringToFront(@NonNull String docId) {
        for (PPTWindow pptWindow : this.pptWindows) {
            if (!docId.equals(pptWindow.getId())) continue;
            pptWindow.bringToForeground();
        }
    }

    private void sbbBackToNormal(@NonNull String id2) {
        for (SmallBlackboardWindow window : this.smallBlackboardWindows) {
            if (!id2.equals(window.getId())) continue;
            if (window.isMaxInSync()) {
                window.resetInSync();
                break;
            }
            if (!window.isMaxInFull()) break;
            window.resetInFull();
            break;
        }
    }

    private void backToNormal(@NonNull String docId) {
        PPTWindow tempPPTWindow = null;
        for (PPTWindow pptWindow : this.pptWindows) {
            if (!docId.equals(pptWindow.getId())) continue;
            tempPPTWindow = pptWindow;
            if (pptWindow.isMaxInFull()) {
                pptWindow.resetInFull(true);
                break;
            }
            if (!pptWindow.isMaxInSync()) break;
            pptWindow.resetInSync(true);
            break;
        }
        this.backToNormalCache();
        if (tempPPTWindow != null && !tempPPTWindow.isCacheStateMax() && !tempPPTWindow.isCacheStateFull()) {
            tempPPTWindow.bringToForeground();
        }
    }

    private void backToNormalWebpage() {
        if (this.browserWindow == null) {
            return;
        }
        if (this.browserWindow.isMinInSync()) {
            this.browserWindow.setReceiveOrder(true);
            this.browserWindow.resetMinInSync();
        } else if (this.browserWindow.isMaxInFull()) {
            this.browserWindow.setReceiveOrder(true);
            this.browserWindow.resetInFull();
        } else if (this.browserWindow.isMaxInSync()) {
            this.browserWindow.setReceiveOrder(true);
            this.browserWindow.resetInSync();
        }
    }

    private void backToNormalCache() {
        PPTWindow maxPPTWindow = this.router.getValueByKey(EventKey.MaxScreenPPTWindow, PPTWindow.class);
        PPTWindow fullPPTWindow = this.router.getValueByKey(EventKey.FullScreenPPTWindow, PPTWindow.class);
        if (maxPPTWindow != null || fullPPTWindow != null) {
            return;
        }
        for (PPTWindow pptWindow : this.pptWindows) {
            if (pptWindow.isCacheStateFull()) {
                pptWindow.resetInFull(true);
            }
            if (pptWindow.isCacheStateMax()) {
                pptWindow.resetInSync(true);
            }
            if (pptWindow.isCacheStateMax() || pptWindow.isCacheStateFull()) continue;
            pptWindow.showTitle();
        }
    }

    private void sbbMaximumWindow(@NonNull String docId) {
        for (SmallBlackboardWindow window : this.smallBlackboardWindows) {
            if (!docId.equals(window.getId())) continue;
            if (window.isMaxInFull()) {
                window.resetInFull();
            }
            if (window.isMaxInSync()) break;
            window.maxInSync();
            break;
        }
    }

    private void maximumWindow(@NonNull String docId) {
        for (PPTWindow pptWindow : this.pptWindows) {
            if (!docId.equals(pptWindow.getId())) continue;
            if (pptWindow.isMaxInFull()) {
                pptWindow.resetInFull(true);
            }
            if (pptWindow.isMaxInSync()) break;
            pptWindow.maxInSync(true);
            break;
        }
        this.addToMaxCache();
    }

    private void maximumWebpage() {
        if (this.browserWindow == null) {
            return;
        }
        if (this.browserWindow.isMinInSync()) {
            this.browserWindow.setReceiveOrder(true);
            this.browserWindow.resetMinInSync();
        }
        if (this.browserWindow.isMaxInFull()) {
            this.browserWindow.setReceiveOrder(true);
            this.browserWindow.resetInFull();
        }
        if (!this.browserWindow.isMaxInSync()) {
            this.browserWindow.setReceiveOrder(true);
            this.browserWindow.maxInSync();
        }
    }

    private void minimumWebpage() {
        if (this.browserWindow == null) {
            return;
        }
        if (this.browserWindow.isMaxInFull()) {
            this.browserWindow.setReceiveOrder(true);
            this.browserWindow.resetInFull();
        }
        if (!this.browserWindow.isMinInSync()) {
            this.browserWindow.setReceiveOrder(true);
            this.browserWindow.minInSync();
        }
    }

    private void addToMaxCache() {
        PPTWindow fullPPTWindow = this.router.getValueByKey(EventKey.FullScreenPPTWindow, PPTWindow.class);
        if (fullPPTWindow != null) {
            return;
        }
        for (PPTWindow pptWindow : this.pptWindows) {
            if (!pptWindow.isCacheStateFull()) continue;
            pptWindow.resetInFull(true);
        }
        PPTWindow maxPPTWindow = this.router.getValueByKey(EventKey.MaxScreenPPTWindow, PPTWindow.class);
        if (maxPPTWindow == null) {
            return;
        }
        for (PPTWindow pptWindow : this.pptWindows) {
            if (pptWindow.isMaxInSync() || pptWindow.isCacheStateMax()) continue;
            pptWindow.maxInSyncCache(true);
        }
        maxPPTWindow.bringToForeground();
    }

    private void sbbFullscreenWindow(@NonNull String docId) {
        for (SmallBlackboardWindow window : this.smallBlackboardWindows) {
            if (!docId.equals(window.getId())) continue;
            if (window.isMaxInFull()) break;
            window.maxInFull();
            break;
        }
    }

    private void fullscreenWindow(@NonNull String docId) {
        for (PPTWindow pptWindow : this.pptWindows) {
            if (!docId.equals(pptWindow.getId())) continue;
            if (pptWindow.isMaxInFull()) break;
            pptWindow.maxInFull(true);
            break;
        }
        this.addToFullCache();
    }

    private void fullscreenWebpage() {
        if (this.browserWindow != null) {
            if (this.browserWindow.isMinInSync()) {
                this.browserWindow.setReceiveOrder(true);
                this.browserWindow.resetMinInSync();
            }
            if (!this.browserWindow.isMaxInFull()) {
                this.browserWindow.setReceiveOrder(true);
                this.browserWindow.maxInFull();
            }
        }
    }

    private void addToFullCache() {
        PPTWindow fullPPTWindow = this.router.getValueByKey(EventKey.FullScreenPPTWindow, PPTWindow.class);
        if (fullPPTWindow == null) {
            return;
        }
        boolean hasChanged = false;
        for (PPTWindow pptWindow : this.pptWindows) {
            if (pptWindow.isMaxInFull() || pptWindow.isCacheStateFull()) continue;
            pptWindow.maxInFullCache(true);
            hasChanged = true;
        }
        if (hasChanged) {
            fullPPTWindow.maxInFull(true);
        }
    }

    private void sbbRepositionWindow(@NonNull LPDocViewUpdateModel lpDocViewUpdateModel) {
        LPDocViewElementModel model = null;
        for (LPDocViewElementModel e : lpDocViewUpdateModel.all) {
            if (!lpDocViewUpdateModel.docId.equals(e.docId)) continue;
            model = e;
            break;
        }
        if (model == null) {
            return;
        }
        for (SmallBlackboardWindow window : this.smallBlackboardWindows) {
            if (!model.docId.equals(window.getId())) continue;
            window.moveTo(Math.round(Float.parseFloat(model.x) * (float)this.getWidth()), Math.round(Float.parseFloat(model.y) * (float)this.getHeight()));
            window.scaleTo(Math.round(Float.parseFloat(model.width) * (float)this.getWidth()), Math.round(Float.parseFloat(model.height) * (float)this.getHeight()));
            break;
        }
    }

    private void repositionWindow(@NonNull LPDocViewUpdateModel lpDocViewUpdateModel) {
        LPDocViewElementModel model = null;
        for (LPDocViewElementModel e : lpDocViewUpdateModel.all) {
            if (!lpDocViewUpdateModel.docId.equals(e.docId)) continue;
            model = e;
            break;
        }
        if (model == null) {
            return;
        }
        for (PPTWindow pptWindow : this.pptWindows) {
            if (!model.docId.equals(pptWindow.getId())) continue;
            pptWindow.moveTo(Math.round(Float.parseFloat(model.x) * (float)this.getWidth()), Math.round(Float.parseFloat(model.y) * (float)this.getHeight()));
            pptWindow.scaleTo(Math.round(Float.parseFloat(model.width) * (float)this.getWidth()), Math.round(Float.parseFloat(model.height) * (float)this.getHeight()));
            break;
        }
    }

    private void repositionWebpage(@NonNull LPDocViewUpdateModel lpDocViewUpdateModel) {
        LPDocViewElementModel model = null;
        for (LPDocViewElementModel e : lpDocViewUpdateModel.all) {
            if (!TextUtils.equals((CharSequence)lpDocViewUpdateModel.docId, (CharSequence)e.docId)) continue;
            model = e;
            break;
        }
        if (model == null || this.browserWindow == null) {
            return;
        }
        this.browserWindow.scaleTo(Math.round(Float.parseFloat(model.width) * (float)this.getWidth()), Math.round(Float.parseFloat(model.height) * (float)this.getHeight()));
        this.browserWindow.moveTo(Math.round(Float.parseFloat(model.x) * (float)this.getWidth()), Math.round(Float.parseFloat(model.y) * (float)this.getHeight()));
    }

    private void showSbbWindowName(LPDocViewUpdateModel viewUpdateModel) {
        LPDocViewElementModel model = null;
        for (LPDocViewElementModel e : viewUpdateModel.all) {
            if (!viewUpdateModel.docId.equals(e.docId)) continue;
            model = e;
            break;
        }
        if (model == null) {
            return;
        }
        for (SmallBlackboardWindow window : this.smallBlackboardWindows) {
            if (!model.docId.equals(window.getId())) continue;
            window.showWindowOwnerName(model);
            break;
        }
    }

    private void addVideoWindow(PlayerViewActionModel model) {
        FrameLayout.LayoutParams params;
        VideoContainerWindow videoContainerWindow2;
        if (this.router == null) {
            return;
        }
        boolean isExist = false;
        LPPlayerViewUpdateModel playerViewUpdateModel = model.getLpPlayerViewUpdateModel();
        String mediaId = FECompatUtil.getMediaIdFromFEUserId(playerViewUpdateModel.id);
        if (playerViewUpdateModel.all.isEmpty()) {
            return;
        }
        for (VideoContainerWindow videoContainerWindow2 : this.videoWindows) {
            if (!videoContainerWindow2.getVideoWindow().getMediaId().equals(mediaId)) continue;
            isExist = true;
            break;
        }
        if (isExist) {
            return;
        }
        VideoWindow seatVideoWindow = model.getVideoContainerWindow();
        if (seatVideoWindow.isDestroyed()) {
            return;
        }
        seatVideoWindow.setRemoteVideoStreamType(BJYRtcCommon.DualStreamType.VIDEO_STREAM_HIGH);
        videoContainerWindow2 = new VideoContainerWindow(this.getContext(), seatVideoWindow);
        LPPlayerViewUpdateModel.PlayerPosition playerPosition = null;
        for (LPPlayerViewUpdateModel.PlayerPosition position : playerViewUpdateModel.all) {
            if (!mediaId.equals(FECompatUtil.getMediaIdFromFEUserId(position.id))) continue;
            playerPosition = position;
            break;
        }
        if (playerPosition == null) {
            return;
        }
        try {
            int width = Math.round((float)this.getWidth() * Float.parseFloat(playerPosition.width));
            int height = Math.round((float)this.getHeight() * Float.parseFloat(playerPosition.height));
            params = new FrameLayout.LayoutParams(width, height);
            params.leftMargin = Math.round((float)this.getWidth() * Float.parseFloat(playerPosition.x));
            params.topMargin = Math.round((float)this.getHeight() * Float.parseFloat(playerPosition.y));
        }
        catch (Exception e) {
            params = new FrameLayout.LayoutParams(400, 300);
            params.leftMargin = this.getMeasuredWidth() / 2 - 200;
            params.topMargin = this.getMeasuredHeight() / 2 - 150;
        }
        this.videoWindows.add(videoContainerWindow2);
        this.bringVideoToFront(playerViewUpdateModel.id);
        this.videoLayer.addWindow((IWindow)videoContainerWindow2, params);
        if (playerPosition.max == 1) {
            this.maximumVideoWindow(playerViewUpdateModel);
        }
        if (playerPosition.full == 1) {
            this.fulledVideoWindow(playerViewUpdateModel);
        }
        if (!this.videoWindows.isEmpty()) {
            this.router.getSubjectByKey(EventKey.ResumeButton).onNext((Object)true);
        }
        videoContainerWindow2.getView().setVisibility(seatVideoWindow.isShowWindow() ? 0 : 8);
        List lpGroupItems = this.router.getLiveRoom().getOnlineUserVM().getGroupList();
        if (null != lpGroupItems && lpGroupItems.size() > 0) {
            block4: for (LPGroupItem lpGroupItem : lpGroupItems) {
                if (lpGroupItem.id == 0) continue;
                List userModelList = lpGroupItem.userModelList;
                for (LPUserModel lpUserModel : userModelList) {
                    if (lpGroupItem.groupItemModel == null || !TextUtils.equals((CharSequence)lpUserModel.number, (CharSequence)model.userNum)) continue;
                    videoContainerWindow2.getVideoWindow().setGroupColor(lpGroupItem.groupItemModel.color, lpGroupItem.groupItemModel.id);
                    continue block4;
                }
            }
        }
    }

    private void removeVideoWindow(@NonNull String uid) {
        String mediaId = FECompatUtil.getMediaIdFromFEUserId(uid);
        for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
            VideoWindow videoWindow = videoContainerWindow.getVideoWindow();
            if (!FECompatUtil.isTargetWindow(videoWindow, mediaId)) continue;
            if (videoContainerWindow.isMaxInFull()) {
                videoContainerWindow.resetInFull();
            }
            this.videoLayer.removeWindow((IWindow)videoContainerWindow);
            this.videoWindows.remove(videoContainerWindow);
            this.router.getSubjectByKey(EventKey.PlayerViewRemove).onNext((Object)videoWindow);
            break;
        }
        if (BaseUtilsKt.isTeacher((IUserModel)this.router.getLiveRoom().getCurrentUser()) && this.videoWindows.isEmpty()) {
            this.router.getSubjectByKey(EventKey.ResumeButton).onNext((Object)false);
        }
    }

    private void requestVideoWindowRemove(String mediaId) {
        Set<LPPlayerViewUpdateModel.PlayerPosition> allList = this.router.getSetByKey(EventKey.AllPlayerViewList, LPPlayerViewUpdateModel.PlayerPosition.class);
        if (null == allList) {
            return;
        }
        LPPlayerViewUpdateModel model = new LPPlayerViewUpdateModel();
        model.id = mediaId;
        model.action = LPConstants.LPPlayerAction.REMOVE;
        for (LPPlayerViewUpdateModel.PlayerPosition playerPosition : allList) {
            if (!playerPosition.id.equals(mediaId)) continue;
            allList.remove(playerPosition);
            model.mediaId = playerPosition.mediaId;
            model.all = allList;
            this.router.getLiveRoom().getMediaVM().requestPlayerViewUpdate(model);
            break;
        }
    }

    private void bringVideoToFront(@NonNull String uid) {
        String mediaId = FECompatUtil.getMediaIdFromFEUserId(uid);
        for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
            VideoWindow videoWindow = videoContainerWindow.getVideoWindow();
            if (FECompatUtil.checkVideoWindowMediaId(videoWindow, mediaId)) {
                videoContainerWindow.bringToForeground();
                if (videoContainerWindow.getVideoWindow().isOverlay()) continue;
                videoWindow.setZOrderMediaOverlay(true);
                continue;
            }
            if (!videoContainerWindow.getVideoWindow().isOverlay()) continue;
            videoWindow.setZOrderMediaOverlay(false);
        }
    }

    private LPPlayerViewUpdateModel.PlayerPosition getCurrentUpdatedPosition(@NonNull LPPlayerViewUpdateModel model) {
        LPPlayerViewUpdateModel.PlayerPosition currPosition = null;
        for (LPPlayerViewUpdateModel.PlayerPosition position : model.all) {
            if (!position.id.equals(model.id)) continue;
            currPosition = position;
        }
        return currPosition;
    }

    private boolean repositionVideoWindow(@NonNull LPPlayerViewUpdateModel model) {
        LPPlayerViewUpdateModel.PlayerPosition currPosition = this.getCurrentUpdatedPosition(model);
        if (currPosition == null) {
            return false;
        }
        for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
            String mediaId = FECompatUtil.getMediaIdFromFEUserId(model.id);
            VideoWindow videoWindow = videoContainerWindow.getVideoWindow();
            if (!FECompatUtil.checkVideoWindowMediaId(videoWindow, mediaId)) continue;
            if (videoContainerWindow.isMaxInFull() && currPosition.full == 0) {
                videoContainerWindow.resetInFull();
            } else if (!videoContainerWindow.isMaxInFull() && currPosition.full == 1) {
                videoContainerWindow.maxInFull();
            }
            if (videoContainerWindow.isMaxInSync() && currPosition.max == 0) {
                videoContainerWindow.resetInSync();
            } else if (!videoContainerWindow.isMaxInSync() && currPosition.max == 1 && currPosition.full != 1) {
                videoContainerWindow.maxInSync();
            }
            videoContainerWindow.moveTo(Math.round((float)this.getWidth() * Float.parseFloat(currPosition.x)), Math.round((float)this.getHeight() * Float.parseFloat(currPosition.y)));
            videoContainerWindow.scaleTo(Math.round((float)this.getWidth() * Float.parseFloat(currPosition.width)), Math.round((float)this.getHeight() * Float.parseFloat(currPosition.height)));
            this.bringVideoToFront(model.id);
            return true;
        }
        return false;
    }

    private boolean normalVideoWindow(LPPlayerViewUpdateModel model) {
        LPPlayerViewUpdateModel.PlayerPosition currPosition = this.getCurrentUpdatedPosition(model);
        if (currPosition == null) {
            return false;
        }
        for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
            String mediaId = FECompatUtil.getMediaIdFromFEUserId(model.id);
            VideoWindow videoWindow = videoContainerWindow.getVideoWindow();
            if (!FECompatUtil.checkVideoWindowMediaId(videoWindow, mediaId)) continue;
            if (videoContainerWindow.isMaxInFull()) {
                videoContainerWindow.resetInFull();
            }
            if (videoContainerWindow.isMaxInSync()) {
                videoContainerWindow.resetInSync();
            }
            if (videoContainerWindow.isMinInSync()) {
                videoContainerWindow.resetMinInSync();
            }
            videoContainerWindow.moveTo(Math.round((float)this.getWidth() * Float.parseFloat(currPosition.x)), Math.round((float)this.getHeight() * Float.parseFloat(currPosition.y)));
            videoContainerWindow.scaleTo(Math.round((float)this.getWidth() * Float.parseFloat(currPosition.width)), Math.round((float)this.getHeight() * Float.parseFloat(currPosition.height)));
            if (currPosition.max == 1) {
                this.maximumVideoWindow(model);
            } else {
                this.bringVideoToFront(model.id);
            }
            return true;
        }
        return false;
    }

    private boolean fulledVideoWindow(LPPlayerViewUpdateModel model) {
        LPPlayerViewUpdateModel.PlayerPosition currPosition = this.getCurrentUpdatedPosition(model);
        if (currPosition == null) {
            return false;
        }
        for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
            String mediaId = FECompatUtil.getMediaIdFromFEUserId(model.id);
            VideoWindow videoWindow = videoContainerWindow.getVideoWindow();
            if (!FECompatUtil.checkVideoWindowMediaId(videoWindow, mediaId)) continue;
            if (videoContainerWindow.isMaxInSync()) {
                videoContainerWindow.resetInSync();
            }
            this.bringVideoToFront(model.id);
            videoContainerWindow.maxInFull();
            return true;
        }
        return false;
    }

    private boolean maximumVideoWindow(LPPlayerViewUpdateModel model) {
        LPPlayerViewUpdateModel.PlayerPosition currPosition = this.getCurrentUpdatedPosition(model);
        if (currPosition == null) {
            return false;
        }
        for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
            String mediaId = FECompatUtil.getMediaIdFromFEUserId(model.id);
            VideoWindow videoWindow = videoContainerWindow.getVideoWindow();
            if (!FECompatUtil.checkVideoWindowMediaId(videoWindow, mediaId)) continue;
            if (videoContainerWindow.isMaxInFull()) {
                videoContainerWindow.resetInFull();
            }
            this.bringVideoToFront(model.id);
            videoContainerWindow.maxInSync();
            return true;
        }
        return false;
    }

    private void showBlackboardPage(float y) {
        this.router.getSubjectByKey(EventKey.ReminderBlackboardPage).onNext((Object)Float.valueOf(y));
    }

    public ConcurrentLinkedQueue<PPTWindow> getPPTWindows() {
        return this.pptWindows;
    }

    public BlackboardListener getBlackboardLayer() {
        return (BlackboardListener)((Object)this.blackboardLayer);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RxUtils.dispose((Disposable)this.subscriptionOfDocDel);
        RxUtils.dispose((Disposable)this.subscriptionOfSelectMode);
        RxUtils.dispose((Disposable)this.subscriptionOfDrawLineMode);
        if (this.laserShapeLayer != null) {
            this.laserShapeLayer.onDestroy();
        }
        this.laserShapeLayer = null;
        this.clearPPTWindows();
        if (this.shapePaint != null) {
            this.shapePaint.removeAllListener();
        }
        this.clearVideoWindows();
        this.router = null;
        this.videoLayer = null;
        if (this.smallBlackboardWindows != null) {
            for (SmallBlackboardWindow window : this.smallBlackboardWindows) {
                window.onDestroy();
            }
            this.smallBlackboardWindows.clear();
        }
        if (this.sbbAllUserSet != null) {
            this.sbbAllUserSet.clear();
        }
        this.removeCallbacks(this.webpageRunnable);
        this.destroyToolBox();
        this.isFirstCalledHandleVideoWindowPosition = false;
        if (this.mediaPlayerWindow != null) {
            this.mediaPlayerWindow.onDestroy();
            this.mediaPlayerWindow = null;
        }
    }

    private void clearVideoWindows() {
        if (this.videoWindows != null) {
            for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
                videoContainerWindow.onDestroy();
            }
            this.videoWindows.clear();
        }
    }

    private void clearPPTWindows() {
        if (this.pptWindows != null) {
            for (PPTWindow pptWindow : this.pptWindows) {
                pptWindow.onDestroy();
            }
            this.pptWindows.clear();
        }
        this.refreshPPTWindowCache();
    }

    private void showResponderWindow(boolean show) {
        if (show) {
            if (this.responderWindow == null) {
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(UtilsKt.getDp((int)400), UtilsKt.getDp((int)220));
                layoutParams.gravity = 17;
                this.responderWindow = new ResponderWindow(this.getContext());
                this.toolBoxLayer.addWindow((IWindow)this.responderWindow, layoutParams);
            }
        } else if (this.responderWindow != null) {
            this.toolBoxLayer.removeWindow((IWindow)this.responderWindow);
            this.responderWindow.onDestroy();
            this.responderWindow = null;
        }
    }

    private void showResponderPrepare(int prepareTime) {
        if (this.responderPrepareView == null) {
            this.responderPrepareView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.uibase_layout_responder_student_prepare_tip, null);
        }
        if (this.responderPrepareView.getParent() != null) {
            this.toolBoxLayer.removeView(this.responderPrepareView);
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 17;
        this.toolBoxLayer.addView(this.responderPrepareView, (ViewGroup.LayoutParams)layoutParams);
        this.responderIntervalDisposable = Observable.interval((long)0L, (long)1L, (TimeUnit)TimeUnit.SECONDS).take((long)(prepareTime + 1)).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            if (aLong == (long)prepareTime) {
                this.toolBoxLayer.removeView(this.responderPrepareView);
                this.showResponderButton();
            }
            QueryPlus.with((View)this.responderPrepareView).id(R.id.responder_student_counting_down).text((CharSequence)String.valueOf((long)prepareTime - aLong));
        });
        this.compositeDisposable.add(this.responderIntervalDisposable);
    }

    private void showResponderButton() {
        if (this.responderRobButton == null) {
            this.responderRobButton = new ResponderRobButton(this.getContext());
            this.responderRobButton.setDefaultSize(80);
        }
        if (this.responderRobButton.getParent() == null) {
            int _80dp = UtilsKt.getDp((int)80);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
            Random random = new Random();
            BaseLayerOfProfessionalClass robButtonParent = this.toolBoxLayer;
            int leftBound = robButtonParent.getWidth() - _80dp;
            int topBound = robButtonParent.getWidth() - _80dp;
            if (robButtonParent.getWidth() == 0) {
                this.post(() -> {
                    layoutParams.leftMargin = leftBound <= 0 ? 0 : random.nextInt(leftBound);
                    layoutParams.topMargin = topBound <= 0 ? 0 : random.nextInt(topBound);
                    this.toolBoxLayer.addView((View)this.responderRobButton, (ViewGroup.LayoutParams)layoutParams);
                });
            } else {
                layoutParams.leftMargin = leftBound <= 0 ? 0 : random.nextInt(leftBound);
                layoutParams.topMargin = topBound <= 0 ? 0 : random.nextInt(topBound);
                this.toolBoxLayer.addView((View)this.responderRobButton, (ViewGroup.LayoutParams)layoutParams);
            }
        }
        this.responderRobButton.changeRobButtonStatus(ResponderRobButton.RobButtonState.NORMAL);
        if (this.router.getLiveRoom().isAudition()) {
            this.responderRobButton.setEnabled(false);
        }
        this.compositeDisposable.add(RxUtils.clicks((View)this.responderRobButton).throttleFirst(1L, TimeUnit.SECONDS).subscribe(o -> {
            this.responderRobButton.changeRobButtonStatus(ResponderRobButton.RobButtonState.READY_TO_SUBMIT);
            this.responderRobButton.setClickable(false);
            this.router.getLiveRoom().getToolBoxVM().requestAnswerRacerParticipate(this.router.getLiveRoom().getCurrentUser());
            RxUtils.dispose((Disposable)this.responderButtonDisposable);
        }));
        this.responderButtonDisposable = Observable.interval((long)2L, (long)2L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            if (this.responderRobButton == null) {
                RxUtils.dispose((Disposable)this.responderButtonDisposable);
            } else {
                this.responderRobButton.changePositionRandom((View)this.toolBoxLayer);
            }
        });
        this.compositeDisposable.add(this.responderButtonDisposable);
    }

    private void cancelResponder() {
        if (this.responderPrepareView != null && this.responderPrepareView.getParent() != null) {
            this.toolBoxLayer.removeView(this.responderPrepareView);
        }
        RxUtils.dispose((Disposable)this.responderIntervalDisposable);
        RxUtils.dispose((Disposable)this.responderButtonDisposable);
    }

    private void updateToolbarWindow() {
        if (!BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
            return;
        }
        if (this.pptWindows == null || this.pptWindows.size() == 0) {
            return;
        }
        for (PPTWindow pptWindow : this.pptWindows) {
            if (!pptWindow.isMaxInFull() && !pptWindow.isMaxInSync()) continue;
            this.router.getSubjectByKey(EventKey.LaserShowState).onNext((Object)false);
            return;
        }
        this.router.getSubjectByKey(EventKey.LaserShowState).onNext((Object)true);
    }

    public void invalidateTextBoundary() {
        for (PPTWindow pptWindow : this.getPPTWindows()) {
            pptWindow.getPPTView().invalidateCurrentPage();
        }
        this.getBlackboardLayer().getBlackImageWindow().getWhiteboardView().invalidateTextBoundary();
        for (SmallBlackboardWindow smallBlackboardWindow : this.smallBlackboardWindows) {
            smallBlackboardWindow.invalidateTextBoundary();
        }
    }

    public void updatePPTView(boolean isUpdate) {
        if (!this.pptWindows.isEmpty()) {
            for (PPTWindow pptWindow : this.pptWindows) {
                PPTView pptView = pptWindow.getPPTView();
                if (!isUpdate || pptView.getTargetPPTViewType() != LPConstants.PPTViewType.STATIC) continue;
                pptView.updateStaticPPT();
            }
        }
    }

    private void startMediaCoursewareObservable() {
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.openMediaPlayerWindow).ofType(LPMediaCoursewareModel.class).observeOn(AndroidSchedulers.mainThread()).subscribe(mediaCoursewareModel -> {
            boolean isMediaPlaying = false;
            for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
                if (LPMediaIdUtils.getMediaSourceType((String)videoContainerWindow.getVideoWindow().getMediaId()) != LPConstants.MediaSourceType.Media) continue;
                this.videoLayer.removeWindow((IWindow)videoContainerWindow);
                this.videoWindows.remove(videoContainerWindow);
                videoContainerWindow.onDestroy();
                isMediaPlaying = true;
                break;
            }
            if (isMediaPlaying) {
                new CommonDialog(this.getContext(), CommonDialog.ChoiceMode.Double_Blue).setMainDisplayText(this.getContext().getString(R.string.bjy_group_play_media_conflict_tips)).setSubtitleDisplayText(this.getContext().getString(R.string.bjy_group_play_media_conflict_detail)).setPositive(this.getContext().getString(R.string.bjysc_confirm), (dialog, which) -> {
                    dialog.dismiss();
                    this.router.getLiveRoom().getMediaVM().sendBroadcastOfTerminateExtraStream(LPConstants.MediaSourceType.Media);
                    this.startPlayMediaCourseware((LPMediaCoursewareModel)mediaCoursewareModel);
                }).setNegative(this.getContext().getString(R.string.bjysc_cancel), (dialog, which) -> dialog.dismiss()).show();
            } else {
                this.startPlayMediaCourseware((LPMediaCoursewareModel)mediaCoursewareModel);
            }
        }));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.closeMediaPlayerWindow).ofType(Boolean.class).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
            if (this.mediaPlayerWindow != null) {
                this.videoLayer.removeWindow((IWindow)this.mediaPlayerWindow);
                this.mediaPlayerWindow.onDestroy();
                this.mediaPlayerWindow = null;
                String mediaId = FECompatUtil.getIOSMediaIdFromMediaId(FECompatUtil.getMediaId(this.router.getLiveRoom().getCurrentUser().getUserId(), LPConstants.MediaSourceType.Media.getValue()));
                this.requestVideoWindowRemove(mediaId);
            }
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getMediaVM().getObservableOfTerminateExtraStream().observeOn(AndroidSchedulers.mainThread()).subscribe(s -> {
            if ("2".equals(s) && this.mediaPlayerWindow != null) {
                this.videoLayer.removeWindow((IWindow)this.mediaPlayerWindow);
                this.mediaPlayerWindow.onDestroy();
                this.mediaPlayerWindow = null;
            }
            for (VideoContainerWindow videoContainerWindow : this.videoWindows) {
                int mediaType = LPMediaIdUtils.getMediaSourceType((String)videoContainerWindow.getVideoWindow().getMediaId()).getValue();
                if (!s.equals(LPMediaIdUtils.transferBackMediaId((String)String.valueOf(mediaType)))) continue;
                this.videoLayer.removeWindow((IWindow)videoContainerWindow);
                this.videoWindows.remove(videoContainerWindow);
                videoContainerWindow.onDestroy();
            }
        }));
    }

    private void showAdminRollCallWindow(int duration, LPRoomRollCallResultModel lpRoomRollCallResultModel) {
        if (this.adminRollCallWindow == null) {
            this.adminRollCallWindow = new AdminRollCallWindow(this.getContext());
            ((AdminRollCallWindow)this.adminRollCallWindow).setRouterListener((RouterListener)this.getContext());
            ((AdminRollCallWindow)this.adminRollCallWindow).setDuration(duration);
            ((AdminRollCallWindow)this.adminRollCallWindow).setRollCallResultModel(lpRoomRollCallResultModel);
            ((AdminRollCallWindow)this.adminRollCallWindow).init();
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.getContext().getResources().getDimensionPixelSize(R.dimen.bjy_base_live_roll_call_width), -2);
            layoutParams.gravity = 17;
            this.toolBoxLayer.addWindow((IWindow)this.adminRollCallWindow, layoutParams);
        } else {
            ((AdminRollCallWindow)this.adminRollCallWindow).setRollCallResultModel(lpRoomRollCallResultModel);
            ((AdminRollCallWindow)this.adminRollCallWindow).setDuration(duration);
            ((AdminRollCallWindow)this.adminRollCallWindow).showRollCallState(BaseUtilsKt.getRollCallStatus(), duration);
        }
    }

    private void dismissAdminRollCallWindow() {
        if (this.adminRollCallWindow != null) {
            this.toolBoxLayer.removeWindow((IWindow)this.adminRollCallWindow);
            this.adminRollCallWindow = null;
        }
    }

    private void showRollCallWindow(int time, OnPhoneRollCallListener.RollCall rollCallListener) {
        if (this.rollCallWindow == null) {
            this.rollCallWindow = new RollCallWindow(this.getContext());
            this.rollCallDialogPresenter = new RollCallDialogPresenter((RollCallDialogContract.View)this.rollCallWindow);
            this.rollCallDialogPresenter.setRollCallInfo(time, rollCallListener);
            ((RollCallDialogContract.View)this.rollCallWindow).setPresenter((BasePresenter)this.rollCallDialogPresenter);
            int screenWidth = DisplayUtils.getScreenWidthPixels((Context)this.getContext());
            int screenHeight = DisplayUtils.getScreenHeightPixels((Context)this.getContext());
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(Math.min(screenHeight, screenWidth), -2);
            layoutParams.gravity = 17;
            this.toolBoxLayer.addWindow((IWindow)this.rollCallWindow, layoutParams);
        }
    }

    private void dismissRollCallWindow() {
        if (this.rollCallWindow != null) {
            this.toolBoxLayer.removeWindow((IWindow)this.rollCallWindow);
            this.rollCallWindow = null;
        }
    }

    private void showTurntableWindow(boolean isTeacherOrAssistant) {
        if (this.turntableWindow == null) {
            if (isTeacherOrAssistant) {
                LPTurntableModel model = new LPTurntableModel();
                model.action = "open";
                this.router.getLiveRoom().requestTurntable(model);
            }
            this.turntableWindow = new TurntableWindow(this.getContext());
            ((TurntableWindow)this.turntableWindow).setCloseEnable(isTeacherOrAssistant);
            ((TurntableWindow)this.turntableWindow).setCloseListener((Function0<Unit>)((Function0)() -> {
                LPTurntableModel model = new LPTurntableModel();
                model.action = "close";
                this.router.getLiveRoom().requestTurntable(model);
                this.removeTurntableWindow();
                return null;
            }));
            ((TurntableWindow)this.turntableWindow).setOnClickListener(view -> {
                LPTurntableModel model = new LPTurntableModel();
                model.action = "start";
                model.value = ((TurntableWindow)this.turntableWindow).teacherTurn();
                this.router.getLiveRoom().requestTurntable(model);
            });
            ((TurntableWindow)this.turntableWindow).setClickable(isTeacherOrAssistant);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(UtilsKt.getDp((int)280), UtilsKt.getDp((int)280));
            layoutParams.gravity = 17;
            this.toolBoxLayer.addWindow((IWindow)this.turntableWindow, layoutParams);
        }
    }

    private void removeTurntableWindow() {
        if (this.turntableWindow != null) {
            this.turntableWindow.onDestroy();
            this.toolBoxLayer.removeWindow((IWindow)this.turntableWindow);
            this.turntableWindow = null;
        }
    }

    private void startOtherObservable() {
        Disposable rollCallCountDownDisposable = this.router.getSubjectByKey(EventKey.RollCallCountDown).ofType(Pair.class).subscribe(pair -> {
            if (this.adminRollCallWindow != null) {
                ((AdminRollCallWindow)this.adminRollCallWindow).setRollCallCountDown(((Integer)pair.first).intValue(), ((Boolean)pair.second).booleanValue());
            }
        });
        Disposable adminRollCallWindowDisposable = this.router.getSubjectByKey(EventKey.OpenAdminRollCallWindow).ofType(Pair.class).subscribe(pair -> this.showAdminRollCallWindow((Integer)pair.first, (LPRoomRollCallResultModel)pair.second));
        Disposable studentRollCallWindowDisposable = this.router.getSubjectByKey(EventKey.OpenStudentRollCallWindow).ofType(Pair.class).subscribe(pair -> this.showRollCallWindow((Integer)pair.first, (OnPhoneRollCallListener.RollCall)pair.second));
        Disposable closeRollCallWindowDisposable = this.router.getSubjectByKey(EventKey.CloseRollCallWindow).subscribe(a -> {
            this.dismissAdminRollCallWindow();
            this.dismissRollCallWindow();
        });
        Disposable openTurntableWindowDisposable = this.router.getSubjectByKey(EventKey.Turntable).subscribe(show -> this.showTurntableWindow(BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())));
        Disposable turntableDisposable = this.router.getLiveRoom().getObservableOfTurntable().observeOn(AndroidSchedulers.mainThread()).subscribe(lpTurntableModel -> {
            if ("open".equals(lpTurntableModel.action)) {
                this.showTurntableWindow(BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom()));
            } else if ("close".equals(lpTurntableModel.action)) {
                this.removeTurntableWindow();
            } else {
                this.showTurntableWindow(BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom()));
                if (this.turntableWindow != null) {
                    ((TurntableWindow)this.turntableWindow).studentTurn(String.valueOf(lpTurntableModel.value));
                }
            }
        });
        this.compositeDisposable.add(rollCallCountDownDisposable);
        this.compositeDisposable.add(adminRollCallWindowDisposable);
        this.compositeDisposable.add(studentRollCallWindowDisposable);
        this.compositeDisposable.add(closeRollCallWindowDisposable);
        this.compositeDisposable.add(turntableDisposable);
        this.compositeDisposable.add(openTurntableWindowDisposable);
    }

    private void startPlayMediaCourseware(LPMediaCoursewareModel mediaCoursewareModel) {
        float ration = 1.6666666f;
        int windowWidth = (int)((float)this.getMeasuredWidth() * 0.45413f);
        if (this.mediaPlayerWindow == null) {
            this.mediaPlayerWindow = new MediaCoursewarePlayerWindow(this.getContext(), mediaCoursewareModel);
            this.videoLayer.addWindow((IWindow)this.mediaPlayerWindow, new FrameLayout.LayoutParams(windowWidth, (int)((float)windowWidth / ration)));
        } else {
            this.mediaPlayerWindow.bringToForeground();
            this.mediaPlayerWindow.startPlay(mediaCoursewareModel);
        }
        Runnable runnable = () -> {
            Set<LPPlayerViewUpdateModel.PlayerPosition> allSet = this.router.getSetByKey(EventKey.AllPlayerViewList, LPPlayerViewUpdateModel.PlayerPosition.class);
            LPPlayerViewUpdateModel model = new LPPlayerViewUpdateModel();
            model.action = LPConstants.LPPlayerAction.ADD;
            LPPlayerViewUpdateModel.PlayerPosition playerPosition = this.mediaPlayerWindow.getPlayerPosition();
            model.id = model.mediaId = playerPosition.id;
            if (null == allSet) {
                allSet = new HashSet<LPPlayerViewUpdateModel.PlayerPosition>();
            }
            allSet.add(playerPosition);
            this.router.setObjectByKey(EventKey.AllPlayerViewList, allSet);
            model.all = allSet;
            this.router.getLiveRoom().getMediaVM().requestPlayerViewUpdate(model);
        };
        if (this.mediaPlayerWindow.getView() != null) {
            this.mediaPlayerWindow.getView().post(runnable);
        } else {
            this.getRootView().postDelayed(runnable, 1000L);
        }
    }
}

