/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.video;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventCode;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.model.VideoMenuControlModel;
import com.baijiayun.groupclassui.util.FECompatUtil;
import com.baijiayun.groupclassui.window.InteractiveBaseWindow;
import com.baijiayun.groupclassui.window.video.VideoWindow;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.context.LPError;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class VideoMenuMoreWindow
extends InteractiveBaseWindow {
    private final String TAG = VideoMenuMoreWindow.class.getCanonicalName();
    private WeakReference<VideoMenuControlModel> weakReference;
    int menuWidthDp = 80;
    int rightMarginDp = 0;
    private final Random random = new Random();

    public VideoMenuMoreWindow(Context context, int menuWidthDp, VideoMenuControlModel videoMenuControlModel) {
        super(context);
        String tutorId;
        this.menuWidthDp = menuWidthDp;
        this.weakReference = new WeakReference<VideoMenuControlModel>(videoMenuControlModel);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(UtilsKt.getDp((int)menuWidthDp), -2);
        params.leftMargin = videoMenuControlModel.getCurrX() - UtilsKt.getDp((int)menuWidthDp) - UtilsKt.getDp((int)this.rightMarginDp);
        params.topMargin = videoMenuControlModel.getCurrY();
        this.view.setLayoutParams((ViewGroup.LayoutParams)params);
        VideoWindow videoWindow = videoMenuControlModel.getVideoWindow();
        String uid = videoWindow.getUserId();
        this.$.id(R.id.window_video_menu_more_bg_container).view().setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context, (int)R.attr.base_theme_brand_container_color)).cornerRadius(context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
        if (uid.equals(this.iRouter.getLiveRoom().getCurrentUser().getUserId())) {
            if (this.iRouter.getLiveRoom().getSpeakQueueVM().enableAttachPhoneCamera()) {
                this.$.id(R.id.window_video_menu_more_scanner_camera).visible();
            }
            if (this.iRouter.getLiveRoom().isClassStarted() && !this.iRouter.getLiveRoom().getSpeakQueueVM().isReplacedUser()) {
                this.$.id(R.id.window_video_menu_more_switch_camera).visible();
                this.$.id(R.id.window_video_menu_more_close_camera).visible();
                if (this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode().isGalleryLayout()) {
                    this.$.id(R.id.window_video_menu_more_seat_down).visible();
                } else {
                    this.$.id(R.id.window_video_menu_more_seat_down).gone();
                }
                if (this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode() == LPConstants.StudyRoomMode.Discuss) {
                    this.$.id(R.id.window_video_menu_more_close_mic).visible();
                } else {
                    this.$.id(R.id.window_video_menu_more_close_mic).gone();
                }
                this.$.id(R.id.window_video_menu_more).visible();
            }
            this.$.id(R.id.window_video_menu_more_toggle_horizontal_mirror_mode).gone();
            this.$.id(R.id.window_video_menu_more_toggle_vertical_mirror_mode).gone();
        } else {
            boolean hideOnlyAudio = this.iRouter.getLiveRoom().getCurrentRoomLayout() == LPConstants.RoomLayoutMode.BOARD && this.iRouter.getLiveRoom().getDisableOtherStudentVideoData().isDisable() || this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode() == LPConstants.StudyRoomMode.SelfStudy;
            boolean isMainVideo = videoWindow.getMediaSourceType() == LPConstants.MediaSourceType.MainCamera;
            this.$.id(R.id.window_video_menu_more_only_audio).visibility(hideOnlyAudio || !isMainVideo || videoWindow.disablePullStream() ? 8 : 0);
            if (videoWindow.getUserModel().getType() == LPConstants.LPUserType.Student && this.iRouter.getLiveRoom().getCurrentUser().getType() != LPConstants.LPUserType.Student) {
                if (this.iRouter.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE && videoWindow.getUserModel().getEndType() != LPConstants.LPEndType.Android && videoWindow.getUserModel().getEndType() != LPConstants.LPEndType.iOS) {
                    this.$.id(R.id.window_video_menu_more_assist_camera).visible();
                }
                this.$.id(R.id.window_video_menu_more_screen_share).visible();
            }
            switch (this.iRouter.getLiveRoom().getCurrentUser().getType()) {
                case Assistant: {
                    if (videoWindow.getUserModel().getType() == LPConstants.LPUserType.Student) {
                        if (!this.iRouter.getLiveRoom().isClassStarted()) break;
                        if (!this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode().isGalleryLayout()) {
                            this.$.id(R.id.window_video_menu_more_draw_auth).visible();
                            this.$.id(R.id.window_video_menu_more_ppt_auth).visible();
                            this.$.id(R.id.window_video_menu_more_close_camera).visible();
                            this.$.id(R.id.window_video_menu_more_close_mic).visible();
                            this.$.id(R.id.window_video_menu_more_seat_down).visible();
                            this.$.id(R.id.window_video_menu_more_kickout).visible();
                            break;
                        }
                        this.$.id(R.id.window_video_menu_more_draw_auth).gone();
                        this.$.id(R.id.window_video_menu_more_ppt_auth).gone();
                        if (this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode() == LPConstants.StudyRoomMode.SelfStudy) {
                            this.$.id(R.id.window_video_menu_more_close_mic).gone();
                        } else {
                            this.$.id(R.id.window_video_menu_more_close_mic).visible();
                        }
                        this.$.id(R.id.window_video_menu_more_close_camera).visible();
                        this.$.id(R.id.window_video_menu_more_seat_down).visible();
                        this.$.id(R.id.window_video_menu_more_kickout).visible();
                        break;
                    }
                    if (videoWindow.getUserModel().getType() == LPConstants.LPUserType.Assistant) {
                        this.$.id(R.id.window_video_menu_more_close_camera).visible();
                        this.$.id(R.id.window_video_menu_more_seat_down).visible();
                        break;
                    }
                    if (videoWindow.getUserModel().getType() != LPConstants.LPUserType.Teacher) break;
                    this.$.id(R.id.window_video_menu_more_toggle_horizontal_mirror_mode).gone();
                    this.$.id(R.id.window_video_menu_more_toggle_vertical_mirror_mode).gone();
                    break;
                }
                case Teacher: {
                    if (videoWindow.getUserModel().getType() != LPConstants.LPUserType.Assistant && this.iRouter.getLiveRoom().isClassStarted()) {
                        this.$.id(R.id.window_video_menu_more_draw_auth).visible();
                        this.$.id(R.id.window_video_menu_more_ppt_auth).visible();
                        this.$.id(R.id.window_video_menu_more_seat_down).visible();
                        this.$.id(R.id.window_video_menu_more_kickout).visible();
                    }
                    if (this.iRouter.getLiveRoom().getCurrentRoomLayout() == LPConstants.RoomLayoutMode.BOARD || !this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode().isGalleryLayout()) {
                        this.$.id(R.id.window_video_menu_more_move).visible();
                    }
                    if (!this.iRouter.getLiveRoom().isClassStarted()) break;
                    this.$.id(R.id.window_video_menu_more_close_camera).visible().id(R.id.window_video_menu_more_close_mic).visible();
                    break;
                }
                default: {
                    this.$.id(R.id.window_video_menu_more_toggle_horizontal_mirror_mode).gone();
                    this.$.id(R.id.window_video_menu_more_toggle_vertical_mirror_mode).gone();
                }
            }
        }
        if (!this.iRouter.getLiveRoom().getPartnerConfig().enableSwitchMirrorMode) {
            this.$.id(R.id.window_video_menu_more_toggle_horizontal_mirror_mode).gone();
            this.$.id(R.id.window_video_menu_more_toggle_vertical_mirror_mode).gone();
        }
        if (!TextUtils.isEmpty((CharSequence)(tutorId = this.iRouter.getSubjectValueByKey(EventKey.StudyStatusTutor, String.class, "")))) {
            this.$.id(R.id.window_video_menu_more_seat_down).gone();
        }
        this.$.id(R.id.window_video_menu_more_scanner_camera).text((CharSequence)(this.iRouter.getLiveRoom().getSpeakQueueVM().isReplacedUser() ? this.getString(R.string.base_live_scanner_camera_end) : this.getString(R.string.base_live_scanner_camera_start))).clicked(v -> {
            this.iRouter.getSubjectByKey(EventKey.ShowQrCode).onNext((Object)(!this.iRouter.getLiveRoom().getSpeakQueueVM().hasAsCameraUser() ? 1 : 0));
            this.hideMenu(videoMenuControlModel);
        }).id(R.id.window_video_menu_more_switch_camera).clicked(v -> {
            this.iRouter.getLiveRoom().getRecorder().switchCamera();
            this.hideMenu(videoMenuControlModel);
        }).id(R.id.window_video_menu_more_close_camera).text(videoWindow.isVideoOn() ? R.string.bjysc_video_menu_more_close_camera : R.string.bjysc_video_menu_more_open_camera).clicked(v -> {
            if (uid.equals(this.iRouter.getLiveRoom().getCurrentUser().getUserId())) {
                this.iRouter.getPublishSubjectByKey(EventCode.AttachVideo).onNext((Object)(!videoWindow.isVideoOn() ? 1 : 0));
            } else {
                this.iRouter.getLiveRoom().getSpeakQueueVM().controlRemoteUser(uid, !videoWindow.isVideoOn(), videoWindow.isAudioOn());
            }
            this.hideMenu(videoMenuControlModel);
        }).id(R.id.window_video_menu_more_close_mic).text(videoWindow.isAudioOn() ? R.string.bjysc_video_menu_more_close_mic : R.string.bjysc_video_menu_more_open_mic).clicked(v -> {
            if (uid.equals(this.iRouter.getLiveRoom().getCurrentUser().getUserId())) {
                this.iRouter.getPublishSubjectByKey(EventCode.AttachAudio).onNext((Object)(!videoWindow.isAudioOn() ? 1 : 0));
            } else {
                this.iRouter.getLiveRoom().getSpeakQueueVM().controlRemoteUser(uid, videoWindow.isVideoOn(), !videoWindow.isAudioOn());
            }
            this.hideMenu(videoMenuControlModel);
        }).id(R.id.window_video_menu_more_ppt_auth).text(videoWindow.isPPTAuthOn() ? R.string.bjysc_video_menu_more_ppt_auth_back : R.string.bjysc_video_menu_more_ppt_auth).clicked(v -> {
            LPError lpError = this.iRouter.getLiveRoom().getDocListVM().requestStudentPPTAuthChange(!videoWindow.isPPTAuthOn(), videoWindow.getUserModel().getNumber());
            if (null == lpError) {
                videoWindow.setPPTAuthOn(!videoWindow.isPPTAuthOn());
            }
            this.hideMenu(videoMenuControlModel);
        }).id(R.id.window_video_menu_more_screen_share).text(videoWindow.isScreenShareOn() ? R.string.bjysc_video_menu_more_srceen_share_back : R.string.bjysc_video_menu_more_srceen_share).clicked(v -> {
            this.iRouter.getLiveRoom().getMediaVM().requestStudentScreenShareChange(!videoWindow.isScreenShareOn(), videoWindow.getUserModel());
            this.hideMenu(videoMenuControlModel);
        }).id(R.id.window_video_menu_more_assist_camera).text(videoWindow.isAssistCameraOn() ? R.string.bjysc_video_menu_more_assist_camera_back : R.string.bjysc_video_menu_more_assist_camera).clicked(v -> {
            this.iRouter.getLiveRoom().getMediaVM().requestStudentExtCameraChange(!videoWindow.isAssistCameraOn(), videoWindow.getUserModel());
            this.hideMenu(videoMenuControlModel);
            if (videoWindow.isAssistCameraOn()) {
                this.iRouter.getSubjectByKey(EventKey.CloseVideoWindow).onNext((Object)FECompatUtil.getIOSMediaIdFromMediaId(FECompatUtil.getMediaId(videoWindow.getUserId(), LPConstants.MediaSourceType.ExtCamera.getValue())));
            }
        }).id(R.id.window_video_menu_more_only_audio).text(videoWindow.isRemoteVideoClose() ? R.string.bjysc_video_menu_more_open_video : R.string.bjysc_video_menu_more_only_audio).clicked(v -> {
            if (videoWindow.isDestroyed()) {
                return;
            }
            if (videoWindow.isRemoteVideoClose()) {
                LPLogger.d((String)"\u6253\u5f00\u753b\u9762");
            } else {
                LPLogger.d((String)"\u53ea\u542c\u58f0\u97f3");
            }
            videoWindow.setRemoteVideoStatus(videoWindow.isRemoteVideoClose() ? 2 : 3);
            videoWindow.muteRemoteVideo(videoWindow.isRemoteVideoClose());
            this.hideMenu(videoMenuControlModel);
        }).id(R.id.window_video_menu_more_draw_auth).text(videoWindow.isDrawAuthOn() ? R.string.bjysc_video_menu_more_auth_draw_back : R.string.bjysc_video_menu_more_draw_auth).clicked(v -> {
            this.hideMenu(videoMenuControlModel);
            LPError lpError = this.iRouter.getLiveRoom().getSpeakQueueVM().requestStudentDrawingAuthChange(!videoWindow.isDrawAuthOn(), videoWindow.getUserModel().getNumber());
            if (lpError != null) {
                return;
            }
            HashMap<String, String> authPaintColors = this.iRouter.getLiveRoom().getAuthPaintColor();
            Map<String, String> cachePaintColors = this.iRouter.getMapValueByKey(EventKey.CachePaintColorMap, String.class, String.class);
            if (authPaintColors == null) {
                authPaintColors = new HashMap<String, String>();
            }
            if (cachePaintColors == null) {
                cachePaintColors = new HashMap<String, String>();
            }
            if (videoWindow.isDrawAuthOn()) {
                for (String color2 : authPaintColors.keySet()) {
                    if (!((String)authPaintColors.get(color2)).equals(videoWindow.getUserModel().getNumber())) continue;
                    cachePaintColors.put(color2, videoWindow.getUserModel().getNumber());
                    this.iRouter.setObjectByKey(EventKey.CachePaintColorMap, cachePaintColors);
                }
            } else {
                String[] colors = context.getResources().getStringArray(R.array.toolbar_paint_color);
                if (!authPaintColors.containsValue(videoWindow.getUserModel().getNumber())) {
                    String allocateColor = this.allocateColor(new ArrayList<String>(Arrays.asList(colors)), cachePaintColors);
                    authPaintColors.put(allocateColor, videoWindow.getUserModel().getNumber());
                }
                this.iRouter.getLiveRoom().requestAuthPaintColor(authPaintColors);
            }
            videoWindow.setDrawAuthOn(!videoWindow.isDrawAuthOn());
        }).id(R.id.window_video_menu_more_move).text(videoWindow.isJoinBlackboard() ? R.string.bjysc_video_menu_more_move_to_seat : R.string.bjysc_video_menu_more_move_to_blackboard).clicked(v -> {
            if (!this.isAdmin()) {
                return;
            }
            if (videoWindow.isJoinBlackboard()) {
                this.iRouter.getSubjectByKey(EventKey.CloseVideoWindow).onNext((Object)videoWindow.getMediaId());
            } else {
                this.iRouter.getSubjectByKey(EventKey.VideoWindowToBlackboard).onNext((Object)videoWindow);
            }
            this.hideMenu(videoMenuControlModel);
        }).id(R.id.window_video_menu_more_seat_down).clicked(v -> {
            this.iRouter.getLiveRoom().getOnlineUserVM().requestRemoveActiveUser(videoWindow.getUserModel());
            this.hideMenu(videoMenuControlModel);
        }).id(R.id.window_video_menu_more_kickout).clicked(v -> this.iRouter.getSubjectByKey(EventKey.KickOutConfirm).onNext((Object)videoWindow.getUserModel())).id(R.id.window_video_menu_more).clicked(v -> {
            this.iRouter.getSubjectByKey(EventKey.SettingWindow).onNext((Object)true);
            this.hideMenu(videoMenuControlModel);
        }).id(R.id.window_video_menu_more_toggle_horizontal_mirror_mode).clicked(v -> {
            boolean isHorizontalMirror = this.iRouter.getLiveRoom().getSpeakQueueVM().getHorizontalMirrorModeSet().contains(videoWindow.getUserModel().getNumber());
            boolean isVerticalMirror = this.iRouter.getLiveRoom().getSpeakQueueVM().getVerticalMirrorModeSet().contains(videoWindow.getUserModel().getNumber());
            this.iRouter.getLiveRoom().requestMirrorMode(videoWindow.getUserModel().getNumber(), videoWindow.getUserId(), !isHorizontalMirror, isVerticalMirror);
            this.hideMenu(videoMenuControlModel);
        }).id(R.id.window_video_menu_more_toggle_vertical_mirror_mode).clicked(v -> {
            boolean isHorizontalMirror = this.iRouter.getLiveRoom().getSpeakQueueVM().getHorizontalMirrorModeSet().contains(videoWindow.getUserModel().getNumber());
            boolean isVerticalMirror = this.iRouter.getLiveRoom().getSpeakQueueVM().getVerticalMirrorModeSet().contains(videoWindow.getUserModel().getNumber());
            this.iRouter.getLiveRoom().requestMirrorMode(videoWindow.getUserModel().getNumber(), videoWindow.getUserId(), isHorizontalMirror, !isVerticalMirror);
            this.hideMenu(videoMenuControlModel);
        });
    }

    protected View onCreateView(Context context) {
        this.setNeedShowShadow(true);
        return LayoutInflater.from((Context)context).inflate(R.layout.window_video_menu_more, null);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.weakReference.clear();
        this.weakReference = null;
    }

    public void repositionMenu() {
        VideoMenuControlModel videoMenuControlModel = (VideoMenuControlModel)this.weakReference.get();
        VideoWindow videoWindow = videoMenuControlModel.getVideoWindow();
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(UtilsKt.getDp((int)this.menuWidthDp), -2);
        params.leftMargin = videoWindow.getMenuPosition()[0] - UtilsKt.getDp((int)this.menuWidthDp) - UtilsKt.getDp((int)this.rightMarginDp);
        params.topMargin = videoWindow.getMenuPosition()[1];
        this.view.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void hideMenu(VideoMenuControlModel videoMenuControlModel) {
        videoMenuControlModel.getVideoWindow().setMenuState(false);
        this.iRouter.getSubjectByKey(EventKey.ShowVideoMenu).onNext((Object)new VideoMenuControlModel());
    }

    private String allocateColor(List<String> colors, Map<String, String> cachePaintColors) {
        String result;
        Map authPaintColors = this.iRouter.getLiveRoom().getAuthPaintColor();
        if (authPaintColors.size() == 0) {
            int index = this.random.nextInt(colors.size());
            result = colors.get(index);
        } else {
            for (String color2 : authPaintColors.keySet()) {
                colors.remove(color2);
            }
            for (String color2 : cachePaintColors.keySet()) {
                colors.remove(color2);
            }
            if (colors.size() == 0) {
                ArrayList<String> list = new ArrayList<String>(cachePaintColors.keySet());
                int randomIndex = this.random.nextInt(list.size());
                result = list.get(randomIndex);
                cachePaintColors.remove(result);
                this.iRouter.setObjectByKey(EventKey.CachePaintColorMap, cachePaintColors);
            } else {
                int index = this.random.nextInt(colors.size());
                result = colors.get(index);
            }
        }
        return result;
    }
}

