/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.studyreport;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.baijiayun.bjyutils.toast.ToastCompat;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.groupclassui.window.studyreport.StudyReportDialogContract;
import com.baijiayun.livebase.widgets.dialog.CommonDialog;
import com.baijiayun.livecore.context.LiveRoom;

public class StudyReportDialogPresenter
implements StudyReportDialogContract.Presenter {
    private IRouter iRouter;
    private StudyReportDialogContract.View view;
    private Context context;
    CommonDialog openStudyReportDialog;

    public StudyReportDialogPresenter(StudyReportDialogContract.View view, Context context) {
        this.view = view;
        this.context = context;
    }

    @Override
    public void setRouter(IRouter router) {
        this.iRouter = router;
    }

    public void subscribe() {
    }

    public void unSubscribe() {
    }

    public void destroy() {
        this.view = null;
        this.iRouter = null;
    }

    @Override
    public LiveRoom getLiveRoom() {
        return this.iRouter.getLiveRoom();
    }

    @Override
    public void openStudyReportBrowser(String url) {
        this.openStudyReportDialog = new CommonDialog(this.context, CommonDialog.ChoiceMode.Double_Blue).setMainDisplayText(this.context.getString(R.string.bjy_group_open_study_report_by_browser)).setNegative(this.context.getResources().getText(R.string.bjysc_cancel).toString(), (dialog, which) -> dialog.dismiss()).setPositive(this.context.getString(R.string.bjysc_confirm), (dialog, which) -> {
            Uri uri = Uri.parse((String)url);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            this.context.startActivity(intent);
        });
        this.openStudyReportDialog.show();
    }

    @Override
    public void copyStudyReportUrl(String url) {
        try {
            ClipboardManager cm = (ClipboardManager)this.context.getSystemService("clipboard");
            ClipData mClipData = ClipData.newPlainText((CharSequence)"Label", (CharSequence)url);
            cm.setPrimaryClip(mClipData);
            ToastCompat.showToast((Context)this.context, (CharSequence)"\u590d\u5236\u6210\u529f", (int)0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void closeStudyReportDialog() {
        this.iRouter.getSubjectByKey(EventKey.DismissStudyReportDialog).onNext((Object)true);
    }
}

