/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.widget;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import androidx.annotation.AnimatorRes;
import androidx.annotation.DrawableRes;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.baijiayun.groupclassui.R;

public class CircleIndicator
extends LinearLayout {
    private static final int DEFAULT_INDICATOR_WIDTH = 5;
    private ViewPager mViewpager;
    private int mIndicatorMargin = -1;
    private int mIndicatorWidth = -1;
    private int mIndicatorHeight = -1;
    private int mIndicatorBackgroundResId;
    private int mIndicatorUnselectedBackgroundResId;
    private Animator mAnimatorOut;
    private Animator mAnimatorIn;
    private Animator mImmediateAnimatorOut;
    private Animator mImmediateAnimatorIn;
    private int mLastPosition = -1;
    private final ViewPager.OnPageChangeListener mInternalPageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
            View selectedIndicator;
            View currentIndicator;
            if (CircleIndicator.this.mViewpager.getAdapter() == null || CircleIndicator.this.mViewpager.getAdapter().getCount() <= 0) {
                return;
            }
            if (CircleIndicator.this.mAnimatorIn.isRunning()) {
                CircleIndicator.this.mAnimatorIn.end();
                CircleIndicator.this.mAnimatorIn.cancel();
            }
            if (CircleIndicator.this.mAnimatorOut.isRunning()) {
                CircleIndicator.this.mAnimatorOut.end();
                CircleIndicator.this.mAnimatorOut.cancel();
            }
            if (CircleIndicator.this.mLastPosition >= 0 && (currentIndicator = CircleIndicator.this.getChildAt(CircleIndicator.this.mLastPosition)) != null) {
                currentIndicator.setBackgroundResource(CircleIndicator.this.mIndicatorUnselectedBackgroundResId);
                CircleIndicator.this.mAnimatorIn.setTarget((Object)currentIndicator);
                CircleIndicator.this.mAnimatorIn.start();
            }
            if ((selectedIndicator = CircleIndicator.this.getChildAt(position)) != null) {
                selectedIndicator.setBackgroundResource(CircleIndicator.this.mIndicatorBackgroundResId);
                CircleIndicator.this.mAnimatorOut.setTarget((Object)selectedIndicator);
                CircleIndicator.this.mAnimatorOut.start();
            }
            CircleIndicator.this.mLastPosition = position;
        }

        public void onPageScrollStateChanged(int state) {
        }
    };
    private final DataSetObserver mInternalDataSetObserver = new DataSetObserver(){

        public void onChanged() {
            int currentCount;
            super.onChanged();
            if (CircleIndicator.this.mViewpager == null) {
                return;
            }
            PagerAdapter adapter = CircleIndicator.this.mViewpager.getAdapter();
            int newCount = adapter != null ? adapter.getCount() : 0;
            if (newCount == (currentCount = CircleIndicator.this.getChildCount())) {
                return;
            }
            if (CircleIndicator.this.mLastPosition < newCount) {
                CircleIndicator.this.mLastPosition = CircleIndicator.this.mViewpager.getCurrentItem();
            } else {
                CircleIndicator.this.mLastPosition = -1;
            }
            CircleIndicator.this.createIndicators();
        }
    };

    public CircleIndicator(Context context) {
        super(context);
        this.init(context, null);
    }

    public CircleIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CircleIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public CircleIndicator(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        Config config = this.handleTypedArray(context, attrs);
        this.initialize(config);
    }

    private Config handleTypedArray(Context context, AttributeSet attrs) {
        Config config = new Config();
        if (attrs == null) {
            return config;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BJYGroupCircleIndicator);
        config.width = typedArray.getDimensionPixelSize(R.styleable.BJYGroupCircleIndicator_bjy_group_ci_width, -1);
        config.height = typedArray.getDimensionPixelSize(R.styleable.BJYGroupCircleIndicator_bjy_group_ci_height, -1);
        config.margin = typedArray.getDimensionPixelSize(R.styleable.BJYGroupCircleIndicator_bjy_group_ci_margin, -1);
        config.animatorResId = typedArray.getResourceId(R.styleable.BJYGroupCircleIndicator_bjy_group_ci_animator, R.animator.indicator_scale_with_alpha);
        config.animatorReverseResId = typedArray.getResourceId(R.styleable.BJYGroupCircleIndicator_bjy_group_ci_animator_reverse, 0);
        config.backgroundResId = typedArray.getResourceId(R.styleable.BJYGroupCircleIndicator_bjy_group_ci_drawable, R.drawable.indicator_white_radius);
        config.unselectedBackgroundId = typedArray.getResourceId(R.styleable.BJYGroupCircleIndicator_bjy_group_ci_drawable_unselected, config.backgroundResId);
        config.orientation = typedArray.getInt(R.styleable.BJYGroupCircleIndicator_bjy_group_ci_orientation, -1);
        config.gravity = typedArray.getInt(R.styleable.BJYGroupCircleIndicator_bjy_group_ci_gravity, -1);
        typedArray.recycle();
        return config.build();
    }

    public void initialize(Config config) {
        int miniSize = (int)(TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()) + 0.5f);
        this.mIndicatorWidth = config.width < 0 ? miniSize : config.width;
        this.mIndicatorHeight = config.height < 0 ? miniSize : config.height;
        this.mIndicatorMargin = config.margin < 0 ? miniSize : config.margin;
        this.mAnimatorOut = this.createAnimatorOut(config);
        this.mImmediateAnimatorOut = this.createAnimatorOut(config);
        this.mImmediateAnimatorOut.setDuration(0L);
        this.mAnimatorIn = this.createAnimatorIn(config);
        this.mImmediateAnimatorIn = this.createAnimatorIn(config);
        this.mImmediateAnimatorIn.setDuration(0L);
        this.mIndicatorBackgroundResId = config.backgroundResId == 0 ? R.drawable.indicator_white_radius : config.backgroundResId;
        this.mIndicatorUnselectedBackgroundResId = config.unselectedBackgroundId == 0 ? config.backgroundResId : config.unselectedBackgroundId;
        this.setOrientation(config.orientation == 1 ? 1 : 0);
        this.setGravity(config.gravity >= 0 ? config.gravity : 17);
    }

    private Animator createAnimatorOut(Config config) {
        return AnimatorInflater.loadAnimator((Context)this.getContext(), (int)config.animatorResId);
    }

    private Animator createAnimatorIn(Config config) {
        Animator animatorIn;
        if (config.animatorReverseResId == 0) {
            animatorIn = AnimatorInflater.loadAnimator((Context)this.getContext(), (int)config.animatorResId);
            animatorIn.setInterpolator((TimeInterpolator)new ReverseInterpolator());
        } else {
            animatorIn = AnimatorInflater.loadAnimator((Context)this.getContext(), (int)config.animatorReverseResId);
        }
        return animatorIn;
    }

    public void setViewPager(ViewPager viewPager) {
        this.mViewpager = viewPager;
        if (this.mViewpager != null && this.mViewpager.getAdapter() != null) {
            this.mViewpager.getAdapter().registerDataSetObserver(this.getDataSetObserver());
            this.mLastPosition = -1;
            this.createIndicators();
            this.mViewpager.removeOnPageChangeListener(this.mInternalPageChangeListener);
            this.mViewpager.addOnPageChangeListener(this.mInternalPageChangeListener);
            this.mInternalPageChangeListener.onPageSelected(this.mViewpager.getCurrentItem());
        }
    }

    public DataSetObserver getDataSetObserver() {
        return this.mInternalDataSetObserver;
    }

    @Deprecated
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        if (this.mViewpager == null) {
            throw new NullPointerException("can not find Viewpager , setViewPager first");
        }
        this.mViewpager.removeOnPageChangeListener(onPageChangeListener);
        this.mViewpager.addOnPageChangeListener(onPageChangeListener);
    }

    private void createIndicators() {
        int count;
        this.removeAllViews();
        PagerAdapter adapter = this.mViewpager.getAdapter();
        if (adapter == null || (count = adapter.getCount()) <= 0) {
            return;
        }
        int currentItem = this.mViewpager.getCurrentItem();
        int orientation = this.getOrientation();
        if (count <= 1) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            if (currentItem == i) {
                this.addIndicator(orientation, this.mIndicatorBackgroundResId, this.mImmediateAnimatorOut);
                continue;
            }
            this.addIndicator(orientation, this.mIndicatorUnselectedBackgroundResId, this.mImmediateAnimatorIn);
        }
    }

    private void addIndicator(int orientation, @DrawableRes int backgroundDrawableId, Animator animator2) {
        if (animator2.isRunning()) {
            animator2.end();
            animator2.cancel();
        }
        View indicator = new View(this.getContext());
        indicator.setBackgroundResource(backgroundDrawableId);
        this.addView(indicator, this.mIndicatorWidth, this.mIndicatorHeight);
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)indicator.getLayoutParams();
        if (orientation == 0) {
            lp.leftMargin = this.mIndicatorMargin;
            lp.rightMargin = this.mIndicatorMargin;
        } else {
            lp.topMargin = this.mIndicatorMargin;
            lp.bottomMargin = this.mIndicatorMargin;
        }
        indicator.setLayoutParams((ViewGroup.LayoutParams)lp);
        animator2.setTarget((Object)indicator);
        animator2.start();
    }

    private static class ReverseInterpolator
    implements Interpolator {
        private ReverseInterpolator() {
        }

        public float getInterpolation(float value) {
            return Math.abs(1.0f - value);
        }
    }

    public static class Config {
        private int width = -1;
        private int height = -1;
        private int margin = -1;
        @AnimatorRes
        private int animatorResId = R.animator.indicator_scale_with_alpha;
        @AnimatorRes
        private int animatorReverseResId = 0;
        @DrawableRes
        private int backgroundResId = R.drawable.indicator_white_radius;
        @DrawableRes
        private int unselectedBackgroundId;
        private int orientation = 0;
        private int gravity = 17;

        public Config width(int width) {
            this.width = width;
            return this;
        }

        public Config height(int height) {
            this.height = height;
            return this;
        }

        public Config margin(int margin) {
            this.margin = margin;
            return this;
        }

        public Config animator(@AnimatorRes int animatorResId) {
            this.animatorResId = animatorResId;
            return this;
        }

        public Config animatorReverse(@AnimatorRes int animatorReverseResId) {
            this.animatorReverseResId = animatorReverseResId;
            return this;
        }

        public Config drawable(@DrawableRes int backgroundResId) {
            this.backgroundResId = backgroundResId;
            return this;
        }

        public Config drawableUnselected(@DrawableRes int unselectedBackgroundId) {
            this.unselectedBackgroundId = unselectedBackgroundId;
            return this;
        }

        public Config orientation(int orientation) {
            this.orientation = orientation;
            return this;
        }

        public Config gravity(int gravity) {
            this.gravity = gravity;
            return this;
        }

        public Config build() {
            return this;
        }
    }
}

