/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.groupclassui.R;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.liveuibase.utils.ShadowUtil;
import java.util.ArrayList;
import java.util.List;

public class HandsUpRemindPopupWindow
extends PopupWindow {
    private Builder.IOnChangeText onChangeText;

    private HandsUpRemindPopupWindow(View contentView, int width, int height, boolean focusable) {
        super(contentView, width, height, focusable);
        this.setAnimationStyle(R.style.BJYPushInOutFromLeftBottom);
    }

    public void dismiss() {
        super.dismiss();
        this.onChangeText.changeRemindText(0, "");
    }

    private void setOnChangeText(Builder.IOnChangeText onChangeText) {
        this.onChangeText = onChangeText;
    }

    public void setRemindText(int count, String name) {
        if (count >= 0) {
            this.onChangeText.changeRemindText(count, name);
        } else {
            this.dismiss();
        }
    }

    public static class Builder {
        private Context context;
        private HandsUpRemindPopupWindow popupWindow;
        private TextView remindText;
        private List<String> handsUpNames;
        private int lastCount;

        public Builder(Context context) {
            this.context = context;
            this.handsUpNames = new ArrayList<String>();
        }

        @SuppressLint(value={"SetTextI18n"})
        public Builder setHandsUpCount(int count, String name) {
            if (count == 0) {
                this.handsUpNames.clear();
            }
            if (count < this.lastCount) {
                this.handsUpNames.remove(name);
            }
            if (count > this.lastCount) {
                this.handsUpNames.add(0, name);
            }
            this.lastCount = count;
            String string2 = name = this.handsUpNames.size() > 0 ? this.handsUpNames.get(0) : name;
            if (count == 1) {
                this.remindText.setText((CharSequence)(UtilsKt.getEncodePhoneNumber((String)name) + this.context.getString(R.string.raising_hand)));
            } else {
                this.remindText.setText((CharSequence)(count + this.context.getString(R.string.students_raising_hand)));
            }
            SpannableStringBuilder stringBuilder = new SpannableStringBuilder(this.remindText.getText());
            ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(Color.parseColor((String)"#FFAE00"));
            stringBuilder.setSpan((Object)foregroundColorSpan, 0, count == 1 ? name.length() : (count > 10 ? 2 : 1), 17);
            this.remindText.setText((CharSequence)stringBuilder);
            return this;
        }

        public Builder build() {
            View handsUpPanel = LayoutInflater.from((Context)this.context).inflate(R.layout.view_interactive_hands_up_remind, null);
            ShadowUtil.setViewBoundShadow((View)handsUpPanel.findViewById(R.id.bjysc_bottom_hands_up_shadow_container));
            handsUpPanel.findViewById(R.id.bjysc_bottom_hands_up_main_container).setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_brand_container_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjysc_toolbar_bg_radius)).build());
            this.remindText = (TextView)handsUpPanel.findViewById(R.id.bjysc_bottom_hands_up_remind_text);
            this.popupWindow = new HandsUpRemindPopupWindow(handsUpPanel, -2, -2, true);
            this.popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.popupWindow.setOutsideTouchable(true);
            this.popupWindow.setTouchable(true);
            this.popupWindow.setOnChangeText(this::setHandsUpCount);
            return this;
        }

        public HandsUpRemindPopupWindow getPopupWindow() {
            return this.popupWindow;
        }

        static interface IOnChangeText {
            public void changeRemindText(int var1, String var2);
        }
    }
}

