/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.utils;

import android.text.TextUtils;
import com.baijiayun.livebase.models.LPExpressionModel;
import com.baijiayun.livebase.models.LPMessageDataModel;
import java.util.HashMap;
import java.util.List;

public class LPChatMessageParser {
    public static final int MESSAGE_TYPE_TEXT = 0;
    public static final int MESSAGE_TYPE_EMOJI = 1;
    public static final int MESSAGE_TYPE_EMOJI_WITH_NAME = 2;
    public static final int MESSAGE_TYPE_IMG = 3;
    private String message;
    private String name;
    private String url;
    private String key;
    private HashMap<String, String> hmEmojiServer = new HashMap();
    private int type = -1;

    public LPChatMessageParser() {
    }

    public LPChatMessageParser(List<LPExpressionModel> expressions) {
        this.setExpressions(expressions);
    }

    public void setExpressions(List<LPExpressionModel> expressions) {
        if (expressions != null) {
            for (LPExpressionModel expressionModel : expressions) {
                this.hmEmojiServer.put(expressionModel.key, expressionModel.getUrl());
                this.hmEmojiServer.put(expressionModel.name, expressionModel.getUrl());
                this.hmEmojiServer.put(expressionModel.nameEn, expressionModel.getUrl());
            }
        }
    }

    public void parseMessage(String message) {
        this.message = message;
        this.name = null;
        this.url = null;
        this.key = null;
        this.type = -1;
        this.analyzeMessage(message);
    }

    private void analyzeMessage(String message) {
        if (!TextUtils.isEmpty((CharSequence)message) && message.startsWith("[") && message.endsWith("]")) {
            String inner = message.substring(1, message.length() - 1);
            if (inner.startsWith("emoji:")) {
                if (inner.contains("|")) {
                    this.type = 2;
                    this.name = inner.substring(6, inner.indexOf("|"));
                    this.url = inner.substring(inner.indexOf("|") + 1);
                } else {
                    this.key = inner.substring(5);
                    if (this.hmEmojiServer.containsKey(inner)) {
                        this.type = 1;
                        this.url = this.hmEmojiServer.get(this.key);
                    } else {
                        this.type = 0;
                    }
                }
            } else if (inner.startsWith("img:")) {
                this.type = 3;
                this.url = inner.substring(4);
            } else if (this.hmEmojiServer.containsKey(inner)) {
                this.type = 1;
                this.key = inner;
                this.url = this.hmEmojiServer.get(this.key);
            } else {
                this.type = 0;
            }
        } else {
            this.type = 0;
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getUrl() {
        return this.url;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public static String toImageMessage(String url) {
        return "[img:" + url + "]";
    }

    public LPMessageDataModel getDataFromContent(String message, int width, int height) {
        this.parseMessage(message);
        if (this.type == 0 || this.type == 2) {
            return null;
        }
        LPMessageDataModel data = new LPMessageDataModel();
        if (this.type == 1) {
            data.type = "emoji";
            data.key = this.key;
        } else if (this.type == 3) {
            data.type = "image";
            data.url = this.url;
            data.height = height;
            data.width = width;
        }
        return data;
    }

    public HashMap<String, String> getHmEmojiServer() {
        return this.hmEmojiServer;
    }
}

