/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.widgets.emoji;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.glide.Glide;
import com.baijiayun.livebase.R;
import com.baijiayun.livebase.base.BaseFragment;
import com.baijiayun.livebase.widgets.emoji.EmojiContract;
import com.baijiayun.livebase.widgets.emoji.EmojiSelectCallBack;
import com.baijiayun.livebase.widgets.emoji.IExpressionModel;

public class EmojiFragment
extends BaseFragment
implements EmojiContract.View {
    private EmojiSelectCallBack callBack;
    private EmojiContract.Presenter presenter;
    private ViewPager viewPager;
    private int gridPadding;
    private int spanCount = 8;
    private int rowCount = 4;
    private int maxWidth;
    private int maxHeight;
    private int itemSize;

    public static EmojiFragment newInstance() {
        Bundle args = new Bundle();
        EmojiFragment fragment = new EmojiFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void setCount(int spanCount, int rowCount) {
        this.spanCount = spanCount;
        this.rowCount = rowCount;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setItemSize(int itemSize) {
        this.itemSize = itemSize;
    }

    @Override
    public int getLayoutId() {
        return R.layout.bjy_pb_fragment_emoji;
    }

    @Override
    protected void init(Bundle savedInstanceState) {
        super.init(savedInstanceState);
        this.gridPadding = UtilsKt.getDp((int)10);
        this.adjustItemCount();
        this.viewPager = (ViewPager)this.$.id(R.id.fragment_emoji_container_viewpager).view();
        EmojiPagerAdapter pagerAdapter = new EmojiPagerAdapter();
        this.viewPager.setAdapter((PagerAdapter)pagerAdapter);
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
            }

            public void onPageScrollStateChanged(int state) {
                if (state == 0) {
                    EmojiFragment.this.presenter.onPageSelected(EmojiFragment.this.viewPager.getCurrentItem());
                }
            }
        });
    }

    @Override
    public void setPresenter(EmojiContract.Presenter presenter) {
        super.setBasePresenter(presenter);
        this.presenter = presenter;
    }

    private void adjustItemCount() {
        if (this.getContext() != null) {
            if (this.itemSize == 0) {
                this.itemSize = UtilsKt.getDp((int)40);
            }
            if (this.maxWidth == 0) {
                this.maxWidth = DisplayUtils.getScreenWidthPixels((Context)this.getContext());
            }
            this.spanCount = (this.maxWidth - 2 * this.gridPadding) / this.itemSize;
            if (this.maxHeight != 0) {
                this.rowCount = this.maxHeight / this.itemSize;
            }
            if (this.presenter != null) {
                this.presenter.onSizeChanged();
            }
        }
    }

    public void setCallBack(EmojiSelectCallBack callBack) {
        this.callBack = callBack;
    }

    @Override
    public int getSpanCount() {
        return this.spanCount;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.presenter = null;
        this.callBack = null;
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.presenter != null) {
            this.adjustItemCount();
            this.presenter.onSizeChanged();
            this.viewPager.setAdapter((PagerAdapter)new EmojiPagerAdapter());
            this.viewPager.setCurrentItem(this.presenter.getPageOfCurrentFirstItem());
        }
    }

    private class EmojiPagerAdapter
    extends PagerAdapter {
        private final View[] viewList = new View[this.getCount()];

        EmojiPagerAdapter() {
        }

        public int getCount() {
            return EmojiFragment.this.presenter.getPageCount();
        }

        public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
            return view == object;
        }

        @NonNull
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            if (this.viewList.length <= position || this.viewList[position] == null) {
                GridView gridView = new GridView(EmojiFragment.this.getContext());
                gridView.setPadding(EmojiFragment.this.gridPadding, 0, EmojiFragment.this.gridPadding, 0);
                gridView.setNumColumns(EmojiFragment.this.spanCount);
                gridView.setAdapter((ListAdapter)new EmojiAdapter(position));
                this.viewList[position] = gridView;
            }
            container.addView(this.viewList[position]);
            return this.viewList[position];
        }

        public void destroyItem(ViewGroup container, int position, @NonNull Object object) {
            container.removeView(this.viewList[position]);
        }

        public void startUpdate(@NonNull ViewGroup container) {
            super.startUpdate(container);
        }
    }

    private static class ViewHolder {
        ImageView imageView;

        private ViewHolder() {
        }
    }

    private class EmojiAdapter
    extends BaseAdapter {
        private final int page;

        EmojiAdapter(int page) {
            this.page = page;
        }

        public int getCount() {
            return EmojiFragment.this.presenter.getCount(this.page);
        }

        @Nullable
        public IExpressionModel getItem(int position) {
            return EmojiFragment.this.presenter.getItem(this.page, position);
        }

        public long getItemId(int position) {
            return (long)this.page * (long)EmojiFragment.this.spanCount * (long)EmojiFragment.this.rowCount + (long)position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                if (EmojiFragment.this.getActivity() == null) {
                    return null;
                }
                LayoutInflater inflater = EmojiFragment.this.getActivity().getLayoutInflater();
                convertView = inflater.inflate(R.layout.bjy_pb_item_emoji, parent, false);
                holder = new ViewHolder();
                holder.imageView = (ImageView)convertView.findViewById(R.id.item_emoji_iv);
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            IExpressionModel expressionModel = this.getItem(position);
            if (EmojiFragment.this.getContext() != null && expressionModel != null) {
                Glide.with((Context)EmojiFragment.this.getContext()).load(expressionModel.getUrl()).into(holder.imageView);
            }
            holder.imageView.setOnClickListener(v -> {
                if (EmojiFragment.this.callBack != null) {
                    EmojiFragment.this.callBack.onEmojiSelected(expressionModel);
                }
            });
            return convertView;
        }
    }
}

