/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.context;

import com.google.gson.annotations.SerializedName;

public class LPConstants {
    public static String[] HOSTS_WEB;
    public static final String BASE_ANIM_PPT_URL = "http://live-cdn.baijiayun.com/js-sdk/webview-v7/whiteboard/webview.html";
    public static final String LIKE_URL = "https://img.baijiayun.com/0baijiatools/f5000c8c2332757d6fec37de5daec5ee/love.svga";
    public static final String SHOP_URL = "https://img.baijiayun.com/0baijiatools/f5000c8c2332757d6fec37de5daec5ee/shopping_cart.svga";
    public static final int DEFAULT_BITMAP_WIDTH = 1080;
    public static final String DEFAULT_DOMAIN_SUFFIX = "baijiayun.com";
    public static final String DEFAULT_APIPREFIX = "www";
    public static final String DEFAULT_INFIX = "at";
    public static final int DEFAULT_COUNT_PER_PAGE = 10;
    public static final int SHAPE_APPEND_TRIGGER_INTERVAL = 400;
    public static final String SMALL_BLACKBOARD_SIGNAL_INFIX = "_";
    public static final int SNIPPET_COUNT_PER_PAGE = 10;
    public static final int ANIM_PPT_MAX_WAIT_TIME = 15;
    public static final int BINDER_SOURCE_LOCAL = 0;
    public static final int BINDER_SOURCE_BACK_STAGE = 1;
    public static final String PREVIEW_PPT_DOC_ID_SUFFIX = "_preview";
    public static final String TYPE_WHITEBOARD_DOC_ID = "0";

    public static enum LiveSoldCountType {
        ROOM_SALE_COUNT,
        TOTAL_SALE_COUNT;

    }

    public static enum LPShareType {
        LP_SHARE_WECHAT(1),
        LP_SHARE_MOMENTS(2),
        LP_SHARE_SMS(3),
        LP_SHARE_QQ(4),
        LP_SHARE_QQ_ZONE(5),
        LP_SHARE_WEIBO(6),
        LP_SHARE_LINK(7);

        private final int type;

        private LPShareType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public static LPShareType from(int type) {
            switch (type) {
                case 1: {
                    return LP_SHARE_WECHAT;
                }
                case 2: {
                    return LP_SHARE_MOMENTS;
                }
                case 3: {
                    return LP_SHARE_SMS;
                }
                case 4: {
                    return LP_SHARE_QQ;
                }
                case 5: {
                    return LP_SHARE_QQ_ZONE;
                }
                case 6: {
                    return LP_SHARE_WEIBO;
                }
            }
            return LP_SHARE_LINK;
        }
    }

    public static enum LPPosition {
        LEFT_TOP(1),
        RIGHT_TOP(2),
        RIGHT_BOTTOM(3),
        LEFT_BOTTOM(4);

        private int position;

        private LPPosition(int position) {
            this.position = position;
        }

        public static LPPosition from(int position) {
            switch (position) {
                case 2: {
                    return RIGHT_TOP;
                }
                case 3: {
                    return RIGHT_BOTTOM;
                }
                case 4: {
                    return LEFT_BOTTOM;
                }
            }
            return LEFT_TOP;
        }

        public int getPosition() {
            return this.position;
        }
    }

    public static enum PPTViewType {
        NOT_INIT,
        STATIC,
        ANIM;

    }

    public static enum LPPKStatus {
        PK_START(1),
        PK_VOTE(2),
        PK_END(0);

        private int status;

        private LPPKStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }

    public static enum LPScreenShareState {
        INIT,
        START,
        RESUME,
        PAUSE,
        STOP,
        ERROR;

    }

    public static enum LPCDNResolution {
        ORIGINAL(0),
        HIGH(1);

        private int resolution;

        private LPCDNResolution(int resolution) {
            this.resolution = resolution;
        }

        public int getResolution() {
            return this.resolution;
        }
    }

    public static enum LPCloudVideoStatus {
        NOT_PLAY(0),
        PLAYING(1),
        PAUSE(2);

        private int status;

        private LPCloudVideoStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }

    public static enum BonusPointType {
        TYPE_ALL(0),
        TYPE_GROUP(1),
        TYPE_MY(2),
        TYPE_MY_GROUP(3);

        private int type;

        private BonusPointType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }

    public static enum ZXYBConnectType {
        TYPE_BLE(0),
        TYPE_SERIALPORT(1),
        TYPE_USB(2);

        private int type;

        private ZXYBConnectType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public static ZXYBConnectType from(int type) {
            switch (type) {
                case 1: {
                    return TYPE_SERIALPORT;
                }
                case 2: {
                    return TYPE_USB;
                }
            }
            return TYPE_BLE;
        }
    }

    public static enum ZXYBConnectStatus {
        CONNECT_STATUS_UNKOWN(-1),
        CONNECT_STATUS_DISCONNECT(0),
        CONNECT_STATUS_SUCCESS(1),
        CONNECT_STATUS_FAIL(2),
        CONNECT_STATUS_CONNECTING(3),
        CONNECT_STATUS_UNIT(4),
        CONNECT_STATUS_SLEEP(5);

        private int type;

        private ZXYBConnectStatus(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public static ZXYBConnectStatus from(int type) {
            switch (type) {
                case 0: {
                    return CONNECT_STATUS_DISCONNECT;
                }
                case 1: {
                    return CONNECT_STATUS_SUCCESS;
                }
                case 2: {
                    return CONNECT_STATUS_FAIL;
                }
                case 3: {
                    return CONNECT_STATUS_CONNECTING;
                }
                case 4: {
                    return CONNECT_STATUS_UNIT;
                }
                case 5: {
                    return CONNECT_STATUS_SLEEP;
                }
            }
            return CONNECT_STATUS_UNKOWN;
        }
    }

    public static enum StudyRoomMode {
        None(0),
        SelfStudy(1),
        Discuss(2),
        Tutor(3),
        SingleTutor(4),
        GroupTutor(5);

        private int mode;

        private StudyRoomMode(int mode) {
            this.mode = mode;
        }

        public int getStudyRoomModeValue() {
            return this.mode;
        }

        public boolean isGalleryLayout() {
            return this.mode == 1 || this.mode == 2;
        }

        public static StudyRoomMode from(int mode) {
            switch (mode) {
                case 1: {
                    return SelfStudy;
                }
                case 2: {
                    return Discuss;
                }
                case 3: {
                    return Tutor;
                }
                case 4: {
                    return SingleTutor;
                }
                case 5: {
                    return GroupTutor;
                }
            }
            return None;
        }
    }

    public static enum H5PlayMode {
        None,
        Teach,
        Practice;

    }

    public static enum MediaState {
        Normal(0),
        Unavailable(1),
        PermissionDeny(2),
        Occupied(3),
        Backstage(4),
        None(5);

        int state;

        private MediaState(int state) {
            this.state = state;
        }

        public int getState() {
            return this.state;
        }

        public static MediaState from(String state) {
            switch (state) {
                case "0": {
                    return Normal;
                }
                case "1": {
                    return Unavailable;
                }
                case "2": {
                    return PermissionDeny;
                }
                case "3": {
                    return Occupied;
                }
                case "4": {
                    return Backstage;
                }
            }
            return None;
        }
    }

    public static enum LPDualTeacherInteractionEffect {
        LIKE("like"),
        GOLD("gold"),
        BOMB("bomb");

        private String name;

        private LPDualTeacherInteractionEffect(String name) {
            this.name = name;
        }

        public String getEffectName() {
            return this.name;
        }
    }

    public static enum CloudRecordStatus {
        Stopped(0),
        Recording(1),
        Paused(2);

        int status;

        private CloudRecordStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }

    public static enum LPForbidChatType {
        TYPE_ALL,
        TYPE_GROUP;

    }

    public static enum LPAspectRatio {
        Fit,
        Fill;

    }

    public static enum LPQuizCacheStauts {
        QUIZ_ADD(1),
        QUIZ_START(2),
        QUIZ_END(3),
        QUIZ_SOLUTION(4),
        QUIZ_DELETE(5);

        private int type;

        private LPQuizCacheStauts(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum LPExamQuizType {
        EXAM_ONLY(0),
        EXAM_ALL(1);

        private int type;

        private LPExamQuizType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum LPQuizType {
        SINGLE_CHOICE(1),
        MUlTI_CHOICE(2),
        SHORT_QUIZ(3),
        JUDGEMENT_QUIZ(4);

        private int type;

        private LPQuizType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum SmallClassTemplateType {
        DEFAULT(1),
        ONEONONE(3);

        private int type;

        private SmallClassTemplateType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum TemplateType {
        ELITE("elite"),
        LIVE_WALL("liveWall"),
        DOUBLE_CAMERA("doubleCamera"),
        VIDEO("video");

        @SerializedName(value="template_name", alternate={"name"})
        private String templateName;

        public String getTemplateName() {
            return this.templateName;
        }

        private TemplateType(String templateName) {
            this.templateName = templateName;
        }
    }

    public static enum ComponentType {
        Answerer("tool_answer"),
        Responder("tool_answer_racer"),
        Timer("tool_timer");

        private String componentType;

        private ComponentType(String componentType) {
            this.componentType = componentType;
        }

        public String getComponentType() {
            return this.componentType;
        }
    }

    public static enum VoiceType {
        VOICE_CALL(0),
        VOICE_MEDIA(1);

        private int voiceType;

        private VoiceType(int voiceType) {
            this.voiceType = voiceType;
        }

        public int getVoiceType() {
            return this.voiceType;
        }
    }

    public static enum MediaSource {
        Camera(0),
        ScreenShare(1),
        MediaFile(2);

        private int source;

        private MediaSource(int source) {
            this.source = source;
        }

        public int getSourceType() {
            return this.source;
        }

        public static MediaSource from(int source) {
            switch (source) {
                case 0: {
                    return Camera;
                }
                case 1: {
                    return ScreenShare;
                }
                case 2: {
                    return MediaFile;
                }
            }
            return Camera;
        }
    }

    public static enum MediaSourceType {
        MainCamera(0),
        ExtCamera(1),
        MainScreenShare(2),
        ExtScreenShare(3),
        Media(4),
        ExtMedia(5);

        private int value;

        private MediaSourceType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MediaSourceType from(int value) {
            switch (value) {
                case 1: {
                    return ExtCamera;
                }
                case 2: {
                    return MainScreenShare;
                }
                case 3: {
                    return ExtScreenShare;
                }
                case 4: {
                    return Media;
                }
                case 5: {
                    return ExtMedia;
                }
            }
            return MainCamera;
        }
    }

    public static enum RoomLayoutMode {
        GALLERY(1),
        BOARD(2),
        SPEECH(3);

        private int layoutMode;

        private RoomLayoutMode(int layoutMode) {
            this.layoutMode = layoutMode;
        }

        public int getLayoutMode() {
            return this.layoutMode;
        }

        public static RoomLayoutMode from(int layoutMode) {
            switch (layoutMode) {
                case 1: {
                    return GALLERY;
                }
                case 2: {
                    return BOARD;
                }
                case 3: {
                    return SPEECH;
                }
            }
            return BOARD;
        }
    }

    public static enum LPVideoViewType {
        SURFACE_VIEW,
        TEXTURE_VIEW;

    }

    public static enum MediaNetworkQuality {
        EXCELLENT(0),
        GOOD(1),
        BAD(2),
        TERRIBLE(3);

        private int quality;

        private MediaNetworkQuality(int quality) {
            this.quality = quality;
        }

        public int getQuality() {
            return this.quality;
        }
    }

    public static enum VolumeLevel {
        NONE(0),
        LOW(1),
        MIDDLE(2),
        HIGH(3);

        private int level;

        private VolumeLevel(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }

    public static enum LPPlayerAction {
        ADD("add"),
        REMOVE("remove"),
        REPOSITION("reposition"),
        STICK("stick"),
        MAX("max"),
        FULL("full"),
        NORMAL("normal");

        private String action;

        private LPPlayerAction(String action) {
            this.action = action;
        }

        public String getAction() {
            return this.action;
        }
    }

    public static enum VideoDefinition {
        _1080P("1080p"),
        _720P("720p"),
        Super("super"),
        High("high"),
        Std("std"),
        Low("low");

        private String type;

        private VideoDefinition(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static VideoDefinition from(int type) {
            switch (type) {
                case 0: {
                    return null;
                }
                case 1: {
                    return Std;
                }
                case 2: {
                    return High;
                }
                case 3: {
                    return Super;
                }
                case 4: {
                    return _720P;
                }
                case 5: {
                    return _1080P;
                }
            }
            return Low;
        }
    }

    public static enum MessageType {
        Text,
        Image,
        Emoji,
        EmojiWithName,
        Reward;

    }

    public static enum PPTEditMode {
        Normal(0),
        SelectMode(1),
        ShapeMode(2),
        EraserMode(3),
        PPTTouchMode(4);

        private int type;

        private PPTEditMode(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum ShapeType {
        StraightLine(2),
        Arrow(3),
        DoubleArrow(4),
        Rect(6),
        Oval(7),
        Triangle(5),
        RectSolid(6),
        OvalSolid(7),
        TriangleSolid(5),
        Text(9),
        Point(10),
        Bitmap(8),
        Doodle(1),
        DottedLine(2),
        MarkerDoodle(11),
        Mouse(1);

        private int value;

        private ShapeType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum LPMediaType {
        Video(0),
        Audio(1);

        private int type;

        private LPMediaType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum LPResolutionType {
        LOW(0),
        HIGH(1),
        _720(2),
        _1080(3),
        _360(4),
        _540(5);

        private int type;

        private LPResolutionType(int type) {
            this.type = type;
        }

        public int getTypeValue() {
            return this.type;
        }

        public static int getTypeValue(int height) {
            if (height >= 1080) {
                return LPResolutionType._1080.type;
            }
            if (height >= 720) {
                return LPResolutionType._720.type;
            }
            if (height >= 540) {
                return LPResolutionType._540.type;
            }
            if (height >= 480) {
                return LPResolutionType.HIGH.type;
            }
            if (height >= 360) {
                return LPResolutionType._360.type;
            }
            return LPResolutionType.LOW.type;
        }

        public int getResolutionHeight() {
            switch (this) {
                case _360: {
                    return 270;
                }
                case _540: {
                    return 540;
                }
                case HIGH: {
                    return 360;
                }
                case _720: {
                    return 720;
                }
                case _1080: {
                    return 1080;
                }
            }
            return 180;
        }

        public int getResolutionWidth() {
            switch (this) {
                case _360: {
                    return 480;
                }
                case _540: {
                    return 960;
                }
                case HIGH: {
                    return 640;
                }
                case _720: {
                    return 1280;
                }
                case _1080: {
                    return 1920;
                }
            }
            return 320;
        }

        public static LPResolutionType from(int type) {
            switch (type) {
                case 1: {
                    return HIGH;
                }
                case 2: {
                    return _720;
                }
                case 3: {
                    return _1080;
                }
                case 4: {
                    return _360;
                }
                case 5: {
                    return _540;
                }
            }
            return LOW;
        }
    }

    public static enum LPLinkType {
        TCP(0),
        UDP(1);

        private int type;

        private LPLinkType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public static LPLinkType from(int type) {
            switch (type) {
                case 0: {
                    return TCP;
                }
                case 1: {
                    return UDP;
                }
            }
            return TCP;
        }
    }

    public static enum LPDeployType {
        Test(0),
        Beta(1),
        Product(2);

        private int type;

        private LPDeployType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum LPRoomType {
        Single(1),
        Multi(2),
        SmallGroup(3),
        NewSmallGroup(4),
        DoubleTeachers(5),
        OneOnOne(6);

        private int type;

        private LPRoomType(int type) {
            this.type = type;
        }

        public static LPRoomType from(int type) {
            switch (type) {
                case 1: {
                    return Single;
                }
                case 2: {
                    return Multi;
                }
                case 3: {
                    return SmallGroup;
                }
                case 4: {
                    return NewSmallGroup;
                }
                case 5: {
                    return DoubleTeachers;
                }
                case 6: {
                    return OneOnOne;
                }
            }
            return Multi;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum LPPPTShowWay {
        SHOW_FULL_SCREEN(0),
        SHOW_COVERED(1);

        private int type;

        private LPPPTShowWay(int type) {
            this.type = type;
        }

        public static LPPPTShowWay from(int type) {
            switch (type) {
                case 0: {
                    return SHOW_FULL_SCREEN;
                }
                case 1: {
                    return SHOW_COVERED;
                }
            }
            return SHOW_FULL_SCREEN;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum LPUserState {
        Online(0),
        Invisible(1);

        private int type;

        private LPUserState(int type) {
            this.type = type;
        }

        public static LPUserState from(int type) {
            switch (type) {
                case 0: {
                    return Online;
                }
                case 1: {
                    return Invisible;
                }
            }
            return Online;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum LPSpeakState {
        Free(0),
        Limit(1);

        private int type;

        private LPSpeakState(int type) {
            this.type = type;
        }

        public static LPSpeakState from(int type) {
            switch (type) {
                case 0: {
                    return Free;
                }
                case 1: {
                    return Limit;
                }
            }
            return Limit;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum LPEndType {
        PC_HTML(0),
        PC_Client(1),
        PC_H5(2),
        iOS(3),
        Android(4),
        PC_MAC_Client(5);

        private int type;

        private LPEndType(int type) {
            this.type = type;
        }

        public static LPEndType from(int type) {
            switch (type) {
                case 0: {
                    return PC_HTML;
                }
                case 1: {
                    return PC_Client;
                }
                case 2: {
                    return PC_H5;
                }
                case 3: {
                    return iOS;
                }
                case 4: {
                    return Android;
                }
                case 5: {
                    return PC_MAC_Client;
                }
            }
            return PC_HTML;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum LPFileType {
        Origin(0),
        H5(1),
        Anim(2);

        int type;

        private LPFileType(int type) {
            this.type = type;
        }

        public static LPFileType from(int type) {
            for (LPFileType fileType : LPFileType.values()) {
                if (fileType.type != type) continue;
                return fileType;
            }
            return null;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum LPUserType {
        Student(0),
        Teacher(1),
        Assistant(2),
        Visitor(3);

        private int type;

        private LPUserType(int type) {
            this.type = type;
        }

        public static LPUserType from(int type) {
            switch (type) {
                case 0: {
                    return Student;
                }
                case 1: {
                    return Teacher;
                }
                case 2: {
                    return Assistant;
                }
                case 3: {
                    return Visitor;
                }
            }
            return Student;
        }

        public int getType() {
            return this.type;
        }
    }
}

