/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.base;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.baijiayun.bjyutils.query.QueryPlus;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.bjyutils.toast.ToastCompat;
import com.baijiayun.livebase.R;
import com.baijiayun.livebase.base.BasePresenter;
import com.baijiayun.livebase.listener.DetachableClickListener;
import java.lang.reflect.Field;

@Deprecated
public abstract class BaseDialogFragment
extends DialogFragment {
    private BasePresenter basePresenter;
    protected View contentView;
    private boolean isEditing;
    protected QueryPlus $;
    private int contentBackgroundColor = -1;
    protected Context contextReference;
    private int theme = R.style.BJYBaseLiveTheme;
    private boolean isThemeContext = false;
    protected FrameLayout baseContent;

    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        this.contextReference = this.isThemeContext ? new ContextThemeWrapper(context, this.theme) : context;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        LayoutInflater layoutInflater = inflater;
        if (this.getActivity() != null) {
            layoutInflater = this.getActivity().getLayoutInflater();
        }
        View baseView = layoutInflater.inflate(R.layout.uibase_dialog_base, container);
        this.contentView = layoutInflater.inflate(this.getLayoutId(), null);
        this.baseContent = (FrameLayout)baseView.findViewById(R.id.dialog_base_content);
        this.baseContent.addView(this.contentView);
        this.$ = QueryPlus.with((View)baseView);
        this.init(savedInstanceState, this.getArguments());
        if (this.basePresenter != null) {
            this.basePresenter.subscribe();
        }
        return baseView;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = new Dialog((Context)this.getActivity(), R.style.BJYBaseUIDialogFragmentStyle);
        dialog.setCanceledOnTouchOutside(this.isCanceledOnTouchOutside());
        this.setCancelable(this.isCanceled());
        dialog.getWindow().requestFeature(1);
        dialog.getWindow().setFlags(8, 8);
        dialog.getWindow().setFlags(1024, 1024);
        if (this.getActivity() != null) {
            dialog.getWindow().getDecorView().setSystemUiVisibility(this.getActivity().getWindow().getDecorView().getSystemUiVisibility());
        }
        DetachableClickListener detachableClickListener = DetachableClickListener.wrap(dialog1 -> {
            try {
                if (this.getDialog() == null || this.getActivity() == null || this.getActivity().isDestroyed()) {
                    return;
                }
                this.getDialog().getWindow().clearFlags(8);
                WindowManager wm = (WindowManager)this.getActivity().getSystemService("window");
                wm.updateViewLayout(this.getDialog().getWindow().getDecorView(), (ViewGroup.LayoutParams)this.getDialog().getWindow().getAttributes());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        dialog.setOnShowListener((DialogInterface.OnShowListener)detachableClickListener);
        detachableClickListener.clearOnDetach(dialog);
        return dialog;
    }

    protected boolean hasWindowAnim() {
        return false;
    }

    public void show(@NonNull FragmentManager manager, String tag) {
        try {
            Field mDismissed = DialogFragment.class.getDeclaredField("mDismissed");
            mDismissed.setAccessible(true);
            mDismissed.set((Object)this, false);
            Field mShownByMe = DialogFragment.class.getDeclaredField("mShownByMe");
            mShownByMe.setAccessible(true);
            mShownByMe.set((Object)this, true);
            FragmentTransaction ft = manager.beginTransaction();
            ft.add((Fragment)this, tag);
            ft.commitAllowingStateLoss();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onStart() {
        Window window;
        super.onStart();
        Window window2 = window = this.getDialog() == null ? null : this.getDialog().getWindow();
        assert (window != null);
        if (this.getContentBackgroundColor() == -1) {
            this.contentBackgroundColor(ContextCompat.getColor((Context)this.contextReference, (int)R.color.base_white));
        }
        window.setBackgroundDrawable((Drawable)new ColorDrawable(this.getContentBackgroundColor()));
        WindowManager.LayoutParams windowParams = window.getAttributes();
        this.setWindowParams(windowParams);
        window.setAttributes(windowParams);
    }

    protected void setWindowParams(WindowManager.LayoutParams windowParams) {
        windowParams.dimAmount = 0.5f;
        windowParams.flags |= 2;
        if (this.hasWindowAnim()) {
            windowParams.windowAnimations = R.style.LiveBaseDialogAnim;
        }
        int longEdge = Math.max(DisplayUtils.getScreenHeightPixels((Context)this.contextReference), DisplayUtils.getScreenWidthPixels((Context)this.contextReference));
        if (this.getResources().getConfiguration().orientation == 1) {
            windowParams.width = -1;
            windowParams.height = longEdge / 2;
        } else {
            windowParams.width = longEdge / 2;
            windowParams.height = -1;
        }
        windowParams.gravity = 0x800055;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Window window = this.getDialog().getWindow();
        WindowManager.LayoutParams windowParams = window.getAttributes();
        this.resetWindowParams(windowParams);
        window.setAttributes(windowParams);
    }

    protected void resetWindowParams(WindowManager.LayoutParams windowParams) {
        this.setWindowParams(windowParams);
    }

    protected abstract int getLayoutId();

    protected abstract void init(@Nullable Bundle var1, @Nullable Bundle var2);

    public void setBasePresenter(BasePresenter presenter) {
        this.basePresenter = presenter;
    }

    public BaseDialogFragment title(String title) {
        this.$.id(R.id.dialog_base_title).text((CharSequence)title);
        return this;
    }

    public BaseDialogFragment contentBackgroundColor(int color2) {
        this.contentBackgroundColor = color2;
        return this;
    }

    @ColorInt
    protected int getContentBackgroundColor() {
        return this.contentBackgroundColor;
    }

    public void setTitleTextColor(int color2) {
        ((TextView)this.$.id(R.id.dialog_base_title).view()).setTextColor(color2);
    }

    public void setTitleHeight(int height) {
        ViewGroup.LayoutParams layoutParams = this.$.id(R.id.dialog_base_title_container).view().getLayoutParams();
        layoutParams.height = height;
        this.$.id(R.id.dialog_base_title_container).view().setLayoutParams(layoutParams);
    }

    public void showCross() {
        this.$.id(R.id.dialog_base_edit).visibility(8);
        this.$.id(R.id.dialog_close).visibility(0);
        this.$.id(R.id.dialog_close).clicked(v -> this.dismissAllowingStateLoss());
    }

    public void setTitleBarColor(int color2) {
        this.$.id(R.id.dialog_base_title_container).view().setBackgroundColor(color2);
    }

    public void setTitleBackground(Drawable drawable2) {
        this.$.id(R.id.dialog_base_title_container).view().setBackground(drawable2);
    }

    public BaseDialogFragment editable(boolean editable) {
        this.$.id(R.id.dialog_base_edit).visibility(editable ? 0 : 8);
        this.$.id(R.id.dialog_base_edit).clicked(v -> {
            if (this.isEditing) {
                this.disableEdit();
            } else {
                this.enableEdit();
            }
        });
        return this;
    }

    public BaseDialogFragment editText(String text) {
        this.$.id(R.id.dialog_base_edit).text((CharSequence)text);
        return this;
    }

    public BaseDialogFragment editColor(int color2) {
        ((TextView)this.$.id(R.id.dialog_base_edit).view()).setTextColor(color2);
        return this;
    }

    public BaseDialogFragment editClick(View.OnClickListener listener) {
        this.$.id(R.id.dialog_base_edit).clicked(listener);
        return this;
    }

    protected BaseDialogFragment hideTitleBar() {
        this.$.id(R.id.dialog_base_title_container).gone();
        return this;
    }

    protected boolean isEditing() {
        return this.isEditing;
    }

    @CallSuper
    protected void disableEdit() {
        this.isEditing = false;
        this.$.id(R.id.dialog_base_edit).text((CharSequence)this.getString(R.string.base_edit));
    }

    @CallSuper
    protected void enableEdit() {
        this.isEditing = true;
        this.$.id(R.id.dialog_base_edit).text((CharSequence)this.getString(R.string.base_live_cancel));
    }

    protected void showToast(String msg) {
        if (this.getActivity() == null || this.getActivity().isDestroyed()) {
            return;
        }
        ToastCompat.showToast((Context)this.contextReference, (CharSequence)msg, (int)0);
    }

    protected boolean isCanceledOnTouchOutside() {
        return true;
    }

    protected boolean isCanceled() {
        return true;
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.basePresenter != null) {
            this.basePresenter.unSubscribe();
            this.basePresenter.destroy();
            this.basePresenter = null;
        }
        this.$ = null;
    }

    public void onDetach() {
        super.onDetach();
        this.contextReference = null;
    }

    public boolean isQueryPlusNull() {
        return this.$ == null;
    }
}

