/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.widgets.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;

public class FullWidthImageView
extends AppCompatImageView {
    public FullWidthImageView(@NonNull Context context) {
        super(context);
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    public FullWidthImageView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    public FullWidthImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable d = this.getDrawable();
        if (d != null) {
            int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (d.getIntrinsicHeight() > d.getIntrinsicWidth()) {
                this.setScaleType(ImageView.ScaleType.MATRIX);
                height = (int)Math.ceil((float)width * (float)d.getIntrinsicHeight() / (float)d.getIntrinsicWidth());
            } else {
                this.setScaleType(ImageView.ScaleType.FIT_CENTER);
            }
            this.setMeasuredDimension(width, height);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }
}

