/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.utils;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.baijiahulian.common.permission.AppPermissions;
import com.baijiayun.bjyutils.toast.ToastCompat;
import com.baijiayun.glide.Glide;
import com.baijiayun.livebase.R;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.LPJoinCodeEnterRoomModel;
import com.baijiayun.livebase.models.LPSignEnterRoomModel;
import com.baijiayun.livebase.models.LPUserModel;
import com.baijiayun.livebase.utils.FileUtils;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class LiveBaseUtils {
    private static String[][] paramNames = new String[][]{{"replaceUserNumber", "replace_user_number"}, {"replaceUserRole", "replace_user_role"}, {"joinCode", "code"}, {"userName", "user_name"}, {"userType", "user_role"}, {"classType", "class_type"}, {"roomId", "room_id"}, {"userNumber", "user_number"}, {"userAvatar", "user_avatar"}, {"sign", "sign"}, {"groupId", "group_id"}, {"privateDomain", "private_domain"}, {"privateDomainPrefix", "private_domain_prefix"}, {"privateDomainSuffix", "private_domain_suffix"}, {"apiDomainPrefix", "api_domain_prefix"}};

    public static Map<String, String> parseEnterRoomUrl(Uri uri) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String[] names : paramNames) {
            String paramName = names[0];
            String backupParamName = names[1];
            String paramValue = uri.getQueryParameter(paramName);
            if (TextUtils.isEmpty((CharSequence)paramValue)) {
                paramValue = uri.getQueryParameter(backupParamName);
            }
            paramMap.put(paramName, paramValue);
        }
        return paramMap;
    }

    public static LPJoinCodeEnterRoomModel parseJoinCodeEnterRoomModel(Uri uri) {
        Map<String, String> paramMap = LiveBaseUtils.parseEnterRoomUrl(uri);
        String joinCode = paramMap.get("joinCode");
        String userName = paramMap.get("userName");
        if (TextUtils.isEmpty((CharSequence)joinCode)) {
            return null;
        }
        LPJoinCodeEnterRoomModel joinCodeEnterRoomModel = new LPJoinCodeEnterRoomModel(joinCode, userName);
        joinCodeEnterRoomModel.userAvatar = paramMap.get("userAvatar");
        String userType = paramMap.get("userType");
        int type = 0;
        if (!TextUtils.isEmpty((CharSequence)userType)) {
            type = Integer.parseInt(userType);
        }
        joinCodeEnterRoomModel.userType = LPConstants.LPUserType.from(type);
        joinCodeEnterRoomModel.customStr = uri.getQueryParameter("customStr");
        return joinCodeEnterRoomModel;
    }

    public static LPSignEnterRoomModel parseSignEnterRoomModel(Uri uri) {
        Map<String, String> paramMap = LiveBaseUtils.parseEnterRoomUrl(uri);
        String userName = paramMap.get("userName");
        String userType = paramMap.get("userType");
        String roomId = paramMap.get("roomId");
        String userNumber = paramMap.get("userNumber");
        String replaceUserNumber = paramMap.get("replaceUserNumber");
        String replaceUserRole = paramMap.get("replaceUserRole");
        String userAvatar = paramMap.get("userAvatar");
        String sign = paramMap.get("sign");
        String groupId = paramMap.get("groupId");
        if (TextUtils.isEmpty((CharSequence)sign)) {
            return null;
        }
        String customStr = uri.getQueryParameter("customStr");
        if (!TextUtils.isEmpty((CharSequence)userAvatar)) {
            try {
                userAvatar = URLDecoder.decode(userAvatar, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        int group = -1;
        if (!TextUtils.isEmpty((CharSequence)groupId)) {
            group = Integer.parseInt(groupId);
        }
        long classId = 0L;
        if (!TextUtils.isEmpty((CharSequence)roomId)) {
            classId = Long.parseLong(roomId);
        }
        int type = 0;
        if (!TextUtils.isEmpty((CharSequence)userType)) {
            type = Integer.parseInt(userType);
        }
        LPUserModel userModel = new LPUserModel();
        userModel.name = userName;
        userModel.number = userNumber;
        userModel.type = LPConstants.LPUserType.from(type);
        userModel.groupId = group;
        userModel.avatar = userAvatar;
        LPSignEnterRoomModel signEnterRoomModel = new LPSignEnterRoomModel(classId, userModel, sign);
        signEnterRoomModel.customStr = customStr;
        signEnterRoomModel.replaceUserRole = replaceUserRole;
        signEnterRoomModel.replaceUserNumber = replaceUserNumber;
        return signEnterRoomModel;
    }

    public static Observable savePictureToGallery(Activity activity, String pictureUrl) {
        String permission2 = Build.VERSION.SDK_INT >= 33 ? "android.permission.READ_MEDIA_IMAGES" : "android.permission.WRITE_EXTERNAL_STORAGE";
        return AppPermissions.newPermissions((Activity)activity).request(new String[]{permission2}).filter(aBoolean -> {
            if (aBoolean.booleanValue()) {
                return true;
            }
            ToastCompat.showToast((Context)activity, (CharSequence)activity.getString(R.string.live_no_write_permission), (int)0);
            return false;
        }).observeOn(Schedulers.io()).map(aBoolean -> {
            File saveDir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), "bjhl_lp_image");
            if (!saveDir.exists()) {
                saveDir.mkdir();
            }
            boolean isGif = pictureUrl.endsWith(".gif");
            String fileName = System.currentTimeMillis() + (isGif ? ".gif" : ".jpg");
            File saveFile = new File(saveDir, fileName);
            File cacheFile = (File)Glide.with((Activity)activity).downloadOnly().load(pictureUrl).submit().get();
            FileUtils.copy(cacheFile, saveFile);
            MediaStore.Images.Media.insertImage((ContentResolver)activity.getContentResolver(), (String)saveFile.getAbsolutePath(), (String)fileName, null);
            return saveFile;
        }).observeOn(AndroidSchedulers.mainThread()).doOnNext(file -> ToastCompat.showToast((Context)activity, (CharSequence)activity.getString(R.string.bjy_base_pic_save_to_gallery), (int)0));
    }
}

