/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.utils;

import com.baijiayun.livebase.network.BJYWSServer;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import java.util.ArrayList;

public class LPWSResponseEmitter<T>
implements ObservableOnSubscribe<T> {
    private BJYWSServer server;
    private String responseKey;
    private Class<T> clazz;
    private boolean supportSmallBlackboard;
    private ArrayList<ObservableEmitter<T>> observableEmitterList;

    public LPWSResponseEmitter(BJYWSServer server, Class<T> clazz, String responseKey) {
        this(server, clazz, responseKey, false);
    }

    public LPWSResponseEmitter(BJYWSServer server, Class<T> clazz, String responseKey, boolean supportSmallBlackboard) {
        this.server = server;
        this.responseKey = responseKey;
        this.clazz = clazz;
        this.supportSmallBlackboard = supportSmallBlackboard;
        this.observableEmitterList = new ArrayList();
    }

    public void subscribe(ObservableEmitter<T> observableEmitter) {
        this.observableEmitterList.add(observableEmitter);
        BJYWSServer.OnResponseModelListener listener = new BJYWSServer.OnResponseModelListener<T>(){

            @Override
            public void onResponseModel(T model) {
                for (ObservableEmitter oe : LPWSResponseEmitter.this.observableEmitterList) {
                    oe.onNext(model);
                }
            }

            @Override
            public void onError(Exception e) {
                for (ObservableEmitter oe : LPWSResponseEmitter.this.observableEmitterList) {
                    oe.onError((Throwable)e);
                }
            }
        };
        this.server.registerResponseListenerAndModel(this.clazz, listener, this.responseKey);
        if (this.supportSmallBlackboard) {
            this.server.registerResponseListenerAndModel(this.clazz, listener, "s_" + this.responseKey);
        }
        observableEmitter.setCancellable(() -> {
            observableEmitter.onComplete();
            this.observableEmitterList.remove(observableEmitter);
            if (this.observableEmitterList.isEmpty()) {
                this.server.unregisterResponseListener(this.responseKey);
                if (this.supportSmallBlackboard) {
                    this.server.unregisterResponseListener("s_" + this.responseKey);
                }
            }
        });
    }
}

