/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.network.alilog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livebase.models.LPUserModel;
import com.baijiayun.livebase.utils.LimitedQueue;
import com.baijiayun.network.OkHttpClientSingleton;
import com.baijiayun.network.OkHttpHelper;
import com.baijiayun.network.interceptor.BJYHttpLoggingInterceptor;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;

public class AliYunLogHelper {
    private String customEnvironmentPrefix;
    private String videoId;
    private String sessionId;
    private String code;
    private String roomId;
    private String sign;
    private LPUserModel userModel;
    private int liveType;
    private final List<Map<String, String>> logListOfMap;
    private final List<Map<String, String>> backupLogList;
    private String userAgent;
    private Disposable timeDispose;
    private volatile boolean isReporting;
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());
    private final Date date = new Date();
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper(), msg -> {
        int logLev = msg.arg1;
        this.addLogs("", logLev, (String)msg.obj);
        return false;
    });
    private int logLevel = 1;
    private final LimitedQueue<String> crashMessageQueue = new LimitedQueue(10);
    private Gson gson;
    private OkHttpClient okHttpClient;
    private static final int MAX_LOGS_COUNT_ONCE = 200;
    private static final int LOG_REPORT_INTERVAL = 30;
    private static final String DEFAULT_HOST = "https://brtc-data-collection.baijiayun.com/collection/client/sdk_log";
    private String host = "https://brtc-data-collection.baijiayun.com/collection/client/sdk_log";

    private AliYunLogHelper() {
        this.logListOfMap = new ArrayList<Map<String, String>>();
        this.backupLogList = new ArrayList<Map<String, String>>();
        this.gson = new Gson();
        OkHttpClient.Builder builder = new OkHttpClient.Builder(OkHttpClientSingleton.getInstance());
        BJYHttpLoggingInterceptor loggingInterceptor = new BJYHttpLoggingInterceptor();
        this.okHttpClient = builder.addInterceptor((Interceptor)loggingInterceptor).build();
    }

    public static AliYunLogHelper getInstance() {
        return AliYunLogHelperHolder.aliYunLogHelper;
    }

    public void setConfig(String host, int logLevel) {
        if (!TextUtils.isEmpty((CharSequence)host)) {
            this.host = host;
        }
        this.logLevel = logLevel;
        this.openAutoReport();
    }

    public void setDefaultConfig(Context context) {
        File crashFile = new File(context.getExternalCacheDir(), "bjy_crash.txt");
        if (crashFile.exists()) {
            try (FileReader fileReader = new FileReader(crashFile);
                 BufferedReader bufferedReader = new BufferedReader(fileReader);){
                StringBuilder stringBuilder = new StringBuilder();
                String line = bufferedReader.readLine();
                while (line != null) {
                    stringBuilder.append(line);
                    stringBuilder.append("\n");
                    line = bufferedReader.readLine();
                }
                crashFile.delete();
                this.addCrashLog(stringBuilder.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.openAutoReport();
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setLiveRoomInfo(String roomId, String sign) {
        this.roomId = roomId;
        this.sign = sign;
    }

    public void setUserInfo(LPUserModel userModel) {
        this.userModel = userModel;
    }

    public AliYunLogHelper setPlaybackRoomInfo(String classId, String sessionId) {
        this.roomId = classId;
        this.sessionId = sessionId;
        return this;
    }

    public void setUserInfo(String userName, String userId) {
        this.userModel = new LPUserModel();
        this.userModel.userId = userId;
        this.userModel.name = userName;
    }

    public AliYunLogHelper setCustomDomain(String customDomain) {
        this.customEnvironmentPrefix = customDomain;
        return this;
    }

    public AliYunLogHelper setVideoId(String videoId) {
        this.videoId = videoId;
        return this;
    }

    public AliYunLogHelper setLiveType(int liveType) {
        this.liveType = liveType;
        return this;
    }

    public String getRoomInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        LimitedQueue<String> tempMessageQueue = new LimitedQueue<String>(20);
        tempMessageQueue.addAll(this.crashMessageQueue);
        for (String msg : tempMessageQueue) {
            stringBuilder.append(msg);
            stringBuilder.append("\n");
        }
        return "code=" + this.code + ", roomId=" + this.roomId + ", sign=" + this.sign + ", user=" + (this.userModel == null ? "null" : this.userModel.toString()) + "\n" + stringBuilder;
    }

    private void openAutoReport() {
        for (Map<String, String> map : this.logListOfMap) {
            this.fillUserInfo(map);
        }
        RxUtils.dispose((Disposable)this.timeDispose);
        this.timeDispose = Observable.interval((long)30L, (long)30L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> this.onBatchEvent(), throwable -> {});
    }

    public void addVerboseLog(String msg) {
        this.addLogs("", 0, msg);
    }

    public void addDebugLog(String msg) {
        this.addLogs("", 1, msg);
    }

    public void addDebugLog(String tag, String msg) {
        this.addLogs(tag, 1, msg);
    }

    public AliYunLogHelper addErrorLog(String msg) {
        return this.addLogs("", 2, msg);
    }

    public void addCrashLog(String crashMsg) {
        this.addLogs("", 3, crashMsg);
    }

    public void addMessageForCrash(String message) {
        this.crashMessageQueue.add(message);
    }

    @SuppressLint(value={"DefaultLocale"})
    private AliYunLogHelper addLogs(String tag, int logLevel, String msg) {
        if (logLevel < this.logLevel) {
            return this;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            if (logLevel <= 1) {
                LPLogger.d((String)tag, (String)msg);
            } else if (logLevel == 2) {
                LPLogger.e((String)tag, (String)msg);
            }
            HashMap<String, String> logMap = new HashMap<String, String>();
            String[] logTypeArray = new String[]{"verbose", "debug", "warn", "error"};
            logMap.put("type", "client_sdk_log");
            logMap.put("customDomain", this.customEnvironmentPrefix);
            logMap.put("userAgent", this.userAgent);
            logMap.put("infoLevel", logTypeArray[logLevel % logTypeArray.length]);
            logMap.put("platform", "Android");
            this.date.setTime(System.currentTimeMillis());
            logMap.put("timestamp", this.simpleDateFormat.format(this.date));
            logMap.put("liveType", String.valueOf(this.liveType));
            this.fillUserInfo(logMap);
            StringBuilder extraInfo = new StringBuilder();
            if (!TextUtils.isEmpty((CharSequence)this.sign)) {
                extraInfo.append("sign:");
                extraInfo.append(this.sign);
            }
            if (!TextUtils.isEmpty((CharSequence)extraInfo)) {
                logMap.put("extraInfo", extraInfo.toString());
            }
            logMap.put("msg", msg);
            if (this.isReporting) {
                if (this.backupLogList.size() <= 200) {
                    this.backupLogList.add(logMap);
                }
            } else if (this.logListOfMap.size() <= 200) {
                this.logListOfMap.add(logMap);
            }
        } else {
            Message message = Message.obtain();
            message.arg1 = logLevel;
            message.obj = msg;
            this.mainThreadHandler.sendMessage(message);
        }
        return this;
    }

    private void fillUserInfo(Map<String, String> logMap) {
        if (this.userModel != null) {
            logMap.put("userId", this.userModel.getUserId());
            logMap.put("userName", this.userModel.getName());
            logMap.put("userNumber", this.userModel.getNumber());
            logMap.put("userRole", String.valueOf((Object)this.userModel.type));
        }
        if (!TextUtils.isEmpty((CharSequence)this.code)) {
            logMap.put("code", this.code);
        }
        if (!TextUtils.isEmpty((CharSequence)this.roomId)) {
            logMap.put("roomId", this.roomId);
        } else {
            logMap.put("videoId", this.videoId);
        }
        if (!TextUtils.isEmpty((CharSequence)this.sessionId)) {
            logMap.put("sessionId", this.sessionId);
        }
    }

    private void onBatchEvent() {
        if (this.logListOfMap.isEmpty()) {
            return;
        }
        HashMap<String, List<Map<String, String>>> payLoad = new HashMap<String, List<Map<String, String>>>();
        payLoad.put("sdkLogs", this.logListOfMap);
        String params = this.gson.toJson(payLoad);
        this.isReporting = true;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        this.okHttpClient.newCall(OkHttpHelper.newPostCall((String)this.host, (RequestBody)OkHttpHelper.createWithJson((String)params), headers)).enqueue(new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NonNull Call call, @NonNull Response response) {
                try {
                    int code;
                    JsonObject jsonObject;
                    String responseString = response.body().string();
                    JsonElement jsonElement = JsonParser.parseString((String)responseString);
                    if (jsonElement.isJsonObject() && (jsonObject = jsonElement.getAsJsonObject()).has("code") && (code = jsonObject.get("code").getAsInt()) != 200) {
                        LPLogger.e((String)("upload fail" + responseString));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    AliYunLogHelper.this.mainThreadHandler.post(() -> {
                        AliYunLogHelper.this.logListOfMap.clear();
                        AliYunLogHelper.this.logListOfMap.addAll(AliYunLogHelper.this.backupLogList);
                        AliYunLogHelper.this.backupLogList.clear();
                        AliYunLogHelper.this.isReporting = false;
                    });
                }
            }

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                LPLogger.e((String)"upload fail");
                AliYunLogHelper.this.isReporting = false;
            }
        });
    }

    public void onDestroy() {
        RxUtils.dispose((Disposable)this.timeDispose);
        this.mainThreadHandler.removeCallbacksAndMessages(null);
        this.mainThreadHandler.postDelayed(() -> {
            if (!this.logListOfMap.isEmpty() || !this.backupLogList.isEmpty()) {
                this.logListOfMap.addAll(this.backupLogList);
                this.backupLogList.clear();
                this.onBatchEvent();
            }
        }, 500L);
    }

    private static final class AliYunLogHelperHolder {
        static final AliYunLogHelper aliYunLogHelper = new AliYunLogHelper();

        private AliYunLogHelperHolder() {
        }
    }
}

