/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyutils;

import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final String UTF_8 = "UTF-8";

    public static String encodeURL(String url, String encode) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        StringBuilder noAsciiPart = new StringBuilder();
        for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            if (c > '\u00ff') {
                noAsciiPart.append(c);
                continue;
            }
            if (noAsciiPart.length() != 0) {
                sb.append(URLEncoder.encode(noAsciiPart.toString(), encode));
                noAsciiPart.delete(0, noAsciiPart.length());
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static int string2Int(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return 0;
        }
        int ret = 0;
        try {
            ret = Integer.parseInt(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static long parseLong(String str, long defaultValue) {
        if (StringUtils.isEmpty(str)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException var4) {
            return defaultValue;
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isBlank(String str) {
        return str != null && StringUtils.isEmpty(str.trim());
    }

    public static boolean isNull(String str) {
        return str == null || "null".equalsIgnoreCase(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str) && !StringUtils.isNull(str);
    }

    public static String toString(int value) {
        return String.valueOf(value);
    }

    public static String toString(boolean value) {
        return String.valueOf(value);
    }

    public static String toString(double value) {
        return String.valueOf(value);
    }

    public static String toString(long value) {
        return String.valueOf(value);
    }

    public static SpannableString scoreSpannable(String content, int large, int small) {
        SpannableString spannableString = new SpannableString((CharSequence)content);
        if (large > 0 && small > 0) {
            int index = content.indexOf(".");
            int end = index > -1 ? index : 1;
            spannableString.setSpan((Object)new AbsoluteSizeSpan(large), 0, end, 33);
            spannableString.setSpan((Object)new AbsoluteSizeSpan(small), end, spannableString.length(), 33);
        }
        return spannableString;
    }

    public static String nullStrToEmpty(Object str) {
        if (str == null) {
            return "";
        }
        return str instanceof String ? (String)str : str.toString();
    }

    public static String capitalizeFirstLetter(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char c = str.charAt(0);
        return Character.isLetter(c) && !Character.isUpperCase(c) ? Character.toUpperCase(c) + str.substring(1) : str;
    }

    public static String utf8Encode(String str) {
        if (!StringUtils.isEmpty(str) && str.getBytes().length != str.length()) {
            try {
                return URLEncoder.encode(str, UTF_8);
            }
            catch (UnsupportedEncodingException var2) {
                throw new RuntimeException("UnsupportedEncodingException occurred. ", var2);
            }
        }
        return str;
    }

    public static String utf8Encode(String str, String defultReturn) {
        if (!StringUtils.isEmpty(str) && str.getBytes().length != str.length()) {
            try {
                return URLEncoder.encode(str, UTF_8);
            }
            catch (UnsupportedEncodingException var3) {
                return defultReturn;
            }
        }
        return str;
    }

    public static String htmlEscapeCharsToString(String source) {
        return StringUtils.isEmpty(source) ? source : source.replace("&lt;", "<").replace("&gt;", ">").replace("&amp;", "&").replace("&quot;", "\"");
    }

    public static String halfWidthToFullWidth(String s) {
        if (StringUtils.isEmpty(s)) {
            return s;
        }
        char[] source = s.toCharArray();
        for (int i = 0; i < source.length; ++i) {
            if (source[i] == ' ') {
                source[i] = 12288;
                continue;
            }
            if (source[i] < '!' || source[i] > '~') continue;
            int n = i;
            source[n] = (char)(source[n] + 65248);
        }
        return new String(source);
    }

    public static String getLastSplit(String org, String split) {
        return TextUtils.isEmpty((CharSequence)org) ? "" : org.substring(org.lastIndexOf(split) + 1);
    }

    public static boolean isMobileNumber(String mobiles) {
        Pattern p = Pattern.compile("((\\d{11})|^((\\d{7,8})|(\\d{4}|\\d{3})-(\\d{7,8})|(\\d{4}|\\d{3})-(\\d{7,8})-(\\d{4}|\\d{3}|\\d{2}|\\d{1})|(\\d{7,8})-(\\d{4}|\\d{3}|\\d{2}|\\d{1}))$)");
        Matcher m = p.matcher(mobiles);
        return m.matches();
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static String getLast2Chars(String input) {
        if (TextUtils.isEmpty((CharSequence)input) || input.length() <= 2) {
            return input;
        }
        return input.substring(input.length() - 2);
    }

    public static String getLimitedLengthString(String originString, int limitLength) {
        if (TextUtils.isEmpty((CharSequence)originString)) {
            return "";
        }
        if (originString.length() <= limitLength) {
            return originString;
        }
        return originString.substring(0, limitLength);
    }
}

