/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyrtcengine;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.View;
import com.baijiayun.bjyrtcengine.BJYRtcEngine;
import com.baijiayun.bjyrtcengine.BJYRtcEventObserver;
import com.baijiayun.bjyrtcengine.BRTCAdapter;
import com.baijiayun.bjyrtcengine.BaseAdapter;
import com.baijiayun.bjyrtcengine.Defines.BJYRtcCommon;
import com.baijiayun.bjyrtcengine.Defines.BJYRtcErrors;
import com.baijiayun.bjyrtcengine.TcAdapter;
import com.baijiayun.bjyrtcengine.Tools.AppRTCPhoneListener;
import com.baijiayun.bjyrtcengine.Tools.DeviceInfoHelper;
import com.baijiayun.utils.LogUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.brtc.sdk.BRTCListener;

public class BJYRtcEngineImpl
extends BJYRtcEngine {
    private static final String TAG = "bjyrtc-BJYRtcEngineImpl";
    private static final int API_31 = 31;
    private boolean mInit = false;
    private boolean mPhoneCallIned = false;
    TelephonyManager telephonyManager = null;
    private AppRTCPhoneListener callPhoneListener = null;
    private AppRTCPhoneListener.PhoneStateListener callPhoneStateListener = null;
    private Context mContext;

    BJYRtcEngineImpl() {
    }

    private static boolean hasPermission(Context context, String string) {
        return context.checkPermission(string, Process.myPid(), Process.myUid()) == 0;
    }

    private void initPhoneListener() {
        LogUtil.d((Object)TAG, (String)"Init phone call listener.");
        this.callPhoneListener = null;
        LogUtil.d((Object)TAG, (String)"Phone call listener is null.");
        this.callPhoneStateListener = new AppRTCPhoneListener.PhoneStateListener(){

            @Override
            public void onPhoneStateChanged(AppRTCPhoneListener.PHONESTATE object) {
                LogUtil.d((Object)BJYRtcEngineImpl.TAG, (String)("Receive phone call state changed: " + object));
                BJYRtcEngineImpl bJYRtcEngineImpl = bJYRtcEngineImpl2.BJYRtcEngineImpl.this;
                if (bJYRtcEngineImpl.mEngineAdapter != null) {
                    if (object == AppRTCPhoneListener.PHONESTATE.PHONE_STATE_HANGUP) {
                        BJYRtcEngineImpl.access$002(bJYRtcEngineImpl, false);
                        bJYRtcEngineImpl2.BJYRtcEngineImpl.this.mEngineAdapter.phoneStateChanged(false);
                    } else if (object == AppRTCPhoneListener.PHONESTATE.PHONE_STATE_CONNECT) {
                        BJYRtcEngineImpl.access$002(bJYRtcEngineImpl, true);
                        bJYRtcEngineImpl2.BJYRtcEngineImpl.this.mEngineAdapter.phoneStateChanged(true);
                    }
                }
                BJYRtcEngineImpl bJYRtcEngineImpl2 = bJYRtcEngineImpl2.BJYRtcEngineImpl.this;
                object = bJYRtcEngineImpl2.mObserver;
                if (object != null) {
                    ((BJYRtcEventObserver)object).onPhoneStatus(bJYRtcEngineImpl2.mPhoneCallIned);
                }
            }
        };
        LogUtil.d((Object)TAG, (String)"Create phone call listener.");
        BJYRtcEngineImpl bJYRtcEngineImpl = this;
        Context context = bJYRtcEngineImpl.mContext;
        this.callPhoneListener = new AppRTCPhoneListener(context, bJYRtcEngineImpl.callPhoneStateListener);
        if (this.telephonyManager == null && (Build.VERSION.SDK_INT < 31 || this.mContext.checkSelfPermission("android.permission.READ_PHONE_STATE") == 0)) {
            context = (TelephonyManager)this.mContext.getSystemService("phone");
            this.telephonyManager = context;
            context.listen((PhoneStateListener)this.callPhoneListener, 32);
        }
    }

    static /* synthetic */ boolean access$002(BJYRtcEngineImpl bJYRtcEngineImpl, boolean bl) {
        bJYRtcEngineImpl.mPhoneCallIned = bl;
        return bl;
    }

    @Override
    public boolean initEngine(Context object, Map<String, Object> map) {
        if (this.mInit) {
            LogUtil.w((Object)TAG, (String)"Engine had been initialized");
            return true;
        }
        super.initEngine((Context)object, map);
        this.mContext = object.getApplicationContext();
        DeviceInfoHelper.printDeviceInfo();
        DeviceInfoHelper.printMediaCodecInfo();
        object = TAG;
        StringBuilder stringBuilder = new StringBuilder().append("begin init Engine...");
        String string = this.mEngineAdapter == null ? "null" : "not null";
        LogUtil.i((Object)object, (String)stringBuilder.append(string).append(" engine type: ").append((Object)this.getEngineType()).toString());
        if (this.getEngineType() == BJYRtcCommon.BJYEngineType.BJY_ENGINE_TYPE_TENCENT) {
            LogUtil.i((Object)TAG, (String)"Create Tencent Adapter.");
            this.mEngineAdapter = new TcAdapter(this.mContext);
        } else {
            if (this.getEngineType() != BJYRtcCommon.BJYEngineType.BJY_ENGINE_TYPE_BRTC_TRTC && this.getEngineType() != BJYRtcCommon.BJYEngineType.BJY_ENGINE_TYPE_BRTC_VLOUD) {
                return false;
            }
            LogUtil.i((Object)TAG, (String)"Create BRTC Adapter.");
            this.mEngineAdapter = new BRTCAdapter(this.mContext);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mExternalExtraParams)) {
            map.put("extra_params", this.mExternalExtraParams);
        }
        if (!this.mEngineAdapter.initEngine(map)) {
            return false;
        }
        LogUtil.i((Object)TAG, (String)("init Engine finished, version:" + this.getSdkVersion()));
        this.initPhoneListener();
        this.mInit = true;
        return true;
    }

    @Override
    public boolean setBlockConfig(List<Map<String, Object>> list) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter == null) {
            return false;
        }
        baseAdapter.setBlockConfig(list);
        return true;
    }

    @Override
    public String getSdkVersion() {
        if (this.mEngineAdapter != null) {
            LogUtil.i((Object)TAG, (String)("SDK version:" + this.mEngineAdapter.getSdkVersion()));
            return this.mEngineAdapter.getSdkVersion();
        }
        LogUtil.e((Object)TAG, (String)"engine Adapter is null.");
        return "null EngineAdapter";
    }

    @Override
    public void dispose() {
        LogUtil.i((Object)TAG, (String)"dispose BJYRtcEngine");
        TelephonyManager telephonyManager = this.telephonyManager;
        if (telephonyManager != null) {
            telephonyManager.listen((PhoneStateListener)this.callPhoneListener, 0);
            this.telephonyManager = null;
        }
        this.callPhoneStateListener = null;
        this.callPhoneListener = null;
        this.mObserver = null;
        if (this.mEngineAdapter != null) {
            LogUtil.i((Object)TAG, (String)"engine adapter dispose.");
            this.mEngineAdapter.dispose();
            this.mEngineAdapter = null;
        }
        this.mInit = false;
        System.gc();
    }

    @Override
    public String getMediaServers() {
        if (this.mEngineAdapter != null) {
            LogUtil.d((Object)TAG, (String)"get media servers address.");
            return this.mEngineAdapter.getMediaServers();
        }
        return null;
    }

    @Override
    public void switchMediaServer(String string) {
        if (this.mEngineAdapter != null) {
            LogUtil.i((Object)TAG, (String)("switch media server to " + string));
            this.mEngineAdapter.switchMediaServer(string);
        }
    }

    @Override
    public int joinRoom(Map<String, Object> map) {
        LogUtil.i((Object)TAG, (String)"start to join room.");
        if (map.isEmpty() && ((BJYRtcEngine)this).mObserver != null) {
            LogUtil.e((Object)TAG, (String)"roomInfo is empty.");
            ((BJYRtcEngine)this).mObserver.onOccurError(BJYRtcErrors.INVALID_PARAMS);
            return -1;
        }
        if (!((BJYRtcEngineImpl)this).mInit && ((BJYRtcEngine)this).mObserver != null) {
            LogUtil.e((Object)TAG, (String)"engine is not initialized when join room.");
            ((BJYRtcEngine)this).mObserver.onOccurError(BJYRtcErrors.ENGINE_NOT_INITIALIZED);
        }
        if ((this = ((BJYRtcEngine)this).mEngineAdapter) != null) {
            return ((BaseAdapter)this).joinRoom(map);
        }
        return -1;
    }

    @Override
    public void publish(boolean bl, boolean bl2) {
        if (this.mEngineAdapter != null) {
            LogUtil.i((Object)TAG, (String)("publish, audio:" + bl + " video:" + bl2 + ", The adapter is " + this.mEngineAdapter.hashCode()));
        }
        if (!this.mInit && this.mObserver != null) {
            LogUtil.e((Object)TAG, (String)"engine is not initialized when publish.");
            this.mObserver.onOccurError(BJYRtcErrors.ENGINE_NOT_INITIALIZED);
            return;
        }
        BaseAdapter baseAdapter = this.mEngineAdapter;
        if (baseAdapter != null && !baseAdapter.isPublished()) {
            this.mEngineAdapter.publish(bl, bl2);
        }
    }

    @Override
    public void unpublish() {
        if (this.mEngineAdapter != null) {
            LogUtil.d((Object)TAG, (String)("unpublish local stream.+The adapter is " + this.mEngineAdapter.hashCode()));
        }
        if (!this.mInit && this.mObserver != null) {
            LogUtil.e((Object)TAG, (String)"engine is not initialized when unpublish.");
            this.mObserver.onOccurError(BJYRtcErrors.ENGINE_NOT_INITIALIZED);
            return;
        }
        BaseAdapter baseAdapter = this.mEngineAdapter;
        if (baseAdapter != null && baseAdapter.isPublished()) {
            this.mEngineAdapter.unpublish();
        }
    }

    @Override
    public boolean isFrontCamera() {
        if (this.mEngineAdapter != null) {
            LogUtil.d((Object)TAG, (String)("current camera is front:" + this.mEngineAdapter.isFrontCamera()));
            return this.mEngineAdapter.isFrontCamera();
        }
        return true;
    }

    @Override
    public boolean getRemoteStreamStatus(String string, int n) {
        if (this.mEngineAdapter != null) {
            LogUtil.d((Object)TAG, (String)("remote stream uid:" + string + " status:" + this.mEngineAdapter.getRemoteStreamStatus(string, n)));
            return this.mEngineAdapter.getRemoteStreamStatus(string, n);
        }
        return false;
    }

    @Override
    public void subscribe(String string, boolean bl, boolean bl2, int n) {
        if (((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter != null) {
            LogUtil.i((Object)TAG, (String)("subscribe stream:" + string + "(a:" + bl + ",v:" + bl2 + "), session type:" + n + "The adapter is " + ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter.hashCode()));
        }
        if (!((BJYRtcEngineImpl)((Object)baseAdapter)).mInit && ((BJYRtcEngine)((Object)baseAdapter)).mObserver != null) {
            LogUtil.e((Object)TAG, (String)"engine is not initialized when subscribe.");
            ((BJYRtcEngine)((Object)baseAdapter)).mObserver.onOccurError(BJYRtcErrors.ENGINE_NOT_INITIALIZED);
            return;
        }
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.subscribe(string, bl, bl2, n);
        }
    }

    @Override
    public void unsubscribe(String string, int n) {
        LogUtil.i((Object)TAG, (String)("unsubscribe stream:" + string + ", session type:" + n));
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.unsubscribe(string, n);
        }
    }

    @Override
    public void play(String string, BJYRtcEngine.BJYVideoCanvas bJYVideoCanvas, int n) {
        LogUtil.i((Object)TAG, (String)("play stream:" + string + ", session type:" + n + ", adapter is " + ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter.getName()));
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            try {
                baseAdapter.play(string, bJYVideoCanvas, n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public boolean isPublished() {
        if (this.mEngineAdapter != null) {
            LogUtil.d((Object)TAG, (String)("isPublished:" + this.mEngineAdapter.isPublished()));
            return this.mEngineAdapter.isPublished();
        }
        return false;
    }

    @Override
    public boolean isAudioAttached() {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            return baseAdapter.isAudioAttached();
        }
        return false;
    }

    @Override
    public boolean isVideoAttached() {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            return baseAdapter.isVideoAttached();
        }
        return false;
    }

    @Override
    public void setVideoResolution(int n) {
        if (this.mEngineAdapter != null) {
            LogUtil.i((Object)TAG, (String)("wanted video resolution by level: " + n));
            this.mEngineAdapter.changeVideoResolutionByLevel(n);
        }
    }

    @Override
    public void setVideoResolution(int n, int n2) {
        if (this.mEngineAdapter != null) {
            LogUtil.i((Object)TAG, (String)("wanted video resolution [" + n + "x" + n2 + "]"));
            this.mEngineAdapter.changeVideoResolutionByLevel(n, n2);
        }
    }

    @Override
    public BJYRtcEngine.BJYVideoResolution getVideoResolution() {
        Object object = ((BJYRtcEngine)object).mEngineAdapter;
        if (object != null && (object = ((BaseAdapter)object).getVideoResolution()) != null) {
            return object;
        }
        return null;
    }

    @Override
    public int muteLocalMic(boolean bl) {
        LogUtil.i((Object)TAG, (String)("mute local mic:" + bl));
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            return baseAdapter.muteLocalMic(bl);
        }
        return -1;
    }

    @Override
    public int muteLocalCamera(boolean bl) {
        LogUtil.i((Object)TAG, (String)("mute local camera:" + bl));
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            return baseAdapter.muteLocalCamera(bl);
        }
        return -1;
    }

    @Override
    public int enableSpeakerphone(boolean bl) {
        LogUtil.i((Object)TAG, (String)("enable speaker phone:" + bl));
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            return baseAdapter.enableSpeakerphone(bl);
        }
        return -1;
    }

    @Override
    public int switchCamera() {
        LogUtil.i((Object)TAG, (String)"switch camera.");
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            return baseAdapter.switchCamera();
        }
        return -1;
    }

    @Override
    public boolean checkH264VideoCodecSupported() {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            return baseAdapter.isH264VideoCodecSupported();
        }
        return false;
    }

    @Override
    public void setRtcEngineObserver(BJYRtcEventObserver bJYRtcEventObserver) {
        LogUtil.d((Object)TAG, (String)("set rtcEngine observer:" + bJYRtcEventObserver));
        ((BJYRtcEngine)((Object)baseAdapter)).mObserver = bJYRtcEventObserver;
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.setRtcEngineObserver(bJYRtcEventObserver);
        }
    }

    @Override
    public void setAudioFrameListener(BRTCListener.BRTCAudioFrameListener bRTCAudioFrameListener) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.setAudioFrameListener(bRTCAudioFrameListener);
        }
    }

    @Override
    public void startPreview(BJYRtcEngine.BJYVideoCanvas bJYVideoCanvas) {
        this.startPreview(true, bJYVideoCanvas);
    }

    @Override
    public void startPreview(boolean bl, BJYRtcEngine.BJYVideoCanvas bJYVideoCanvas) {
        Object object;
        LogUtil.i((Object)TAG, (String)"start preview.");
        if (!((BJYRtcEngineImpl)object).mInit && ((BJYRtcEngine)object).mObserver != null) {
            LogUtil.e((Object)TAG, (String)"engine is not initialized when start preview.");
            ((BJYRtcEngine)object).mObserver.onOccurError(BJYRtcErrors.ENGINE_NOT_INITIALIZED);
            return;
        }
        if (bJYVideoCanvas == null && ((BJYRtcEngine)object).mObserver != null) {
            LogUtil.e((Object)TAG, (String)"canvas is null when start preview.");
            ((BJYRtcEngine)object).mObserver.onOccurError(BJYRtcErrors.INVALID_PARAMS);
            return;
        }
        if (!BJYRtcEngineImpl.hasPermission(((BJYRtcEngineImpl)object).mContext, "android.permission.CAMERA")) {
            LogUtil.e((Object)TAG, (String)"camera no permission.");
            object = ((BJYRtcEngine)object).mObserver;
            if (object != null) {
                ((BJYRtcEventObserver)object).onOccurError(BJYRtcErrors.NOT_CAMERA_PERMISSION);
            }
        } else {
            object = ((BJYRtcEngine)object).mEngineAdapter;
            if (object != null) {
                ((BaseAdapter)object).startPreview(bl, bJYVideoCanvas);
            }
        }
    }

    @Override
    public void stopPreview() {
        LogUtil.i((Object)TAG, (String)"stop preview.");
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            try {
                baseAdapter.stopPreview();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public BJYRtcEngine.BJYVideoCanvas createVideoCanvas(String string, boolean bl) {
        LogUtil.d((Object)TAG, (String)"create video canvas.");
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            return baseAdapter.createVideoCanvas(string, bl);
        }
        return null;
    }

    @Override
    public void muteRemoteAudio(String string, boolean bl, int n) {
        LogUtil.i((Object)TAG, (String)("remote audio:" + string + " is mute:" + bl + ", session type:" + n));
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.muteRemoteAudio(string, bl, n);
        }
    }

    @Override
    public void muteRemoteVideo(String string, boolean bl, int n) {
        LogUtil.i((Object)TAG, (String)("mute remote video:" + string + ", session type:" + n + ", mute:" + bl));
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.muteRemoteVideo(string, bl, n);
        }
    }

    @Override
    public void unmuteRemoteVideo(String string, BJYRtcEngine.BJYVideoCanvas bJYVideoCanvas, int n) {
        LogUtil.i((Object)TAG, (String)("unmute remote video:" + string + ", session type:" + n));
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.unmuteRemoteVideo(string, bJYVideoCanvas, n);
        }
    }

    @Override
    public void muteAllRemoteAudio(boolean bl) {
        LogUtil.i((Object)TAG, (String)("all remote audio is mute:" + bl));
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.muteAllRemoteAudio(bl);
        }
    }

    @Override
    public void muteAllRemoteVideo(boolean bl) {
        LogUtil.i((Object)TAG, (String)("all remote video is mute:" + bl));
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.muteAllRemoteVideo(bl);
        }
    }

    @Override
    public void saveScreenshot(String string, int n) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            try {
                baseAdapter.saveScreenshot(string, n);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public void enableLogReport(boolean bl) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.enableLogReport(bl);
        }
    }

    @Override
    public void setRtcLagConfigs(int n, int n2, int n3, int n4) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter instanceof TcAdapter) {
            baseAdapter.setRtcLagConfigs(n, n2, n3, n4);
        }
    }

    @Override
    public void setLocalVideoMirror(BJYRtcCommon.VideoMirrorMode videoMirrorMode) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.setLocalVideoMirror(videoMirrorMode);
        }
    }

    @Override
    public int enableDualStreamMode(boolean bl) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            return baseAdapter.enableDualStreamMode(bl);
        }
        return -1;
    }

    @Override
    public int setRemoteVideoStreamType(String string, int n, BJYRtcCommon.DualStreamType dualStreamType) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            return baseAdapter.setRemoteVideoStreamType(string, n, dualStreamType);
        }
        return -1;
    }

    @Override
    public int setRemoteDefaultVideoStreamType(BJYRtcCommon.DualStreamType dualStreamType) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            return baseAdapter.setRemoteDefaultVideoStreamType(dualStreamType);
        }
        return -1;
    }

    @Override
    public void setEncVideoMirrorMode(BJYRtcCommon.VideoMirrorMode videoMirrorMode) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.setEncVideoMirrorMode(videoMirrorMode);
        }
    }

    @Override
    public void setEncVideoMirrorModeLandScape(boolean bl) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.setEncVideoMirrorModeLandScape(bl);
        }
    }

    @Override
    public BJYRtcCommon.VideoMirrorMode getEncVideoMirrorMode() {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            return baseAdapter.getEncVideoMirrorMode();
        }
        return BJYRtcCommon.VideoMirrorMode.AUTO_MIRROR;
    }

    @Override
    public void setVideoResolutionMode(BJYRtcCommon.VideoResolutionMode videoResolutionMode) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.setVideoResolutionMode(videoResolutionMode);
        }
    }

    @Override
    public void setLocalViewRotation(BJYRtcCommon.VideoRotation videoRotation) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.setLocalViewRotation(videoRotation);
        }
    }

    @Override
    public void setVideoEncoderRotation(BJYRtcCommon.VideoRotation videoRotation) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.setVideoEncoderRotation(videoRotation);
        }
    }

    @Override
    public void startScreenCapture(int n, int n2, View view) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.startScreenCapture(n, n2, view);
        }
    }

    @Override
    public void stopScreenCapture() {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.stopScreenCapture();
        }
    }

    @Override
    public void stopScreenCapture(boolean bl) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.stopScreenCapture(bl);
        }
    }

    @Override
    public void pauseScreenCapture() {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.pauseScreenCapture();
        }
    }

    @Override
    public void resumeScreenCapture() {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.resumeScreenCapture();
        }
    }

    @Override
    public void setBeautyLevel(float f) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.setBeautyLevel(f);
        }
    }

    @Override
    public void setWhitenessLevel(float f) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.setWhitenessLevel(f);
        }
    }

    @Override
    public void changeMusicMode(boolean bl) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.changeMusicMode(bl);
        }
    }

    @Override
    public boolean isMusicModeOn() {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            return baseAdapter.isMusicModeOn();
        }
        return false;
    }

    @Override
    public void setDefaultStreamRecvMode(boolean bl, boolean bl2) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.setDefaultStreamRecvMode(bl, bl2);
        }
    }

    @Override
    public void callExperimentalApi(String string) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.callExperimentalApi(string);
        }
    }

    @Override
    public void setNetworkQosPreference(int n, BJYRtcCommon.NetworkQosPreference networkQosPreference) {
        BaseAdapter baseAdapter = ((BJYRtcEngine)((Object)baseAdapter)).mEngineAdapter;
        if (baseAdapter != null) {
            baseAdapter.setNetworkQosPreference(n, networkQosPreference);
        }
    }
}

