/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyrtcengine.player;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.ViewGroup;
import com.baijiayun.bjyrtcengine.player.MediaPlayer;
import com.baijiayun.bjyrtcengine.player.MediaPlayerObserver;
import com.baijiayun.bjyrtcengine.player.RtmpError;
import com.baijiayun.bjyrtcengine.player.RtmpEventObserver;
import com.baijiayun.bjyrtcengine.player.RtmpView;
import com.baijiayun.bjyrtcengine.player.StreamQualityRtmp;
import com.baijiayun.bjyrtcengine.player.SurfaceRenderView;
import com.baijiayun.utils.LogUtil;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class RtmpEngine
implements StreamQualityRtmp.StreamQualityRtmpEvent {
    private static final String TAG = "bjyrtc-BJYRtmpEngine";
    private static RtmpEngine mInstance;
    private static Context mContext;
    private ConcurrentHashMap<String, MediaPlayer> mediaPlayerList = new ConcurrentHashMap();
    private HashMap<String, MediaPlayer.AVParameters> mAVParams = new HashMap();
    private ConcurrentHashMap<String, StreamQualityRtmp> mRemoteCalculator = new ConcurrentHashMap();
    private RtmpEventObserver mRtmpEventObserver = null;
    private float mBufferTcp;
    private int mDisplayMode = 0;
    private int restartTimes = 0;
    private Handler handler = new Handler(Looper.getMainLooper());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RtmpEngine getInstance(Context context) {
        if (mInstance != null) return mInstance;
        Class<RtmpEngine> clazz = RtmpEngine.class;
        synchronized (clazz) {
            mContext = context.getApplicationContext();
            mInstance = new RtmpEngine();
            // ** MonitorExit[com.baijiayun.bjyrtcengine.player.RtmpEngine.class] (shouldn't be in output)
            return mInstance;
        }
    }

    public void setRtmpEngineObserver(RtmpEventObserver rtmpEventObserver) {
        this.mRtmpEventObserver = rtmpEventObserver;
    }

    public void playAV(String string, String object, boolean bl, boolean bl2, RtmpView rtmpView, int n) {
        System.currentTimeMillis();
        LogUtil.i((Object)TAG, (String)("playAV, uid=" + string + ", url=" + (String)object + ", a=" + bl + ", v=" + bl2 + ", sessionType=" + n + ", canvas=" + rtmpView));
        if (object != null && !((String)object).isEmpty() && (bl || bl2)) {
            StreamQualityRtmp streamQualityRtmp;
            MediaPlayer mediaPlayer;
            MediaPlayer.AVParameters aVParameters;
            Object object2;
            if (((RtmpEngine)((Object)rtmpEventObserver)).mediaPlayerList.containsKey(string)) {
                object2 = ((RtmpEngine)((Object)rtmpEventObserver)).mediaPlayerList.get(string);
                LogUtil.w((Object)TAG, (String)("Exist player, current state=" + (Object)((Object)((MediaPlayer)object2).getState())));
                if (((MediaPlayer)object2).getState() == MediaPlayer.PLAYER_STATE.CREATING) {
                    LogUtil.w((Object)TAG, (String)("Previous player[uid=" + string + "] is creating, discard this playAV action"));
                    ((MediaPlayer)object2).setRenderView(rtmpView);
                    return;
                }
                StreamQualityRtmp streamQualityRtmp2 = ((RtmpEngine)((Object)rtmpEventObserver)).mRemoteCalculator.get(string);
                if (streamQualityRtmp2 != null) {
                    streamQualityRtmp2.stopCheckFreeze();
                    ((RtmpEngine)((Object)rtmpEventObserver)).mRemoteCalculator.remove(string);
                }
                RtmpEventObserver rtmpEventObserver = rtmpEventObserver;
                ((MediaPlayer)object2).dispose();
                ((RtmpEngine)((Object)rtmpEventObserver)).mediaPlayerList.remove(string);
                ((RtmpEngine)((Object)rtmpEventObserver)).mAVParams.remove(string);
            }
            LogUtil.i((Object)TAG, (String)"Create a new bjy media player");
            object2 = aVParameters;
            float f = ((RtmpEngine)((Object)rtmpEventObserver)).mBufferTcp;
            aVParameters = new MediaPlayer.AVParameters(string, (String)object, rtmpView, n, bl, bl2, false, f);
            Object object3 = object = mediaPlayer;
            ((MediaPlayer)object3)((MediaPlayer.AVParameters)object2);
            ((MediaPlayer)object3).enableMediaCodec(false);
            ((MediaPlayer)object).setRenderView(rtmpView);
            mediaPlayer.setMixedStreamDisplayMode(((RtmpEngine)((Object)rtmpEventObserver)).mDisplayMode);
            if (!mediaPlayer.init(mContext)) {
                LogUtil.e((Object)TAG, (String)"Failed to init bjy media player");
                return;
            }
            Object object4 = rtmpEventObserver;
            ((MediaPlayer)object).setObserver(new MediaPlayerObserver(){
                final /* synthetic */ MediaPlayer val$player;
                final /* synthetic */ String val$uid;
                final /* synthetic */ int val$sType;
                {
                    this.val$player = mediaPlayer;
                    this.val$uid = string;
                    this.val$sType = n;
                }

                @Override
                public void onPrepared() {
                    LogUtil.i((Object)RtmpEngine.TAG, (String)("~ bjy media player prepared ~ video size: " + string2.val$player.getVideoWidth() + "x" + string2.val$player.getVideoHeight()));
                    if (string2.RtmpEngine.this.mRtmpEventObserver != null) {
                        1 v0 = string2;
                        1 v1 = string2;
                        String string = v1.val$uid;
                        v0.RtmpEngine.this.mRtmpEventObserver.onRemoteVideoAvailable(string, v1.val$sType);
                        1 v2 = string2;
                        String string2 = v2.val$uid;
                        v0.RtmpEngine.this.mRtmpEventObserver.onFirstFrameAvailable(string2, v2.val$sType);
                    }
                }

                @Override
                public void onError(int n, int n2) {
                    RtmpEngine.this.handler.postDelayed(() -> {
                        LogUtil.e((Object)RtmpEngine.TAG, (String)("pull stream error what=" + n + ", extra=" + n2 + ", auto close and pull again restartTimes=" + RtmpEngine.this.restartTimes));
                        if (RtmpEngine.this.restartTimes++ < 5) {
                            1 v0 = this;
                            LogUtil.w((Object)RtmpEngine.TAG, (String)"pull stream error, retry");
                            v0.RtmpEngine.this.stopOrRestartAvStream(true, this.val$uid);
                            v0.RtmpEngine.this.stopOrRestartAvStream(false, this.val$uid);
                        } else if (RtmpEngine.this.mRtmpEventObserver != null) {
                            RtmpEngine.this.mRtmpEventObserver.onOccurError(RtmpError.getNewError(-73), this.val$uid);
                        }
                    }, (long)RtmpEngine.this.restartTimes * 1000L + 1000L);
                }

                @Override
                public void onVideoSizeChanged(int n, int n2) {
                    LogUtil.i((Object)RtmpEngine.TAG, (String)("rtmp stream video size changed to: " + n + "x" + n2));
                    if (RtmpEngine.this.mRtmpEventObserver != null) {
                        1 v0 = this;
                        int n3 = v0.val$sType;
                        String string = v0.val$player.getId();
                        RtmpEngine.this.mRtmpEventObserver.onFrameResolutionChanged(n, n2, 0, n3, string);
                    }
                }

                @Override
                public void onCompletion() {
                    if (string.RtmpEngine.this.mRtmpEventObserver != null) {
                        1 v0 = string;
                        String string = v0.val$player.getId();
                        string.RtmpEngine.this.mRtmpEventObserver.onCompletion(string, v0.val$sType);
                    }
                }

                @Override
                public void onSeekComplete() {
                    if (string.RtmpEngine.this.mRtmpEventObserver != null) {
                        1 v0 = string;
                        String string = v0.val$player.getId();
                        string.RtmpEngine.this.mRtmpEventObserver.onSeekComplete(string, v0.val$sType);
                    }
                }

                @Override
                public void onBufferingUpdate(int n) {
                    if (string.RtmpEngine.this.mRtmpEventObserver != null) {
                        1 v0 = string;
                        String string = v0.val$player.getId();
                        string.RtmpEngine.this.mRtmpEventObserver.onBufferingUpdate(string, v0.val$sType, n);
                    }
                }
            });
            ((RtmpEngine)object4).mediaPlayerList.put(string, (MediaPlayer)object);
            ((RtmpEngine)object4).mAVParams.put(string, (MediaPlayer.AVParameters)object2);
            StreamQualityRtmp streamQualityRtmp3 = streamQualityRtmp;
            streamQualityRtmp3(string, (MediaPlayer)object);
            streamQualityRtmp.addStreamQualityRtmpEvent((StreamQualityRtmp.StreamQualityRtmpEvent)((Object)rtmpEventObserver));
            streamQualityRtmp.startCheckFreeze();
            ((RtmpEngine)object4).mRemoteCalculator.put(string, streamQualityRtmp3);
            return;
        }
        RtmpEventObserver rtmpEventObserver = ((RtmpEngine)((Object)rtmpEventObserver)).mRtmpEventObserver;
        if (rtmpEventObserver != null) {
            rtmpEventObserver.onOccurError(RtmpError.getNewError(-6), string);
        }
    }

    public void playAVClose(String string, int n) {
        JsonObject jsonObject;
        System.currentTimeMillis();
        JsonObject jsonObject2 = jsonObject;
        new JsonObject().addProperty("mixStreamId", string);
        if (this.mAVParams.get(string) != null) {
            jsonObject2.addProperty("url", this.mAVParams.get((Object)string).url);
        }
        LogUtil.i((Object)TAG, (String)("playAVClose, uid=" + string + ", sessionType=" + n + ", player size=" + this.mediaPlayerList.size()));
        if (this.mediaPlayerList.isEmpty()) {
            return;
        }
        Object object = this.mRemoteCalculator.get(string);
        if (object != null) {
            ((StreamQualityRtmp)object).stopCheckFreeze();
            this.mRemoteCalculator.remove(string);
        }
        if ((object = this.mediaPlayerList.get(string)) != null) {
            ((MediaPlayer)object).dispose();
            this.mediaPlayerList.remove(string);
            LogUtil.d((Object)TAG, (String)("remove mediaPlayerList key=" + string));
        }
        RtmpEngine rtmpEngine = this;
        rtmpEngine.mediaPlayerList.remove(string);
        rtmpEngine.mAVParams.remove(string);
    }

    public void stopOrRestartAvStream(boolean bl, String string) {
        System.currentTimeMillis();
        LogUtil.i((Object)TAG, (String)("stopOrRestartAvStream, stop:" + bl + ", uid:" + string + ", av params size:" + this.mAVParams.size()));
        for (String string2 : this.mAVParams.keySet()) {
            JsonObject jsonObject;
            Object object = jsonObject;
            jsonObject = new JsonObject();
            if (this.mAVParams.get(string2) != null) {
                object.addProperty("mixStreamId", this.mAVParams.get((Object)string2).uid);
                object.addProperty("url", this.mAVParams.get((Object)string2).url);
            }
            if (string != null && !string.isEmpty() && string2.compareToIgnoreCase(string) != 0) continue;
            if (bl) {
                object = this.mediaPlayerList.get(string2);
                if (object == null) continue;
                StreamQualityRtmp streamQualityRtmp = this.mRemoteCalculator.get(string2);
                if (streamQualityRtmp != null) {
                    streamQualityRtmp.stopCheckFreeze();
                    this.mRemoteCalculator.remove(string2);
                }
                LogUtil.w((Object)TAG, (String)("Dispose bjy media player[uid=" + string2 + "] automatically"));
                ((MediaPlayer)object).dispose();
                this.mediaPlayerList.remove(string2);
                this.mAVParams.get((Object)string2).isAutoClose = true;
                continue;
            }
            if (!this.mAVParams.get((Object)string2).isAutoClose) continue;
            LogUtil.w((Object)TAG, (String)("Replay bjy media player[uid=" + string2 + "] automatically"));
            this.mAVParams.get((Object)string2).isAutoClose = false;
            object = this.mAVParams.get((Object)string2).view;
            if (object != null) {
                LogUtil.i((Object)TAG, (String)"remove old surface view from parent");
                ViewGroup viewGroup = (ViewGroup)object.getView().getParent();
                if (viewGroup != null) {
                    viewGroup.removeView(object.getView());
                    LogUtil.i((Object)TAG, (String)"create a new surface view");
                    this.mAVParams.get((Object)string2).view = new SurfaceRenderView(mContext);
                    viewGroup.addView(this.mAVParams.get((Object)string2).view.getView());
                }
                if (this.mAVParams.get(string2) == null) continue;
                RtmpEngine rtmpEngine = this;
                RtmpEngine rtmpEngine2 = this;
                object = rtmpEngine2.mAVParams.get((Object)string2).url;
                boolean bl2 = rtmpEngine2.mAVParams.get((Object)string2).enableAudio;
                boolean bl3 = rtmpEngine2.mAVParams.get((Object)string2).enableVideo;
                RtmpView rtmpView = rtmpEngine2.mAVParams.get((Object)string2).view;
                int n = rtmpEngine2.mAVParams.get((Object)string2).sessType;
                rtmpEngine.playAV(rtmpEngine.mAVParams.get((Object)string2).uid, (String)object, bl2, bl3, rtmpView, n);
                continue;
            }
            LogUtil.e((Object)TAG, (String)"Surface view disappeared, cannot play automatically");
        }
    }

    public void setBufferTcp(float f) {
        this.mBufferTcp = f;
    }

    public void setDisplayMode(int n) {
        this.mDisplayMode = n;
    }

    public void setSpeed(String string, float f) {
        if (!((RtmpEngine)((Object)mediaPlayer)).mediaPlayerList.isEmpty() && !(f <= 0.0f)) {
            MediaPlayer mediaPlayer = ((RtmpEngine)((Object)mediaPlayer)).mediaPlayerList.get(string);
            if (mediaPlayer != null) {
                mediaPlayer.setSpeed(f);
            }
            return;
        }
    }

    public void seekTo(String string, int n) {
        if (((RtmpEngine)((Object)mediaPlayer)).mediaPlayerList.isEmpty()) {
            return;
        }
        MediaPlayer mediaPlayer = ((RtmpEngine)((Object)mediaPlayer)).mediaPlayerList.get(string);
        if (mediaPlayer != null) {
            mediaPlayer.seekTo(n);
        }
    }

    public long getCurrentPosition(String string) {
        if (((RtmpEngine)((Object)mediaPlayer)).mediaPlayerList.isEmpty()) {
            return 0L;
        }
        MediaPlayer mediaPlayer = ((RtmpEngine)((Object)mediaPlayer)).mediaPlayerList.get(string);
        if (mediaPlayer != null) {
            return mediaPlayer.getCurrentPosition();
        }
        return 0L;
    }

    public long getDuration(String string) {
        if (((RtmpEngine)((Object)mediaPlayer)).mediaPlayerList.isEmpty()) {
            return 0L;
        }
        MediaPlayer mediaPlayer = ((RtmpEngine)((Object)mediaPlayer)).mediaPlayerList.get(string);
        if (mediaPlayer != null) {
            return mediaPlayer.getDuration();
        }
        return 0L;
    }

    public MediaPlayer.PLAYER_STATE getState(String string) {
        if (((RtmpEngine)((Object)mediaPlayer)).mediaPlayerList.isEmpty()) {
            return MediaPlayer.PLAYER_STATE.UINT;
        }
        MediaPlayer mediaPlayer = ((RtmpEngine)((Object)mediaPlayer)).mediaPlayerList.get(string);
        if (mediaPlayer != null) {
            return mediaPlayer.getState();
        }
        return MediaPlayer.PLAYER_STATE.UINT;
    }

    public void resume(String string) {
        if (((RtmpEngine)((Object)mediaPlayer)).mediaPlayerList.isEmpty()) {
            return;
        }
        MediaPlayer mediaPlayer = ((RtmpEngine)((Object)mediaPlayer)).mediaPlayerList.get(string);
        if (mediaPlayer != null) {
            mediaPlayer.resume();
        }
    }

    public void pause(String string) {
        if (((RtmpEngine)((Object)mediaPlayer)).mediaPlayerList.isEmpty()) {
            return;
        }
        MediaPlayer mediaPlayer = ((RtmpEngine)((Object)mediaPlayer)).mediaPlayerList.get(string);
        if (mediaPlayer != null) {
            mediaPlayer.pause();
        }
    }

    @Override
    public void onRemoteFrameFreeze(String string) {
        RtmpEventObserver rtmpEventObserver = ((RtmpEngine)((Object)rtmpEventObserver)).mRtmpEventObserver;
        if (rtmpEventObserver != null) {
            rtmpEventObserver.onRtmpLag(string);
            LogUtil.i((Object)TAG, (String)("rtmp  onRemoteFrameFreeze is frozen uid:" + string));
        }
    }

    public void dispose() {
        if (this.mediaPlayerList.size() > 0) {
            Iterator<Object> iterator = this.mRemoteCalculator.entrySet().iterator();
            while (iterator.hasNext()) {
                iterator.next().getValue().stopCheckFreeze();
            }
            RtmpEngine rtmpEngine = this;
            rtmpEngine.mRemoteCalculator.clear();
            iterator = rtmpEngine.mediaPlayerList.values().iterator();
            while (iterator.hasNext()) {
                ((MediaPlayer)iterator.next()).dispose();
            }
            RtmpEngine rtmpEngine2 = this;
            rtmpEngine2.mediaPlayerList.clear();
            rtmpEngine2.mAVParams.clear();
        }
        this.mRtmpEventObserver = null;
        LogUtil.i((Object)TAG, (String)"dispose BJYRtmpEngine");
    }
}

