/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyrtcengine;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.text.TextUtils;
import android.view.View;
import com.baijiayun.bjyrtcengine.BJYRtcEngine;
import com.baijiayun.bjyrtcengine.BJYRtcEventObserver;
import com.baijiayun.bjyrtcengine.BaseAdapter;
import com.baijiayun.bjyrtcengine.Defines.BJYRtcCommon;
import com.baijiayun.bjyrtcengine.Enums;
import com.baijiayun.bjyrtcengine.EventHandler.TcEngineEventListenerImpl;
import com.baijiayun.bjyrtcengine.TcVideoEncConfig;
import com.baijiayun.bjyrtcengine.Tools.Utility;
import com.baijiayun.bjyrtcengine.VideoBaseProps;
import com.baijiayun.bjyrtcengine.VideoEncConfig;
import com.baijiayun.bjyrtcengine.player.RtmpEngine;
import com.baijiayun.utils.LogUtil;
import com.google.gson.JsonObject;
import com.tencent.rtmp.TXLivePlayConfig;
import com.tencent.rtmp.TXLivePlayer;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.trtc.TRTCCloud;
import com.tencent.trtc.TRTCCloudDef;
import com.tencent.trtc.TRTCCloudListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.brtc.sdk.BRTCListener;
import org.json.JSONException;
import org.json.JSONObject;

public class TcAdapter
extends BaseAdapter {
    private static final String TAG = "bjyrtc-BJYRtcEngineImpl";
    private static final String mScreenShotPath = "/TXSnapshot";
    private TRTCCloud mTcEngine = null;
    private TcEngineEventListenerImpl mTCCloudListener;
    private BJYRtcEventObserver rtcEventObserver;
    private TXLivePlayer mTXLivePlayer;
    private int mAppID = -1;
    private String mUserSig;
    private boolean mFrontCamera = true;
    private boolean isPublishingVideo = false;
    private boolean isPhoneCallIn = false;
    private boolean isMusicModeOn = false;
    private int mStreamType = 0;
    private int mWebrtcType = 1;
    private int[] mVideoLossRate = new int[]{20, 20};
    private int[] mAudioLossRate = new int[]{30, 30};
    private int[] mPubFps = new int[]{5, 5};
    private int[] mSubFps = new int[]{5, 5};
    private int[] mWin = new int[]{6, 6};
    private int mForcedVideoSendBps = 0;
    private TRTCCloudDef.TRTCVideoEncParam smallVideoParam = new TRTCCloudDef.TRTCVideoEncParam();
    private TRTCCloudDef.TRTCVideoEncParam encParam;
    private BJYRtcCommon.DualStreamType defaultDualStreamType = BJYRtcCommon.DualStreamType.VIDEO_STREAM_HIGH;
    private TXCloudVideoView localView;
    private boolean isLandScape = true;
    private TRTCCloudDef.TRTCRenderParams renderParams = new TRTCCloudDef.TRTCRenderParams();
    private Map<String, BJYRtcCommon.DualStreamType> streamTypeMap = new HashMap<String, BJYRtcCommon.DualStreamType>();
    private boolean isStartLocalAudio = false;

    public TcAdapter(Context context) {
        super(context);
        this.mTCCloudListener = new TcEngineEventListenerImpl(this);
        this.adapterName = "TRTCAdapter";
    }

    private void setLogPath() {
        File file;
        Object object = ((BaseAdapter)object).mContext.getExternalFilesDir(null);
        object = object != null && ((File)object).exists() ? ((File)object).getPath() : Environment.getExternalStorageDirectory().getPath();
        File file2 = file;
        if (!new File((String)object + "/bjyLogFile").exists() && !file2.mkdir()) {
            LogUtil.i((Object)TAG, (String)"Log File can not create, save local log in  /app\u79c1\u6709\u76ee\u5f55/files/log/tencent/liteav/");
            return;
        }
        TRTCCloud.setLogDirPath((String)((String)object + "/bjyLogFile"));
    }

    private int bjyRenderModeToTencentMode(BJYRtcCommon.BJYRtcRenderMode bJYRtcRenderMode) {
        return bJYRtcRenderMode == BJYRtcCommon.BJYRtcRenderMode.BJYRtcRenderModeFill ? 0 : 1;
    }

    private int gettingRenderModeThroughType(int n, BJYRtcEngine.BJYVideoCanvas bJYVideoCanvas) {
        if (n != 2 && n != 3) {
            if (n == 1) {
                return 0;
            }
            BJYRtcCommon.BJYRtcRenderMode bJYRtcRenderMode = bJYVideoCanvas.getRenderMode();
            if (bJYRtcRenderMode != null) {
                return this.bjyRenderModeToTencentMode(bJYRtcRenderMode);
            }
            return 0;
        }
        return 1;
    }

    private void updateVideoResolution(int n, int n2) {
        VideoEncConfig videoEncConfig = this.mVideoEncConfig;
        if (videoEncConfig == null) {
            return;
        }
        if (!videoEncConfig.selectVideoByResolution(n, n2)) {
            return;
        }
        TcVideoEncConfig.TcVideoProps tcVideoProps = (TcVideoEncConfig.TcVideoProps)this.mVideoEncConfig.getSelectedVideoProp();
        if (tcVideoProps != null && this.mTcEngine != null) {
            LogUtil.i((Object)TAG, (String)("updateVideoResolution to [" + tcVideoProps.encParam.videoResolution + ", " + tcVideoProps.encParam.videoBitrate + "kbps, fps:" + tcVideoProps.encParam.videoFps + "]"));
            if (this.mForcedVideoSendBps != 0) {
                LogUtil.i((Object)TAG, (String)("##### use forced video send bps: " + this.mForcedVideoSendBps));
                tcVideoProps.encParam.videoBitrate = this.mForcedVideoSendBps;
            }
            tcVideoProps = tcVideoProps.encParam;
            this.encParam = tcVideoProps;
            tcVideoProps.encParam.videoResolutionMode = TcVideoEncConfig.mode;
            this.mTcEngine.setVideoEncoderParam((TRTCCloudDef.TRTCVideoEncParam)tcVideoProps);
        }
    }

    private int getVideoType(int n) {
        if (Enums.SessionIntegerTypeToString(n).equals("token")) {
            return 0;
        }
        if (Enums.SessionIntegerTypeToString(n).equals("screen_token")) {
            return 2;
        }
        return 0;
    }

    private int getTRTCStreamType(String string) {
        TcAdapter tcAdapter = this;
        BJYRtcCommon.DualStreamType dualStreamType = tcAdapter.defaultDualStreamType;
        if (tcAdapter.streamTypeMap.containsKey(string)) {
            dualStreamType = this.streamTypeMap.get(string);
        }
        return dualStreamType == BJYRtcCommon.DualStreamType.VIDEO_STREAM_HIGH ? 0 : 1;
    }

    @Override
    public boolean setBlockConfig(List<Map<String, Object>> list) {
        for (int i = 0; i < list.size(); ++i) {
            int n;
            Map<String, Object> map;
            block28: {
                map = list.get(i);
                TcAdapter tcAdapter = this;
                int n2 = (int)Double.parseDouble(String.valueOf(map.get("streamType")));
                tcAdapter.mStreamType = n2;
                int n3 = (int)Double.parseDouble(String.valueOf(map.get("webrtcType")));
                this.mWebrtcType = n3;
                if (n3 != 3) continue;
                n = this.mStreamType;
                if (n != 1) break block28;
                TcAdapter tcAdapter2 = this;
                TcAdapter tcAdapter3 = tcAdapter2;
                TcAdapter tcAdapter4 = tcAdapter2;
                TcAdapter tcAdapter5 = tcAdapter2;
                TcAdapter tcAdapter6 = tcAdapter2;
                int[] nArray = tcAdapter2.mVideoLossRate;
                n = 0;
                int n4 = (int)Double.parseDouble(String.valueOf(map.get("videoLossRate")));
                nArray[n] = n4;
                int[] nArray2 = tcAdapter4.mAudioLossRate;
                n = 0;
                int n5 = (int)Double.parseDouble(String.valueOf(map.get("audioLossRate")));
                nArray2[n] = n5;
                int[] nArray3 = tcAdapter5.mPubFps;
                n = 0;
                int n6 = (int)Double.parseDouble(String.valueOf(map.get("pubFps")));
                nArray3[n] = n6;
                int[] nArray4 = tcAdapter6.mSubFps;
                n = 0;
                int n7 = (int)Double.parseDouble(String.valueOf(map.get("subFps")));
                nArray4[n] = n7;
                int[] nArray5 = tcAdapter3.mWin;
                int n8 = 0;
                int n9 = (int)Double.parseDouble(String.valueOf(map.get("win")));
                nArray5[n8] = n9;
                continue;
            }
            if (n != 2) continue;
            TcAdapter tcAdapter = this;
            TcAdapter tcAdapter7 = tcAdapter;
            TcAdapter tcAdapter8 = tcAdapter;
            TcAdapter tcAdapter9 = tcAdapter;
            TcAdapter tcAdapter10 = tcAdapter;
            int[] nArray = tcAdapter.mVideoLossRate;
            n = 1;
            int n10 = (int)Double.parseDouble(String.valueOf(map.get("videoLossRate")));
            nArray[n] = n10;
            int[] nArray6 = tcAdapter8.mAudioLossRate;
            n = 1;
            int n11 = (int)Double.parseDouble(String.valueOf(map.get("audioLossRate")));
            nArray6[n] = n11;
            int[] nArray7 = tcAdapter9.mPubFps;
            n = 1;
            int n12 = (int)Double.parseDouble(String.valueOf(map.get("pubFps")));
            nArray7[n] = n12;
            int[] nArray8 = tcAdapter10.mSubFps;
            n = 1;
            int n13 = (int)Double.parseDouble(String.valueOf(map.get("subFps")));
            nArray8[n] = n13;
            int[] nArray9 = tcAdapter7.mWin;
            int n14 = 1;
            int n15 = (int)Double.parseDouble(String.valueOf(map.get("win")));
            try {
                nArray9[n14] = n15;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.mStreamType = 0;
                numberFormatException.printStackTrace();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean initEngine(Map<String, Object> map) {
        TXLivePlayConfig tXLivePlayConfig;
        TRTCCloud tRTCCloud;
        TcAdapter tcAdapter;
        TcAdapter tcAdapter2;
        TcAdapter tcAdapter3;
        boolean bl;
        LogUtil.i((Object)TAG, (String)"init TcAdapter.");
        Object object = map.get("appId");
        if (object == null) {
            LogUtil.e((Object)TAG, (String)"Not set AppId, cannot init RtcEngine");
            return false;
        }
        boolean bl2 = map.get("DemoUI") != null && (Boolean)map.get("DemoUI") != false;
        try {
            bl = bl2;
            TcAdapter tcAdapter4 = this;
            tcAdapter3 = tcAdapter4;
            TcAdapter tcAdapter5 = tcAdapter4;
            tcAdapter2 = tcAdapter4;
            tcAdapter = tcAdapter4;
            tcAdapter4.setLogPath();
            tcAdapter4.mVideoEncConfig = new TcVideoEncConfig();
            tRTCCloud = TRTCCloud.sharedInstance((Context)tcAdapter4.mContext);
        }
        catch (Exception exception) {
            return false;
        }
        {
            this.mTcEngine = tRTCCloud;
            tRTCCloud.setListener((TRTCCloudListener)this.mTCCloudListener);
            tcAdapter.mTcEngine.setGSensorMode(1);
            tcAdapter5.mTXLivePlayer = new TXLivePlayer(this.mContext);
        }
        tRTCCloud = tXLivePlayConfig;
        {
            int n;
            TcAdapter tcAdapter6;
            new TXLivePlayConfig().setEnableMessage(true);
            tcAdapter2.mTXLivePlayer.setConfig((TXLivePlayConfig)tRTCCloud);
            tcAdapter3.mTCCloudListener.setTcAdapter(this);
            if (bl) {
                tcAdapter6 = this;
                n = (Integer)object;
            } else {
                tcAdapter6 = this;
                n = ((Double)map.get("appId")).intValue();
            }
            tcAdapter6.mAppID = n;
            this.mUserSig = (String)map.get("token");
            LogUtil.i((Object)TAG, (String)("AppID id [" + this.mAppID + "], UserSig is [" + this.mUserSig + "].initEngine done."));
            return true;
        }
    }

    @Override
    public void dispose() {
        LogUtil.i((Object)TAG, (String)"dispose TcAdapter");
        TRTCCloud tRTCCloud = this.mTcEngine;
        if (tRTCCloud != null) {
            tRTCCloud.exitRoom();
            TRTCCloud.destroySharedInstance();
            this.mTcEngine = null;
        }
        this.mTCCloudListener = null;
        this.mRtcEventObserver = null;
        this.mainHandler.removeCallbacks(null);
    }

    @Override
    public boolean isH264VideoCodecSupported() {
        return true;
    }

    @Override
    public String getMediaServers() {
        return null;
    }

    @Override
    public boolean switchMediaServer(String string) {
        return false;
    }

    @Override
    public int joinRoom(Map<String, Object> object) {
        TRTCCloudDef.TRTCParams tRTCParams;
        Object object2;
        boolean bl;
        JSONObject jSONObject;
        String string;
        block13: {
            JSONObject jSONObject2;
            TRTCCloud tRTCCloud = object;
            LogUtil.i((Object)TAG, (String)"Begine to join room");
            this.mLocalUserId = (String)object.get("uid");
            string = String.valueOf(tRTCCloud.get("roomid"));
            jSONObject = jSONObject2;
            bl = false;
            new JSONObject().put("strGroupId", (Object)string);
            object2 = (Map)tRTCCloud.get("webrtc_info");
            if (object2 == null) break block13;
            object2 = (Map)object2.get("webrtc_ext");
            if (object2 == null) break block13;
            try {
                bl = this.parseWebrtcExt((Map<String, Object>)object2);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        Object object3 = object.get("support_live_definition");
        if (!bl && object3 != null) {
            this.parseLiveDefinitionConfig((JsonObject)object3);
        }
        object3 = object.get("small_stream_ratio");
        object2 = object.get("small_stream_height");
        if (object3 != null && object2 != null) {
            VideoBaseProps.VideoResolution videoResolution;
            int n;
            TcAdapter tcAdapter = this;
            this.mSmallStreamRatio = Integer.parseInt(String.valueOf(object3));
            tcAdapter.mSmallStreamHeight = n = Integer.parseInt(String.valueOf(object2));
            VideoBaseProps.VideoResolution videoResolution2 = videoResolution = Utility.getSmallVideoResolution(tcAdapter.mSmallStreamRatio, n);
            int n2 = videoResolution2.width;
            object3 = (TcVideoEncConfig.TcVideoProps)tcAdapter.mVideoEncConfig.getVideoProp(n2, videoResolution2.height);
            if (object3 != null) {
                this.smallVideoParam = ((TcVideoEncConfig.TcVideoProps)object3).encParam;
            }
        }
        TcAdapter tcAdapter = this;
        object3 = tRTCParams;
        TcAdapter tcAdapter2 = this;
        int n = tcAdapter2.mAppID;
        object2 = tcAdapter2.mLocalUserId;
        String string2 = tcAdapter2.mUserSig;
        String string3 = jSONObject.toString();
        new TRTCCloudDef.TRTCParams((int)n, (String)object2, (String)string2, (int)-1, (String)"", (String)string3).role = 21;
        tcAdapter.mTCCloudListener.setLocalUserId(this.mLocalUserId);
        if (tcAdapter.mVideoEncConfig != null) {
            if (object.get("video_send_bps") != null) {
                this.mForcedVideoSendBps = Integer.parseInt(object.get("video_send_bps").toString());
            }
            if ((object = (TcVideoEncConfig.TcVideoProps)this.mVideoEncConfig.getSelectedVideoProp()) != null) {
                if (this.mForcedVideoSendBps != 0) {
                    LogUtil.i((Object)TAG, (String)("##### use forced video send bps: " + this.mForcedVideoSendBps));
                    object.encParam.videoBitrate = this.mForcedVideoSendBps;
                }
                object = object.encParam;
                this.encParam = object;
                object.encParam.videoResolutionMode = TcVideoEncConfig.mode;
                this.mTcEngine.setVideoEncoderParam((TRTCCloudDef.TRTCVideoEncParam)object);
            }
        }
        if ((object = this.mTcEngine) != null) {
            object.enterRoom((TRTCCloudDef.TRTCParams)object3, 1);
            LogUtil.i((Object)TAG, (String)("Enter room done, mLocalUser id is " + this.mLocalUserId + ", roomId is " + string));
        }
        return 0;
    }

    @Override
    public void publish(boolean bl, boolean bl2) {
        LogUtil.i((Object)TAG, (String)"Begine to publish");
        this.mSelfPublished = true;
        TRTCCloud tRTCCloud = this.mTcEngine;
        if (tRTCCloud != null) {
            tRTCCloud.switchRole(20);
            if (bl) {
                TcAdapter tcAdapter = this;
                tRTCCloud = tcAdapter.mTcEngine;
                int n = tcAdapter.isMusicModeOn ? 3 : 2;
                tRTCCloud.startLocalAudio(n);
                this.mTcEngine.muteLocalAudio(false);
            }
            if (bl2) {
                this.mTcEngine.muteLocalVideo(false);
            }
        }
        this.isAudioAttached = bl;
        this.isPublishingVideo = bl2;
        TcEngineEventListenerImpl tcEngineEventListenerImpl = this.mTCCloudListener;
        if (tcEngineEventListenerImpl != null) {
            int n = Enums.SessionTypeToInteger(Enums.BJYSessionType.BJY_SESSION_CAMERA_MASTER);
            tcEngineEventListenerImpl.onPublishResult(n, this.mLocalUserId);
        }
    }

    @Override
    public void publish(boolean bl, boolean bl2, boolean bl3) {
    }

    @Override
    public void unpublish() {
        LogUtil.i((Object)TAG, (String)"unpublish called !");
        Object object = this.mTcEngine;
        if (object != null) {
            object.muteLocalVideo(true);
            this.mTcEngine.stopLocalAudio();
            this.isStartLocalAudio = false;
        }
        this.mSelfPublished = false;
        this.isPublishingVideo = false;
        this.isAudioAttached = false;
        object = this.mTCCloudListener;
        if (object != null) {
            int n = Enums.SessionTypeToInteger(Enums.BJYSessionType.BJY_SESSION_CAMERA_MASTER);
            object.onUnpublishResult(n, this.mLocalUserId);
        }
    }

    @Override
    public int muteLocalMic(boolean bl) {
        String string = TAG;
        StringBuilder stringBuilder = new StringBuilder().append("muteLocalMic: ");
        String string2 = bl ? "true" : "false";
        LogUtil.i((Object)string, (String)stringBuilder.append(string2).toString());
        string = this.mTcEngine;
        if (string == null) {
            return -1;
        }
        this.isAudioAttached = bl ^ true;
        if (!bl && !this.isStartLocalAudio) {
            int n = this.isMusicModeOn ? 3 : 2;
            string.startLocalAudio(n);
            this.isStartLocalAudio = true;
        }
        this.mTcEngine.muteLocalAudio(bl);
        return 0;
    }

    @Override
    public int muteLocalCamera(boolean bl) {
        String string = TAG;
        StringBuilder stringBuilder = new StringBuilder().append("muteLocalCamera: ");
        String string2 = bl ? "true" : "false";
        LogUtil.i((Object)string, (String)stringBuilder.append(string2).toString());
        string = this.mTcEngine;
        if (string == null) {
            return -1;
        }
        this.isPublishingVideo = bl ^ true;
        string.muteLocalVideo(bl);
        return 0;
    }

    @Override
    public void subscribe(String string, boolean bl, boolean bl2, int n) {
        String string2 = Enums.convertUid(string, n);
        LogUtil.i((Object)TAG, (String)("[remote stream] subscribe  subscribe Begine to subscribe, call remote VideoAvailable.The Uid :[" + string + "] type\uff1a " + n + " tencentId\uff1a" + string2));
        TRTCCloud tRTCCloud = ((TcAdapter)this).mTcEngine;
        if (tRTCCloud != null) {
            tRTCCloud.muteRemoteAudio(string2, bl ^ true);
            ((TcAdapter)this).mTcEngine.muteRemoteVideoStream(string2, bl2 ^ true);
        }
        if ((this = ((TcAdapter)this).mTCCloudListener) != null) {
            ((TcEngineEventListenerImpl)((Object)this)).onSubscribedResult(n, string);
        }
    }

    @Override
    public void unsubscribe(String string, int n) {
        this.unsubscribe(string, n, true);
    }

    @Override
    public void unsubscribe(String string, int n, boolean bl) {
        LogUtil.i((Object)TAG, (String)("[remote stream] Unsubscribe remote stream : uid is [" + string + "] sessionType is [" + n + "]"));
        String string2 = Enums.convertUid(string, n);
        TRTCCloud tRTCCloud = this.mTcEngine;
        if (tRTCCloud != null) {
            tRTCCloud.muteRemoteAudio(string2, true);
            this.mTcEngine.stopRemoteView(string2, this.getTRTCStreamType(string2));
            if (bl) {
                this.mTCCloudListener.unsubscribed(n, string);
            }
        }
    }

    @Override
    public void play(String string, BJYRtcEngine.BJYVideoCanvas bJYVideoCanvas, int n) {
        String string2 = TAG;
        StringBuilder stringBuilder = new StringBuilder().append("playRemoteVideo, uid is [").append(string).append("] and the sType is ");
        boolean bl = this.getVideoType(n) == 0;
        LogUtil.i((Object)string2, (String)stringBuilder.append(bl).toString());
        string2 = Enums.convertUid(string, n);
        bJYVideoCanvas.setSessionType(n);
        if (this.mTcEngine != null) {
            TcAdapter tcAdapter = this;
            LogUtil.i((Object)TAG, (String)"startRemoteView");
            tcAdapter.mTcEngine.setRemoteViewFillMode(string2, this.gettingRenderModeThroughType(n, bJYVideoCanvas));
            int n2 = this.getTRTCStreamType(string2);
            tcAdapter.mTcEngine.startRemoteView(string2, n2, bJYVideoCanvas.getTXCloudVideoView());
            tcAdapter.mainHandler.postDelayed(() -> this.rtcEventObserver.onFirstFrameAvailable(string, n), 5000L);
        }
    }

    @Override
    public void startPreview(BJYRtcEngine.BJYVideoCanvas bJYVideoCanvas) {
        this.startPreview(true, bJYVideoCanvas);
    }

    @Override
    public void startPreview(boolean bl, BJYRtcEngine.BJYVideoCanvas bJYVideoCanvas) {
        LogUtil.i((Object)TAG, (String)("startPreview : canvas is " + bJYVideoCanvas + "isFrontCamera:" + bl));
        if (tcAdapter2.mTcEngine != null) {
            TcAdapter tcAdapter = tcAdapter2;
            tcAdapter2.mFrontCamera = bl;
            TcAdapter tcAdapter2 = bJYVideoCanvas.getTXCloudVideoView();
            tcAdapter.localView = tcAdapter2;
            tcAdapter.mTcEngine.startLocalPreview(bl, (TXCloudVideoView)tcAdapter2);
        }
    }

    @Override
    public void stopPreview() {
        LogUtil.i((Object)TAG, (String)"stopPreview");
        TcAdapter tcAdapter = tcAdapter.mTcEngine;
        if (tcAdapter != null) {
            tcAdapter.stopLocalPreview();
        }
    }

    @Override
    public void setRtcEngineObserver(BJYRtcEventObserver bJYRtcEventObserver) {
        this.rtcEventObserver = bJYRtcEventObserver;
        this.mTCCloudListener.setEngineObserver(bJYRtcEventObserver);
        this.mRtcEventObserver = bJYRtcEventObserver;
    }

    @Override
    public void setAudioFrameListener(BRTCListener.BRTCAudioFrameListener bRTCAudioFrameListener) {
    }

    @Override
    public String getSdkVersion() {
        return TRTCCloud.getSDKVersion();
    }

    @Override
    public int enableSpeakerphone(boolean bl) {
        return 0;
    }

    @Override
    public int switchCamera() {
        LogUtil.i((Object)TAG, (String)"switchCamera");
        TRTCCloud tRTCCloud = this.mTcEngine;
        if (tRTCCloud != null) {
            this.mFrontCamera ^= true;
            tRTCCloud.switchCamera();
        }
        return 0;
    }

    @Override
    public BJYRtcEngine.BJYVideoCanvas createVideoCanvas(String string, boolean bl) {
        BJYRtcEngine.BJYVideoCanvas bJYVideoCanvas2;
        LogUtil.i((Object)TAG, (String)"create Video canvas.");
        BJYRtcEngine.BJYVideoCanvas bJYVideoCanvas3 = bJYVideoCanvas2;
        bJYVideoCanvas3(this.mContext, string, bl, BJYRtcCommon.BJYEngineType.BJY_ENGINE_TYPE_TENCENT);
        bJYVideoCanvas2.addVideoRenderModeChangedListener((bJYVideoCanvas, bJYRtcRenderMode) -> {
            if (TextUtils.equals((CharSequence)string, (CharSequence)this.mLocalUserId)) {
                if (this.mTcEngine != null) {
                    this.renderParams.fillMode = this.bjyRenderModeToTencentMode(bJYRtcRenderMode);
                    this.mTcEngine.setLocalRenderParams(this.renderParams);
                }
            } else {
                string = Enums.convertUid(string, bJYVideoCanvas.getSessionType());
                bJYVideoCanvas = this.mTcEngine;
                if (bJYVideoCanvas != null) {
                    bJYVideoCanvas.setRemoteViewFillMode(string, this.bjyRenderModeToTencentMode(bJYRtcRenderMode));
                }
            }
        });
        return bJYVideoCanvas2;
    }

    @Override
    public void muteRemoteAudio(String string, boolean bl, int n) {
        TcAdapter tcAdapter = string2;
        LogUtil.i((Object)TAG, (String)("muteRemoteAudio :" + bl));
        String string2 = Enums.convertUid(string, n);
        string = tcAdapter.mTcEngine;
        if (string != null) {
            string.muteRemoteAudio(string2, bl);
        }
    }

    @Override
    public void muteRemoteVideo(String string, boolean bl, int n) {
        TcAdapter tcAdapter = string2;
        LogUtil.i((Object)TAG, (String)("muteRemoteVideo :" + bl));
        String string2 = Enums.convertUid(string, n);
        string = tcAdapter.mTcEngine;
        if (string != null) {
            string.muteRemoteVideoStream(string2, bl);
        }
    }

    @Override
    public void unmuteRemoteVideo(String string, BJYRtcEngine.BJYVideoCanvas bJYVideoCanvas, int n) {
        LogUtil.i((Object)TAG, (String)("unMuteRemoteVideo, uid is [" + string + "] type is [" + n + "]"));
        String string2 = Enums.convertUid(string, n);
        TRTCCloud tRTCCloud = this.mTcEngine;
        if (tRTCCloud != null) {
            int n2 = this.getTRTCStreamType(string2);
            tRTCCloud.startRemoteView(string2, n2, bJYVideoCanvas.getTXCloudVideoView());
            this.mainHandler.postDelayed(() -> this.rtcEventObserver.onFirstFrameAvailable(string, n), 5000L);
        }
    }

    @Override
    public void muteAllRemoteAudio(boolean bl) {
        LogUtil.i((Object)TAG, (String)("muteAllRemoteAudio :" + bl));
        TcAdapter tcAdapter = tcAdapter.mTcEngine;
        if (tcAdapter != null) {
            tcAdapter.muteAllRemoteAudio(bl);
        }
    }

    @Override
    public void muteAllRemoteVideo(boolean bl) {
        LogUtil.i((Object)TAG, (String)("muteAllRemoteVideo :" + bl));
        TcAdapter tcAdapter = tcAdapter.mTcEngine;
        if (tcAdapter != null) {
            tcAdapter.muteAllRemoteVideoStreams(bl);
        }
    }

    @Override
    public boolean getRemoteStreamStatus(String string, int n) {
        return false;
    }

    @Override
    public void changeVideoResolutionByLevel(int n) {
        VideoBaseProps.VideoResolution videoResolution = Utility.getVideoResolutionByLevel(n);
        int n2 = videoResolution.width;
        this.updateVideoResolution(n2, videoResolution.height);
    }

    @Override
    public void changeVideoResolutionByLevel(int n, int n2) {
        this.updateVideoResolution(n, n2);
    }

    @Override
    public void saveScreenshot(final String string, int n) {
        TRTCCloudListener.TRTCSnapshotListener tRTCSnapshotListener;
        Object object = Enums.convertUid(string, n);
        String string2 = object;
        object = tRTCSnapshotListener;
        tRTCSnapshotListener = new TRTCCloudListener.TRTCSnapshotListener(){

            public void onSnapshotComplete(Bitmap bitmap) {
                FileOutputStream fileOutputStream;
                String string2;
                block7: {
                    FileOutputStream fileOutputStream2;
                    File file;
                    File file2;
                    string2 = TcAdapter.this.mContext.getExternalFilesDir(null).getAbsolutePath() + TcAdapter.mScreenShotPath + "/" + TcAdapter.this.mLocalUserId + System.currentTimeMillis() + ".png";
                    File file3 = file2;
                    if (!new File(TcAdapter.this.mContext.getExternalFilesDir(null).getAbsolutePath() + TcAdapter.mScreenShotPath).exists()) {
                        file3.mkdir();
                    }
                    file3 = file;
                    file = new File(string2);
                    fileOutputStream = fileOutputStream2;
                    fileOutputStream2 = new FileOutputStream(file3);
                    if (bitmap == null) break block7;
                    bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream);
                }
                try {
                    FileOutputStream fileOutputStream3 = fileOutputStream;
                    fileOutputStream3.flush();
                    fileOutputStream3.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                TcAdapter.this.mRtcEventObserver.onScreenshotReady(string, string2);
            }
        };
        this.mTcEngine.snapshotVideo(string2, n, (TRTCCloudListener.TRTCSnapshotListener)object);
    }

    @Override
    public boolean isVideoAttached() {
        return this.isPublishingVideo;
    }

    @Override
    public void phoneStateChanged(boolean bl) {
        if (bl) {
            TcAdapter tcAdapter = this;
            tcAdapter.isPhoneCallIn = tcAdapter.isAudioAttached;
            TRTCCloud tRTCCloud = tcAdapter.mTcEngine;
            if (tRTCCloud != null) {
                tRTCCloud.muteLocalAudio(true);
                this.mTcEngine.muteAllRemoteAudio(true);
            }
        } else {
            TRTCCloud tRTCCloud = this.mTcEngine;
            if (tRTCCloud != null) {
                tRTCCloud.muteLocalAudio(this.isPhoneCallIn);
                this.mTcEngine.muteAllRemoteAudio(false);
            }
        }
        RtmpEngine.getInstance(this.mContext).stopOrRestartAvStream(bl, null);
    }

    @Override
    public void setRtcLagConfigs(int n, int n2, int n3, int n4) {
    }

    @Override
    public void setLocalVideoMirror(BJYRtcCommon.VideoMirrorMode videoMirrorMode) {
        TRTCCloud tRTCCloud = tcAdapter.mTcEngine;
        if (tRTCCloud != null) {
            TcAdapter tcAdapter = tcAdapter.renderParams;
            tcAdapter.renderParams.rotation = 0;
            tcAdapter.renderParams.mirrorType = 2;
            if (videoMirrorMode == BJYRtcCommon.VideoMirrorMode.HORIZONTAL_MIRROR) {
                ((TRTCCloudDef.TRTCRenderParams)tcAdapter).mirrorType = 1;
            } else if (videoMirrorMode == BJYRtcCommon.VideoMirrorMode.VERTICAL_MIRROR) {
                TcAdapter tcAdapter2 = tcAdapter;
                ((TRTCCloudDef.TRTCRenderParams)tcAdapter2).rotation = 2;
                ((TRTCCloudDef.TRTCRenderParams)tcAdapter2).mirrorType = 1;
            } else if (videoMirrorMode == BJYRtcCommon.VideoMirrorMode.HORIZONTAL_VERTICAL_MIRROR) {
                ((TRTCCloudDef.TRTCRenderParams)tcAdapter).rotation = 2;
            }
            tRTCCloud.setLocalRenderParams((TRTCCloudDef.TRTCRenderParams)tcAdapter);
        }
    }

    @Override
    public int enableDualStreamMode(boolean bl) {
        if (this.mTcEngine != null) {
            LogUtil.w((Object)TAG, (String)"Dual stream mode only support Windows, macOS or high performance iPad");
            return this.mTcEngine.enableEncSmallVideoStream(bl, this.smallVideoParam);
        }
        return -1;
    }

    @Override
    public int setRemoteVideoStreamType(String string, int n, BJYRtcCommon.DualStreamType dualStreamType) {
        if (this.mTcEngine != null) {
            TcAdapter tcAdapter = this;
            String string2 = Enums.convertUid(string, n);
            tcAdapter.streamTypeMap.put(string2, dualStreamType);
            LogUtil.v((Object)TAG, (String)("setRemoteVideoStreamType, [" + string + ", " + string2 + ", " + n + ", " + (Object)((Object)dualStreamType) + "]"));
            tcAdapter.mTcEngine.setRemoteVideoStreamType(string2, this.getTRTCStreamType(string2));
        }
        return 0;
    }

    @Override
    public int setRemoteDefaultVideoStreamType(BJYRtcCommon.DualStreamType dualStreamType) {
        if (tcAdapter.mTcEngine != null) {
            tcAdapter.defaultDualStreamType = dualStreamType;
            LogUtil.v((Object)TAG, (String)("setRemoteDefaultVideoStreamType, [" + (Object)((Object)dualStreamType) + "]"));
            TcAdapter tcAdapter = tcAdapter.mTcEngine;
            int n = dualStreamType == BJYRtcCommon.DualStreamType.VIDEO_STREAM_HIGH ? 0 : 1;
            tcAdapter.setPriorRemoteVideoStreamType(n);
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setEncVideoMirrorMode(BJYRtcCommon.VideoMirrorMode var1_1) {
        block8: {
            block7: {
                block11: {
                    block9: {
                        block10: {
                            var2_6 = this.mVideoEncConfig;
                            if (var2_6 == null) {
                                return;
                            }
                            if ((TcVideoEncConfig.TcVideoProps)var2_6.getSelectedVideoProp() == null || this.mTcEngine == null) break block8;
                            v0 = this;
                            LogUtil.v((Object)"bjyrtc-BJYRtcEngineImpl", (String)("Success set encode video mirror mode to " + (Object)var1_1));
                            v0.mVideoEncMirrorMode = var1_1;
                            v0.mTcEngine.setGSensorMode(1);
                            var2_7 = false;
                            var3_8 = v0.isLandScape;
                            var4_9 = var3_8 != false ? 0 : (this.mFrontCamera != false ? 3 : 1);
                            if (var1_1 != BJYRtcCommon.VideoMirrorMode.HORIZONTAL_MIRROR) break block9;
                            var2_7 = true;
                            if (!var3_8) break block10;
                            var4_9 = var1_2 = 0;
                            break block7;
                        }
                        if (this.mFrontCamera) lbl-1000:
                        // 3 sources

                        {
                            while (true) {
                                var4_9 = var1_3 = 1;
                                break block7;
                                break;
                            }
                        }
lbl22:
                        // 4 sources

                        while (true) {
                            var4_9 = var1_4 = 3;
                            break block7;
                            break;
                        }
                    }
                    if (var1_1 != BJYRtcCommon.VideoMirrorMode.VERTICAL_MIRROR) break block11;
                    var2_7 = true;
                    if (var3_8) {
                        while (true) {
                            var4_9 = var1_5 = 2;
                            break block7;
                            break;
                        }
                    }
                    if (!this.mFrontCamera) ** GOTO lbl-1000
                    ** GOTO lbl22
                }
                if (var1_1 == BJYRtcCommon.VideoMirrorMode.HORIZONTAL_VERTICAL_MIRROR) {
                    if (var3_8) ** continue;
                    if (this.mFrontCamera) ** break;
                    ** continue;
                    ** continue;
                }
            }
            v1 = this;
            v1.mTcEngine.setVideoEncoderMirror(var2_7);
            v1.mTcEngine.setVideoEncoderRotation(var4_9);
        }
    }

    @Override
    public boolean isFrontCamera() {
        return this.mFrontCamera;
    }

    @Override
    public void setLocalViewRotation(BJYRtcCommon.VideoRotation videoRotation) {
        TcAdapter tcAdapter = tcAdapter.mTcEngine;
        if (tcAdapter != null) {
            tcAdapter.setLocalViewRotation(videoRotation.ordinal());
        }
    }

    @Override
    public void setVideoEncoderRotation(BJYRtcCommon.VideoRotation videoRotation) {
        TRTCCloud tRTCCloud = this.mTcEngine;
        if (tRTCCloud != null) {
            tRTCCloud.setGSensorMode(1);
            this.mTcEngine.setVideoEncoderRotation(videoRotation.ordinal());
        }
    }

    @Override
    public void setVideoResolutionMode(BJYRtcCommon.VideoResolutionMode videoResolutionMode) {
        TcVideoEncConfig.mode = videoResolutionMode.getMode();
    }

    @Override
    public void startScreenCapture(int n, int n2, View view) {
        if (this.mTcEngine != null) {
            VideoBaseProps.VideoResolution videoResolution;
            VideoBaseProps.VideoResolution videoResolution2 = videoResolution = Utility.getVideoResolutionByLevel(n2);
            int n3 = videoResolution2.width;
            TcVideoEncConfig.TcVideoProps tcVideoProps = (TcVideoEncConfig.TcVideoProps)this.mVideoEncConfig.getVideoProp(n3, videoResolution2.height);
            if (tcVideoProps != null) {
                TRTCCloudDef.TRTCScreenShareParams tRTCScreenShareParams;
                tcVideoProps = tcVideoProps.encParam;
                TRTCCloudDef.TRTCScreenShareParams tRTCScreenShareParams2 = tRTCScreenShareParams;
                new TRTCCloudDef.TRTCScreenShareParams().floatingView = view;
                if (n != 2) {
                    this.mTcEngine.stopLocalPreview();
                }
                this.mTcEngine.startScreenCapture(n, (TRTCCloudDef.TRTCVideoEncParam)tcVideoProps, tRTCScreenShareParams2);
            }
        }
    }

    @Override
    public void stopScreenCapture() {
        this.stopScreenCapture(true);
    }

    @Override
    public void stopScreenCapture(boolean bl) {
        TRTCCloud tRTCCloud = this.mTcEngine;
        if (tRTCCloud != null) {
            tRTCCloud.stopScreenCapture();
            tRTCCloud = this.encParam;
            if (tRTCCloud != null) {
                this.mTcEngine.setVideoEncoderParam((TRTCCloudDef.TRTCVideoEncParam)tRTCCloud);
            }
            if ((tRTCCloud = this.localView) != null && bl) {
                this.mTcEngine.startLocalPreview(true, (TXCloudVideoView)tRTCCloud);
            }
        }
    }

    @Override
    public void pauseScreenCapture() {
        TcAdapter tcAdapter = tcAdapter.mTcEngine;
        if (tcAdapter != null) {
            tcAdapter.pauseScreenCapture();
        }
    }

    @Override
    public void resumeScreenCapture() {
        TcAdapter tcAdapter = tcAdapter.mTcEngine;
        if (tcAdapter != null) {
            tcAdapter.resumeScreenCapture();
        }
    }

    @Override
    public void setBeautyLevel(float f) {
        if (this.mTcEngine != null) {
            float f2 = Math.min(0.9f, Math.min(1.0f, Math.max(0.0f, f))) * 10.0f;
            this.mTcEngine.getBeautyManager().setBeautyLevel(f2);
        }
    }

    @Override
    public void setWhitenessLevel(float f) {
        if (this.mTcEngine != null) {
            float f2 = Math.min(0.9f, Math.min(1.0f, Math.max(0.0f, f))) * 10.0f;
            this.mTcEngine.getBeautyManager().setWhitenessLevel(f2);
        }
    }

    @Override
    public void changeMusicMode(boolean bl) {
        this.isMusicModeOn = bl;
    }

    @Override
    public boolean isMusicModeOn() {
        return this.isMusicModeOn;
    }

    @Override
    public void setEncVideoMirrorModeLandScape(boolean bl) {
    }

    @Override
    public void setDefaultStreamRecvMode(boolean bl, boolean bl2) {
        this.mTcEngine.setDefaultStreamRecvMode(bl, bl2);
    }

    @Override
    public void callExperimentalApi(String string) {
        this.mTcEngine.callExperimentalAPI(string);
    }

    @Override
    public void setNetworkQosPreference(int n, BJYRtcCommon.NetworkQosPreference networkQosPreference) {
        if (this.mTcEngine != null) {
            TRTCCloudDef.TRTCNetworkQosParam tRTCNetworkQosParam;
            TRTCCloudDef.TRTCNetworkQosParam tRTCNetworkQosParam2 = tRTCNetworkQosParam;
            tRTCNetworkQosParam = new TRTCCloudDef.TRTCNetworkQosParam();
            int n2 = networkQosPreference == BJYRtcCommon.NetworkQosPreference.SMOOTH ? 1 : 2;
            TRTCCloudDef.TRTCNetworkQosParam tRTCNetworkQosParam3 = tRTCNetworkQosParam2;
            tRTCNetworkQosParam3.preference = n2;
            tRTCNetworkQosParam3.controlMode = 0;
            this.mTcEngine.setNetworkQosParam(tRTCNetworkQosParam2);
        }
    }
}

