/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.playback.chat.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.load.resource.gif.GifDrawable;
import com.baijiayun.glide.request.target.SimpleTarget;
import com.baijiayun.glide.request.target.Target;
import com.baijiayun.glide.request.transition.Transition;

public class URLImageParser
implements Drawable.Callback {
    public static final String GIF_SUFFIX = ".gif";
    private TextView mTextView;
    private final float mImageSize;
    public float bitmapScale = 1.6f;
    public float gifScale = 1.8f;

    public URLImageParser(TextView textView, float imageSize) {
        this.mTextView = textView;
        this.mImageSize = imageSize;
    }

    public Drawable getDrawable(String url) {
        if (url.endsWith(GIF_SUFFIX)) {
            final GlideGifDrawable glideDrawable = new GlideGifDrawable();
            Glide.with((Context)this.mTextView.getContext()).asGif().load(url).into((Target)new SimpleTarget<GifDrawable>(){

                public void onResourceReady(@NonNull GifDrawable resource, @Nullable Transition<? super GifDrawable> transition) {
                    if (URLImageParser.this.mTextView == null) {
                        return;
                    }
                    Rect rect = new Rect(0, 0, (int)(URLImageParser.this.mImageSize * URLImageParser.this.gifScale), (int)(URLImageParser.this.mImageSize * URLImageParser.this.gifScale));
                    resource.setBounds(rect);
                    glideDrawable.setBounds(rect);
                    glideDrawable.setDrawable(resource);
                    glideDrawable.setCallback(URLImageParser.this);
                    resource.setLoopCount(-1);
                    resource.start();
                    URLImageParser.this.mTextView.invalidate();
                    URLImageParser.this.mTextView.setText(URLImageParser.this.mTextView.getText());
                }
            });
            return glideDrawable;
        }
        final URLDrawable urlDrawable = new URLDrawable();
        Glide.with((Context)this.mTextView.getContext()).asBitmap().load(url).into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                if (URLImageParser.this.mTextView == null) {
                    return;
                }
                urlDrawable.bitmap = URLImageParser.this.changeBitmapSize(resource, URLImageParser.this.mImageSize);
                urlDrawable.setBounds(0, 0, urlDrawable.bitmap.getWidth(), urlDrawable.bitmap.getHeight());
                URLImageParser.this.mTextView.invalidate();
                URLImageParser.this.mTextView.setText(URLImageParser.this.mTextView.getText());
            }
        });
        return urlDrawable;
    }

    private Bitmap changeBitmapSize(Bitmap bitmap, float mImageSize) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float newWidth = mImageSize * this.bitmapScale;
        float newHeight = (float)height * newWidth / (float)width;
        float scaleWidth = newWidth / (float)width;
        float scaleHeight = newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return bitmap;
    }

    public void invalidateDrawable(@NonNull Drawable who) {
        if (this.mTextView != null) {
            this.mTextView.invalidate();
        }
    }

    public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
    }

    public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
    }

    public void onDestroy() {
        this.mTextView = null;
    }

    public static class GlideGifDrawable
    extends Drawable
    implements Drawable.Callback {
        private GifDrawable mDrawable;

        public void draw(Canvas canvas) {
            if (this.mDrawable != null) {
                this.mDrawable.draw(canvas);
            }
        }

        public void setAlpha(int alpha) {
            if (this.mDrawable != null) {
                this.mDrawable.setAlpha(alpha);
            }
        }

        public void setColorFilter(ColorFilter cf) {
            if (this.mDrawable != null) {
                this.mDrawable.setColorFilter(cf);
            }
        }

        public int getOpacity() {
            if (this.mDrawable != null) {
                return this.mDrawable.getOpacity();
            }
            return 0;
        }

        public void setDrawable(GifDrawable drawable2) {
            if (this.mDrawable != null) {
                this.mDrawable.setCallback(null);
            }
            drawable2.setCallback((Drawable.Callback)this);
            this.mDrawable = drawable2;
        }

        public void invalidateDrawable(Drawable who) {
            if (this.getCallback() != null) {
                this.getCallback().invalidateDrawable(who);
            }
        }

        public void scheduleDrawable(Drawable who, Runnable what, long when) {
            if (this.getCallback() != null) {
                this.getCallback().scheduleDrawable(who, what, when);
            }
        }

        public void unscheduleDrawable(Drawable who, Runnable what) {
            if (this.getCallback() != null) {
                this.getCallback().unscheduleDrawable(who, what);
            }
        }

        public void onDestroy() {
            if (this.mDrawable != null) {
                this.mDrawable.setLoopCount(0);
                this.mDrawable.stop();
            }
        }
    }

    public static class URLDrawable
    extends BitmapDrawable {
        public Bitmap bitmap;

        public void draw(Canvas canvas) {
            super.draw(canvas);
            if (this.bitmap != null) {
                canvas.drawBitmap(this.bitmap, 0.0f, 0.0f, this.getPaint());
            }
        }
    }
}

