/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.widget;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.baijiayun.constant.VideoDefinition;
import com.baijiayun.download.DownloadModel;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.load.Transformation;
import com.baijiayun.glide.load.resource.bitmap.CircleCrop;
import com.baijiayun.glide.request.RequestOptions;
import com.baijiayun.videoplayer.IBJYVideoPlayer;
import com.baijiayun.videoplayer.bean.VideoItem;
import com.baijiayun.videoplayer.event.BundlePool;
import com.baijiayun.videoplayer.listeners.OnBufferingListener;
import com.baijiayun.videoplayer.player.PlayerStatus;
import com.baijiayun.videoplayer.render.AspectRatio;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.utils.NetworkUtils;
import com.baijiayun.videoplayer.ui.widget.BaseVideoView;
import com.baijiayun.videoplayer.ui.widget.ComponentContainer;
import com.baijiayun.videoplayer.widget.BJYPlayerView;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;

public class BJYVideoView
extends BaseVideoView {
    private static final String TAG = "BJYVideoView";
    private BJYPlayerView bjyPlayerView;
    private long videoId;
    private String token;
    private int mAspectRatio = AspectRatio.AspectRatio_FILL_PARENT.ordinal();
    private int mRenderType = 1;
    private boolean isPlayOnlineVideo = false;
    private PublishSubject<Integer> subjectOfPlayingTime;
    private View audioCoverView;
    private ObjectAnimator audioCoverAnimator;
    private String audioCover;
    private View audioCoverContainer;

    public BJYVideoView(@NonNull Context context) {
        this(context, null);
    }

    public BJYVideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BJYVideoView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.BJVideoView, 0, 0);
        if (a.hasValue(R.styleable.BJVideoView_bjy_aspect_ratio)) {
            this.mAspectRatio = a.getInt(R.styleable.BJVideoView_bjy_aspect_ratio, AspectRatio.AspectRatio_FILL_PARENT.ordinal());
        }
        if (a.hasValue(R.styleable.BJVideoView_bjy_render_type)) {
            this.mRenderType = a.getInt(R.styleable.BJVideoView_bjy_render_type, 1);
        }
        a.recycle();
    }

    public void setAspectRatio(AspectRatio aspectRatio) {
        this.mAspectRatio = aspectRatio.ordinal();
        this.bjyPlayerView.setAspectRatio(aspectRatio);
    }

    public void setRenderType(int renderType) {
        this.mRenderType = renderType == 0 ? 0 : 1;
    }

    @Override
    protected void init(Context context, AttributeSet attrs, int defStyleAttr) {
        super.init(context, attrs, defStyleAttr);
        this.bjyPlayerView = new BJYPlayerView(context, attrs);
        this.subjectOfPlayingTime = PublishSubject.create();
        this.addView((View)this.bjyPlayerView);
    }

    public void reset() {
        this.bjyPlayerView.reset();
        if (this.audioCoverAnimator != null) {
            this.audioCoverAnimator.cancel();
        }
    }

    @Override
    public void initPlayer(IBJYVideoPlayer videoPlayer) {
        this.initPlayer(videoPlayer, true, this.mRenderType);
    }

    public void initPlayer(IBJYVideoPlayer videoPlayer, boolean shouldRenderCustomComponent) {
        this.initPlayer(videoPlayer, shouldRenderCustomComponent, this.mRenderType);
    }

    public void initPlayer(IBJYVideoPlayer videoPlayer, boolean shouldRenderCustomComponent, int preferRenderType) {
        super.initPlayer(videoPlayer);
        this.bjyVideoPlayer.bindPlayerView(this.bjyPlayerView);
        this.bjyPlayerView.setRenderType(preferRenderType);
        this.bjyPlayerView.setAspectRatio(AspectRatio.values()[this.mAspectRatio]);
        if (shouldRenderCustomComponent) {
            this.initComponentContainer(true);
            this.addPlayerListener();
        }
        this.useDefaultNetworkListener = !shouldRenderCustomComponent;
    }

    private void addPlayerListener() {
        this.bjyVideoPlayer.addOnPlayerErrorListener(error -> {
            Bundle bundle = BundlePool.obtain();
            bundle.putString("string_data", error.getMessage());
            this.componentContainer.dispatchErrorEvent(error.getCode(), bundle);
        });
        this.bjyVideoPlayer.addOnPlayingTimeChangeListener((currentTime, duration) -> {
            this.subjectOfPlayingTime.onNext((Object)currentTime);
            this.componentContainer.dispatchPlayEvent(component -> "controller_component".equals(component.getKey()), -99019, BundlePool.obtain((int)currentTime));
            this.componentContainer.dispatchPlayEvent(component -> "simple_controller_component".equals(component.getKey()), -99019, BundlePool.obtain((int)currentTime));
            this.componentContainer.dispatchPlayEvent(component -> "keyframe_sign_component".equals(component.getKey()), -99019, BundlePool.obtain((int)currentTime));
        });
        this.bjyVideoPlayer.addOnBufferUpdateListener(bufferedPercentage -> {
            this.componentContainer.dispatchPlayEvent(component -> "controller_component".equals(component.getKey()), -99012, BundlePool.obtain((int)bufferedPercentage));
            this.componentContainer.dispatchPlayEvent(component -> "simple_controller_component".equals(component.getKey()), -99012, BundlePool.obtain((int)bufferedPercentage));
        });
        this.bjyVideoPlayer.addOnBufferingListener(new OnBufferingListener(){

            public void onBufferingStart() {
                BJYVideoView.this.componentContainer.dispatchPlayEvent(-80010, null);
            }

            public void onBufferingEnd() {
                BJYVideoView.this.componentContainer.dispatchPlayEvent(-80011, null);
            }
        });
        this.bjyVideoPlayer.addCubChangeListener(cues -> {
            Bundle bundle = BundlePool.obtain();
            bundle.putParcelableArrayList("subtitle", (ArrayList)cues);
            this.componentContainer.dispatchCustomEvent(component -> component.getKey().equals("controller_component"), -80019, bundle);
        });
    }

    private void initComponentContainer(boolean enableDefaultComponents) {
        this.componentContainer = new ComponentContainer(this.getContext());
        this.componentContainer.init(this.bjyVideoPlayer, enableDefaultComponents);
        this.componentContainer.setOnComponentEventListener(this.internalComponentEventListener);
        this.addView((View)this.componentContainer, new ViewGroup.LayoutParams(-1, -1));
    }

    public void setComponentVisibility(int visibility) {
        if (this.componentContainer != null) {
            this.componentContainer.setVisibility(visibility);
        }
    }

    public void removeComponent(String key) {
        this.componentContainer.removeComponent(key);
    }

    @Override
    protected void requestPlayAction() {
        super.requestPlayAction();
        if (this.isPlayOnlineVideo && (this.bjyVideoPlayer.getVideoInfo() == null || this.bjyVideoPlayer.getVideoInfo().getVideoId() == 0L)) {
            this.setupOnlineVideoWithId(this.videoId, this.token);
            this.sendCustomEvent(-80017, null);
        } else {
            this.bjyVideoPlayer.play();
        }
    }

    public long getVideoId() {
        return this.videoId;
    }

    public String getToken() {
        return this.token;
    }

    public void setupOnlineVideoWithId(long videoId, String token) {
        this.videoId = videoId;
        this.token = token;
        if (this.useDefaultNetworkListener) {
            this.registerNetChangeReceiver();
        }
        if (!this.enablePlayWithMobileNetwork && NetworkUtils.isMobile(NetworkUtils.getNetworkState(this.getContext()))) {
            this.sendCustomEvent(-80012, null);
        } else {
            this.bjyVideoPlayer.setupOnlineVideoWithId(videoId, token);
        }
        this.isPlayOnlineVideo = true;
    }

    public void setAudioCover(String audioCover) {
        this.audioCover = audioCover;
    }

    public void setupOnlineVideoWithVideoItem(VideoItem videoItem) {
        this.videoId = videoItem.videoId;
        if (this.useDefaultNetworkListener) {
            this.registerNetChangeReceiver();
        }
        if (!this.enablePlayWithMobileNetwork && NetworkUtils.isMobile(NetworkUtils.getNetworkState(this.getContext()))) {
            this.sendCustomEvent(-80012, null);
        } else {
            this.bjyVideoPlayer.setupOnlineVideoWithVideoItem(videoItem);
        }
        this.isPlayOnlineVideo = true;
    }

    public void setupLocalVideoWithDownloadModel(DownloadModel downloadModel) {
        this.bjyVideoPlayer.setupLocalVideoWithDownloadModel(downloadModel);
        this.isPlayOnlineVideo = false;
    }

    private void newAudioCover() {
        this.audioCoverView = View.inflate((Context)this.getContext(), (int)R.layout.bjy_pb_layout_audio_placeholder, null);
        this.audioCoverContainer = this.audioCoverView.findViewById(R.id.audio_cover_container);
        ImageView audioCoverIv = (ImageView)this.audioCoverView.findViewById(R.id.audio_cover_iv);
        Glide.with((View)this).load(this.audioCover).apply(RequestOptions.bitmapTransform((Transformation)new CircleCrop())).into(audioCoverIv);
        int index = this.indexOfChild((View)this.componentContainer);
        this.addView(this.audioCoverView, index, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    private void startAnimation(View view) {
        if (this.audioCoverAnimator == null) {
            this.audioCoverAnimator = ObjectAnimator.ofFloat((Object)view, (String)"rotation", (float[])new float[]{0.0f, 360.0f});
            this.audioCoverAnimator.setRepeatCount(-1);
            this.audioCoverAnimator.setRepeatMode(1);
            this.audioCoverAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.audioCoverAnimator.setDuration(2000L);
        }
        this.audioCoverAnimator.start();
    }

    @Override
    public void updateAudioCoverStatus(boolean forceAudio) {
        if (this.videoStatus == PlayerStatus.STATE_PLAYBACK_COMPLETED || this.bjyVideoPlayer.getVideoInfo() == null) {
            return;
        }
        if (this.audioCoverView == null) {
            this.newAudioCover();
        }
        if (this.bjyVideoPlayer.getVideoInfo().getDefinition() == VideoDefinition.Audio || forceAudio) {
            this.audioCoverView.setVisibility(0);
            this.startAnimation(this.audioCoverContainer);
        } else {
            this.audioCoverView.setVisibility(8);
            if (this.audioCoverAnimator != null) {
                this.audioCoverAnimator.cancel();
            }
        }
    }

    @Override
    protected void updateAudioCoverAnim(PlayerStatus status) {
        super.updateAudioCoverAnim(status);
        if (status == PlayerStatus.STATE_STARTED) {
            if (this.audioCoverAnimator != null && this.audioCoverAnimator.isPaused()) {
                this.audioCoverAnimator.resume();
            }
        } else if (status == PlayerStatus.STATE_PAUSED && this.audioCoverAnimator != null && this.audioCoverAnimator.isRunning()) {
            this.audioCoverAnimator.pause();
        }
    }

    public Observable<Integer> getObservablePlayingTime() {
        return this.subjectOfPlayingTime;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.audioCoverAnimator != null) {
            this.audioCoverAnimator.cancel();
        }
    }
}

