/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.component;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.Switch;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.BJYPlayerSDK;
import com.baijiayun.videoplayer.bean.SubtitleItem;
import com.baijiayun.videoplayer.event.BundlePool;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.component.BaseComponent;
import com.baijiayun.videoplayer.ui.databinding.BjyPbLayoutSubtitleMenuComponentBinding;
import com.baijiayun.videoplayer.ui.listener.OnTouchGestureListener;
import java.util.List;

public class SubtitleMenuComponent
extends BaseComponent
implements OnTouchGestureListener {
    private Switch subtitleSwitch;
    private int selectedPosition = 0;
    private SubtitleAdapter subtitleAdapter;
    private List<SubtitleItem> subtitleItemList;
    private BjyPbLayoutSubtitleMenuComponentBinding binding;
    private View checkedIv;
    private int[] colors = new int[]{-1, -381651, -159934, -14693204, -7647774, -16746753};

    public SubtitleMenuComponent(Context context, List<SubtitleItem> subtitleItemList) {
        super(context);
        this.subtitleItemList = subtitleItemList;
        this.initView();
    }

    @Override
    protected View onCreateComponentView(Context context) {
        View view = View.inflate((Context)context, (int)R.layout.bjy_pb_layout_subtitle_menu_component, null);
        this.binding = BjyPbLayoutSubtitleMenuComponentBinding.bind(view);
        return view;
    }

    private void initView() {
        this.subtitleSwitch = (Switch)this.findViewById(R.id.subtitle_switch);
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.subtitle_list_view);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.subtitleSwitch.setOnCheckedChangeListener((buttonView, isChecked) -> {
            this.notifyComponentEvent(-80021, BundlePool.obtain((boolean)isChecked));
            this.subtitleAdapter.notifyDataSetChanged();
        });
        this.subtitleAdapter = new SubtitleAdapter();
        recyclerView.setAdapter((RecyclerView.Adapter)this.subtitleAdapter);
        for (int i = 0; i < this.subtitleItemList.size(); ++i) {
            if (!this.subtitleItemList.get((int)i).isDefault) continue;
            this.selectedPosition = i + 1;
            break;
        }
        this.binding.subtitleCheckIv1.setSelected(true);
        this.checkedIv = this.binding.subtitleCheckIv1;
        this.binding.subtitleCheckIv1.setOnClickListener((View.OnClickListener)new ClickListener(0));
        this.binding.subtitleCheckIv2.setOnClickListener((View.OnClickListener)new ClickListener(1));
        this.binding.subtitleCheckIv3.setOnClickListener((View.OnClickListener)new ClickListener(2));
        this.binding.subtitleCheckIv4.setOnClickListener((View.OnClickListener)new ClickListener(3));
        this.binding.subtitleCheckIv5.setOnClickListener((View.OnClickListener)new ClickListener(4));
        this.binding.subtitleCheckIv6.setOnClickListener((View.OnClickListener)new ClickListener(5));
    }

    @Override
    protected void setKey() {
        this.key = "subtitle_menu_component";
    }

    @Override
    public void onComponentEvent(int eventCode, Bundle bundle) {
        super.onComponentEvent(eventCode, bundle);
        if (eventCode == -80020) {
            this.getView().setVisibility(bundle.getBoolean("req_toggle_subtitle") && this.getView().getVisibility() == 8 ? 0 : 8);
        } else if (eventCode == -80034) {
            this.getView().setVisibility(8);
        }
    }

    @Override
    public void onCustomEvent(int eventCode, Bundle bundle) {
        super.onCustomEvent(eventCode, bundle);
        if (this.subtitleSwitch != null && eventCode == -80054) {
            this.subtitleSwitch.setChecked(bundle.getBoolean("bool_data"));
        }
    }

    @Override
    public void onSingleTapUp(MotionEvent event) {
        if (this.getView().getVisibility() == 0) {
            this.getView().setVisibility(8);
        }
    }

    @Override
    public void onDoubleTap(MotionEvent event) {
    }

    @Override
    public void onDown(MotionEvent event) {
    }

    @Override
    public void onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
    }

    @Override
    public void onEndGesture() {
    }

    @Override
    public void duringComponentTouch(boolean isInTouch) {
    }

    @Override
    public void onLongPress() {
    }

    private class SubtitleAdapter
    extends RecyclerView.Adapter<SubtitleViewHolder> {
        private SubtitleAdapter() {
        }

        @NonNull
        public SubtitleViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
            View view = LayoutInflater.from((Context)SubtitleMenuComponent.this.getContext()).inflate(R.layout.bjy_pb_item_subtitle_menu, viewGroup, false);
            return new SubtitleViewHolder(view);
        }

        public void onBindViewHolder(@NonNull SubtitleViewHolder subtitleViewHolder, int i) {
            SubtitleItem subtitleItem = (SubtitleItem)SubtitleMenuComponent.this.subtitleItemList.get(i);
            subtitleViewHolder.checkedTextView.setText((CharSequence)subtitleItem.name);
            if (Math.abs(SubtitleMenuComponent.this.selectedPosition - 1) == i) {
                subtitleViewHolder.checkedTextView.setTextColor(SubtitleMenuComponent.this.getContext().getResources().getColor(R.color.live_white));
                subtitleViewHolder.checkIv.setVisibility(0);
            } else {
                subtitleViewHolder.checkedTextView.setTextColor(SubtitleMenuComponent.this.getContext().getResources().getColor(R.color.subtitle_item_unselected_color));
                subtitleViewHolder.checkIv.setVisibility(4);
            }
            subtitleViewHolder.itemView.setOnClickListener(v -> {
                if (SubtitleMenuComponent.this.selectedPosition > 0) {
                    SubtitleMenuComponent.this.selectedPosition = i + 1;
                    this.notifyDataSetChanged();
                    Bundle bundle = !TextUtils.isEmpty((CharSequence)subtitleItem.zhUrl) && !TextUtils.isEmpty((CharSequence)subtitleItem.enUrl) ? BundlePool.obtain((String)subtitleItem.zhUrl, (String)subtitleItem.enUrl) : BundlePool.obtain((String)subtitleItem.url);
                    SubtitleMenuComponent.this.notifyComponentEvent(-80022, bundle);
                }
            });
        }

        public int getItemCount() {
            return SubtitleMenuComponent.this.subtitleItemList.size();
        }

        class SubtitleViewHolder
        extends RecyclerView.ViewHolder {
            TextView checkedTextView;
            ImageView checkIv;

            SubtitleViewHolder(View itemView) {
                super(itemView);
                this.checkedTextView = (TextView)itemView.findViewById(R.id.subtitle_text_view);
                this.checkIv = (ImageView)itemView.findViewById(R.id.subtitle_check_iv);
            }
        }
    }

    private class ClickListener
    implements View.OnClickListener {
        private int index;

        public ClickListener(int index) {
            this.index = index;
        }

        public void onClick(View v) {
            if (v == SubtitleMenuComponent.this.checkedIv) {
                return;
            }
            SubtitleMenuComponent.this.checkedIv.setSelected(false);
            v.setSelected(true);
            SubtitleMenuComponent.this.checkedIv = v;
            BJYPlayerSDK.subtitleForegroundColor = SubtitleMenuComponent.this.colors[this.index];
            SubtitleMenuComponent.this.notifyComponentEvent(-80055, null);
        }
    }
}

