/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.download.DownloadModel;
import com.baijiayun.livebase.widgets.dialog.CustomUserDialog;
import com.baijiayun.network.request.VideoQuizAnswerModel;
import com.baijiayun.videoplayer.bean.AlbumInfoModel;
import com.baijiayun.videoplayer.event.BundlePool;
import com.baijiayun.videoplayer.player.PlayerStatus;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.activity.BaseActivity;
import com.baijiayun.videoplayer.ui.bean.VisitorModel;
import com.baijiayun.videoplayer.ui.component.HorseLampComponent;
import com.baijiayun.videoplayer.ui.component.KeyFrameComponent;
import com.baijiayun.videoplayer.ui.listener.CallbackManager;
import com.baijiayun.videoplayer.ui.utils.PBUIUtils;
import com.baijiayun.videoplayer.ui.utils.PiPHelper;
import com.baijiayun.videoplayer.ui.videoplayer.CommentFragment;
import com.baijiayun.videoplayer.ui.videoplayer.CommentPresenter;
import com.baijiayun.videoplayer.ui.viewmodel.VideoPlayViewModel;
import com.baijiayun.videoplayer.ui.widget.BJYVideoView;
import com.baijiayun.videoplayer.ui.widget.DragControllerDialog;
import com.baijiayun.videoplayer.ui.widget.SignDialogFragment;
import com.baijiayun.videoplayer.ui.widget.VideoAlbumDialogFragment;
import com.baijiayun.videoplayer.ui.widget.VideoQuizDialogFragment;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.io.Serializable;
import java.util.ArrayList;

public class VideoPlayActivity
extends BaseActivity {
    private Disposable disposeOfPlayingTime;
    private Disposable disposeOfKeyFrame;
    private PiPHelper pipHelper;
    private VideoQuizDialogFragment videoQuizDialogFragment;
    private VideoAlbumDialogFragment videoAlbumDialogFragment;
    private FrameLayout commentContainer;
    private CommentFragment commentFragment;
    private SignDialogFragment signDialogFragment;
    private VideoPlayViewModel videoPlayViewModel;
    private BJYVideoView videoView;
    private CustomUserDialog customUserDialog;
    private DragControllerDialog dragControllerDialog;
    private boolean isSubtitleInit;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.bjy_pb_activity_video_play);
        this.videoPlayViewModel = (VideoPlayViewModel)new ViewModelProvider((ViewModelStoreOwner)this).get(VideoPlayViewModel.class);
        this.rootContainer = (ViewGroup)this.findViewById(R.id.video_root_container);
        this.initView();
        this.subscribe();
        this.isLandscape = this.videoPlayerConfig.isLandscape != null ? this.videoPlayerConfig.isLandscape : true;
        if (this.isLandscape || !TextUtils.isEmpty((CharSequence)this.albumID)) {
            this.requestedOrientation(0);
            this.requestLayout(true);
        } else {
            this.requestedOrientation(1);
            this.requestLayout(false);
        }
        this.initDataModel();
    }

    private void initView() {
        this.initOrientationEventListener();
        this.videoView = (BJYVideoView)this.findViewById(R.id.bjyvideoview);
        this.baseVideoView = this.videoView;
        this.videoView.initPlayer(this.bjyVideoPlayer);
        this.initHorseLamp();
        if (!TextUtils.isEmpty((CharSequence)this.videoPlayerConfig.videoTitle)) {
            this.videoView.sendCustomEvent(-80050, BundlePool.obtain((String)this.videoPlayerConfig.videoTitle));
        }
        this.videoView.setComponentEventListener((eventCode, bundle) -> {
            switch (eventCode) {
                case -80007: {
                    if (this.isLandscape && this.videoPlayerConfig.enableToggleScreen && !this.isInMultiMode()) {
                        this.requestedOrientation(1);
                        break;
                    }
                    this.finish();
                    break;
                }
                case -80006: {
                    this.requestedOrientation(this.isLandscape ? 1 : 0);
                    break;
                }
                case -80043: {
                    this.currentAlbumIndex = Math.max(0, this.currentAlbumIndex - 1);
                    this.switchTargetVideo();
                    break;
                }
                case -80044: {
                    this.currentAlbumIndex = Math.min(this.currentAlbumIndex + 1, this.albumItemList.size() - 1);
                    this.switchTargetVideo();
                    break;
                }
                case -80046: {
                    if (this.videoAlbumDialogFragment == null) {
                        this.videoAlbumDialogFragment = new VideoAlbumDialogFragment(this.albumItemList, true);
                        this.videoAlbumDialogFragment.setOnAlbumItemClickListener(position -> {
                            this.currentAlbumIndex = position;
                            this.switchTargetVideo();
                        });
                    }
                    if (this.videoAlbumDialogFragment.isVisible()) {
                        this.videoAlbumDialogFragment.dismiss();
                        break;
                    }
                    this.showDialogFragment(this.videoAlbumDialogFragment);
                    this.videoAlbumDialogFragment.updateList(this.currentAlbumIndex);
                    break;
                }
                case -80002: {
                    int seekToPosition = bundle.getInt("int_data");
                    if (this.videoPlayViewModel.getCacheTime() == -1) {
                        this.videoPlayViewModel.setCacheTime(this.bjyVideoPlayer.getCurrentPosition());
                    }
                    if (!this.checkDragControllerDialog(seekToPosition)) break;
                    bundle.putInt("int_data", this.videoPlayViewModel.getCacheTime());
                    break;
                }
                case -80048: {
                    boolean showPiP = bundle.getBoolean("bool_data");
                    if (showPiP) {
                        this.showPiP();
                        break;
                    }
                    if (this.pipHelper == null) break;
                    this.pipHelper.dismiss();
                    break;
                }
                case -80053: {
                    this.takeScreenshot();
                    break;
                }
            }
        });
        this.startVideo();
    }

    private void initHorseLamp() {
        this.videoView.addComponent("horse_lamp_component", new HorseLampComponent((Context)this));
        Bundle bundle = BundlePool.obtain();
        bundle.putSerializable("videoConfig", (Serializable)this.videoPlayerConfig);
        this.videoView.sendCustomEvent(-80049, bundle);
    }

    private void startVideo() {
        if (this.getIntent().getBooleanExtra("isOffline", false)) {
            this.videoView.setupLocalVideoWithDownloadModel((DownloadModel)this.getIntent().getSerializableExtra("videoDownloadModel"));
        } else if (!this.albumItemList.isEmpty()) {
            AlbumInfoModel currentAlbum = (AlbumInfoModel)this.albumItemList.get(this.currentAlbumIndex % this.albumItemList.size());
            this.videoView.setupOnlineVideoWithId(currentAlbum.videoUnique, currentAlbum.playerToken);
        }
    }

    private void switchTargetVideo() {
        int index = this.currentAlbumIndex % this.albumItemList.size();
        String playerToken = ((AlbumInfoModel)this.albumItemList.get((int)index)).playerToken;
        long vid = ((AlbumInfoModel)this.albumItemList.get((int)index)).videoUnique;
        if (TextUtils.isEmpty((CharSequence)playerToken)) {
            this.videoPlayViewModel.getPlayInfoByAlbum((Context)this, this.albumID, String.valueOf(vid), false);
        } else {
            this.bjyVideoPlayer.stop();
            this.bjyVideoPlayer.setupOnlineVideoWithId(vid, playerToken);
        }
    }

    @Override
    protected void subscribe() {
        super.subscribe();
        this.compositeDisposable.add(this.videoView.getObservableVideoStatus().observeOn(AndroidSchedulers.mainThread()).subscribe(videoStatus -> {
            if (videoStatus == PlayerStatus.STATE_PREPARED) {
                if (PBUIUtils.disableScreenRecording(this.bjyVideoPlayer)) {
                    this.getWindow().addFlags(8192);
                }
                if (!this.isSubtitleInit) {
                    this.isSubtitleInit = true;
                    this.videoView.sendCustomEvent(-80054, BundlePool.obtain((boolean)this.bjyVideoPlayer.subtitleDefaultEnabled()));
                }
                if (!this.bjyVideoPlayer.isPlayLocalVideo()) {
                    this.initVideoAssociatedFeatures();
                }
                if (this.albumItemList.size() <= 1) {
                    this.videoView.sendCustomEvent(-80045, BundlePool.obtain((int)-1));
                } else {
                    this.videoView.sendCustomEvent(-80045, BundlePool.obtain((int)(this.currentAlbumIndex == 0 ? 0 : (this.currentAlbumIndex == this.albumItemList.size() - 1 ? 2 : 1))));
                }
                if (CallbackManager.getInstance().getExternalAlbumListener() != null) {
                    this.videoView.updateAlbumBtnWhenPrepared(true, true);
                } else {
                    this.videoView.updateAlbumBtnWhenPrepared(!TextUtils.isEmpty((CharSequence)this.albumID) && this.albumItemList.size() > 0, true);
                }
            } else if (videoStatus == PlayerStatus.STATE_PLAYBACK_COMPLETED && !this.bjyVideoPlayer.isPlayLocalVideo() && !TextUtils.isEmpty((CharSequence)this.albumID)) {
                this.currentAlbumIndex = (this.currentAlbumIndex + 1) % this.albumItemList.size();
                this.switchTargetVideo();
            }
        }));
        this.disposeOfPlayingTime = this.videoView.getObservablePlayingTime().observeOn(AndroidSchedulers.mainThread()).subscribe(currentDuration -> {
            this.checkShowVideoQuizWithDuration((int)currentDuration);
            if (!this.videoPlayerConfig.supportBackgroundAudio) {
                return;
            }
            if (currentDuration.intValue() == this.bjyVideoPlayer.getDuration()) {
                this.updatePlayTime(0L, (long)this.bjyVideoPlayer.getDuration() * 1000L);
                return;
            }
            this.updatePlayTime((long)currentDuration.intValue() * 1000L, (long)this.bjyVideoPlayer.getDuration() * 1000L);
        });
    }

    @Override
    protected void parseSerializableExtra() {
        super.parseSerializableExtra();
        long videoId = this.getIntent().getLongExtra("videoId", 0L);
        String token = this.getIntent().getStringExtra("token");
        if (videoId != 0L && !TextUtils.isEmpty((CharSequence)token) && this.albumItemList.isEmpty()) {
            AlbumInfoModel albumInfoModel = new AlbumInfoModel();
            albumInfoModel.videoUnique = videoId;
            albumInfoModel.playerToken = token;
            this.albumItemList.add(albumInfoModel);
        }
        this.albumID = this.getIntent().getStringExtra("album_no");
    }

    private void initDataModel() {
        this.videoPlayViewModel.setDefaultAlbumIndex(this.currentAlbumIndex);
        this.videoPlayViewModel.setAlbumNo(this.albumID);
        this.videoPlayViewModel.setVisitorModel(this.videoPlayerConfig.visitorModel == null ? new VisitorModel() : this.videoPlayerConfig.visitorModel);
        this.videoPlayViewModel.setSignModelList(this.videoPlayerConfig.signModelList == null ? new ArrayList() : this.videoPlayerConfig.signModelList);
        this.videoPlayViewModel.subscribe((Context)this, this.bjyVideoPlayer, false);
        this.videoPlayViewModel.getShowSignDialog().observe((LifecycleOwner)this, signModel -> {
            if (signModel != null) {
                if (this.signDialogFragment == null) {
                    this.signDialogFragment = new SignDialogFragment();
                }
                this.videoView.sendCustomEvent(-80002, BundlePool.obtain((String)"int_data", (Serializable)Integer.valueOf(signModel.seconds)));
                this.showDialogFragment(this.signDialogFragment);
            }
        });
        this.videoPlayViewModel.getShowVisitorDialog().observe((LifecycleOwner)this, visitorModel -> {
            if (visitorModel != null) {
                if (this.customUserDialog == null) {
                    this.customUserDialog = new CustomUserDialog();
                }
                this.videoView.sendCustomEvent(-80002, BundlePool.obtain((String)"int_data", (Serializable)Integer.valueOf(visitorModel.seconds)));
                this.customUserDialog.setArguments(BundlePool.obtain((String)CustomUserDialog.class.getSimpleName(), (Serializable)((Object)this.videoPlayerConfig.visitorModel)));
                this.customUserDialog.setOnNegativeClickListener(v -> CallbackManager.getInstance().getVisitorListener().onNavigateClick((DialogFragment)this.customUserDialog, this.bjyVideoPlayer));
                this.customUserDialog.setOnPositiveClickListener(v -> CallbackManager.getInstance().getVisitorListener().onPositiveClick((DialogFragment)this.customUserDialog, this.bjyVideoPlayer));
                this.customUserDialog.show(this.getSupportFragmentManager(), "CustomUserDialog");
            }
        });
        this.videoPlayViewModel.getAlbumError().observe((LifecycleOwner)this, unit -> {
            if (unit != null) {
                this.requestedOrientation(0);
                View emptyView = View.inflate((Context)this, (int)R.layout.bjy_pb_layout_album_empty, null);
                this.rootContainer.removeAllViews();
                this.rootContainer.addView(emptyView, -1, -1);
            }
        });
        this.videoPlayViewModel.getAlbumReady().observe((LifecycleOwner)this, unit -> {
            if (unit != null) {
                this.albumItemList = this.videoPlayViewModel.getAlbumInfoModelList();
                this.startVideo();
            }
        });
        this.videoPlayViewModel.getAlbumUpdate().observe((LifecycleOwner)this, unit -> {
            if (unit != null) {
                this.albumItemList = this.videoPlayViewModel.getAlbumInfoModelList();
                this.switchTargetVideo();
            }
        });
        this.videoPlayViewModel.getVideoItemLiveData().observe((LifecycleOwner)this, videoItem -> {
            if (!TextUtils.isEmpty((CharSequence)videoItem.audioModeCover) && this.videoView != null) {
                this.videoView.setAudioCover(videoItem.audioModeCover);
            }
        });
    }

    private boolean checkDragControllerDialog(int seekPosition) {
        if (!this.videoPlayerConfig.enableDragController && seekPosition > this.videoPlayViewModel.getCacheTime()) {
            if (this.dragControllerDialog == null) {
                this.dragControllerDialog = new DragControllerDialog();
            }
            this.dragControllerDialog.setArguments(BundlePool.obtain((String)CustomUserDialog.class.getSimpleName(), (Serializable)((Object)this.videoPlayerConfig.dragControllerModel)));
            this.dragControllerDialog.show(this.getSupportFragmentManager(), "DragControllerDialog");
            this.dragControllerDialog.setOnPositiveClickListener(v -> {
                this.dragControllerDialog.dismissAllowingStateLoss();
                CallbackManager.getInstance().getDragConsumer().accept((Object)this.videoPlayerConfig.dragControllerModel);
            });
            return true;
        }
        return false;
    }

    private void initVideoAssociatedFeatures() {
        this.bjyVideoPlayer.getVideoQuizList(String.valueOf(this.videoView.getVideoId()), this.videoPlayerConfig.userId, this.videoView.getToken(), videoQuizModels -> {
            this.dismissVideoQuizDlg();
            if (videoQuizModels.isEmpty()) {
                return;
            }
            if (this.videoQuizDialogFragment == null) {
                this.videoQuizDialogFragment = new VideoQuizDialogFragment(new VideoQuizDialogFragment.SubmitClickListener(){

                    @Override
                    public void skip(@NonNull VideoQuizAnswerModel videoQuizAnswerModel) {
                        videoQuizAnswerModel.token = VideoPlayActivity.this.videoView.getToken();
                        videoQuizAnswerModel.userName = VideoPlayActivity.this.videoPlayerConfig.userName;
                        videoQuizAnswerModel.userNumber = VideoPlayActivity.this.videoPlayerConfig.userId;
                        VideoPlayActivity.this.bjyVideoPlayer.sendVideoQuizAnswer(videoQuizAnswerModel);
                        VideoPlayActivity.this.videoQuizDialogFragment.dismiss();
                        VideoPlayActivity.this.bjyVideoPlayer.play();
                    }

                    @Override
                    public void commit(@NonNull VideoQuizAnswerModel videoQuizAnswerModel) {
                        videoQuizAnswerModel.userNumber = VideoPlayActivity.this.videoPlayerConfig.userId;
                        videoQuizAnswerModel.userName = VideoPlayActivity.this.videoPlayerConfig.userName;
                        videoQuizAnswerModel.token = VideoPlayActivity.this.videoView.getToken();
                        VideoPlayActivity.this.bjyVideoPlayer.sendVideoQuizAnswer(videoQuizAnswerModel);
                    }

                    @Override
                    public void finish(int backoffTimeIfWrong) {
                        VideoPlayActivity.this.videoQuizDialogFragment.dismiss();
                        if (backoffTimeIfWrong != -1) {
                            VideoPlayActivity.this.bjyVideoPlayer.seek(backoffTimeIfWrong);
                        }
                        VideoPlayActivity.this.bjyVideoPlayer.play();
                    }
                });
            }
            this.videoQuizDialogFragment.initQuizMap(videoQuizModels);
        });
        RxUtils.dispose((Disposable)this.disposeOfKeyFrame);
        this.disposeOfKeyFrame = this.bjyVideoPlayer.getObservableOfRequestKeyFrameModel(String.valueOf(this.videoView.getVideoId())).filter(keyFrameModel -> keyFrameModel != null && keyFrameModel.total != 0).subscribe(keyFrameModel -> {
            this.videoView.removeComponent("keyframe_sign_component");
            this.videoView.addComponent("keyframe_sign_component", new KeyFrameComponent((Context)this, this.isLandscape));
            Bundle bundle = new Bundle();
            bundle.putSerializable("key_frame_model", (Serializable)keyFrameModel);
            this.videoView.sendCustomEvent(-80040, bundle);
        });
        if (this.bjyVideoPlayer.isEnableVideoComment() && !TextUtils.isEmpty((CharSequence)this.videoPlayerConfig.loginToken)) {
            if (this.commentFragment == null || !this.commentFragment.isAdded()) {
                this.initCommentView(this.videoPlayerConfig.loginToken, this.videoPlayerConfig.avatar);
                this.requestedOrientation(1);
                this.requestLayout(false);
            }
        } else {
            this.clearCommentView();
            if (this.isLandscape) {
                this.requestedOrientation(0);
                this.requestLayout(true);
            }
        }
    }

    private void checkShowVideoQuizWithDuration(int duration) {
        int showTime;
        if (this.videoQuizDialogFragment != null && (showTime = this.videoQuizDialogFragment.isShowTime(duration)) != -1) {
            this.bjyVideoPlayer.pause();
            this.bjyVideoPlayer.seek(showTime);
            this.videoQuizDialogFragment.updateViewBeforeShow();
            this.showDialogFragment(this.videoQuizDialogFragment);
        }
    }

    private void dismissVideoQuizDlg() {
        if (this.videoQuizDialogFragment != null && this.videoQuizDialogFragment.isAdded()) {
            this.videoQuizDialogFragment.dismissAllowingStateLoss();
            this.removeFragment((Fragment)this.videoQuizDialogFragment);
        }
        this.videoQuizDialogFragment = null;
    }

    private void initCommentView(String loginToken, String avatarUrl) {
        if (this.commentContainer == null) {
            this.commentContainer = new FrameLayout((Context)this);
            this.commentContainer.setId(View.generateViewId());
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
            params.addRule(12);
            params.addRule(3, R.id.bjyvideoview);
            this.rootContainer.addView((View)this.commentContainer, (ViewGroup.LayoutParams)params);
            this.commentContainer.setVisibility(8);
        }
        if (this.commentFragment == null) {
            this.commentFragment = new CommentFragment();
            CommentPresenter presenter = new CommentPresenter(this.commentFragment, String.valueOf(this.videoView.getVideoId()), loginToken, avatarUrl);
            this.commentFragment.setPresenter(presenter);
        }
        this.addFragment(this.commentContainer.getId(), (Fragment)this.commentFragment);
    }

    private void clearCommentView() {
        if (this.commentContainer != null) {
            this.removeFragment((Fragment)this.commentFragment);
            this.rootContainer.removeView((View)this.commentContainer);
            this.commentFragment = null;
            this.commentContainer = null;
        }
    }

    @Override
    public void onBackPressed() {
        if (this.videoPlayerConfig.enableToggleScreen) {
            super.onBackPressed();
        } else {
            this.finish();
        }
    }

    @Override
    protected void notificationSeekTo(long pos) {
        this.bjyVideoPlayer.seek((int)pos / 1000);
    }

    @Override
    protected void requestLayout(boolean isLandscape) {
        super.requestLayout(isLandscape);
        if (this.videoView == null) {
            return;
        }
        if (!(this.videoView.getLayoutParams() instanceof RelativeLayout.LayoutParams)) {
            return;
        }
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.videoView.getLayoutParams();
        if (isLandscape) {
            layoutParams.width = -1;
            layoutParams.height = -1;
            if (this.commentContainer != null) {
                layoutParams.removeRule(10);
                this.commentContainer.setVisibility(8);
            }
        } else {
            layoutParams.width = DisplayUtils.getScreenWidthPixels((Context)this);
            layoutParams.height = layoutParams.width * 9 / 16;
            if (this.commentContainer != null) {
                layoutParams.addRule(10);
                this.commentContainer.setVisibility(0);
            }
        }
        this.videoView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.videoView.sendCustomEvent(-80006, BundlePool.obtain((boolean)isLandscape));
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.pipHelper != null) {
            this.pipHelper.onActivityResult(requestCode, resultCode, data);
        }
    }

    private void showPiP() {
        if (this.pipHelper == null) {
            this.pipHelper = new PiPHelper((Activity)this, this.bjyVideoPlayer);
            this.getLifecycle().addObserver((LifecycleObserver)this.pipHelper);
        }
        this.pipHelper.show((View)this.videoView);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.clearCommentView();
        if (this.videoView != null) {
            this.videoView.onDestroy();
        }
        RxUtils.dispose((Disposable)this.disposeOfPlayingTime);
        RxUtils.dispose((Disposable)this.disposeOfKeyFrame);
        this.dismissVideoQuizDlg();
        this.dismissAlbumDlg();
    }

    private void dismissAlbumDlg() {
        if (this.videoAlbumDialogFragment != null && this.videoAlbumDialogFragment.isAdded()) {
            this.videoAlbumDialogFragment.dismissAllowingStateLoss();
            this.removeFragment((Fragment)this.videoAlbumDialogFragment);
        }
        this.videoAlbumDialogFragment = null;
    }
}

