/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.widget;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.baijiayun.playback.PBRoom;
import com.baijiayun.videoplayer.IBJYVideoPlayer;
import com.baijiayun.videoplayer.ui.component.BaseComponent;
import com.baijiayun.videoplayer.ui.component.ComponentManager;
import com.baijiayun.videoplayer.ui.event.EventDispatcher;
import com.baijiayun.videoplayer.ui.listener.IComponent;
import com.baijiayun.videoplayer.ui.listener.IComponentEventListener;
import com.baijiayun.videoplayer.ui.listener.IFilter;

public class ComponentContainer
extends FrameLayout {
    private ComponentManager componentManager;
    private IComponentEventListener onComponentEventListener;
    private String key;
    private IComponentEventListener internalComponentEventListener = new IComponentEventListener(){

        @Override
        public void onReceiverEvent(int eventCode, Bundle bundle) {
            if (bundle != null) {
                ComponentContainer.this.key = bundle.getString("private_event");
            } else {
                ComponentContainer.this.key = "";
            }
            if (ComponentContainer.this.onComponentEventListener != null) {
                ComponentContainer.this.onComponentEventListener.onReceiverEvent(eventCode, bundle);
            }
            if (ComponentContainer.this.eventDispatcher != null) {
                ComponentContainer.this.eventDispatcher.dispatchComponentEvent(component -> TextUtils.isEmpty((CharSequence)ComponentContainer.this.key) || component.getKey().equals(ComponentContainer.this.key), eventCode, bundle);
            }
        }
    };
    private EventDispatcher eventDispatcher;
    private GestureDetector mGestureDetector;
    private boolean mGestureEnable = true;
    private IBJYVideoPlayer videoPlayer;
    private PBRoom pbRoom;

    public ComponentContainer(@NonNull Context context) {
        this(context, null);
    }

    public ComponentContainer(PBRoom pbRoom, @NonNull Context context) {
        this(context, null);
        this.pbRoom = pbRoom;
    }

    public ComponentContainer(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ComponentContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initGestureDetector(context);
    }

    private void initGestureDetector(Context context) {
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDown(MotionEvent e) {
                if (ComponentContainer.this.eventDispatcher != null) {
                    ComponentContainer.this.eventDispatcher.dispatchTouchEventOnDown(e);
                }
                return ComponentContainer.this.mGestureEnable;
            }

            public boolean onSingleTapConfirmed(@NonNull MotionEvent e) {
                if (ComponentContainer.this.eventDispatcher != null) {
                    ComponentContainer.this.eventDispatcher.dispatchTouchEventOnSingleTabUp(e);
                }
                return super.onSingleTapConfirmed(e);
            }

            public boolean onDoubleTap(MotionEvent e) {
                if (ComponentContainer.this.eventDispatcher != null) {
                    ComponentContainer.this.eventDispatcher.dispatchTouchEventOnDoubleTabUp(e);
                }
                return super.onDoubleTap(e);
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                if (ComponentContainer.this.eventDispatcher != null) {
                    ComponentContainer.this.eventDispatcher.dispatchTouchEventOnScroll(e1, e2, distanceX, distanceY);
                }
                return super.onScroll(e1, e2, distanceX, distanceY);
            }

            public void onLongPress(@NonNull MotionEvent e) {
                super.onLongPress(e);
                if (ComponentContainer.this.eventDispatcher != null) {
                    ComponentContainer.this.eventDispatcher.dispatchTouchEventLongPress();
                }
            }
        });
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 1 && this.eventDispatcher != null) {
            this.eventDispatcher.dispatchTouchEventOnEndGesture();
        }
        return this.mGestureEnable && this.mGestureDetector.onTouchEvent(event);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            if (this.eventDispatcher != null) {
                this.eventDispatcher.dispatchDuringDispatchTouchEvent(true);
            }
        } else if (ev.getAction() == 1 && this.eventDispatcher != null) {
            this.eventDispatcher.dispatchDuringDispatchTouchEvent(false);
        }
        return super.dispatchTouchEvent(ev);
    }

    public void addComponent(String key, BaseComponent component) {
        if (this.componentManager != null) {
            this.componentManager.addComponent(key, component);
        }
        this.addComponent(component);
    }

    public void removeComponent(String key) {
        if (this.componentManager != null) {
            this.componentManager.forEach(component -> {
                if (key.equals(component.getKey())) {
                    this.removeComponent(component);
                }
            });
            this.componentManager.removeComponent(key);
        }
    }

    private void addComponent(IComponent component) {
        component.bindVideoPlayer(this.videoPlayer);
        this.addView(component.getView(), new ViewGroup.LayoutParams(-1, -1));
        component.setComponentEventListener(this.internalComponentEventListener);
    }

    private void removeComponent(IComponent component) {
        this.removeView(component.getView());
        component.destroy();
    }

    public void setOnComponentEventListener(IComponentEventListener componentEventListener) {
        this.onComponentEventListener = componentEventListener;
    }

    public final void dispatchPlayEvent(int eventCode, Bundle bundle) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.dispatchPlayEvent(eventCode, bundle);
        }
    }

    public final void dispatchPlayEvent(IFilter filter, int eventCode, Bundle bundle) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.dispatchPlayEvent(filter, eventCode, bundle);
        }
    }

    public final void dispatchErrorEvent(int eventCode, Bundle bundle) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.dispatchErrorEvent(eventCode, bundle);
        }
    }

    public final void dispatchErrorEvent(IFilter filter, int eventCode, Bundle bundle) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.dispatchErrorEvent(filter, eventCode, bundle);
        }
    }

    public final void dispatchCustomEvent(int eventCode, Bundle bundle) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.dispatchCustomEvent(eventCode, bundle);
        }
    }

    public final void dispatchCustomEvent(IFilter filter, int eventCode, Bundle bundle) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.dispatchCustomEvent(filter, eventCode, bundle);
        }
    }

    public final void dispatchSingleTapEvent(MotionEvent event) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.dispatchTouchEventOnSingleTabUp(event);
        }
    }

    public void destroy() {
        this.onComponentEventListener = null;
        this.internalComponentEventListener = null;
        this.eventDispatcher = null;
        this.videoPlayer = null;
        if (this.componentManager != null) {
            this.componentManager.forEach(this::removeComponent);
            this.componentManager.release();
        }
    }

    public boolean isGestureEnable() {
        return this.mGestureEnable;
    }

    public void setGestureEnable(boolean gestureEnable) {
        this.mGestureEnable = gestureEnable;
    }

    public void init(IBJYVideoPlayer videoPlayer, boolean enableDefaultComponents) {
        this.videoPlayer = videoPlayer;
        this.componentManager = new ComponentManager(this.getContext(), enableDefaultComponents, this.pbRoom);
        this.eventDispatcher = new EventDispatcher(this.componentManager);
        this.componentManager.forEach(this::addComponent);
    }
}

