/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.playback.toolbox.timer;

import android.content.Context;
import android.content.res.Resources;
import android.media.SoundPool;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.core.content.res.ResourcesCompat;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.databinding.BjyPbLayoutTimerShowyBinding;

public class TimerShowyWindow
extends FrameLayout {
    private Context context;
    private SoundPool soundPool;
    private BjyPbLayoutTimerShowyBinding binding;

    public TimerShowyWindow(Context context) {
        super(context);
        this.context = context;
        View rootView = View.inflate((Context)context, (int)R.layout.bjy_pb_layout_timer_showy, null);
        this.binding = BjyPbLayoutTimerShowyBinding.bind(rootView);
        this.addView(rootView, -1, -1);
    }

    public TimerShowyWindow(Context context, @Nullable AttributeSet attrs) {
        this(context);
    }

    public TimerShowyWindow(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, null);
    }

    public TimerShowyWindow(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this(context, attrs, defStyleAttr);
    }

    public void setTimer(long remainSeconds) {
        if (remainSeconds < 0L) {
            remainSeconds = 0L;
        }
        long min = remainSeconds / 60L;
        long second = remainSeconds % 60L;
        String sb = (min >= 10L ? Long.valueOf(min) : "0" + min) + ":" + (second >= 10L ? Long.valueOf(second) : "0" + second);
        this.binding.dialogTimerShowyTime.setText((CharSequence)sb);
    }

    public void showViewWarning(boolean enable) {
        this.binding.dialogTimerShowyBg.setBackgroundDrawable(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)(enable ? R.drawable.shape_timer_showy_bg_end : R.drawable.shape_timer_showy_bg_nomal), null));
    }

    public void showTimerEnd() {
        this.binding.dialogTimerShowyBg.setBackgroundDrawable(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)R.drawable.shape_timer_showy_bg_end, null));
        if (this.soundPool != null) {
            this.soundPool.release();
        }
        this.soundPool = UtilsKt.playAudio((Context)this.getContext(), (int)R.raw.timer_end);
    }

    public void release() {
        if (this.soundPool != null) {
            this.soundPool.release();
        }
    }
}

