/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.playback.ppt;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.baijiayun.videoplayer.ui.R;

public class PPTErrorDialogPlayBack
extends Dialog {
    public PPTErrorDialogPlayBack(@NonNull Context context) {
        super(context);
    }

    public static class Builder {
        private Context context;
        private String descriptionText;
        private String suggestionText;
        private String negativeText;
        private String positiveText;
        private DialogInterface.OnClickListener onPositiveClickListener;
        private DialogInterface.OnClickListener onNegativeClickListener;
        private int recordType;

        public Builder(Context context, int recordType) {
            this.context = context;
            this.recordType = recordType;
        }

        public Builder setDescriptionText(String descriptionText) {
            this.descriptionText = descriptionText;
            return this;
        }

        public Builder setSuggestionText(String suggestionText) {
            this.suggestionText = suggestionText;
            return this;
        }

        public Builder setNegative(String negativeText, DialogInterface.OnClickListener onNegativeClickListener) {
            this.negativeText = negativeText;
            this.onNegativeClickListener = onNegativeClickListener;
            return this;
        }

        public Builder setPositive(String positiveText, DialogInterface.OnClickListener onPositiveClickListener) {
            this.positiveText = positiveText;
            this.onPositiveClickListener = onPositiveClickListener;
            return this;
        }

        public PPTErrorDialogPlayBack create() {
            PPTErrorDialogPlayBack dialog = new PPTErrorDialogPlayBack(this.context);
            View layout2 = LayoutInflater.from((Context)this.context).inflate(R.layout.bjy_dialog_anim_ppt_overtime_play_back, null);
            dialog.addContentView(layout2, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
            TextView tvDescription = (TextView)layout2.findViewById(R.id.anim_ppt_error_description);
            tvDescription.setText((CharSequence)this.descriptionText);
            TextView tvSuggestion = (TextView)layout2.findViewById(R.id.anim_ppt_error_suggestion);
            tvSuggestion.setText((CharSequence)this.suggestionText);
            TextView tvNegative = (TextView)layout2.findViewById(R.id.anim_ppt_error_negative_btn);
            if (TextUtils.isEmpty((CharSequence)this.negativeText)) {
                tvNegative.setVisibility(8);
            } else {
                tvNegative.setText((CharSequence)this.negativeText);
                if (this.onNegativeClickListener != null) {
                    tvNegative.setOnClickListener(v -> {
                        this.onNegativeClickListener.onClick((DialogInterface)dialog, -2);
                        dialog.dismiss();
                    });
                }
            }
            TextView tvPositive = (TextView)layout2.findViewById(R.id.anim_ppt_error_positive_btn);
            if (TextUtils.isEmpty((CharSequence)this.positiveText)) {
                tvPositive.setVisibility(8);
            } else {
                tvPositive.setText((CharSequence)this.positiveText);
                if (this.onPositiveClickListener != null) {
                    tvPositive.setOnClickListener(v -> {
                        this.onPositiveClickListener.onClick((DialogInterface)dialog, -1);
                        dialog.dismiss();
                    });
                }
            }
            if (this.recordType != 0 && this.recordType != 1) {
                layout2.setBackground(this.context.getResources().getDrawable(R.drawable.bg_dialog_ppt_error_play_back_pro));
                tvDescription.setTextColor(this.context.getResources().getColor(R.color.live_white));
                tvSuggestion.setTextColor(this.context.getResources().getColor(R.color.live_white));
                tvNegative.setTextAppearance(this.context, R.style.PPTErrorDialogBtLeftPro);
                tvPositive.setTextAppearance(this.context, R.style.PPTErrorDialogBtRightPro);
            }
            dialog.setContentView(layout2);
            Window dialogWindow = dialog.getWindow();
            dialogWindow.setBackgroundDrawableResource(17170445);
            return dialog;
        }
    }
}

