/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.playback.ppt;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.DimenRes;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

public class ListSpacingDecoration
extends RecyclerView.ItemDecoration {
    private static final int VERTICAL = 1;
    private int orientation = -1;
    private int spanCount = -1;
    private int spacing;

    public ListSpacingDecoration(Context context, @DimenRes int spacingDimen) {
        this.spacing = context.getResources().getDimensionPixelSize(spacingDimen);
    }

    public ListSpacingDecoration(int spacingPx) {
        this.spacing = spacingPx;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        if (this.orientation == -1) {
            this.orientation = this.getOrientation(parent);
        }
        if (this.spanCount == -1) {
            this.spanCount = this.getTotalSpan(parent);
        }
        int childCount = parent.getLayoutManager().getItemCount();
        int childIndex = parent.getChildAdapterPosition(view);
        int itemSpanSize = this.getItemSpanSize(parent, childIndex);
        int spanIndex = this.getItemSpanIndex(parent, childIndex);
        if (this.spanCount < 1) {
            return;
        }
        this.setSpacings(outRect, parent, childCount, childIndex, itemSpanSize, spanIndex);
    }

    protected void setSpacings(Rect outRect, RecyclerView parent, int childCount, int childIndex, int itemSpanSize, int spanIndex) {
        if (this.isBottomEdge(parent, childCount, childIndex, itemSpanSize, spanIndex)) {
            outRect.bottom = this.spacing;
        }
    }

    protected int getTotalSpan(RecyclerView parent) {
        RecyclerView.LayoutManager mgr = parent.getLayoutManager();
        if (mgr instanceof GridLayoutManager) {
            return ((GridLayoutManager)mgr).getSpanCount();
        }
        if (mgr instanceof StaggeredGridLayoutManager) {
            return ((StaggeredGridLayoutManager)mgr).getSpanCount();
        }
        if (mgr instanceof LinearLayoutManager) {
            return 1;
        }
        return -1;
    }

    protected int getItemSpanSize(RecyclerView parent, int childIndex) {
        RecyclerView.LayoutManager mgr = parent.getLayoutManager();
        if (mgr instanceof GridLayoutManager) {
            return ((GridLayoutManager)mgr).getSpanSizeLookup().getSpanSize(childIndex);
        }
        if (mgr instanceof StaggeredGridLayoutManager) {
            return 1;
        }
        if (mgr instanceof LinearLayoutManager) {
            return 1;
        }
        return -1;
    }

    protected int getItemSpanIndex(RecyclerView parent, int childIndex) {
        RecyclerView.LayoutManager mgr = parent.getLayoutManager();
        if (mgr instanceof GridLayoutManager) {
            return ((GridLayoutManager)mgr).getSpanSizeLookup().getSpanIndex(childIndex, this.spanCount);
        }
        if (mgr instanceof StaggeredGridLayoutManager) {
            return childIndex % this.spanCount;
        }
        if (mgr instanceof LinearLayoutManager) {
            return 0;
        }
        return -1;
    }

    protected int getOrientation(RecyclerView parent) {
        RecyclerView.LayoutManager mgr = parent.getLayoutManager();
        if (mgr instanceof LinearLayoutManager) {
            return ((LinearLayoutManager)mgr).getOrientation();
        }
        if (mgr instanceof GridLayoutManager) {
            return ((GridLayoutManager)mgr).getOrientation();
        }
        if (mgr instanceof StaggeredGridLayoutManager) {
            return ((StaggeredGridLayoutManager)mgr).getOrientation();
        }
        return 1;
    }

    protected boolean isBottomEdge(RecyclerView parent, int childCount, int childIndex, int itemSpanSize, int spanIndex) {
        if (this.orientation == 1) {
            return this.isLastItemEdgeValid(childIndex >= childCount - this.spanCount, parent, childCount, childIndex, spanIndex);
        }
        return spanIndex + itemSpanSize == this.spanCount;
    }

    protected boolean isLastItemEdgeValid(boolean isOneOfLastItems, RecyclerView parent, int childCount, int childIndex, int spanIndex) {
        int totalSpanRemaining = 0;
        if (isOneOfLastItems) {
            for (int i = childIndex; i < childCount; ++i) {
                totalSpanRemaining += this.getItemSpanSize(parent, i);
            }
        }
        return isOneOfLastItems && totalSpanRemaining <= this.spanCount - spanIndex;
    }
}

