/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.component;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.drawable.StateListDrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.constant.VideoDefinition;
import com.baijiayun.videoplayer.bean.BJYVideoInfo;
import com.baijiayun.videoplayer.event.BundlePool;
import com.baijiayun.videoplayer.player.PlayerStatus;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.bean.Rate;
import com.baijiayun.videoplayer.ui.component.BaseComponent;
import com.baijiayun.videoplayer.ui.listener.OnTouchGestureListener;
import com.baijiayun.videoplayer.util.VideoPlayerUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MenuComponent
extends BaseComponent
implements OnTouchGestureListener {
    private RecyclerView recyclerView;
    private FrameLayout recyclerContainer;
    private List<VideoDefinition> definitionItemList = new ArrayList<VideoDefinition>();
    private List<Rate> rateList = new ArrayList<Rate>();
    private TextAdapter textAdapter;

    public MenuComponent(Context context) {
        super(context);
        this.getView().setBackground(new DrawableBuilder().solidColor(Color.parseColor((String)"#4D000000")).cornerRadius(UtilsKt.getDp((int)4)).build());
        this.initView();
        this.initRateList();
        this.initAdapter();
    }

    @Override
    protected View onCreateComponentView(Context context) {
        return View.inflate((Context)context, (int)R.layout.bjy_pb_layout_menu_component, null);
    }

    private void initView() {
        this.recyclerView = (RecyclerView)this.findViewById(R.id.rv_bjplayer);
        this.recyclerContainer = (FrameLayout)this.findViewById(R.id.bjplayer_rv_fl);
        this.recyclerContainer.setVisibility(8);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
    }

    @Override
    protected void setKey() {
        this.key = "menu_component";
    }

    @Override
    public void onCustomEvent(int eventCode, Bundle bundle) {
        super.onCustomEvent(eventCode, bundle);
        switch (eventCode) {
            case -80006: {
                this.isLandscape = bundle.getBoolean("bool_data");
                break;
            }
            case -80016: {
                this.doSingleTapUp();
                break;
            }
        }
    }

    @Override
    public void onPlayerEvent(int eventCode, Bundle bundle) {
        PlayerStatus playerStatus;
        super.onPlayerEvent(eventCode, bundle);
        if (eventCode == -99031 && (playerStatus = (PlayerStatus)bundle.getSerializable("serializable_data")) == PlayerStatus.STATE_INITIALIZED) {
            BJYVideoInfo videoInfo = this.getVideoPlayer().getVideoInfo();
            if (videoInfo != null && videoInfo.getSupportedDefinitionList() != null) {
                this.definitionItemList = videoInfo.getSupportedDefinitionList();
                Bundle rst = new Bundle();
                rst.putInt("type", 0);
                rst.putString("definition", VideoPlayerUtils.getDefinitionInString((Context)this.getContext(), (VideoDefinition)videoInfo.getDefinition()));
                this.notifyComponentEvent(-80024, rst);
                this.textAdapter.notifyDefinitionDataSetChange(this.definitionItemList);
            } else {
                Bundle rst = new Bundle();
                rst.putInt("type", 0);
                rst.putString("definition", null);
                this.notifyComponentEvent(-80024, rst);
            }
        }
    }

    @Override
    public void onComponentEvent(int eventCode, Bundle bundle) {
        super.onComponentEvent(eventCode, bundle);
        if (eventCode == -80023) {
            int reqFunc = bundle.getInt("req_toggle_menu", -1);
            switch (reqFunc) {
                case -80025: {
                    this.updateRecyclerContainerPosition(bundle);
                    this.textAdapter.notifyRateDataSetChange(this.rateList);
                    this.recyclerContainer.setVisibility(0);
                    break;
                }
                case -80026: {
                    this.updateRecyclerContainerPosition(bundle);
                    this.textAdapter.notifyDefinitionDataSetChange(this.definitionItemList);
                    this.recyclerContainer.setVisibility(0);
                    break;
                }
                case -80051: {
                    this.updateRecyclerContainerPosition(bundle);
                    this.textAdapter.notifyCDNDataSetChange(this.getVideoPlayer().getCDNCount());
                    this.recyclerContainer.setVisibility(0);
                    break;
                }
                case -80027: {
                    this.recyclerContainer.setVisibility(8);
                    break;
                }
            }
        } else if (eventCode == -80034) {
            this.recyclerContainer.setVisibility(8);
        }
    }

    private void updateRecyclerContainerPosition(Bundle bundle) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.recyclerContainer.getLayoutParams();
        layoutParams.gravity = 8388691;
        layoutParams.width = -2;
        layoutParams.height = -2;
        layoutParams.bottomMargin = bundle.getInt("controller_button_y");
        layoutParams.setMarginStart((int)((float)bundle.getInt("controller_button_x") - this.getContext().getResources().getDimension(R.dimen.controller_component_bar_height)));
        this.recyclerContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void initAdapter() {
        this.textAdapter = new TextAdapter(this.getContext());
        this.textAdapter.setOnRvItemClickListener((view, menuType, index) -> {
            Bundle rst = new Bundle();
            if (menuType == 0) {
                this.notifyComponentEvent(-80009, BundlePool.obtain((Serializable)((Serializable)this.definitionItemList.get(index))));
                rst.putInt("type", 0);
                rst.putString("definition", VideoPlayerUtils.getDefinitionInString((Context)this.getContext(), (VideoDefinition)this.definitionItemList.get(index)));
            } else if (menuType == 1) {
                this.notifyComponentEvent(-80008, BundlePool.obtain((float)this.rateList.get((int)index).rate));
                rst.putInt("type", 1);
                rst.putString("ratio", this.rateList.get((int)index).rate == 1.0f ? "\u500d\u901f" : this.rateList.get((int)index).rateDescription);
            } else {
                this.getVideoPlayer().setCDNIndex(index);
            }
            this.notifyComponentEvent(-80024, rst);
            this.recyclerContainer.setVisibility(8);
        });
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.textAdapter);
    }

    private void initRateList() {
        this.rateList.add(new Rate("0.75", 0.75f));
        this.rateList.add(new Rate("1.0", 1.0f));
        this.rateList.add(new Rate("1.25", 1.25f));
        this.rateList.add(new Rate("1.5", 1.5f));
        this.rateList.add(new Rate("1.75", 1.75f));
        this.rateList.add(new Rate("2.0", 2.0f));
    }

    @Override
    public void onSingleTapUp(MotionEvent event) {
        this.doSingleTapUp();
    }

    @Override
    public void onDoubleTap(MotionEvent event) {
    }

    @Override
    public void onDown(MotionEvent event) {
    }

    @Override
    public void onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
    }

    @Override
    public void onEndGesture() {
    }

    @Override
    public void duringComponentTouch(boolean isInTouch) {
    }

    @Override
    public void onLongPress() {
    }

    private void doSingleTapUp() {
        if (this.recyclerContainer.getVisibility() == 0) {
            this.recyclerContainer.setVisibility(8);
        }
    }

    class TextAdapter
    extends RecyclerView.Adapter<TextViewHolder> {
        private List<String> strings = new ArrayList<String>();
        Context context;
        OnRvItemClickListener onRvItemClickListener;
        private boolean isSelected;
        private String lastSelectedDefinitionText;
        private String lastSelectedRateText;
        private TextView lastSelectedTv;
        private int menuType;

        TextAdapter(Context context) {
            this.context = context;
        }

        void notifyDefinitionDataSetChange(List<VideoDefinition> list) {
            this.menuType = 0;
            this.strings.clear();
            for (VideoDefinition videoDefinition : list) {
                String definition = VideoPlayerUtils.getDefinitionInString((Context)this.context, (VideoDefinition)videoDefinition);
                this.strings.add(definition);
                if (MenuComponent.this.getVideoPlayer().getVideoInfo().getDefinition() != videoDefinition) continue;
                this.lastSelectedDefinitionText = definition;
            }
            this.isSelected = true;
            this.notifyDataSetChanged();
        }

        void notifyRateDataSetChange(List<Rate> list) {
            this.menuType = 1;
            this.strings.clear();
            for (Rate rate : list) {
                this.strings.add(rate.rateDescription);
                if (MenuComponent.this.getVideoPlayer().getPlayRate() != rate.rate) continue;
                this.lastSelectedRateText = rate.rateDescription;
            }
            this.isSelected = false;
            this.notifyDataSetChanged();
        }

        void notifyCDNDataSetChange(int cdnCount) {
            this.menuType = 2;
            this.strings.clear();
            for (int i = 0; i < cdnCount; ++i) {
                this.strings.add(MenuComponent.this.getContext().getString(R.string.bjy_pb_cdn, new Object[]{i + 1}));
                if (MenuComponent.this.getVideoPlayer().getCDNIndex() != i) continue;
                this.lastSelectedDefinitionText = MenuComponent.this.getContext().getString(R.string.bjy_pb_cdn, new Object[]{i + 1});
            }
            this.isSelected = true;
            this.notifyDataSetChanged();
        }

        void setOnRvItemClickListener(OnRvItemClickListener onRvItemClickListener) {
            this.onRvItemClickListener = onRvItemClickListener;
        }

        @NonNull
        public TextViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            View textView = LayoutInflater.from((Context)this.context).inflate(R.layout.bjy_pb_menu_item_text, parent, false);
            return new TextViewHolder(textView);
        }

        public void onBindViewHolder(TextViewHolder holder, int position) {
            holder.tv.setText((CharSequence)this.strings.get(position));
            if (this.strings.get(position).equals(this.isSelected ? this.lastSelectedDefinitionText : this.lastSelectedRateText)) {
                holder.tv.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.live_blue));
                holder.tv.setSelected(true);
                this.lastSelectedTv = holder.tv;
            } else {
                holder.tv.setSelected(false);
                holder.tv.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.live_white));
            }
            holder.tv.setOnClickListener(v -> {
                if (this.onRvItemClickListener != null) {
                    this.onRvItemClickListener.onItemClick(v, this.menuType, position);
                }
                holder.tv.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.live_blue));
                holder.tv.setSelected(true);
                if (this.lastSelectedTv != null) {
                    this.lastSelectedTv.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.live_white));
                    this.lastSelectedTv.setSelected(false);
                }
                this.lastSelectedTv = holder.tv;
                if (this.isSelected) {
                    this.lastSelectedDefinitionText = this.strings.get(position);
                } else {
                    this.lastSelectedRateText = this.strings.get(position);
                }
            });
        }

        public int getItemCount() {
            return this.strings.size();
        }

        class TextViewHolder
        extends RecyclerView.ViewHolder {
            TextView tv;

            TextViewHolder(View itemView) {
                super(itemView);
                this.tv = (TextView)itemView.findViewById(R.id.menu_item_tv);
                this.tv.setBackground((Drawable)new StateListDrawableBuilder().selected(new DrawableBuilder().solidColor(Color.parseColor((String)"#66000000")).build()).build());
            }
        }
    }

    static interface OnRvItemClickListener {
        public void onItemClick(View var1, int var2, int var3);
    }
}

