/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.component;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.videoplayer.event.BundlePool;
import com.baijiayun.videoplayer.player.PlayerStatus;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.bean.VideoPlayerConfig;
import com.baijiayun.videoplayer.ui.component.BaseComponent;
import com.baijiayun.videoplayer.ui.listener.OnTouchGestureListener;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;

public class SimpleControllerComponent
extends BaseComponent
implements OnTouchGestureListener {
    private static final int AUTO_HIDE_TIME = 5;
    private int noTouchTime;
    private ImageView pauseIv;
    private SeekBar seekBar;
    private TextView valueTv;
    private TextView totalTv;
    private VideoPlayerConfig videoPlayerConfig;
    private Disposable disposeOfAutoHide;
    private final int scaledTouchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();

    public SimpleControllerComponent(Context context) {
        super(context);
        this.initView();
        this.initListener();
    }

    private void initView() {
        this.pauseIv = (ImageView)this.findViewById(R.id.pause_iv);
        this.seekBar = (SeekBar)this.findViewById(R.id.seek_bar);
        this.valueTv = (TextView)this.findViewById(R.id.value_tv);
        this.totalTv = (TextView)this.findViewById(R.id.total_tv);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void initListener() {
        this.seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    Bundle bundle = BundlePool.obtain();
                    bundle.putInt("int_data", progress);
                    SimpleControllerComponent.this.requestSeek(bundle);
                    SimpleControllerComponent.this.changeProgress(progress);
                    SimpleControllerComponent.this.noTouchTime = 0;
                    SimpleControllerComponent.this.valueTv.setVisibility(0);
                    SimpleControllerComponent.this.totalTv.setVisibility(0);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.disposeOfAutoHide = Observable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            ++this.noTouchTime;
            if (this.noTouchTime >= 5) {
                this.valueTv.setVisibility(8);
                this.totalTv.setVisibility(8);
                this.seekBar.setVisibility(8);
            }
        });
    }

    private void changeProgress(int currentTimeSeconds) {
        this.seekBar.setProgress(currentTimeSeconds);
        this.valueTv.setText((CharSequence)UtilsKt.getFormatterTime((int)currentTimeSeconds));
    }

    @Override
    public void onCustomEvent(int eventCode, Bundle bundle) {
        super.onCustomEvent(eventCode, bundle);
        if (eventCode == -80049) {
            this.videoPlayerConfig = (VideoPlayerConfig)bundle.getSerializable("videoConfig");
        }
    }

    @Override
    @SuppressLint(value={"SetTextI18n"})
    public void onPlayerEvent(int eventCode, Bundle bundle) {
        block0 : switch (eventCode) {
            case -99031: {
                PlayerStatus status = (PlayerStatus)bundle.getSerializable("serializable_data");
                if (status == null) break;
                switch (status) {
                    case STATE_PAUSED: {
                        this.setPlayState(true);
                        break block0;
                    }
                    case STATE_STARTED: {
                        this.setPlayState(false);
                        break block0;
                    }
                    case STATE_INITIALIZED: {
                        int duration = this.getVideoPlayer().getDuration();
                        if (duration < 0) {
                            duration = 0;
                        }
                        this.totalTv.setText((CharSequence)("/" + UtilsKt.getFormatterTime((int)duration)));
                        this.seekBar.setMax(duration);
                        break block0;
                    }
                    case STATE_PREPARED: {
                        if (this.getVideoPlayer().getVideoInfo() == null) break block0;
                        int videoDuration = this.getVideoPlayer().getDuration();
                        int memoryPoint = this.videoPlayerConfig.supportBreakPointPlay ? this.getVideoPlayer().getVideoMemoryPoint() : 0;
                        this.totalTv.setText((CharSequence)("/" + UtilsKt.getFormatterTime((int)videoDuration)));
                        this.seekBar.setMax(videoDuration);
                        this.changeProgress(memoryPoint);
                        break block0;
                    }
                }
                break;
            }
            case -99019: {
                int currentTime = bundle.getInt("int_data");
                this.changeProgress(currentTime);
                if (this.getVideoPlayer().getPlayerStatus() != PlayerStatus.STATE_PLAYBACK_COMPLETED || currentTime != this.getVideoPlayer().getDuration()) break;
                this.requestSeek(BundlePool.obtain((int)0));
                this.changeProgress(0);
                this.noTouchTime = 0;
                this.seekBar.setVisibility(0);
                if (this.videoPlayerConfig.supportLooping) break;
                this.setPlayState(true);
                break;
            }
            case -99012: {
                this.seekBar.setSecondaryProgress(bundle.getInt("int_data"));
                break;
            }
        }
    }

    @Override
    protected View onCreateComponentView(Context context) {
        return View.inflate((Context)context, (int)R.layout.bjy_pb_layout_simple_controller_component, null);
    }

    @Override
    protected void setKey() {
        this.key = "simple_controller_component";
    }

    @Override
    public void onSingleTapUp(MotionEvent event) {
        if (this.pauseIv.isSelected()) {
            this.requestPlay(null);
        } else {
            this.requestPause(null);
        }
    }

    private void setPlayState(boolean isPause) {
        if (isPause) {
            this.pauseIv.setVisibility(0);
            this.pauseIv.setSelected(true);
        } else {
            this.pauseIv.setVisibility(8);
            this.pauseIv.setSelected(false);
        }
    }

    @Override
    public void onDoubleTap(MotionEvent event) {
    }

    @Override
    public void onDown(MotionEvent event) {
        this.noTouchTime = 0;
        this.seekBar.setVisibility(0);
    }

    @Override
    public void onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        float xDiff = e2.getX() - e1.getX();
        if (Math.abs(xDiff) > (float)this.scaledTouchSlop) {
            int progress = (int)((float)this.seekBar.getProgress() + 0.1f * xDiff / (float)this.seekBar.getWidth() * (float)this.seekBar.getMax());
            if (progress > this.seekBar.getMax()) {
                progress = this.seekBar.getMax();
            }
            if (progress < 0) {
                progress = 0;
            }
            Bundle bundle = BundlePool.obtain();
            bundle.putInt("int_data", progress);
            this.requestSeek(bundle);
            this.changeProgress(progress);
            this.valueTv.setVisibility(0);
            this.totalTv.setVisibility(0);
        }
    }

    @Override
    public void onEndGesture() {
    }

    @Override
    public void duringComponentTouch(boolean isInTouch) {
    }

    @Override
    public void destroy() {
        super.destroy();
        RxUtils.dispose((Disposable)this.disposeOfAutoHide);
    }
}

