/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.component;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import com.baijiayun.videoplayer.player.PlayerStatus;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.component.BaseComponent;
import com.baijiayun.videoplayer.ui.utils.NetworkUtils;

public class ErrorComponent
extends BaseComponent {
    private TextView errorMsgTv;
    private TextView errorCodeTv;
    private TextView retryBtn;

    public ErrorComponent(Context context) {
        super(context);
        this.initView();
    }

    @Override
    protected View onCreateComponentView(Context context) {
        return View.inflate((Context)context, (int)R.layout.bjy_pb_layout_error_component, null);
    }

    private void initView() {
        this.errorMsgTv = (TextView)this.findViewById(R.id.error_msg_tv);
        this.errorCodeTv = (TextView)this.findViewById(R.id.error_code_tv);
        this.retryBtn = (TextView)this.findViewById(R.id.retry_btn);
    }

    @Override
    protected void setKey() {
        this.key = "error_component";
    }

    @Override
    public void onPlayerEvent(int eventCode, Bundle bundle) {
        block0 : switch (eventCode) {
            case -99031: {
                PlayerStatus playerStatus = (PlayerStatus)bundle.getSerializable("serializable_data");
                if (playerStatus == null) {
                    return;
                }
                switch (playerStatus) {
                    case STATE_INITIALIZED: 
                    case STATE_PREPARED: 
                    case STATE_STARTED: 
                    case STATE_PLAYBACK_COMPLETED: {
                        this.setComponentVisibility(8);
                        break block0;
                    }
                }
                break;
            }
            case -80010: {
                this.setComponentVisibility(8);
                break;
            }
        }
    }

    @Override
    public void onErrorEvent(int eventCode, Bundle bundle) {
        this.setComponentVisibility(0);
        this.errorMsgTv.setText((CharSequence)bundle.getString("string_data"));
        this.errorCodeTv.setText((CharSequence)("[" + eventCode + "]"));
        this.retryBtn.setOnClickListener(v -> this.notifyComponentEvent(-80004, null));
    }

    @Override
    public void onCustomEvent(int eventCode, Bundle bundle) {
        super.onCustomEvent(eventCode, bundle);
        switch (eventCode) {
            case -80012: {
                this.setComponentVisibility(0);
                this.errorMsgTv.setText((CharSequence)this.getContext().getString(R.string.bjplayer_play_no_wifi));
                this.retryBtn.setText((CharSequence)this.getContext().getString(R.string.bjplayer_still_play));
                this.retryBtn.setOnClickListener(v -> {
                    this.setComponentVisibility(8);
                    this.notifyComponentEvent(-80015, null);
                });
                break;
            }
            case -80014: {
                boolean isNetworkConnected = bundle.getBoolean("bool_data");
                if (isNetworkConnected) {
                    if (!this.errorMsgTv.getText().equals(this.getContext().getString(R.string.bjplayer_video_player_error_no_network))) break;
                    this.setComponentVisibility(8);
                    break;
                }
                this.setComponentVisibility(0);
                this.errorMsgTv.setText((CharSequence)this.getContext().getString(R.string.bjplayer_video_player_error_no_network));
                this.retryBtn.setText((CharSequence)this.getContext().getString(R.string.bjplayer_video_reload));
                this.retryBtn.setOnClickListener(v -> {
                    if (NetworkUtils.isNetConnected(this.getContext())) {
                        this.setComponentVisibility(8);
                        this.notifyComponentEvent(-80015, null);
                    }
                });
                break;
            }
        }
    }
}

