/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.component;

import android.content.Context;
import com.baijiayun.BJYPlayerSDK;
import com.baijiayun.playback.PBRoom;
import com.baijiayun.videoplayer.ui.component.BaseComponent;
import com.baijiayun.videoplayer.ui.component.ChatComponent;
import com.baijiayun.videoplayer.ui.component.ControllerComponent;
import com.baijiayun.videoplayer.ui.component.ErrorComponent;
import com.baijiayun.videoplayer.ui.component.GestureComponent;
import com.baijiayun.videoplayer.ui.component.LoadingComponent;
import com.baijiayun.videoplayer.ui.component.MediaPlayerDebugInfoComponent;
import com.baijiayun.videoplayer.ui.component.MenuComponent;
import com.baijiayun.videoplayer.ui.component.SimpleControllerComponent;
import com.baijiayun.videoplayer.ui.listener.IComponent;
import com.baijiayun.videoplayer.ui.listener.IComponentChangeListener;
import com.baijiayun.videoplayer.ui.listener.IFilter;
import com.baijiayun.videoplayer.ui.listener.OnLoopListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class ComponentManager {
    private Map<String, IComponent> componentMap;
    private List<IComponentChangeListener> componentChangeListeners;
    private Context context;
    private PBRoom pbRoom;

    public ComponentManager(Context context, boolean enableDefaultComponents) {
        this.context = context;
        this.componentMap = Collections.synchronizedMap(new LinkedHashMap());
        this.componentChangeListeners = new CopyOnWriteArrayList<IComponentChangeListener>();
        if (enableDefaultComponents) {
            this.generateDefaultComponentList();
        }
    }

    public ComponentManager(Context context, boolean enableDefaultComponents, PBRoom pbRoom) {
        this.pbRoom = pbRoom;
        this.context = context;
        this.componentMap = Collections.synchronizedMap(new LinkedHashMap());
        this.componentChangeListeners = new CopyOnWriteArrayList<IComponentChangeListener>();
        if (enableDefaultComponents) {
            this.generateDefaultComponentList();
        }
    }

    public void addComponent(String key, BaseComponent component) {
        this.componentMap.put(key, component);
        for (IComponentChangeListener changeListener : this.componentChangeListeners) {
            changeListener.onComponentAdd(component);
        }
    }

    public void removeComponent(String key) {
        IComponent removedComponent = this.componentMap.remove(key);
        for (IComponentChangeListener changeListener : this.componentChangeListeners) {
            changeListener.onComponentRemove(removedComponent);
        }
    }

    public void addOnComponentChangeListener(IComponentChangeListener componentChangeListener) {
        if (componentChangeListener != null && !this.componentChangeListeners.contains(componentChangeListener)) {
            this.componentChangeListeners.add(componentChangeListener);
        }
    }

    public void removeOnComponentChangeListener(IComponentChangeListener componentChangeListener) {
        this.componentChangeListeners.remove(componentChangeListener);
    }

    public void forEach(OnLoopListener loopListener) {
        for (IComponent component : this.componentMap.values()) {
            loopListener.onEach(component);
        }
    }

    public void forEach(IFilter filter, OnLoopListener loopListener) {
        for (IComponent component : this.componentMap.values()) {
            if (filter != null && !filter.filter(component)) continue;
            loopListener.onEach(component);
        }
    }

    public void release() {
        this.componentMap.clear();
        this.componentChangeListeners.clear();
    }

    public void generateDefaultComponentList() {
        this.componentMap.clear();
        this.componentChangeListeners.clear();
        if (BJYPlayerSDK.isVideoList) {
            this.addComponent("simple_controller_component", new SimpleControllerComponent(this.context));
            return;
        }
        this.addComponent("loading_component", new LoadingComponent(this.context));
        this.addComponent("gesture_component", new GestureComponent(this.context));
        if (this.pbRoom != null) {
            this.addComponent("chat_component", new ChatComponent(this.context, this.pbRoom));
        }
        this.addComponent("controller_component", new ControllerComponent(this.context));
        this.addComponent("error_component", new ErrorComponent(this.context));
        this.addComponent("menu_component", new MenuComponent(this.context));
        if (BJYPlayerSDK.IS_DEVELOP_MODE) {
            this.addComponent("video_info_component", new MediaPlayerDebugInfoComponent(this.context));
        }
    }
}

