/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.activity;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import androidx.lifecycle.LifecycleObserver;
import com.baijiayun.BJYPlayerSDK;
import com.baijiayun.bjyutils.TimeUtilsKt;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.download.DownloadModel;
import com.baijiayun.glide.Glide;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.context.LPError;
import com.baijiayun.livebase.models.LPHorseLamp;
import com.baijiayun.livebase.models.LPJsonModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.network.alilog.AliYunLogHelper;
import com.baijiayun.livebase.widgets.HorseLampView;
import com.baijiayun.livebase.widgets.dialog.CustomUserDialog;
import com.baijiayun.livebase.widgets.dialog.custom_webpage.CustomWebPageDialogFragment;
import com.baijiayun.livebase.widgets.dialog.preview.ChatPictureViewFragment;
import com.baijiayun.livebase.widgets.dialog.preview.ChatSavePicDialogFragment;
import com.baijiayun.playback.PBRoom;
import com.baijiayun.playback.bean.models.LPAnswerModel;
import com.baijiayun.playback.bean.models.LPBJTimerModel;
import com.baijiayun.playback.bean.models.LPCustomImageGiftModel;
import com.baijiayun.playback.bean.models.LPLiveRewardConfigModel;
import com.baijiayun.playback.bean.models.imodels.IMessageModel;
import com.baijiayun.playback.bean.models.roomresponse.LPResRoomNoticeModel;
import com.baijiayun.playback.dataloader.PlayerDataLoader;
import com.baijiayun.playback.mocklive.LPLaunchListener;
import com.baijiayun.playback.ppt.PPTView;
import com.baijiayun.playback.util.PBJsonUtils;
import com.baijiayun.videoplayer.IBJYVideoPlayer;
import com.baijiayun.videoplayer.VideoPlayerFactory;
import com.baijiayun.videoplayer.bean.AlbumInfoModel;
import com.baijiayun.videoplayer.bean.RedPacketConfigBean;
import com.baijiayun.videoplayer.event.BundlePool;
import com.baijiayun.videoplayer.listeners.OnSwitchPlaybackListener;
import com.baijiayun.videoplayer.player.PlayerStatus;
import com.baijiayun.videoplayer.ui.PBRoomUI;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.activity.BaseActivity;
import com.baijiayun.videoplayer.ui.activity.PBRoomRouterListener;
import com.baijiayun.videoplayer.ui.base.BasePBPresenter;
import com.baijiayun.videoplayer.ui.base.BaseView;
import com.baijiayun.videoplayer.ui.databinding.BjyPbLayoutGiftHeaderBinding;
import com.baijiayun.videoplayer.ui.listener.CallbackManager;
import com.baijiayun.videoplayer.ui.playback.announcement.AnnouncementFragment;
import com.baijiayun.videoplayer.ui.playback.chat.PBChatFragment;
import com.baijiayun.videoplayer.ui.playback.chat.preview.IChatMessageCallback;
import com.baijiayun.videoplayer.ui.playback.ppt.PPTErrorDialogPlayBack;
import com.baijiayun.videoplayer.ui.playback.toolbox.answersheet.QuestionShowFragment;
import com.baijiayun.videoplayer.ui.playback.toolbox.answersheet.QuestionShowPresenter;
import com.baijiayun.videoplayer.ui.playback.toolbox.answersheet.QuestionToolFragment;
import com.baijiayun.videoplayer.ui.playback.toolbox.answersheet.QuestionToolPresenter;
import com.baijiayun.videoplayer.ui.playback.toolbox.questionanswer.QuestionAnswerFragment;
import com.baijiayun.videoplayer.ui.playback.toolbox.questionanswer.QuestionAnswerPresenter;
import com.baijiayun.videoplayer.ui.playback.toolbox.quiz.QuizDialogFragment;
import com.baijiayun.videoplayer.ui.playback.toolbox.quiz.QuizDialogPresenter;
import com.baijiayun.videoplayer.ui.playback.toolbox.redpacket.RedPacketDialog;
import com.baijiayun.videoplayer.ui.playback.toolbox.timer.TimerShowyWindow;
import com.baijiayun.videoplayer.ui.utils.NetworkUtils;
import com.baijiayun.videoplayer.ui.utils.PBUIUtils;
import com.baijiayun.videoplayer.ui.utils.PiPHelper;
import com.baijiayun.videoplayer.ui.widget.BJYPlaybackContainer;
import com.baijiayun.videoplayer.ui.widget.BJYVideoView;
import com.baijiayun.videoplayer.ui.widget.BaseVideoView;
import com.baijiayun.videoplayer.ui.widget.CustomerGiftView;
import com.baijiayun.videoplayer.ui.widget.DragControllerDialog;
import com.baijiayun.videoplayer.ui.widget.DragFrameLayout;
import com.baijiayun.videoplayer.ui.widget.VideoAlbumDialogFragment;
import com.google.gson.JsonObject;
import com.tencent.smtt.sdk.WebView;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class PBRoomActivity
extends BaseActivity
implements IChatMessageCallback,
PBRoomRouterListener {
    private static final String CHAT_FRAGMENT_TAG = "CHAT_FRAGMENT_TAG";
    private PBRoom pbRoom;
    private PPTView pptView;
    private BJYPlaybackContainer bigContainer;
    private BJYVideoView smallPureVideoView;
    private DragFrameLayout videoDragLayout;
    private FrameLayout chatContainer;
    private PBChatFragment chatFragment;
    private QuestionShowFragment questionShowFragment;
    private ImageView switchIv;
    private ImageView chatSwitchIv;
    private ImageView questionAnswerBtn;
    private ImageView announcementBtn;
    private DragFrameLayout cloudVideoContainer;
    private BJYVideoView cloudVideoView;
    private IBJYVideoPlayer cloudVideoPlayer;
    private CustomerGiftView giftView;
    private LinearLayout giftContainer;
    private boolean hasLaunchSuccess = false;
    private boolean isVideoInDragFrameLayout;
    private int recordType = 0;
    private int smallCourseRecordType = 0;
    private LPAnswerModel lpAnswerModel;
    private QuestionToolFragment questionToolFragment;
    private DragFrameLayout flQuestionTool;
    private QuizDialogFragment quizFragment;
    private QuestionAnswerFragment questionAnswerFragment;
    private PPTErrorDialogPlayBack errorDialogPlayBack;
    public static final int VIDEO_WIDTH_1V1_WEBRTC = 160;
    public static final int VIDEO_HEIGHT_1V1_WEBRTC = 180;
    private AnnouncementFragment announcementFragment;
    private LPResRoomNoticeModel announcementModel;
    private BroadcastReceiver mBroadcastReceiver;
    private PiPHelper pipHelper;
    private TextView presenterIdentityTv;
    private CustomWebPageDialogFragment customWebPageDialogFragment;
    private VideoAlbumDialogFragment videoAlbumDialogFragment;
    private CustomUserDialog customUserDialog;
    private int cacheTime = -1;
    private DragControllerDialog dragControllerDialog;
    private View albumEmptyView;
    private Disposable disposableOfRedPacket;
    private List<Integer> times = new ArrayList<Integer>();
    private TimerShowyWindow timerWindow;
    private DragFrameLayout timerLayout;
    private LPBJTimerModel timerModel;
    private boolean pauseTimer;
    private BaseDialogFragment redPacketDialog;
    private boolean isChatFloatRightCloseChat = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.bjy_pb_activity_playback);
        this.initView();
        this.initRoom();
        this.initListener();
    }

    private void initView() {
        this.videoDragLayout = (DragFrameLayout)this.findViewById(R.id.video_drag_layout);
        this.videoDragLayout.setInterceptTouchEvent(true);
        this.albumEmptyView = this.findViewById(R.id.album_empty_view);
        this.presenterIdentityTv = new TextView(this.videoDragLayout.getContext());
        this.presenterIdentityTv.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.pb_live_white));
        this.presenterIdentityTv.setTextSize(14.0f);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
        lp.gravity = 81;
        this.presenterIdentityTv.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.baseVideoView = (BaseVideoView)this.findViewById(R.id.fl_pb_container_big);
        this.baseVideoView.setBackgroundColor(ContextCompat.getColor((Context)this, (int)R.color.bjy_pb_bg_color));
        this.bigContainer = (BJYPlaybackContainer)this.baseVideoView;
        this.switchIv = (ImageView)this.findViewById(R.id.switch_iv);
        this.chatSwitchIv = (ImageView)this.findViewById(R.id.iv_pb_chat_switch);
        this.flQuestionTool = (DragFrameLayout)this.findViewById(R.id.activity_dialog_question_tool);
        this.timerLayout = (DragFrameLayout)this.findViewById(R.id.activity_dialog_timer);
        this.rootContainer = (ViewGroup)this.findViewById(R.id.pbRoom_root_container);
        this.chatContainer = (FrameLayout)this.findViewById(R.id.fl_pb_chat_content_container);
        this.announcementBtn = (ImageView)this.findViewById(R.id.fragment_left_menu_announcement);
        this.cloudVideoContainer = (DragFrameLayout)this.findViewById(R.id.activity_cloud_video_container);
        this.cloudVideoView = (BJYVideoView)this.findViewById(R.id.pb_bjy_cloud_video_view);
        this.giftView = (CustomerGiftView)this.findViewById(R.id.pb_bjy_gift_view);
        this.giftContainer = (LinearLayout)this.findViewById(R.id.pb_bjy_gift_container);
        this.initPPTView();
        this.smallPureVideoView = (BJYVideoView)this.findViewById(R.id.pb_bjy_videoview);
        this.getWindow().setFormat(-3);
        this.questionAnswerBtn = (ImageView)this.findViewById(R.id.fragment_left_menu_question_answer);
        this.initOrientationEventListener();
    }

    private void initPPTView() {
        this.pptView = new PPTView((Context)this);
        this.pptView.setBackgroundColor(ContextCompat.getColor((Context)this, (int)R.color.bjy_pb_ppt_bg_color));
        this.pptView.setPPTErrorListener(new PPTView.OnPPTErrorListener(){

            public void onAnimPPTLoadError(int errorCode, String description) {
                try {
                    if (PBRoomActivity.this.isFinishing()) {
                        return;
                    }
                    if (errorCode == -2007) {
                        if (PBRoomActivity.this.errorDialogPlayBack == null) {
                            PBRoomActivity.this.errorDialogPlayBack = new PPTErrorDialogPlayBack.Builder((Context)PBRoomActivity.this, PBRoomActivity.this.recordType).setDescriptionText(description).setSuggestionText(PBRoomActivity.this.getResources().getString(R.string.anim_ppt_error_suggestion_over_time)).setNegative(PBRoomActivity.this.getResources().getString(R.string.anim_ppt_error_skip_anim), (dialog, which) -> PBRoomActivity.this.pptView.setAnimPPTEnable(false)).setPositive(PBRoomActivity.this.getResources().getString(R.string.anim_ppt_error_reload), (dialog, which) -> dialog.dismiss()).create();
                        }
                        PBRoomActivity.this.errorDialogPlayBack.show();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void onAnimPPTLoadFinish() {
                if (PBRoomActivity.this.errorDialogPlayBack != null && PBRoomActivity.this.errorDialogPlayBack.isShowing()) {
                    PBRoomActivity.this.errorDialogPlayBack.dismiss();
                }
            }

            public void onAnimPPTLoadStart() {
            }
        });
        this.pptView.setPPTCallback(new PPTView.OnPPTCallback(){

            public void attached() {
                PBRoomActivity.this.updateBigContainerPPTArea();
            }

            public void destroy() {
                PBRoomActivity.this.updateBigContainerPPTArea();
            }
        });
    }

    private void initListener() {
        this.switchIv.setOnClickListener(v -> {
            this.videoDragLayout.setVisibility(0);
            this.switchIv.setVisibility(8);
        });
        this.videoDragLayout.setOnClickListener(v -> {
            if (!this.hasLaunchSuccess) {
                return;
            }
            ArrayList<String> options = new ArrayList<String>();
            options.add(this.getString(R.string.full_screen));
            options.add(this.getString(R.string.close));
            options.add(this.getString(R.string.cancel));
            CharSequence[] opts = new String[options.size()];
            opts = options.toArray(opts);
            new AlertDialog.Builder((Context)this).setItems(opts, (dialog, which) -> {
                if (which == 0) {
                    this.isVideoInDragFrameLayout = !this.isVideoInDragFrameLayout;
                    this.switchPPTAndVideo(true);
                    this.updateBigContainerPPTArea();
                } else if (which == 1) {
                    this.videoDragLayout.setVisibility(4);
                    this.switchIv.setVisibility(0);
                    this.switchIv.setBackgroundResource(this.isVideoInDragFrameLayout ? R.drawable.ic_video_back_stopvideo : R.drawable.ic_video_back_ppt);
                }
                dialog.dismiss();
            }).show();
        });
        this.bigContainer.setComponentEventListener((eventCode, bundle) -> {
            switch (eventCode) {
                case -80007: {
                    if (this.recordType != 2 && this.isLandscape && !this.isInMultiMode()) {
                        this.requestedOrientation(1);
                        break;
                    }
                    this.finish();
                    break;
                }
                case -80006: {
                    this.requestedOrientation(this.isLandscape ? 1 : 0);
                    break;
                }
                case -80034: {
                    boolean show = bundle.getBoolean("bool_data");
                    this.questionAnswerBtn.setVisibility(show && this.isQuestionAnswerEnable() ? 0 : 8);
                    this.chatSwitchIv.setVisibility(show && this.isChatEnable() ? 0 : 8);
                    this.announcementBtn.setVisibility(show && this.isAnnouncementEnable() ? 0 : 8);
                    break;
                }
                case -80041: {
                    this.bigContainer.setPPTTouchEnable(!bundle.getBoolean("bool_data"));
                    break;
                }
                case -80048: {
                    boolean showPiP = bundle.getBoolean("bool_data");
                    if (showPiP) {
                        this.showPiP();
                        break;
                    }
                    if (this.pipHelper == null) break;
                    this.pipHelper.dismiss();
                    break;
                }
                case -80046: {
                    if (this.videoAlbumDialogFragment == null) {
                        this.videoAlbumDialogFragment = new VideoAlbumDialogFragment(this.albumItemList, false);
                        this.videoAlbumDialogFragment.setOnAlbumItemClickListener(position -> {
                            AliYunLogHelper.getInstance().addDebugLog("\u56de\u653e\u5408\u96c6\u5207\u6362");
                            this.videoPlayerConfig.defaultAlbumIndex = position;
                            PBRoomUI.enterPBRoom((Context)this, this.albumID, this.videoPlayerConfig, null);
                            this.finish();
                        });
                    }
                    if (this.videoAlbumDialogFragment.isVisible()) {
                        this.videoAlbumDialogFragment.dismiss();
                        break;
                    }
                    this.showDialogFragment(this.videoAlbumDialogFragment);
                    this.videoAlbumDialogFragment.updateList(this.currentAlbumIndex);
                    break;
                }
                case -80002: {
                    int seekToPosition = bundle.getInt("int_data");
                    if (this.cacheTime == -1) {
                        this.cacheTime = this.bjyVideoPlayer.getCurrentPosition();
                    }
                    if (!this.checkDragControllerDialog(seekToPosition)) break;
                    bundle.putInt("int_data", this.cacheTime);
                    break;
                }
                case -80053: {
                    this.takeScreenshot();
                    break;
                }
            }
        });
        this.chatSwitchIv.setOnClickListener(v -> {
            if (this.chatContainer.getVisibility() == 8) {
                this.chatContainer.setVisibility(0);
                this.chatSwitchIv.setImageResource(R.drawable.ic_video_back_sentmsg_no);
            } else {
                this.chatContainer.setVisibility(8);
                this.chatSwitchIv.setImageResource(R.drawable.ic_video_back_sentmsg_no_on);
            }
        });
        this.questionAnswerBtn.setOnClickListener(v -> {
            this.showQuestionAnswer(true);
            this.questionAnswerBtn.setImageResource(R.drawable.live_ic_question_answer_normal);
        });
        this.announcementBtn.setOnClickListener(v -> this.showAnnouncementFragment());
    }

    private void handlePlaybackAlbum() {
        this.showAlbumEmptyView(false);
        this.compositeDisposable.add(PlayerDataLoader.getInstance((Context)this).getObservableOfAlbumInfoPlaybackList(this.albumID).subscribe(albumInfoModels -> {
            if (!albumInfoModels.isEmpty()) {
                this.albumEmptyView.setVisibility(8);
                this.albumItemList = albumInfoModels;
                AlbumInfoModel albumInfoModel = (AlbumInfoModel)this.albumItemList.get(this.videoPlayerConfig.defaultAlbumIndex % this.albumItemList.size());
                String roomId = String.valueOf(albumInfoModel.roomId);
                String token = albumInfoModel.playerToken;
                String sessionId = String.valueOf(albumInfoModel.sessionId);
                int version = albumInfoModel.version;
                this.pbRoom = BJYPlayerSDK.newPlaybackRoom((Context)this, (long)Long.parseLong(roomId), (long)Long.parseLong(sessionId), (int)version, (String)token);
                this.initRoom();
            } else {
                this.showAlbumEmptyView(true);
            }
        }, throwable -> this.showAlbumEmptyView(true)));
    }

    private void showAlbumEmptyView(boolean isEmpty) {
        this.albumEmptyView.setVisibility(0);
        ((TextView)this.albumEmptyView.findViewById(R.id.tv)).setText((CharSequence)this.getString(isEmpty ? R.string.bjy_pb_playback_album_is_empty : R.string.bjy_pb_playback_album_loading));
    }

    @Override
    protected boolean isPlayback() {
        return true;
    }

    private void initRoom() {
        if (this.pbRoom == null) {
            this.handlePlaybackAlbum();
            return;
        }
        this.subscribe();
        this.smallPureVideoView.initPlayer(this.bjyVideoPlayer, false);
        this.pbRoom.bindPlayer(this.bjyVideoPlayer);
        this.bigContainer.attachPBRoom(this.pbRoom);
        this.pptView.attachRoom(this.pbRoom);
        if (this.pbRoom.isPlaybackOffline() || this.bigContainer.checkNetState()) {
            this.enterRoom();
        }
        this.bigContainer.setRetryEnterRoomCallback(this::enterRoom);
        this.bigContainer.addCubChangeListener();
        if (!TextUtils.isEmpty((CharSequence)this.videoPlayerConfig.videoTitle)) {
            this.bigContainer.sendCustomEvent(-80050, BundlePool.obtain((String)this.videoPlayerConfig.videoTitle));
        }
    }

    private void enterRoom() {
        this.pbRoom.enterRoom(new LPLaunchListener(){

            public void onLaunchSteps(int step, int totalStep) {
            }

            public void onLaunchError(LPError error) {
                if (error.getCode() == -2010) {
                    error.message = PBRoomActivity.this.getString(R.string.bjy_pb_playback_expired);
                }
                Toast.makeText((Context)PBRoomActivity.this, (CharSequence)error.getMessage(), (int)1).show();
                PBRoomActivity.this.bigContainer.sendCustomEvent(-80018, null);
            }

            @SuppressLint(value={"SourceLockedOrientationActivity"})
            public void onLaunchSuccess(PBRoom room) {
                PBRoomActivity.this.hasLaunchSuccess = true;
                if (PBRoomActivity.this.videoPlayerConfig.userGroup > 0) {
                    PBRoomActivity.this.pbRoom.setMessageGroup(PBRoomActivity.this.videoPlayerConfig.userGroup);
                }
                PBRoomActivity.this.handleLaunchSuccess(room);
            }
        });
    }

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    private void handleLaunchSuccess(PBRoom room) {
        if (this.pbRoom.getPartnerConfig().getIntConfig("initial_ppt_model_in_playback") == 0) {
            this.bigContainer.setPPTTouchEnable(true);
            this.bigContainer.sendCustomEvent(-80052, BundlePool.obtain((boolean)true));
        }
        this.bigContainer.sendCustomEvent(-80053, BundlePool.obtain());
        boolean bl = this.videoPlayerConfig.isVideoMain == null ? !this.pbRoom.isVideoMain() : (this.isVideoInDragFrameLayout = this.videoPlayerConfig.isVideoMain == false);
        if (room.isPlaybackOffline()) {
            this.recordType = this.getIntent().getIntExtra("pb_room_record_type", 0);
            this.smallCourseRecordType = this.getIntent().getIntExtra("pb_room_small_course_record_type", 0);
        } else {
            this.recordType = room.getRecordType();
            this.smallCourseRecordType = room.getSmallCourseRecordType();
        }
        if (this.isMixedPBRoom) {
            this.bigContainer.addPPTView((View)this.pptView, new FrameLayout.LayoutParams(-1, -1));
            this.chatContainer.setVisibility(0);
            if (this.isChatEnable()) {
                this.addChatFragment();
                this.chatSwitchIv.setVisibility(0);
            } else {
                this.chatSwitchIv.setVisibility(8);
            }
            this.switchPPTAndVideo();
            this.questionAnswerBtn.setVisibility(this.isQuestionAnswerEnable() ? 0 : 8);
            this.announcementBtn.setVisibility(this.isAnnouncementEnable() ? 0 : 8);
        } else if (this.recordType == 2 && this.smallCourseRecordType != 1) {
            this.pptView.destroy();
            View videoView2 = this.videoDragLayout.getChildAt(0);
            this.videoDragLayout.removeAllViews();
            this.videoDragLayout.setVisibility(8);
            this.bigContainer.addView(videoView2, 0);
            this.chatSwitchIv.setVisibility(8);
            this.questionAnswerBtn.setVisibility(8);
            this.announcementBtn.setVisibility(8);
            this.isLandscape = true;
        } else {
            if (this.recordType == 2) {
                this.bigContainer.addPPTView((View)this.pptView, new FrameLayout.LayoutParams(-1, -1));
                this.changeDragLayoutParams();
                this.switchPPTAndVideo();
                this.questionAnswerBtn.setVisibility(8);
                this.initCloudVideoView();
            } else {
                if (this.pbRoom.getTemplateType() == LPConstants.TemplateType.VIDEO) {
                    this.pptView.destroy();
                    View videoView3 = this.videoDragLayout.getChildAt(0);
                    this.videoDragLayout.removeAllViews();
                    this.videoDragLayout.setVisibility(8);
                    this.bigContainer.addView(videoView3, 0);
                    this.isLandscape = true;
                } else if (this.pbRoom.getTemplateType() == LPConstants.TemplateType.LIVE_WALL) {
                    this.bigContainer.addPPTView((View)this.pptView, new FrameLayout.LayoutParams(-1, -1));
                    this.videoDragLayout.setVisibility(4);
                    this.switchIv.setVisibility(0);
                    this.switchIv.setBackgroundResource(R.drawable.ic_video_back_ppt);
                    this.isVideoInDragFrameLayout = false;
                    this.switchPPTAndVideo();
                } else {
                    this.bigContainer.addPPTView((View)this.pptView, new FrameLayout.LayoutParams(-1, -1));
                    this.switchPPTAndVideo();
                }
                this.questionAnswerBtn.setVisibility(this.isQuestionAnswerEnable() ? 0 : 8);
                this.announcementBtn.setVisibility(this.isAnnouncementEnable() ? 0 : 8);
            }
            this.chatContainer.setVisibility(0);
            if (this.isChatEnable()) {
                this.addChatFragment();
                this.chatSwitchIv.setVisibility(0);
            } else {
                this.chatSwitchIv.setVisibility(8);
            }
        }
        if (this.disableScreenRecording()) {
            this.getWindow().addFlags(8192);
        }
        if (this.isWebrtcOneOnOnePlayback() && !this.isMixedPBRoom) {
            this.changeDragLayoutParams();
        }
        this.initHorseLamp();
        if (this.isLandscape) {
            this.requestedOrientation(0);
            this.requestLayout(true);
        }
        this.updateIdentityText(this.pbRoom.getCurrentPresenter());
        if (this.isVideoInDragFrameLayout) {
            UtilsKt.removeViewFromParent((View)this.presenterIdentityTv);
            this.videoDragLayout.addView((View)this.presenterIdentityTv);
        }
        this.fetchRedPacketInfo();
    }

    private void fetchRedPacketInfo() {
        this.times.clear();
        this.disposableOfRedPacket = this.pbRoom.getObservableOfRedPackageConfig(this.pbRoom.getPlaybackId(), this.pbRoom.getRoomId(), this.pbRoom.getRoomToken()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<RedPacketConfigBean>(){

            public void accept(RedPacketConfigBean redPacketConfigBean) throws Exception {
                int breakPoint = PBRoomActivity.this.bjyVideoPlayer.getBreakPoint();
                for (RedPacketConfigBean.TimeBean timeBean : redPacketConfigBean.times) {
                    int time = TimeUtilsKt.getSecondFromDate((String)timeBean.timeOffset);
                    if (breakPoint != 0 && breakPoint >= time) continue;
                    PBRoomActivity.this.times.add(time);
                }
            }
        });
    }

    @Override
    protected boolean disableScreenRecording() {
        if (BJYPlayerSDK.enableScreenRecording == null) {
            return this.pbRoom.getPBRoomListener().enablePreventScreenCapture();
        }
        return BJYPlayerSDK.enableScreenRecording == false;
    }

    @Override
    protected boolean isScreenRecorderClass() {
        return this.recordType == 2 && this.smallCourseRecordType == 0;
    }

    private boolean isQuestionAnswerEnable() {
        return this.pbRoom != null && this.pbRoom.getPBRoomListener().enablePlaybackQuestionAnswer() && this.recordType != 2 && !this.isMixedPBRoom;
    }

    private boolean isChatEnable() {
        boolean isChatEnable = this.pbRoom.getPartnerConfig() == null || this.pbRoom.getPartnerConfig().playbackFeatureTabs.contains("chat");
        return (this.recordType != 2 || this.pbRoom.isSmallCourseSignalPlayback()) && isChatEnable;
    }

    private boolean isAnnouncementEnable() {
        return !this.isScreenRecorderClass();
    }

    boolean isWebrtcOneOnOnePlayback() {
        return this.pbRoom != null && this.pbRoom.getPartnerConfig() != null && this.pbRoom.getRecordType() == 1 && this.pbRoom.getPartnerConfig().roomType == 6;
    }

    private void changeDragLayoutParams() {
        if (this.videoDragLayout.getChildCount() <= 0) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = this.videoDragLayout.getLayoutParams();
        if (this.isVideoInDragFrameLayout && this.isWebrtcOneOnOnePlayback()) {
            layoutParams.width = UtilsKt.getDp((int)160);
            layoutParams.height = UtilsKt.getDp((int)180);
        } else {
            layoutParams.width = UtilsKt.getDp((int)150);
            layoutParams.height = this.isVideoInDragFrameLayout ? UtilsKt.getDp((int)(this.pbRoom.isSmallCourseSignalPlayback() ? 180 : 90)) : UtilsKt.getDp((int)(this.pbRoom.isSmallCourseSignalPlayback() ? 84 : 90));
        }
    }

    @Override
    protected void parseSerializableExtra() {
        super.parseSerializableExtra();
        this.albumID = this.getIntent().getStringExtra("album_no");
        if (TextUtils.isEmpty((CharSequence)this.albumID)) {
            if (this.isMixedPBRoom) {
                String mixedId = this.getIntent().getStringExtra("pb_room_mixed_id");
                String mixedToken = this.getIntent().getStringExtra("pb_room_mixed_token");
                this.pbRoom = BJYPlayerSDK.newPlaybackRoom((Context)this, (String)mixedId, (String)mixedToken);
            } else if (this.getIntent().getBooleanExtra("isOffline", false)) {
                this.pbRoom = BJYPlayerSDK.newPlaybackRoom((Context)this, (DownloadModel)((DownloadModel)this.getIntent().getSerializableExtra("videoDownloadModel")), (DownloadModel)((DownloadModel)this.getIntent().getSerializableExtra("signalDownloadModel")));
            } else {
                String roomId = this.getIntent().getStringExtra("pb_room_id");
                String token = this.getIntent().getStringExtra("pb_room_token");
                String sessionId = this.getIntent().getStringExtra("pb_room_session_id");
                int version = this.getIntent().getIntExtra("pb_room_version", -1);
                this.pbRoom = BJYPlayerSDK.newPlaybackRoom((Context)this, (long)Long.parseLong(roomId), (long)Long.parseLong(sessionId), (int)version, (String)token);
            }
        }
        if (this.videoPlayerConfig.isLandscape != null) {
            this.isLandscape = this.videoPlayerConfig.isLandscape;
        }
    }

    @Override
    protected void subscribe() {
        super.subscribe();
        this.compositeDisposable.add(this.baseVideoView.getObservableVideoStatus().observeOn(AndroidSchedulers.mainThread()).subscribe(videoStatus -> {
            if (videoStatus == PlayerStatus.STATE_PREPARED) {
                this.bigContainer.updateAlbumBtnWhenPrepared(this.albumItemList.size() > 0, false);
            }
        }));
        this.compositeDisposable.add(this.bigContainer.getObservablePlayingTime().observeOn(AndroidSchedulers.mainThread()).subscribe(currentDuration -> {
            if (!this.videoPlayerConfig.supportBackgroundAudio) {
                return;
            }
            if (currentDuration.intValue() == this.bjyVideoPlayer.getDuration()) {
                this.updatePlayTime(0L, this.bjyVideoPlayer.getDuration() * 1000);
                return;
            }
            this.updatePlayTime(currentDuration * 1000, this.bjyVideoPlayer.getDuration() * 1000);
        }));
        this.compositeDisposable.add(this.pbRoom.getObservableOfVideoStatus().filter(aBoolean -> this.recordType != 1 && this.recordType != 3).observeOn(AndroidSchedulers.mainThread()).subscribe(isVideoOn -> {
            if (this.isVideoInDragFrameLayout && !this.pbRoom.isSmallCourseSignalPlayback()) {
                this.smallPureVideoView.updateAudioCoverStatus(isVideoOn == false);
            }
        }));
        this.compositeDisposable.add(this.pbRoom.getObservableOfPresenterChange().observeOn(AndroidSchedulers.mainThread()).subscribe(this::updateIdentityText));
        this.compositeDisposable.add(this.pbRoom.getToolBoxVM().getObservableOfQuizStart().filter(lpJsonModel -> !this.pbRoom.isPlaybackOffline()).observeOn(AndroidSchedulers.mainThread()).subscribe(this::quizStart));
        this.compositeDisposable.add(this.pbRoom.getToolBoxVM().getObservableOfAnswerStart().observeOn(AndroidSchedulers.mainThread()).subscribe(this::answerStart));
        this.compositeDisposable.add(this.pbRoom.getToolBoxVM().getObservableOfQuestionQueue().subscribe(lpQuestionPullResItems -> {
            if (!lpQuestionPullResItems.isEmpty()) {
                this.questionAnswerBtn.setImageResource(R.drawable.live_ic_question_answer);
            }
        }));
        this.compositeDisposable.add(this.pbRoom.getObservableOfCustomBroadcast().filter(lpJsonModel -> "custom_image".equals(lpJsonModel.data.get("key").getAsString())).filter(lpJsonModel -> this.isSignalInOneSecond(lpJsonModel.data.get("offset_timestamp_ms").getAsInt())).map(lpJsonModel -> (LPCustomImageGiftModel)PBJsonUtils.parseJsonObject((JsonObject)lpJsonModel.data.getAsJsonObject("value"), LPCustomImageGiftModel.class)).observeOn(AndroidSchedulers.mainThread()).subscribe(this::showCustomGiftAnim));
        this.compositeDisposable.add(this.pbRoom.getObservableOfCustomBroadcast().filter(lpJsonModel -> "custom_webpage".equals(lpJsonModel.data.get("key").getAsString())).observeOn(AndroidSchedulers.mainThread()).subscribe(lpJsonModel -> {
            JsonObject value = lpJsonModel.data.get("value").getAsJsonObject();
            String action = value.get("action").getAsString();
            if ("student_open_webpage".equals(action)) {
                this.showCustomWebpageDialog(value.get("url").getAsString());
            } else if ("student_close_webpage".equals(action)) {
                this.closeCustomWebpageDialog();
            }
        }));
        this.compositeDisposable.add(this.pbRoom.getChatVM().getObservableOfMessageReceived().flatMap(iMessageModels -> {
            Stack<IMessageModel> stack = new Stack<IMessageModel>();
            for (int i = iMessageModels.size() - 1; i >= 0 && this.isSignalInOneSecond(((IMessageModel)iMessageModels.get(i)).getOffSetMs()); --i) {
                stack.add((IMessageModel)iMessageModels.get(i));
            }
            return Observable.fromIterable(stack);
        }).filter(iMessageModel -> iMessageModel.getMessageType() == LPConstants.MessageType.Reward && "reward-gift".equals(iMessageModel.getData().type)).observeOn(AndroidSchedulers.mainThread()).subscribe(iMessageModel -> this.showChatGiftAnim(new LPLiveRewardConfigModel(iMessageModel.getData().giftImg, iMessageModel.getData().isFloat == 1, iMessageModel.getFrom().getName()))));
        this.compositeDisposable.add(this.pbRoom.getToolBoxVM().getObservableOfBJTimerStart().subscribe(lpbjTimerModel -> {
            this.pauseTimer = false;
            this.startTimer((LPBJTimerModel)lpbjTimerModel, this.bjyVideoPlayer.getCurrentPosition());
        }));
        this.compositeDisposable.add(this.pbRoom.getToolBoxVM().getObservableOfBJTimerEnd().subscribe(lpbjTimerModel -> this.endTimer((LPBJTimerModel)lpbjTimerModel)));
        this.compositeDisposable.add(this.pbRoom.getToolBoxVM().getObservableOfBJTimerPause().subscribe(lpbjTimerModel -> {
            this.pauseTimer = true;
            this.startTimer((LPBJTimerModel)lpbjTimerModel, this.bjyVideoPlayer.getCurrentPosition());
        }));
        this.bjyVideoPlayer.addOnPlayingTimeChangeListener((currentTime, duration) -> {
            if (currentTime == duration) {
                this.announcementModel = null;
                this.questionAnswerBtn.setImageResource(R.drawable.live_ic_question_answer_normal);
            }
            this.checkVisitorDialog(currentTime);
            if (this.cacheTime < currentTime) {
                this.cacheTime = currentTime;
            }
            this.checkRedPacketDialog(currentTime);
            if (this.timerModel != null && !this.pauseTimer) {
                this.startTimer(this.timerModel, currentTime);
            }
        });
        this.bjyVideoPlayer.addOnSeekCompleteListener((beforeSeekPosition, seekPosition) -> {
            this.checkVisitorDialog(seekPosition);
            if (this.timerModel != null) {
                this.checkTimer(this.timerModel, seekPosition);
            }
        });
        this.compositeDisposable.add(this.pbRoom.getObservableOfAnnouncementChange().observeOn(AndroidSchedulers.mainThread()).subscribe(announcementModel -> {
            this.announcementModel = (LPResRoomNoticeModel)announcementModel;
            this.showAnnouncementFragment();
        }));
        this.pbRoom.setOnSwitchPlaybackListener(new OnSwitchPlaybackListener(){

            public void onSwitchPlaybackReady() {
            }

            public void onSwitchPlaybackSuccess() {
                PBRoomActivity.this.pptView.release();
                PBRoomActivity.this.initPPTView();
                PBRoomActivity.this.pptView.attachRoom(PBRoomActivity.this.pbRoom);
                if (PBRoomActivity.this.isVideoInDragFrameLayout) {
                    PBRoomActivity.this.bigContainer.addPPTView((View)PBRoomActivity.this.pptView, new FrameLayout.LayoutParams(-1, -1));
                } else {
                    PBRoomActivity.this.videoDragLayout.removeAllViews();
                    PBRoomActivity.this.videoDragLayout.addView((View)PBRoomActivity.this.pptView, 0);
                }
            }
        });
        this.registerNetChangeReceiver();
    }

    private void checkTimer(LPBJTimerModel timerModel, long currentPosition) {
        if (this.pauseTimer) {
            return;
        }
        long startTime = timerModel.startTimer;
        long endTime = timerModel.total + startTime;
        if (currentPosition < startTime || currentPosition > endTime) {
            this.timerLayout.setVisibility(8);
        }
    }

    private void endTimer(LPBJTimerModel lpbjTimerModel) {
        if (this.timerModel != null && lpbjTimerModel.startTimer > this.timerModel.startTimer) {
            if (this.timerWindow != null) {
                this.timerWindow.release();
            }
            if (this.timerLayout != null) {
                this.timerLayout.setVisibility(8);
            }
            this.timerModel = null;
        }
    }

    private void startTimer(LPBJTimerModel lpbjTimerModel, long currentTime) {
        long startTime = lpbjTimerModel.startTimer;
        long endTime = lpbjTimerModel.total + startTime;
        if (lpbjTimerModel.current > 0L) {
            endTime = lpbjTimerModel.current + startTime;
        }
        if (currentTime >= startTime && currentTime <= endTime) {
            long time;
            if (this.timerWindow == null) {
                this.timerWindow = new TimerShowyWindow((Context)this);
            }
            if (this.timerLayout.getChildCount() == 0) {
                this.timerLayout.addView((View)this.timerWindow, -1, -1);
            }
            this.timerModel = lpbjTimerModel;
            long remainTime = endTime - currentTime;
            if (this.timerModel.isCountDown()) {
                if (this.pauseTimer) {
                    remainTime = time = lpbjTimerModel.current;
                } else {
                    time = endTime - currentTime;
                }
            } else if (this.pauseTimer) {
                time = lpbjTimerModel.total - lpbjTimerModel.current;
                remainTime = lpbjTimerModel.current;
            } else {
                time = currentTime - startTime + lpbjTimerModel.total - lpbjTimerModel.current;
            }
            this.timerWindow.setTimer(time);
            if (remainTime <= 60L && lpbjTimerModel.total >= 60L) {
                this.timerWindow.showViewWarning(true);
            } else {
                this.timerWindow.showViewWarning(false);
            }
            if (remainTime == 0L) {
                this.timerWindow.showTimerEnd();
            }
            this.timerLayout.setVisibility(0);
        } else {
            this.checkTimer(lpbjTimerModel, currentTime);
        }
    }

    private void checkRedPacketDialog(int currentTime) {
        Iterator<Integer> iterator = this.times.iterator();
        while (iterator.hasNext()) {
            Integer next = iterator.next();
            if (next != currentTime) continue;
            iterator.remove();
            this.showRedPacketDialog(currentTime);
        }
    }

    private void showRedPacketDialog(int currentTime) {
        if (this.isFinishing() || this.isDestroyed()) {
            return;
        }
        if (this.redPacketDialog != null) {
            this.redPacketDialog.dismissAllowingStateLoss();
        }
        this.redPacketDialog = new RedPacketDialog();
        Bundle bundle = new Bundle();
        bundle.putLong("playback_id", this.pbRoom.getPlaybackId());
        bundle.putLong("time_offset", (long)currentTime);
        bundle.putString("user_number", this.videoPlayerConfig.userId);
        bundle.putString("user_name", this.videoPlayerConfig.userName);
        bundle.putLong("room_id", this.pbRoom.getRoomId());
        bundle.putString("token", this.pbRoom.getRoomToken());
        this.redPacketDialog.setArguments(bundle);
        this.showDialogFragment(this.redPacketDialog);
    }

    private boolean checkDragControllerDialog(int seekPosition) {
        if (!this.videoPlayerConfig.enableDragController && seekPosition > this.cacheTime) {
            if (this.dragControllerDialog == null) {
                this.dragControllerDialog = new DragControllerDialog();
            }
            this.dragControllerDialog.setArguments(BundlePool.obtain((String)CustomUserDialog.class.getSimpleName(), (Serializable)((Object)this.videoPlayerConfig.dragControllerModel)));
            this.dragControllerDialog.show(this.getSupportFragmentManager(), "DragControllerDialog");
            this.dragControllerDialog.setOnPositiveClickListener(v -> {
                this.dragControllerDialog.dismissAllowingStateLoss();
                CallbackManager.getInstance().getDragConsumer().accept((Object)this.videoPlayerConfig.dragControllerModel);
            });
            return true;
        }
        return false;
    }

    private void checkVisitorDialog(int currentTime) {
        boolean checkVisitorModel;
        boolean bl = checkVisitorModel = this.videoPlayerConfig != null && this.videoPlayerConfig.visitorModel != null;
        if (checkVisitorModel && this.videoPlayerConfig.visitorModel.seconds >= 0 && currentTime >= this.videoPlayerConfig.visitorModel.seconds) {
            this.bigContainer.sendCustomEvent(-80002, BundlePool.obtain((String)"int_data", (Serializable)Integer.valueOf(this.videoPlayerConfig.visitorModel.seconds)));
            if (currentTime > this.videoPlayerConfig.visitorModel.seconds) {
                this.bjyVideoPlayer.seek(this.videoPlayerConfig.visitorModel.seconds);
            }
            this.bjyVideoPlayer.pause();
            if (this.customUserDialog == null) {
                this.customUserDialog = new CustomUserDialog();
            }
            this.customUserDialog.setArguments(BundlePool.obtain((String)CustomUserDialog.class.getSimpleName(), (Serializable)((Object)this.videoPlayerConfig.visitorModel)));
            this.customUserDialog.setOnNegativeClickListener(v -> CallbackManager.getInstance().getVisitorListener().onNavigateClick((DialogFragment)this.customUserDialog, this.bjyVideoPlayer));
            this.customUserDialog.setOnPositiveClickListener(v -> CallbackManager.getInstance().getVisitorListener().onPositiveClick((DialogFragment)this.customUserDialog, this.bjyVideoPlayer));
            this.customUserDialog.show(this.getSupportFragmentManager(), "CustomUserDialog");
            this.videoPlayerConfig.visitorModel = null;
        }
    }

    private void showCustomWebpageDialog(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        String realUrl = Uri.parse((String)url).buildUpon().appendQueryParameter("class_id", String.valueOf(this.pbRoom.getRoomId())).appendQueryParameter("user_number", this.videoPlayerConfig.userId).appendQueryParameter("user_name", this.videoPlayerConfig.userName).toString();
        if (this.customWebPageDialogFragment == null) {
            this.customWebPageDialogFragment = new CustomWebPageDialogFragment();
        }
        this.customWebPageDialogFragment.setListener(new CustomWebPageDialogFragment.Callback(){

            public void onShow(WebView webView, String url) {
            }

            public void onClose(WebView webview) {
                PBRoomActivity.this.closeCustomWebpageDialog();
            }
        });
        if (this.customWebPageDialogFragment.isAdded()) {
            this.customWebPageDialogFragment.loadUrl(realUrl);
        } else {
            Bundle bundle = new Bundle();
            float[] size = this.pbRoom.getPartnerConfig().getLiveCustomWebpageSize(this.isLandscape ? this.pbRoom.getPartnerConfig().liveCustomWebpageSize : this.pbRoom.getPartnerConfig().liveCustomWebpageSizePortrait);
            float[] position = this.pbRoom.getPartnerConfig().getLiveCustomWebpagePosition(this.isLandscape ? this.pbRoom.getPartnerConfig().liveCustomWebpagePosition : this.pbRoom.getPartnerConfig().liveCustomWebpagePositionPortrait);
            bundle.putFloat("width", size[0]);
            bundle.putFloat("height", size[1]);
            bundle.putFloat("x", position[0]);
            bundle.putFloat("y", position[1]);
            bundle.putString("url", realUrl);
            this.customWebPageDialogFragment.setArguments(bundle);
            this.showDialogFragment((BaseDialogFragment)this.customWebPageDialogFragment);
        }
    }

    private void closeCustomWebpageDialog() {
        if (this.customWebPageDialogFragment.isAdded() && this.customWebPageDialogFragment.isVisible()) {
            this.customWebPageDialogFragment.dismissAllowingStateLoss();
        }
    }

    private boolean isSignalInOneSecond(int offsetMs) {
        int currentMs = this.bjyVideoPlayer.getCurrentPosition() * 1000;
        return offsetMs != -1000 && currentMs - offsetMs <= 1000;
    }

    private void updateIdentityText(IUserModel presenter) {
        if (presenter == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(presenter.getName());
        if (presenter.getType() == LPConstants.LPUserType.Teacher) {
            stringBuilder.append(this.getString(R.string.bjy_player_presenter_identity_text, new Object[]{this.pbRoom.getPartnerConfig().teacherLabel != null ? this.pbRoom.getPartnerConfig().teacherLabel : "\u8001\u5e08"}));
        } else if (presenter.getType() == LPConstants.LPUserType.Assistant) {
            if (this.pbRoom.getCurrentPresenter() != null && presenter.getUserId().equals(this.pbRoom.getCurrentPresenter().getUserId())) {
                stringBuilder.append(this.getString(R.string.bjy_player_presenter_identity_text, new Object[]{"\u4e3b\u8bb2"}));
            } else if (this.pbRoom.getPartnerConfig().assistantLabel != null) {
                stringBuilder.append(this.getString(R.string.bjy_player_presenter_identity_text, new Object[]{this.pbRoom.getPartnerConfig().assistantLabel}));
            }
        }
        this.presenterIdentityTv.setText((CharSequence)stringBuilder.toString());
    }

    private void showCustomGiftAnim(LPCustomImageGiftModel customImageGiftModel) {
        if (customImageGiftModel.specialEffects != 0 && !TextUtils.isEmpty((CharSequence)customImageGiftModel.customImage)) {
            this.giftView.setVisibility(0);
            this.giftView.loadImage(customImageGiftModel.customImage);
            this.giftView.startAnim();
        }
    }

    private void showChatGiftAnim(LPLiveRewardConfigModel lpLiveRewardConfig) {
        if (lpLiveRewardConfig.isFloat) {
            this.addGiftAnim(lpLiveRewardConfig.sendUserName, lpLiveRewardConfig.imgUrl, -1);
        }
    }

    private void addGiftAnim(String sendUserName, String remoteUrl, int localRes) {
        int childCount = this.giftContainer.getChildCount();
        final View view = View.inflate((Context)this, (int)R.layout.bjy_pb_layout_gift_header, null);
        BjyPbLayoutGiftHeaderBinding binding = BjyPbLayoutGiftHeaderBinding.bind(view);
        int radius = UtilsKt.getDp((int)20);
        binding.giftBgContainer.setBackground(new DrawableBuilder().gradientType(0).gradient(true).gradientColors(0x4D000000, 0, null).cornerRadius(radius).build());
        binding.tvName.setText((CharSequence)UtilsKt.getEncodePhoneNumber((String)sendUserName));
        if (TextUtils.isEmpty((CharSequence)remoteUrl)) {
            binding.ivGift.setImageResource(localRes);
        } else {
            Glide.with((Context)view.getContext()).load(remoteUrl).into(binding.ivGift);
        }
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        if (childCount == 3) {
            this.giftContainer.removeAllViews();
        }
        this.giftContainer.addView(view, (ViewGroup.LayoutParams)layoutParams);
        ObjectAnimator animatorIn = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{-UtilsKt.getDp((int)300), UtilsKt.getDp((int)16)});
        animatorIn.setDuration(500L);
        animatorIn.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animatorIn.start();
        view.postDelayed(() -> {
            ObjectAnimator animatorOut = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{UtilsKt.getDp((int)16), -UtilsKt.getDp((int)300)});
            animatorOut.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            animatorOut.start();
            animatorOut.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    PBRoomActivity.this.giftContainer.removeView(view);
                }
            });
        }, 2000L);
    }

    private void addChatFragment() {
        if (this.chatFragment == null) {
            this.chatFragment = new PBChatFragment();
            this.chatFragment.setRoom(this.pbRoom);
            this.addFragment(R.id.fl_pb_chat_content_container, this.chatFragment, false, CHAT_FRAGMENT_TAG);
        }
    }

    private void switchPPTAndVideo() {
        this.switchPPTAndVideo(false);
    }

    private void switchPPTAndVideo(boolean isManual) {
        if (this.pipHelper != null) {
            this.pipHelper.dismiss();
        }
        if (this.bigContainer.containPPTView((View)this.pptView) && this.isVideoInDragFrameLayout) {
            return;
        }
        if (!this.bigContainer.containPPTView((View)this.pptView) && !this.isVideoInDragFrameLayout) {
            return;
        }
        if (!isManual) {
            this.isVideoInDragFrameLayout = !this.isVideoInDragFrameLayout;
        }
        View bigView = this.bigContainer.getChildAt(0);
        View smallView = this.videoDragLayout.getChildAt(0);
        this.bigContainer.removeView(bigView);
        this.videoDragLayout.removeAllViews();
        this.bigContainer.addView(smallView, 0);
        this.videoDragLayout.addView(bigView, 0);
        if (this.isVideoInDragFrameLayout) {
            UtilsKt.removeViewFromParent((View)this.presenterIdentityTv);
            this.videoDragLayout.addView((View)this.presenterIdentityTv);
        }
        this.changeDragLayoutParams();
        if (this.pptView != null) {
            this.pptView.sizeChange();
        }
    }

    @Override
    protected void requestLayout(boolean isLandscape) {
        super.requestLayout(isLandscape);
        if (this.bigContainer == null || this.pbRoom == null) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = this.bigContainer.getLayoutParams();
        if (isLandscape) {
            layoutParams.width = -1;
            layoutParams.height = -1;
        } else {
            layoutParams.width = DisplayUtils.getScreenWidthPixels((Context)this);
            layoutParams.height = layoutParams.width * 9 / 16;
        }
        this.bigContainer.setLayoutParams(layoutParams);
        this.bigContainer.sendCustomEvent(-80006, BundlePool.obtain((boolean)isLandscape));
        if (this.pptView != null) {
            this.pptView.sizeChange();
        }
        this.doOnChatDrawerConfigurationChanged(isLandscape);
        this.doOnDragContainerConfigurationChanged(isLandscape);
        this.videoDragLayout.configurationChanged();
        this.flQuestionTool.configurationChanged();
        this.layoutCloudVideoView();
        if (BJYPlayerSDK.hideChatLandscape) {
            if (isLandscape) {
                this.chatContainer.setVisibility(8);
                this.chatSwitchIv.setImageResource(R.drawable.ic_video_back_sentmsg_no_on);
            } else {
                this.chatContainer.setVisibility(0);
                this.chatSwitchIv.setImageResource(R.drawable.ic_video_back_sentmsg_no);
            }
        }
    }

    private void updateBigContainerPPTArea() {
        if (this.bigContainer == null || this.pbRoom == null) {
            return;
        }
        if (this.bigContainer.containPPTView((View)this.pptView) && this.pptView != null && this.pptView.isPPTAttached()) {
            this.bigContainer.sendCustomEvent(-80042, BundlePool.obtain((boolean)true));
        } else {
            this.bigContainer.setPPTTouchEnable(false);
            this.bigContainer.sendCustomEvent(-80042, BundlePool.obtain((boolean)false));
        }
    }

    private void initCloudVideoView() {
        this.cloudVideoPlayer = new VideoPlayerFactory.Builder().setContext((Context)this).setStatisticReportEnable(false).build();
        this.pbRoom.bindCloudVideoPlayer(this.cloudVideoPlayer);
        this.cloudVideoView.initPlayer(this.cloudVideoPlayer, false);
        this.cloudVideoPlayer.addOnPlayerStatusChangeListener(status -> this.cloudVideoContainer.setVisibility(status != PlayerStatus.STATE_PAUSED && status != PlayerStatus.STATE_STARTED ? 8 : 0));
        this.layoutCloudVideoView();
    }

    private void layoutCloudVideoView() {
        this.cloudVideoContainer.configurationChanged();
        int parentHeight = this.isLandscape ? DisplayUtils.getScreenHeightPixels((Context)this) : DisplayUtils.getScreenWidthPixels((Context)this) * 9 / 16;
        int height = (int)((double)parentHeight * 0.6);
        int width = (int)((float)height * 1.7777778f);
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.cloudVideoContainer.getLayoutParams();
        layoutParams.width = width;
        layoutParams.height = height;
    }

    private void doOnChatDrawerConfigurationChanged(boolean isLandScape) {
        ConstraintLayout.LayoutParams chatDrawerLayoutParam = new ConstraintLayout.LayoutParams(-2, -2);
        ConstraintLayout.LayoutParams questionLayoutParam = (ConstraintLayout.LayoutParams)this.questionAnswerBtn.getLayoutParams();
        ConstraintLayout.LayoutParams chatLayoutParam = (ConstraintLayout.LayoutParams)this.chatSwitchIv.getLayoutParams();
        ConstraintLayout.LayoutParams announcementBtnLayoutParams = (ConstraintLayout.LayoutParams)this.announcementBtn.getLayoutParams();
        int marginLeft = UtilsKt.getDp((int)12);
        int marginBottom = UtilsKt.getDp((int)68);
        if (isLandScape) {
            chatDrawerLayoutParam.width = UtilsKt.getDp((int)300);
            chatDrawerLayoutParam.height = 0;
            if (PBUIUtils.isChatFloatRight(this.pbRoom)) {
                chatDrawerLayoutParam.startToStart = -1;
                chatDrawerLayoutParam.endToEnd = 0;
            } else {
                chatDrawerLayoutParam.startToStart = 0;
                chatDrawerLayoutParam.endToEnd = -1;
            }
            chatDrawerLayoutParam.topToTop = 0;
            chatDrawerLayoutParam.bottomToTop = R.id.iv_pb_chat_switch;
            chatDrawerLayoutParam.topMargin = UtilsKt.getDp((int)50);
            chatLayoutParam.setMargins(marginLeft, 0, 0, marginBottom);
            questionLayoutParam.setMargins(marginLeft, 0, 0, marginBottom);
            announcementBtnLayoutParams.setMargins(marginLeft, 0, 0, marginBottom);
        } else {
            chatDrawerLayoutParam.width = -1;
            chatDrawerLayoutParam.height = 0;
            chatDrawerLayoutParam.startToStart = 0;
            chatDrawerLayoutParam.topToBottom = R.id.fl_pb_container_big;
            chatDrawerLayoutParam.bottomToBottom = 0;
            chatDrawerLayoutParam.endToEnd = -1;
            chatLayoutParam.setMargins(marginLeft, 0, 0, marginLeft);
            questionLayoutParam.setMargins(marginLeft, 0, 0, marginLeft);
            announcementBtnLayoutParams.setMargins(marginLeft, 0, 0, marginLeft);
        }
        this.chatContainer.setLayoutParams((ViewGroup.LayoutParams)chatDrawerLayoutParam);
        if (PBUIUtils.isChatFloatRight(this.pbRoom) && isLandScape) {
            this.isChatFloatRightCloseChat = true;
            this.chatContainer.setVisibility(8);
        } else if (this.isChatFloatRightCloseChat) {
            this.chatContainer.setVisibility(0);
        }
    }

    private void doOnDragContainerConfigurationChanged(boolean isLandscape) {
        ConstraintLayout.LayoutParams lpSmallContainer = new ConstraintLayout.LayoutParams(UtilsKt.getDp((int)150), UtilsKt.getDp((int)(this.pbRoom.isSmallCourseSignalPlayback() && this.isVideoInDragFrameLayout ? 180 : 90)));
        if (this.isVideoInDragFrameLayout && this.isWebrtcOneOnOnePlayback()) {
            lpSmallContainer = new ConstraintLayout.LayoutParams(UtilsKt.getDp((int)160), UtilsKt.getDp((int)180));
        }
        if (isLandscape) {
            if (PBUIUtils.isChatFloatRight(this.pbRoom)) {
                lpSmallContainer.startToStart = 0;
                lpSmallContainer.endToEnd = -1;
            } else {
                lpSmallContainer.startToStart = -1;
                lpSmallContainer.endToEnd = 0;
            }
            lpSmallContainer.topToTop = 0;
            lpSmallContainer.topMargin = UtilsKt.getDp((int)50);
        } else {
            lpSmallContainer.startToStart = -1;
            lpSmallContainer.endToEnd = 0;
            lpSmallContainer.topToBottom = R.id.fl_pb_container_big;
            lpSmallContainer.topMargin = UtilsKt.getDp((int)0);
        }
        this.videoDragLayout.setLayoutParams((ViewGroup.LayoutParams)lpSmallContainer);
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.timerLayout.getLayoutParams();
        layoutParams.topMargin = isLandscape ? UtilsKt.getDp((int)180) : UtilsKt.getDp((int)56);
    }

    @Override
    public void showSaveImageDialog(String url) {
        ChatSavePicDialogFragment fragment = new ChatSavePicDialogFragment(url);
        this.showDialogFragment((BaseDialogFragment)fragment);
    }

    @Override
    public void displayImage(String imageUrl) {
        ChatPictureViewFragment fragment = ChatPictureViewFragment.newInstance(new ArrayList<String>(Collections.singletonList(imageUrl)));
        fragment.setCallback((ChatPictureViewFragment.Callback)new ChatPictureViewFragment.SimpleChatPicCallback(){

            public void save(String url) {
                PBRoomActivity.this.showSaveImageDialog(url);
            }
        });
        this.showDialogFragment((BaseDialogFragment)fragment);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.pipHelper != null) {
            this.pipHelper.onActivityResult(requestCode, resultCode, data);
        }
    }

    private void showPiP() {
        if (this.pipHelper == null) {
            this.pipHelper = new PiPHelper((Activity)this, this.bjyVideoPlayer);
            this.getLifecycle().addObserver((LifecycleObserver)this.pipHelper);
        }
        this.pipHelper.show((View)this.smallPureVideoView);
    }

    @Override
    protected void onDestroy() {
        RxUtils.dispose((Disposable)this.disposableOfRedPacket);
        this.unregisterNetChangeReceiver();
        if (this.pptView != null) {
            this.pptView.destroy();
        }
        if (this.pbRoom != null) {
            this.pbRoom.quitRoom();
        }
        if (this.bigContainer != null) {
            this.bigContainer.onDestroy();
        }
        if (this.timerWindow != null) {
            this.timerWindow.release();
        }
        this.removeAnswer();
        this.dismissQuizDlg();
        this.dismissAlbumDlg();
        super.onDestroy();
    }

    private void dismissAlbumDlg() {
        if (this.videoAlbumDialogFragment != null && this.videoAlbumDialogFragment.isAdded()) {
            this.videoAlbumDialogFragment.dismissAllowingStateLoss();
            this.removeFragment((Fragment)this.videoAlbumDialogFragment);
        }
        this.videoAlbumDialogFragment = null;
    }

    @Override
    public void onBackPressed() {
        if (this.recordType != 2) {
            super.onBackPressed();
        } else {
            this.onBackPressedExitImmediately();
        }
    }

    protected void showFragment(Fragment fragment) {
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        transaction.show(fragment);
        transaction.commitAllowingStateLoss();
    }

    private <V extends BaseView, P extends BasePBPresenter> void bindVP(V view, P presenter) {
        presenter.setRouter(this);
        view.setPresenter(presenter);
    }

    @Override
    public PBRoom getPBRoom() {
        return this.pbRoom;
    }

    private void answerStart(LPAnswerModel model) {
        this.lpAnswerModel = model;
        this.removeAnswer();
        this.answerEnd(false);
        QuestionToolPresenter questionToolPresenter = new QuestionToolPresenter();
        questionToolPresenter.setRouter(this);
        questionToolPresenter.setLpQuestionToolModel(model);
        this.questionToolFragment = new QuestionToolFragment();
        questionToolPresenter.setView(this.questionToolFragment);
        this.bindVP(this.questionToolFragment, questionToolPresenter);
        this.flQuestionTool.setVisibility(0);
        this.addFragment(R.id.activity_dialog_question_tool, (Fragment)this.questionToolFragment);
        this.showFragment((Fragment)this.questionToolFragment);
    }

    private void showAnswer() {
        QuestionShowPresenter questionShowPresenter = new QuestionShowPresenter();
        questionShowPresenter.setRouter(this);
        questionShowPresenter.setLpQuestionToolModel(this.lpAnswerModel);
        this.questionShowFragment = new QuestionShowFragment();
        questionShowPresenter.setView(this.questionShowFragment);
        this.bindVP(this.questionShowFragment, questionShowPresenter);
        this.flQuestionTool.setVisibility(0);
        this.addFragment(R.id.activity_dialog_question_tool, (Fragment)this.questionShowFragment);
        this.showFragment((Fragment)this.questionShowFragment);
    }

    @Override
    public void answerEnd(boolean ended) {
        if (this.questionToolFragment != null && this.questionToolFragment.isAdded()) {
            this.removeFragment((Fragment)this.questionToolFragment);
            this.flQuestionTool.setVisibility(8);
            this.questionToolFragment = null;
        }
        if (this.lpAnswerModel != null && ended) {
            this.showAnswer();
        }
    }

    @Override
    public void removeAnswer() {
        if (this.questionShowFragment != null && this.questionShowFragment.isAdded()) {
            this.removeFragment((Fragment)this.questionShowFragment);
            this.flQuestionTool.setVisibility(8);
            this.questionShowFragment = null;
        }
    }

    @Override
    public void setQuestionAnswerCache(LPAnswerModel lpAnswerModel) {
        this.lpAnswerModel = lpAnswerModel;
    }

    private void quizStart(LPJsonModel jsonModel) {
        this.dismissQuizDlg();
        this.quizFragment = new QuizDialogFragment();
        this.quizFragment.setCancelable(false);
        QuizDialogPresenter quizPresenter = new QuizDialogPresenter(this.quizFragment);
        this.quizFragment.onStartArrived(jsonModel);
        this.bindVP(this.quizFragment, quizPresenter);
        this.showDialogFragment(this.quizFragment);
    }

    @Override
    public void dismissQuizDlg() {
        if (this.quizFragment != null && this.quizFragment.isAdded()) {
            this.quizFragment.dismissAllowingStateLoss();
        }
    }

    @Override
    public void showQuestionAnswer(boolean show) {
        if (show) {
            if (this.questionAnswerFragment == null) {
                this.questionAnswerFragment = new QuestionAnswerFragment();
            }
            if (this.questionAnswerFragment.isAdded()) {
                return;
            }
            QuestionAnswerPresenter questionAnswerPresenter = new QuestionAnswerPresenter(this.questionAnswerFragment);
            this.bindVP(this.questionAnswerFragment, questionAnswerPresenter);
            this.showDialogFragment(this.questionAnswerFragment);
        } else {
            this.removeFragment((Fragment)this.questionAnswerFragment);
        }
    }

    private void showAnnouncementFragment() {
        if (this.announcementFragment == null) {
            this.announcementFragment = AnnouncementFragment.newInstance(this.announcementModel);
            this.announcementFragment.setPbRoom(this.pbRoom);
        } else {
            Bundle bundle = new Bundle();
            bundle.putSerializable("announcement", (Serializable)this.announcementModel);
            this.announcementFragment.setArguments(bundle);
        }
        if (this.announcementFragment.isAdded()) {
            return;
        }
        this.showDialogFragment(this.announcementFragment);
    }

    @Override
    protected void notificationSeekTo(long pos) {
        this.bjyVideoPlayer.seek((int)(pos / 1000L));
    }

    private void initHorseLamp() {
        LPHorseLamp horseLamp = this.bjyVideoPlayer.getHorseLamp();
        if ((horseLamp = PBUIUtils.checkHorseLampConfig(horseLamp, this.videoPlayerConfig)) != null) {
            HorseLampView horseLampView = new HorseLampView((Context)this);
            this.rootContainer.addView((View)horseLampView, (ViewGroup.LayoutParams)new ConstraintLayout.LayoutParams(-1, -1));
            horseLampView.startHorseLamp(horseLamp);
        }
    }

    protected void registerNetChangeReceiver() {
        if (this.mBroadcastReceiver == null) {
            this.unregisterNetChangeReceiver();
            this.mBroadcastReceiver = new NetChangeBroadcastReceiver();
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            this.registerReceiver(this.mBroadcastReceiver, intentFilter);
        }
    }

    protected void unregisterNetChangeReceiver() {
        if (this.mBroadcastReceiver != null) {
            this.unregisterReceiver(this.mBroadcastReceiver);
            this.mBroadcastReceiver = null;
        }
    }

    class NetChangeBroadcastReceiver
    extends BroadcastReceiver {
        NetChangeBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action;
            if (PBRoomActivity.this.pbRoom.isPlaybackOffline() && "android.net.conn.CONNECTIVITY_CHANGE".equals(action = intent.getAction())) {
                boolean isConnected = NetworkUtils.isNetConnected(context);
                PBRoomActivity.this.pptView.setAnimPPTEnable(isConnected);
            }
        }
    }
}

