/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.baijiayun.BJYPlayerSDK;
import com.baijiayun.constant.VideoDefinition;
import com.baijiayun.videoplayer.IBJYVideoPlayer;
import com.baijiayun.videoplayer.bean.BJYVideoInfo;
import com.baijiayun.videoplayer.event.BundlePool;
import com.baijiayun.videoplayer.player.PlayerStatus;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.bean.NetworkState;
import com.baijiayun.videoplayer.ui.component.BaseComponent;
import com.baijiayun.videoplayer.ui.component.SubtitleMenuComponent;
import com.baijiayun.videoplayer.ui.listener.IComponentEventListener;
import com.baijiayun.videoplayer.ui.utils.NetworkUtils;
import com.baijiayun.videoplayer.ui.widget.ComponentContainer;
import com.baijiayun.videoplayer.util.VideoPlayerUtils;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.io.Serializable;
import java.util.List;

public class BaseVideoView
extends FrameLayout {
    protected IBJYVideoPlayer bjyVideoPlayer;
    protected ComponentContainer componentContainer;
    private IComponentEventListener componentEventListener;
    protected boolean useDefaultNetworkListener = true;
    protected boolean enablePlayWithMobileNetwork = false;
    private NetChangeBroadcastReceiver mBroadcastReceiver;
    private PublishSubject<PlayerStatus> subjectOfVideoStatus;
    protected PlayerStatus videoStatus;
    protected IComponentEventListener internalComponentEventListener = new IComponentEventListener(){

        @Override
        public void onReceiverEvent(int eventCode, Bundle bundle) {
            if (BaseVideoView.this.componentEventListener != null) {
                BaseVideoView.this.componentEventListener.onReceiverEvent(eventCode, bundle);
            }
            switch (eventCode) {
                case -80003: {
                    BaseVideoView.this.bjyVideoPlayer.pause();
                    break;
                }
                case -80004: {
                    BaseVideoView.this.bjyVideoPlayer.rePlay();
                    break;
                }
                case -80002: {
                    int seekToPosition = bundle.getInt("int_data");
                    BaseVideoView.this.bjyVideoPlayer.seek(seekToPosition);
                    break;
                }
                case -80008: {
                    BaseVideoView.this.bjyVideoPlayer.setPlayRate(bundle.getFloat("float_data"));
                    break;
                }
                case -80009: {
                    BaseVideoView.this.bjyVideoPlayer.changeDefinition((VideoDefinition)bundle.getSerializable("serializable_data"));
                    BaseVideoView.this.updateAudioCoverStatus(false);
                    break;
                }
                case -80015: {
                    BaseVideoView.this.enablePlayWithMobileNetwork = true;
                    BaseVideoView.this.requestPlayAction();
                    break;
                }
                case -80021: {
                    BaseVideoView.this.bjyVideoPlayer.toggleSubtitleEngine(!bundle.getBoolean("bool_data"));
                    break;
                }
                case -80022: {
                    BaseVideoView.this.bjyVideoPlayer.changeSubtitlePath(bundle.getString("string_data"), bundle.getString("string_data1", ""));
                    break;
                }
            }
        }
    };

    public BaseVideoView(@NonNull Context context) {
        this(context, null);
    }

    public BaseVideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseVideoView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public BaseVideoView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    protected void init(Context context, AttributeSet attributeSet, int defStyleAttr) {
        this.subjectOfVideoStatus = PublishSubject.create();
    }

    protected void initPlayer(IBJYVideoPlayer videoPlayer) {
        this.bjyVideoPlayer = videoPlayer;
        this.bjyVideoPlayer.addOnPlayerStatusChangeListener(status -> {
            this.subjectOfVideoStatus.onNext((Object)status);
            if (status == PlayerStatus.STATE_PREPARED) {
                this.updateAudioCoverStatus(false);
                if (!BJYPlayerSDK.isVideoList && this.componentContainer != null && !VideoPlayerUtils.isEmptyList((List)this.bjyVideoPlayer.getVideoInfo().getSubtitleItemList())) {
                    this.componentContainer.addComponent("subtitle_menu_component", new SubtitleMenuComponent(this.getContext(), this.bjyVideoPlayer.getVideoInfo().getSubtitleItemList()));
                }
            }
            this.updateAudioCoverAnim(status);
            if (this.componentContainer != null) {
                Bundle bundle = BundlePool.obtain((Serializable)status);
                this.componentContainer.dispatchPlayEvent(-99031, bundle);
            }
            this.videoStatus = status;
        });
    }

    protected void updateAudioCoverAnim(PlayerStatus status) {
    }

    public Observable<PlayerStatus> getObservableVideoStatus() {
        return this.subjectOfVideoStatus;
    }

    public void updateAudioCoverStatus() {
        this.updateAudioCoverStatus(false);
    }

    protected void requestPlayAction() {
    }

    public void addComponent(String key, BaseComponent component) {
        if (this.componentContainer != null) {
            this.componentContainer.addComponent(key, component);
        }
    }

    public void setComponentEventListener(IComponentEventListener componentEventListener) {
        this.componentEventListener = componentEventListener;
    }

    public void sendCustomEvent(int eventCode, Bundle bundle) {
        if (this.componentContainer != null) {
            this.componentContainer.dispatchCustomEvent(eventCode, bundle);
        }
    }

    protected void registerNetChangeReceiver() {
        if (this.mBroadcastReceiver == null) {
            this.unregisterNetChangeReceiver();
            this.mBroadcastReceiver = new NetChangeBroadcastReceiver();
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            this.getContext().registerReceiver((BroadcastReceiver)this.mBroadcastReceiver, intentFilter);
        }
    }

    protected void unregisterNetChangeReceiver() {
        if (this.mBroadcastReceiver != null) {
            this.getContext().unregisterReceiver((BroadcastReceiver)this.mBroadcastReceiver);
            this.mBroadcastReceiver = null;
        }
    }

    public void onDestroy() {
        this.unregisterNetChangeReceiver();
        if (this.bjyVideoPlayer != null) {
            this.bjyVideoPlayer.release();
        }
        this.componentEventListener = null;
        if (this.componentContainer != null) {
            this.componentContainer.destroy();
        }
    }

    protected void updateAudioCoverStatus(boolean forceAudio) {
    }

    public void updateAlbumBtnWhenPrepared(boolean showAlbumMenu, boolean isVideoPlay) {
        Bundle bundle = BundlePool.obtain();
        if (showAlbumMenu) {
            bundle.putString("string_data", this.getContext().getString(isVideoPlay ? R.string.bjy_pb_menu : R.string.bjy_pb_video_list));
        }
        bundle.putBoolean("bool_data", showAlbumMenu);
        this.sendCustomEvent(-80047, bundle);
    }

    public BJYVideoInfo getVideoInfo() {
        return this.bjyVideoPlayer.getVideoInfo();
    }

    class NetChangeBroadcastReceiver
    extends BroadcastReceiver {
        NetChangeBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (BaseVideoView.this.bjyVideoPlayer.isPlayLocalVideo()) {
                return;
            }
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(action)) {
                boolean isConnected;
                NetworkState netState = NetworkUtils.getNetworkState(context);
                if (!BaseVideoView.this.enablePlayWithMobileNetwork && NetworkUtils.isMobile(netState)) {
                    BaseVideoView.this.bjyVideoPlayer.pause();
                    if (BaseVideoView.this.componentContainer != null) {
                        BaseVideoView.this.componentContainer.dispatchCustomEvent(-80012, null);
                    }
                }
                if (!(isConnected = NetworkUtils.isNetConnected(context))) {
                    BaseVideoView.this.bjyVideoPlayer.pause();
                }
                if (BaseVideoView.this.componentContainer != null) {
                    BaseVideoView.this.componentContainer.dispatchCustomEvent(-80014, BundlePool.obtain((boolean)isConnected));
                }
            }
        }
    }
}

