/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.SeekBar;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.videoplayer.IBJYVideoPlayer;
import com.baijiayun.videoplayer.player.PlayerStatus;
import com.baijiayun.videoplayer.render.AspectRatio;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.databinding.BjyPbLayoutPipBinding;
import com.baijiayun.videoplayer.ui.widget.BJYVideoView;
import com.baijiayun.videoplayer.ui.widget.FloatingView;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 82\u00020\u0001:\u00018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010#\u001a\u00020$2\u0006\u0010#\u001a\u00020\u0016H\u0002J\u0006\u0010%\u001a\u00020$J\u0012\u0010&\u001a\u00020$2\b\u0010'\u001a\u0004\u0018\u00010\u001dH\u0002J\u0012\u0010(\u001a\u00020$2\b\u0010'\u001a\u0004\u0018\u00010\u001dH\u0002J \u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001b2\b\u0010,\u001a\u0004\u0018\u00010-J\u0010\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020$2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00102\u001a\u00020$2\u0006\u0010/\u001a\u000200H\u0016J\b\u00103\u001a\u00020$H\u0002J\u0012\u00104\u001a\u00020$2\b\u0010'\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u00105\u001a\u00020$H\u0002J\u000e\u00106\u001a\u00020$2\u0006\u0010'\u001a\u00020\u001dJ\b\u00107\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\f\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/baijiayun/videoplayer/ui/utils/PiPHelper;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "activity", "Landroid/app/Activity;", "player", "Lcom/baijiayun/videoplayer/IBJYVideoPlayer;", "(Landroid/app/Activity;Lcom/baijiayun/videoplayer/IBJYVideoPlayer;)V", "am", "Landroid/app/ActivityManager;", "getAm", "()Landroid/app/ActivityManager;", "am$delegate", "Lkotlin/Lazy;", "binding", "Lcom/baijiayun/videoplayer/ui/databinding/BjyPbLayoutPipBinding;", "dialog", "Landroidx/appcompat/app/AlertDialog;", "disposeOfAutoHide", "Lio/reactivex/disposables/Disposable;", "floatingView", "Lcom/baijiayun/videoplayer/ui/widget/FloatingView;", "initialSupportBackgroundAudio", "", "isClearScreen", "isForeground", "isInPiP", "noTouchTime", "", "placeholderView", "Landroid/view/View;", "kotlin.jvm.PlatformType", "getPlaceholderView", "()Landroid/view/View;", "placeholderView$delegate", "videoView", "clearScreen", "", "dismiss", "max", "view", "min", "onActivityResult", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "onDestroy", "owner", "Landroidx/lifecycle/LifecycleOwner;", "onStart", "onStop", "openOverlayDialog", "removeViewFromParent", "requestDrawOverLays", "show", "showFloatingView", "Companion", "videoplayer-ui_release"})
@SuppressLint(value={"ClickableViewAccessibility"})
public final class PiPHelper
implements DefaultLifecycleObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Activity activity;
    @NotNull
    private final IBJYVideoPlayer player;
    @Nullable
    private Disposable disposeOfAutoHide;
    private int noTouchTime;
    private boolean isClearScreen;
    private boolean isInPiP;
    @Nullable
    private View videoView;
    @NotNull
    private BjyPbLayoutPipBinding binding;
    @NotNull
    private FloatingView floatingView;
    @Nullable
    private AlertDialog dialog;
    private boolean initialSupportBackgroundAudio;
    private boolean isForeground;
    @NotNull
    private final Lazy am$delegate;
    @NotNull
    private final Lazy placeholderView$delegate;
    @NotNull
    public static final String TAG = "PiPHelper";
    public static final int OVERLAY_PERMISSION_REQ_CODE = 66;
    public static final long AUTO_HIDE_TIME = 6L;

    public PiPHelper(@NotNull Activity activity, @NotNull IBJYVideoPlayer player) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.activity = activity;
        this.player = player;
        this.isForeground = true;
        this.am$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ActivityManager>(this){
            final /* synthetic */ PiPHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ActivityManager invoke() {
                Object object = PiPHelper.access$getActivity$p(this.this$0).getSystemService("activity");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.ActivityManager");
                return (ActivityManager)object;
            }
        }));
        this.placeholderView$delegate = LazyKt.lazy((Function0)((Function0)new Function0<View>(this){
            final /* synthetic */ PiPHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final View invoke() {
                return View.inflate((Context)((Context)PiPHelper.access$getActivity$p(this.this$0)), (int)R.layout.bjy_base_pip_placeholder, null);
            }
        }));
        View view = View.inflate((Context)((Context)this.activity), (int)R.layout.bjy_pb_layout_pip, null);
        this.floatingView = new FloatingView(this.activity.getApplicationContext(), view);
        this.floatingView.setBackground(new DrawableBuilder().solidColor(ContextCompat.getColor((Context)((Context)this.activity), (int)R.color.pb_half_black)).cornerRadius(UtilsKt.getDp((int)10)).build());
        DisplayUtils.setRoundCorner((View)((View)this.floatingView), (float)UtilsKt.getDp((float)10.0f));
        BjyPbLayoutPipBinding bjyPbLayoutPipBinding = BjyPbLayoutPipBinding.bind(view);
        Intrinsics.checkNotNullExpressionValue((Object)bjyPbLayoutPipBinding, (String)"bind(view)");
        this.binding = bjyPbLayoutPipBinding;
        this.binding.closeIv.setOnClickListener(arg_0 -> PiPHelper._init_$lambda$0(this, arg_0));
        this.binding.backIv.setOnClickListener(arg_0 -> PiPHelper._init_$lambda$1(this, arg_0));
        this.binding.playIv.setOnClickListener(arg_0 -> PiPHelper._init_$lambda$2(this, arg_0));
        this.binding.playerSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(@Nullable SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    player.seek(progress);
                }
            }

            public void onStartTrackingTouch(@Nullable SeekBar seekBar) {
            }

            public void onStopTrackingTouch(@Nullable SeekBar seekBar) {
            }
        });
        this.initialSupportBackgroundAudio = this.player.getSupportBackgroundAudio();
        this.player.addOnPlayingTimeChangeListener((arg_0, arg_1) -> PiPHelper._init_$lambda$3(this, arg_0, arg_1));
        this.player.addOnPlayerStatusChangeListener(arg_0 -> PiPHelper._init_$lambda$4(this, arg_0));
        this.disposeOfAutoHide = Observable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).filter(arg_0 -> PiPHelper._init_$lambda$5((Function1)new Function1<Long, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull Long it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return isInPiP;
            }
        }, arg_0)).observeOn(AndroidSchedulers.mainThread()).subscribe(arg_0 -> PiPHelper._init_$lambda$6((Function1)new Function1<Long, Unit>(){

            public final void invoke(Long it) {
                PiPHelper piPHelper = this;
                int n = piPHelper.noTouchTime;
                piPHelper.noTouchTime = n + 1;
                if (!isClearScreen && (long)noTouchTime >= 6L) {
                    this.clearScreen(true);
                }
            }
        }, arg_0));
        this.binding.getRoot().setOnTouchListener((arg_0, arg_1) -> PiPHelper._init_$lambda$7(this, arg_0, arg_1));
    }

    private final ActivityManager getAm() {
        Lazy lazy = this.am$delegate;
        return (ActivityManager)lazy.getValue();
    }

    private final View getPlaceholderView() {
        Lazy lazy = this.placeholderView$delegate;
        return (View)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void openOverlayDialog() {
        block1: {
            if (this.dialog == null) {
                void $this$openOverlayDialog_u24lambda_u2410;
                AlertDialog.Builder builder;
                AlertDialog.Builder builder2;
                AlertDialog.Builder builder3 = builder2 = (builder = new AlertDialog.Builder((Context)this.activity));
                PiPHelper piPHelper = this;
                boolean bl = false;
                $this$openOverlayDialog_u24lambda_u2410.setTitle((CharSequence)this.activity.getString(R.string.bjy_player_floating_window_tip));
                $this$openOverlayDialog_u24lambda_u2410.setNegativeButton((CharSequence)this.activity.getString(R.string.bjy_player_open_later), PiPHelper::openOverlayDialog$lambda$10$lambda$8);
                $this$openOverlayDialog_u24lambda_u2410.setPositiveButton((CharSequence)this.activity.getString(R.string.bjy_player_open_now), (arg_0, arg_1) -> PiPHelper.openOverlayDialog$lambda$10$lambda$9(this, arg_0, arg_1));
                piPHelper.dialog = builder2.create();
            }
            AlertDialog alertDialog = this.dialog;
            if (alertDialog == null) break block1;
            alertDialog.show();
        }
    }

    private final void clearScreen(boolean clearScreen) {
        this.isClearScreen = clearScreen;
        int visible = clearScreen ? 8 : 0;
        this.binding.playIv.setVisibility(visible);
        this.binding.closeIv.setVisibility(visible);
        this.binding.backIv.setVisibility(visible);
        this.binding.playerSeekBar.setVisibility(visible);
    }

    private final void requestDrawOverLays() {
        if (Build.VERSION.SDK_INT >= 23 && !Settings.canDrawOverlays((Context)((Context)this.activity))) {
            this.openOverlayDialog();
        } else {
            this.min(this.videoView);
        }
    }

    private final void showFloatingView() {
        if (!this.floatingView.isShown()) {
            this.floatingView.show(UtilsKt.getDp((int)224), UtilsKt.getDp((int)126), Math.min(DisplayUtils.getScreenWidthPixels((Context)((Context)this.activity)), DisplayUtils.getScreenHeightPixels((Context)((Context)this.activity))) - UtilsKt.getDp((int)212), 0);
        }
    }

    private final void min(View view) {
        ViewGroup parentView;
        ViewGroup viewGroup;
        if (this.isInPiP || view == null) {
            return;
        }
        this.isInPiP = true;
        this.player.supportBackgroundAudio(true);
        this.binding.playerSeekBar.setMax(this.player.getDuration());
        this.binding.playerSeekBar.setProgress(this.player.getCurrentPosition());
        if (view.getParent() instanceof View) {
            ViewParent viewParent = view.getParent();
            Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.ViewGroup");
            viewGroup = (ViewGroup)viewParent;
        } else {
            viewGroup = null;
        }
        ViewGroup viewGroup2 = parentView = viewGroup;
        if (viewGroup2 != null) {
            ViewGroup viewGroup3;
            ViewGroup $this$min_u24lambda_u2411 = viewGroup3 = viewGroup2;
            boolean bl = false;
            int index = $this$min_u24lambda_u2411.indexOfChild(view);
            if (index != -1) {
                view.setTag(R.id.pip_index_of_parent, (Object)index);
                view.setTag(R.id.pip_parent, (Object)parentView);
                view.setTag(R.id.pip_child_params, (Object)view.getLayoutParams());
                View iv = this.getPlaceholderView().findViewById(R.id.iv);
                ViewGroup.LayoutParams layoutParams = iv.getLayoutParams();
                Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)layoutParams;
                if (parentView.getWidth() > parentView.getHeight()) {
                    params.matchConstraintPercentWidth = 1.0f;
                    params.matchConstraintPercentHeight = 0.5f;
                } else {
                    params.matchConstraintPercentWidth = 0.5f;
                    params.matchConstraintPercentHeight = 1.0f;
                }
                $this$min_u24lambda_u2411.addView(this.getPlaceholderView(), index, new ViewGroup.LayoutParams(-1, -1));
                $this$min_u24lambda_u2411.removeView(view);
            }
        }
        this.binding.videoContainer.removeAllViews();
        this.binding.videoContainer.addView(view, -1, -1);
        if (view instanceof BJYVideoView) {
            ((BJYVideoView)view).setComponentVisibility(8);
            ((BJYVideoView)view).setAspectRatio(AspectRatio.AspectRatio_FILL_PARENT);
        }
        this.showFloatingView();
    }

    private final void max(View view) {
        if (!this.isInPiP || view == null) {
            return;
        }
        this.isInPiP = false;
        this.removeViewFromParent(view);
        Object index = view.getTag(R.id.pip_index_of_parent);
        Object parentView = view.getTag(R.id.pip_parent);
        Object layoutParams = view.getTag(R.id.pip_child_params);
        Object object = parentView;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            if (it instanceof ViewGroup && index instanceof Integer && layoutParams instanceof ViewGroup.LayoutParams) {
                ((ViewGroup)it).removeView(this.getPlaceholderView());
                ((ViewGroup)it).addView(view, ((Number)index).intValue(), (ViewGroup.LayoutParams)layoutParams);
            }
        }
        if (view instanceof BJYVideoView) {
            ((BJYVideoView)view).setComponentVisibility(0);
            ((BJYVideoView)view).setAspectRatio(AspectRatio.AspectRatio_FIT_PARENT);
        }
        this.player.supportBackgroundAudio(this.initialSupportBackgroundAudio);
    }

    private final void removeViewFromParent(View view) {
        View view2 = view;
        Object object = view2 != null ? view2.getParent() : null;
        if (object == null) {
            return;
        }
        ViewParent viewParent = object;
        ((ViewGroup)viewParent).removeView(view);
    }

    public final void dismiss() {
        if (this.floatingView.isShown()) {
            this.floatingView.dismiss();
        }
        this.max(this.videoView);
    }

    public final void show(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.videoView = view;
        this.requestDrawOverLays();
    }

    public void onStart(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super.onStart(owner);
        this.isForeground = true;
    }

    public void onStop(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super.onStop(owner);
        this.isForeground = false;
    }

    public void onDestroy(@NotNull LifecycleOwner owner) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            super.onDestroy(owner);
            if (this.floatingView.isShown()) {
                this.floatingView.dismiss();
            }
            AlertDialog alertDialog = this.dialog;
            if (alertDialog != null) {
                alertDialog.dismiss();
            }
            Disposable disposable = this.disposeOfAutoHide;
            if (disposable == null) break block2;
            disposable.dispose();
        }
    }

    public final void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 66) {
            AlertDialog alertDialog = this.dialog;
            if (alertDialog != null) {
                alertDialog.dismiss();
            }
            if (Build.VERSION.SDK_INT >= 23 && !Settings.canDrawOverlays((Context)((Context)this.activity))) {
                Toast.makeText((Context)((Context)this.activity), (CharSequence)this.activity.getString(R.string.bjy_player_floating_window_permission_toast), (int)0).show();
            } else {
                this.min(this.videoView);
            }
        }
    }

    private static final void _init_$lambda$0(PiPHelper this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!this$0.isForeground && !this$0.initialSupportBackgroundAudio) {
            this$0.player.pause();
        }
        this$0.dismiss();
    }

    private static final void _init_$lambda$1(PiPHelper this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getAm().moveTaskToFront(this$0.activity.getTaskId(), 1);
        for (ActivityManager.AppTask appTask : this$0.getAm().getAppTasks()) {
            if (appTask.getTaskInfo().id != this$0.activity.getTaskId()) continue;
            appTask.moveToFront();
            break;
        }
        this$0.dismiss();
    }

    private static final void _init_$lambda$2(PiPHelper this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.binding.playIv.setSelected(!this$0.binding.playIv.isSelected());
        if (this$0.binding.playIv.isSelected()) {
            this$0.player.pause();
        } else {
            this$0.player.play();
        }
    }

    private static final void _init_$lambda$3(PiPHelper this$0, int currentTime, int n) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.binding.playerSeekBar.setProgress(currentTime);
    }

    private static final void _init_$lambda$4(PiPHelper this$0, PlayerStatus it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.binding.playIv.setSelected(it != PlayerStatus.STATE_STARTED);
    }

    private static final boolean _init_$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean _init_$lambda$7(PiPHelper this$0, View view, MotionEvent motionEvent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.clearScreen(false);
        this$0.noTouchTime = 0;
        return false;
    }

    private static final void openOverlayDialog$lambda$10$lambda$8(DialogInterface dialog, int n) {
        dialog.dismiss();
    }

    private static final void openOverlayDialog$lambda$10$lambda$9(PiPHelper this$0, DialogInterface dialog, int n) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (Build.VERSION.SDK_INT >= 23 && !Settings.canDrawOverlays((Context)((Context)this$0.activity)) && (intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + this$0.activity.getPackageName())))).resolveActivity(this$0.activity.getPackageManager()) != null) {
            this$0.activity.startActivityForResult(intent, 66);
        }
        dialog.dismiss();
    }

    public static final /* synthetic */ Activity access$getActivity$p(PiPHelper $this) {
        return $this.activity;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/baijiayun/videoplayer/ui/utils/PiPHelper$Companion;", "", "()V", "AUTO_HIDE_TIME", "", "OVERLAY_PERMISSION_REQ_CODE", "", "TAG", "", "videoplayer-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

