/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.playback.ppt;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.load.Transformation;
import com.baijiayun.glide.load.resource.bitmap.RoundedCorners;
import com.baijiayun.glide.request.RequestOptions;
import com.baijiayun.videoplayer.bean.TripartiteScreen;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.utils.PPTOutlineUtilsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0001\u0019B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u00020\u0007H\u0016J\u001e\u0010\u000e\u001a\u00020\n2\n\u0010\u000f\u001a\u00060\u0002R\u00020\u00002\b\b\u0001\u0010\u0010\u001a\u00020\u0007H\u0016J\u001c\u0010\u0011\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0018\u001a\u00020\n2\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n\u0018\u00010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/baijiayun/videoplayer/ui/playback/ppt/PPTOutlineAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/baijiayun/videoplayer/ui/playback/ppt/PPTOutlineAdapter$PPTOutlineViewHolder;", "hasImg", "", "(Z)V", "index", "", "listener", "Lkotlin/Function1;", "", "tripartiteScreen", "Lcom/baijiayun/videoplayer/bean/TripartiteScreen;", "getItemCount", "onBindViewHolder", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setChecked", "currentTime", "setData", "setListener", "PPTOutlineViewHolder", "videoplayer-ui_release"})
public final class PPTOutlineAdapter
extends RecyclerView.Adapter<PPTOutlineViewHolder> {
    private final boolean hasImg;
    @Nullable
    private TripartiteScreen tripartiteScreen;
    private int index;
    @Nullable
    private Function1<? super Integer, Unit> listener;

    public PPTOutlineAdapter(boolean hasImg) {
        this.hasImg = hasImg;
    }

    public /* synthetic */ PPTOutlineAdapter(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @NotNull
    public PPTOutlineViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjy_pb_item_outline_triple, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)itemView, (String)"itemView");
        return new PPTOutlineViewHolder(itemView);
    }

    public void onBindViewHolder(@NotNull PPTOutlineViewHolder holder, @SuppressLint(value={"RecyclerView"}) int position) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        if (this.tripartiteScreen == null) {
            return;
        }
        TripartiteScreen tripartiteScreen = this.tripartiteScreen;
        Intrinsics.checkNotNull((Object)tripartiteScreen);
        TripartiteScreen tripartiteScreen2 = tripartiteScreen;
        TripartiteScreen.ContentBean content = (TripartiteScreen.ContentBean)tripartiteScreen2.getTxt().getContent().get(position);
        TextView textView = holder.getContentTv();
        if (TextUtils.isEmpty((CharSequence)content.getOutline())) {
            Object[] objectArray = new Object[]{content.getPage()};
            charSequence = holder.itemView.getContext().getString(R.string.bjy_player_video_ppt_page_title, objectArray);
        } else {
            charSequence = content.getOutline();
        }
        textView.setText(charSequence);
        if (this.hasImg) {
            holder.getPlayContentIv().setVisibility(0);
            String url = tripartiteScreen2.getPpt().getUrl().getBaseUrl() + '/' + tripartiteScreen2.getPpt().getFid() + '_' + tripartiteScreen2.getPpt().getSn() + '_' + content.getPage() + ".png";
            Glide.with((Context)holder.itemView.getContext()).load(url).apply(RequestOptions.bitmapTransform((Transformation)((Transformation)new RoundedCorners(UtilsKt.getDp((int)4))))).into(holder.getPlayContentIv());
        }
        holder.itemView.setSelected(content.isChecked());
        holder.getContentTv().setSelected(content.isChecked());
        holder.getPlayStatusIv().setSelected(content.isChecked());
        holder.itemView.setOnClickListener(arg_0 -> PPTOutlineAdapter.onBindViewHolder$lambda$0(this, position, tripartiteScreen2, content, arg_0));
    }

    public int getItemCount() {
        Object object = this.tripartiteScreen;
        return object != null && (object = object.getTxt()) != null && (object = object.getContent()) != null ? object.size() : 0;
    }

    public final void setData(@NotNull TripartiteScreen tripartiteScreen) {
        Intrinsics.checkNotNullParameter((Object)tripartiteScreen, (String)"tripartiteScreen");
        this.tripartiteScreen = tripartiteScreen;
        if (this.index == 0) {
            List list = tripartiteScreen.getTxt().getContent();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"tripartiteScreen.txt.content");
            if (!((Collection)list).isEmpty()) {
                ((TripartiteScreen.ContentBean)tripartiteScreen.getTxt().getContent().get(0)).setChecked(true);
            }
        }
        this.notifyDataSetChanged();
    }

    public final void setChecked(int currentTime) {
        TripartiteScreen tripartiteScreen;
        Collection collection;
        if (this.tripartiteScreen == null || (collection = (Collection)((tripartiteScreen = this.tripartiteScreen) != null && (tripartiteScreen = tripartiteScreen.getTxt()) != null ? tripartiteScreen.getContent() : null)) == null || collection.isEmpty()) {
            return;
        }
        TripartiteScreen tripartiteScreen2 = this.tripartiteScreen;
        Intrinsics.checkNotNull((Object)tripartiteScreen2);
        List contents = tripartiteScreen2.getTxt().getContent();
        Intrinsics.checkNotNullExpressionValue((Object)contents, (String)"contents");
        int selectIndex = PPTOutlineUtilsKt.findIndexWithTimes(contents, currentTime);
        if (selectIndex != this.index) {
            ((TripartiteScreen.ContentBean)contents.get(this.index)).setChecked(false);
            ((TripartiteScreen.ContentBean)contents.get(selectIndex)).setChecked(true);
            this.notifyItemChanged(this.index);
            this.notifyItemChanged(selectIndex);
            this.index = selectIndex;
        }
    }

    public final void setListener(@Nullable Function1<? super Integer, Unit> listener) {
        this.listener = listener;
    }

    private static final void onBindViewHolder$lambda$0(PPTOutlineAdapter this$0, int $position, TripartiteScreen $tripartiteScreen, TripartiteScreen.ContentBean $content, View it) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$tripartiteScreen, (String)"$tripartiteScreen");
            if (this$0.index == $position) break block1;
            ((TripartiteScreen.ContentBean)$tripartiteScreen.getTxt().getContent().get(this$0.index)).setChecked(false);
            $content.setChecked(true);
            this$0.notifyItemChanged(this$0.index);
            this$0.notifyItemChanged($position);
            this$0.index = $position;
            Function1<? super Integer, Unit> function1 = this$0.listener;
            if (function1 != null) {
                function1.invoke((Object)$content.getTime());
            }
        }
    }

    public PPTOutlineAdapter() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/baijiayun/videoplayer/ui/playback/ppt/PPTOutlineAdapter$PPTOutlineViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lcom/baijiayun/videoplayer/ui/playback/ppt/PPTOutlineAdapter;Landroid/view/View;)V", "contentTv", "Landroid/widget/TextView;", "getContentTv", "()Landroid/widget/TextView;", "playContentIv", "Landroid/widget/ImageView;", "getPlayContentIv", "()Landroid/widget/ImageView;", "playStatusIv", "getPlayStatusIv", "videoplayer-ui_release"})
    public final class PPTOutlineViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final TextView contentTv;
        @NotNull
        private final ImageView playStatusIv;
        @NotNull
        private final ImageView playContentIv;

        public PPTOutlineViewHolder(View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.content_tv);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.content_tv)");
            this.contentTv = (TextView)view;
            View view2 = itemView.findViewById(R.id.play_status_iv);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"itemView.findViewById(R.id.play_status_iv)");
            this.playStatusIv = (ImageView)view2;
            View view3 = itemView.findViewById(R.id.play_content_iv);
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"itemView.findViewById(R.id.play_content_iv)");
            this.playContentIv = (ImageView)view3;
        }

        @NotNull
        public final TextView getContentTv() {
            return this.contentTv;
        }

        @NotNull
        public final ImageView getPlayStatusIv() {
            return this.playStatusIv;
        }

        @NotNull
        public final ImageView getPlayContentIv() {
            return this.playContentIv;
        }
    }
}

