/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.component;

import android.content.Context;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TableLayout;
import android.widget.TextView;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.constant.MediaPlayerDebugInfo;
import com.baijiayun.videoplayer.IBJYVideoPlayer;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.component.BaseComponent;
import com.baijiayun.videoplayer.util.VideoPlayerUtils;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class MediaPlayerDebugInfoComponent
extends BaseComponent {
    private TableLayout mTableLayout;
    private Disposable disposable;
    private SparseArray<View> mRowMap = new SparseArray();

    public MediaPlayerDebugInfoComponent(Context context) {
        super(context);
        this.initView();
    }

    @Override
    protected View onCreateComponentView(Context context) {
        return View.inflate((Context)context, (int)R.layout.bjy_pb_table_media_info, null);
    }

    private void initView() {
        this.mTableLayout = (TableLayout)this.findViewById(R.id.table);
    }

    @Override
    protected void setKey() {
        this.key = "video_info_component";
    }

    @Override
    public void bindVideoPlayer(IBJYVideoPlayer videoPlayer) {
        super.bindVideoPlayer(videoPlayer);
        this.disposable = Observable.interval((long)0L, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            MediaPlayerDebugInfo debugInfo = this.getVideoPlayer().getMediaPlayerDebugInfo();
            this.setRowValue(R.string.video_format, debugInfo.videoFormat);
            this.setRowValue(R.string.vdec, debugInfo.vdec);
            this.setRowValue(R.string.fps, String.format(Locale.US, "%.2f / %.2f", Float.valueOf(debugInfo.fpsDecode), Float.valueOf(debugInfo.fpsOutput)));
            this.setRowValue(R.string.v_cache, String.format(Locale.US, "%s, %s", VideoPlayerUtils.formatDurationMilli((long)debugInfo.videoCachedDuration), VideoPlayerUtils.formatSize((long)debugInfo.videoCachedBytes)));
            this.setRowValue(R.string.a_cache, String.format(Locale.US, "%s, %s", VideoPlayerUtils.formatDurationMilli((long)debugInfo.audioCachedDuration), VideoPlayerUtils.formatSize((long)debugInfo.audioCachedBytes)));
            this.setRowValue(R.string.seek_load_cost, String.format(Locale.US, "%d ms", debugInfo.seekLoadDuration));
            this.setRowValue(R.string.tcp_speed, String.format(Locale.US, "%s", VideoPlayerUtils.formatSpeed((long)debugInfo.tcpSpeed, (long)1000L)));
            this.setRowValue(R.string.bit_rate, String.format(Locale.US, "%.2f kbs", Float.valueOf((float)debugInfo.bitRate / 1000.0f)));
        });
    }

    private void setRowValue(int id2, String value) {
        View rowView = (View)this.mRowMap.get(id2);
        if (rowView == null) {
            rowView = this.appendRow(this.getContext().getString(id2), value);
            this.mRowMap.put(id2, (Object)rowView);
        } else {
            this.setValueText(rowView, value);
        }
    }

    private View appendRow(String name, String value) {
        ViewGroup rowView = (ViewGroup)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.bjy_pb_table_media_info_row1, (ViewGroup)this.mTableLayout, false);
        this.setNameValueText((View)rowView, name, value);
        this.mTableLayout.addView((View)rowView);
        return rowView;
    }

    private void setValueText(View rowView, String value) {
        ViewHolder viewHolder = this.obtainViewHolder(rowView);
        viewHolder.setValue(value);
    }

    private void setNameValueText(View rowView, String name, String value) {
        ViewHolder viewHolder = this.obtainViewHolder(rowView);
        viewHolder.setName(name);
        viewHolder.setValue(value);
    }

    private ViewHolder obtainViewHolder(View rowView) {
        ViewHolder viewHolder = (ViewHolder)rowView.getTag();
        if (viewHolder == null) {
            viewHolder = new ViewHolder();
            viewHolder.mNameTextView = (TextView)rowView.findViewById(R.id.name);
            viewHolder.mValueTextView = (TextView)rowView.findViewById(R.id.value);
            rowView.setTag((Object)viewHolder);
        }
        return viewHolder;
    }

    @Override
    public void destroy() {
        super.destroy();
        RxUtils.dispose((Disposable)this.disposable);
        this.mRowMap.clear();
    }

    private static class ViewHolder {
        private TextView mNameTextView;
        private TextView mValueTextView;

        private ViewHolder() {
        }

        public void setName(String name) {
            if (this.mNameTextView != null) {
                this.mNameTextView.setText((CharSequence)name);
            }
        }

        public void setValue(String value) {
            if (this.mValueTextView != null) {
                this.mValueTextView.setText((CharSequence)value);
            }
        }
    }
}

