/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.component;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import com.baijiayun.livebase.models.LPHorseLamp;
import com.baijiayun.livebase.widgets.HorseLampView;
import com.baijiayun.videoplayer.player.PlayerStatus;
import com.baijiayun.videoplayer.ui.bean.VideoPlayerConfig;
import com.baijiayun.videoplayer.ui.component.BaseComponent;
import com.baijiayun.videoplayer.ui.utils.PBUIUtils;

public class HorseLampComponent
extends BaseComponent {
    private HorseLampView horseLampView;
    private VideoPlayerConfig videoPlayerConfig;

    public HorseLampComponent(Context context) {
        super(context);
    }

    @Override
    protected View onCreateComponentView(Context context) {
        this.horseLampView = new HorseLampView(context);
        return this.horseLampView;
    }

    @Override
    protected void setKey() {
        this.key = "horse_lamp_component";
    }

    @Override
    public void onCustomEvent(int eventCode, Bundle bundle) {
        super.onCustomEvent(eventCode, bundle);
        if (eventCode == -80049) {
            this.videoPlayerConfig = (VideoPlayerConfig)bundle.getSerializable("videoConfig");
        }
    }

    @Override
    public void onPlayerEvent(int eventCode, Bundle bundle) {
        LPHorseLamp horseLamp;
        PlayerStatus playerStatus;
        super.onPlayerEvent(eventCode, bundle);
        if (eventCode == -99031 && (playerStatus = (PlayerStatus)bundle.getSerializable("serializable_data")) == PlayerStatus.STATE_PREPARED && (horseLamp = PBUIUtils.checkHorseLampConfig(this.getVideoPlayer().getHorseLamp(), this.videoPlayerConfig)) != null) {
            this.horseLampView.startHorseLamp(horseLamp);
        }
    }
}

