/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.viewmodel;

import android.content.Context;
import android.text.TextUtils;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.constant.VideoType;
import com.baijiayun.playback.dataloader.PlayerDataLoader;
import com.baijiayun.videoplayer.IBJYVideoPlayer;
import com.baijiayun.videoplayer.bean.AlbumInfoModel;
import com.baijiayun.videoplayer.bean.TripartiteScreen;
import com.baijiayun.videoplayer.bean.VideoItem;
import com.baijiayun.videoplayer.player.PlayerStatus;
import com.baijiayun.videoplayer.ui.bean.SignModel;
import com.baijiayun.videoplayer.ui.bean.VisitorModel;
import com.baijiayun.videoplayer.ui.viewmodel.VideoPlayViewModel;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020?2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020\u000f2\b\b\u0002\u0010A\u001a\u00020BJ\b\u0010C\u001a\u00020\u0005H\u0014J\u000e\u0010D\u001a\u00020\u00052\u0006\u0010E\u001a\u00020)J\u000e\u0010F\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u001bJ\u0014\u0010H\u001a\u00020\u00052\f\u0010I\u001a\b\u0012\u0004\u0012\u00020)0JJ \u0010K\u001a\u00020\u00052\u0006\u0010>\u001a\u00020?2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010L\u001a\u00020BR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0007R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0007R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0007R*\u0010.\u001a\u001e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020)0/j\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020)`0X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u00102\u001a\b\u0012\u0004\u0012\u0002030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0007R\u0017\u00105\u001a\b\u0012\u0004\u0012\u0002060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u0007R\u001a\u00108\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<\u00a8\u0006M"}, d2={"Lcom/baijiayun/videoplayer/ui/viewmodel/VideoPlayViewModel;", "Landroidx/lifecycle/ViewModel;", "()V", "albumError", "Landroidx/lifecycle/MutableLiveData;", "", "getAlbumError", "()Landroidx/lifecycle/MutableLiveData;", "albumInfoModelList", "Ljava/util/ArrayList;", "Lcom/baijiayun/videoplayer/bean/AlbumInfoModel;", "Lkotlin/collections/ArrayList;", "getAlbumInfoModelList", "()Ljava/util/ArrayList;", "albumNo", "", "getAlbumNo", "()Ljava/lang/String;", "setAlbumNo", "(Ljava/lang/String;)V", "albumReady", "getAlbumReady", "albumUpdate", "getAlbumUpdate", "bjyVideoPlayer", "Lcom/baijiayun/videoplayer/IBJYVideoPlayer;", "cacheTime", "", "getCacheTime", "()I", "setCacheTime", "(I)V", "defaultAlbumIndex", "getDefaultAlbumIndex", "setDefaultAlbumIndex", "disposableOfVideoAlbumInfo", "Lio/reactivex/disposables/Disposable;", "disposableOfVideoToken", "playingTimeLiveData", "getPlayingTimeLiveData", "showSignDialog", "Lcom/baijiayun/videoplayer/ui/bean/SignModel;", "getShowSignDialog", "showVisitorDialog", "Lcom/baijiayun/videoplayer/ui/bean/VisitorModel;", "getShowVisitorDialog", "signModelMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "subscriptionOfVideoInfo", "tripartiteScreenLiveData", "Lcom/baijiayun/videoplayer/bean/TripartiteScreen;", "getTripartiteScreenLiveData", "videoItemLiveData", "Lcom/baijiayun/videoplayer/bean/VideoItem;", "getVideoItemLiveData", "visitorModel", "getVisitorModel", "()Lcom/baijiayun/videoplayer/ui/bean/VisitorModel;", "setVisitorModel", "(Lcom/baijiayun/videoplayer/ui/bean/VisitorModel;)V", "getPlayInfoByAlbum", "context", "Landroid/content/Context;", "vid", "isInner", "", "onCleared", "onSign", "signModel", "seek", "time", "setSignModelList", "signModelList", "", "subscribe", "isVideoPlayTriple", "videoplayer-ui_release"})
public final class VideoPlayViewModel
extends ViewModel {
    @NotNull
    private final MutableLiveData<TripartiteScreen> tripartiteScreenLiveData = new MutableLiveData();
    @NotNull
    private final MutableLiveData<Integer> playingTimeLiveData = new MutableLiveData();
    @NotNull
    private final MutableLiveData<SignModel> showSignDialog = new MutableLiveData();
    @Nullable
    private Disposable subscriptionOfVideoInfo;
    @Nullable
    private IBJYVideoPlayer bjyVideoPlayer;
    @NotNull
    private final HashMap<Integer, SignModel> signModelMap = new HashMap();
    @NotNull
    private VisitorModel visitorModel = new VisitorModel();
    @NotNull
    private final MutableLiveData<VisitorModel> showVisitorDialog = new MutableLiveData();
    private int cacheTime = -1;
    @Nullable
    private Disposable disposableOfVideoAlbumInfo;
    @Nullable
    private Disposable disposableOfVideoToken;
    @Nullable
    private String albumNo;
    @NotNull
    private final MutableLiveData<Unit> albumError = new MutableLiveData();
    @NotNull
    private final ArrayList<AlbumInfoModel> albumInfoModelList = new ArrayList();
    @NotNull
    private final MutableLiveData<Unit> albumReady = new MutableLiveData();
    @NotNull
    private final MutableLiveData<Unit> albumUpdate = new MutableLiveData();
    private int defaultAlbumIndex;
    @NotNull
    private final MutableLiveData<VideoItem> videoItemLiveData = new MutableLiveData();

    @NotNull
    public final MutableLiveData<TripartiteScreen> getTripartiteScreenLiveData() {
        return this.tripartiteScreenLiveData;
    }

    @NotNull
    public final MutableLiveData<Integer> getPlayingTimeLiveData() {
        return this.playingTimeLiveData;
    }

    @NotNull
    public final MutableLiveData<SignModel> getShowSignDialog() {
        return this.showSignDialog;
    }

    @NotNull
    public final VisitorModel getVisitorModel() {
        return this.visitorModel;
    }

    public final void setVisitorModel(@NotNull VisitorModel visitorModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)visitorModel), (String)"<set-?>");
        this.visitorModel = visitorModel;
    }

    @NotNull
    public final MutableLiveData<VisitorModel> getShowVisitorDialog() {
        return this.showVisitorDialog;
    }

    public final int getCacheTime() {
        return this.cacheTime;
    }

    public final void setCacheTime(int n) {
        this.cacheTime = n;
    }

    @Nullable
    public final String getAlbumNo() {
        return this.albumNo;
    }

    public final void setAlbumNo(@Nullable String string2) {
        this.albumNo = string2;
    }

    @NotNull
    public final MutableLiveData<Unit> getAlbumError() {
        return this.albumError;
    }

    @NotNull
    public final ArrayList<AlbumInfoModel> getAlbumInfoModelList() {
        return this.albumInfoModelList;
    }

    @NotNull
    public final MutableLiveData<Unit> getAlbumReady() {
        return this.albumReady;
    }

    @NotNull
    public final MutableLiveData<Unit> getAlbumUpdate() {
        return this.albumUpdate;
    }

    public final int getDefaultAlbumIndex() {
        return this.defaultAlbumIndex;
    }

    public final void setDefaultAlbumIndex(int n) {
        this.defaultAlbumIndex = n;
    }

    @NotNull
    public final MutableLiveData<VideoItem> getVideoItemLiveData() {
        return this.videoItemLiveData;
    }

    public final void subscribe(@NotNull Context context, @NotNull IBJYVideoPlayer bjyVideoPlayer, boolean isVideoPlayTriple) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bjyVideoPlayer, (String)"bjyVideoPlayer");
        this.bjyVideoPlayer = bjyVideoPlayer;
        this.subscriptionOfVideoInfo = bjyVideoPlayer.getLoadVideoInfoObservable().map(arg_0 -> VideoPlayViewModel.subscribe$lambda$0((Function1)new Function1<VideoItem, VideoItem>(this){
            final /* synthetic */ VideoPlayViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final VideoItem invoke(@NotNull VideoItem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getVideoItemLiveData().setValue((Object)it);
                return it;
            }
        }, arg_0)).filter(arg_0 -> VideoPlayViewModel.subscribe$lambda$1((Function1)new Function1<VideoItem, Boolean>(isVideoPlayTriple){
            final /* synthetic */ boolean $isVideoPlayTriple;
            {
                this.$isVideoPlayTriple = $isVideoPlayTriple;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull VideoItem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$isVideoPlayTriple;
            }
        }, arg_0)).filter(arg_0 -> VideoPlayViewModel.subscribe$lambda$2(subscribe.3.INSTANCE, arg_0)).map(arg_0 -> VideoPlayViewModel.subscribe$lambda$3(subscribe.4.INSTANCE, arg_0)).observeOn(AndroidSchedulers.mainThread()).subscribe(arg_0 -> VideoPlayViewModel.subscribe$lambda$4((Function1)new Function1<VideoItem, Unit>(this){
            final /* synthetic */ VideoPlayViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(VideoItem it) {
                this.this$0.getTripartiteScreenLiveData().setValue((Object)it.tripartiteScreen);
            }
        }, arg_0));
        bjyVideoPlayer.addOnPlayerStatusChangeListener(arg_0 -> VideoPlayViewModel.subscribe$lambda$5(bjyVideoPlayer, this, arg_0));
        bjyVideoPlayer.addOnPlayingTimeChangeListener((arg_0, arg_1) -> VideoPlayViewModel.subscribe$lambda$6(this, bjyVideoPlayer, arg_0, arg_1));
        bjyVideoPlayer.addOnSeekCompleteListener((arg_0, arg_1) -> VideoPlayViewModel.subscribe$lambda$7(this, bjyVideoPlayer, arg_0, arg_1));
        if (!TextUtils.isEmpty((CharSequence)this.albumNo)) {
            this.disposableOfVideoAlbumInfo = PlayerDataLoader.getInstance((Context)context).getObservableOfAlbumInfoVideoList(this.albumNo).subscribe(arg_0 -> VideoPlayViewModel.subscribe$lambda$8((Function1)new Function1<List<AlbumInfoModel>, Unit>(this, context){
                final /* synthetic */ VideoPlayViewModel this$0;
                final /* synthetic */ Context $context;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    super(1);
                }

                public final void invoke(List<AlbumInfoModel> it) {
                    if (it.isEmpty()) {
                        this.this$0.getAlbumError().setValue((Object)Unit.INSTANCE);
                    } else {
                        this.this$0.getAlbumInfoModelList().clear();
                        this.this$0.getAlbumInfoModelList().addAll((Collection<AlbumInfoModel>)it);
                        String string2 = this.this$0.getAlbumNo();
                        Intrinsics.checkNotNull((Object)string2);
                        this.this$0.getPlayInfoByAlbum(this.$context, string2, String.valueOf(it.get((int)(this.this$0.getDefaultAlbumIndex() % it.size())).videoUnique), true);
                    }
                }
            }, arg_0), arg_0 -> VideoPlayViewModel.subscribe$lambda$9((Function1)new Function1<Throwable, Unit>(this){
                final /* synthetic */ VideoPlayViewModel this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(Throwable it) {
                    this.this$0.getAlbumError().setValue((Object)Unit.INSTANCE);
                }
            }, arg_0));
        }
    }

    public static /* synthetic */ void subscribe$default(VideoPlayViewModel videoPlayViewModel, Context context, IBJYVideoPlayer iBJYVideoPlayer, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        videoPlayViewModel.subscribe(context, iBJYVideoPlayer, bl);
    }

    public final void getPlayInfoByAlbum(@NotNull Context context, @NotNull String albumNo, @NotNull String vid, boolean isInner) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)albumNo, (String)"albumNo");
        Intrinsics.checkNotNullParameter((Object)vid, (String)"vid");
        this.disposableOfVideoToken = PlayerDataLoader.getInstance((Context)context).getObservableOfPlayInfoByAlbum(albumNo, vid).subscribe(arg_0 -> VideoPlayViewModel.getPlayInfoByAlbum$lambda$10((Function1)new Function1<AlbumInfoModel, Unit>(this, isInner){
            final /* synthetic */ VideoPlayViewModel this$0;
            final /* synthetic */ boolean $isInner;
            {
                this.this$0 = $receiver;
                this.$isInner = $isInner;
                super(1);
            }

            public final void invoke(AlbumInfoModel it) {
                for (AlbumInfoModel albumInfo : this.this$0.getAlbumInfoModelList()) {
                    if (albumInfo.videoUnique != it.videoId) continue;
                    albumInfo.playerToken = it.playerToken;
                    if (this.$isInner) {
                        this.this$0.getAlbumReady().setValue((Object)Unit.INSTANCE);
                        break;
                    }
                    this.this$0.getAlbumUpdate().setValue((Object)Unit.INSTANCE);
                    break;
                }
            }
        }, arg_0));
    }

    public static /* synthetic */ void getPlayInfoByAlbum$default(VideoPlayViewModel videoPlayViewModel, Context context, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        videoPlayViewModel.getPlayInfoByAlbum(context, string2, string3, bl);
    }

    public final void setSignModelList(@NotNull List<? extends SignModel> signModelList) {
        Intrinsics.checkNotNullParameter(signModelList, (String)"signModelList");
        if (!((Collection)signModelList).isEmpty()) {
            Collections.sort(signModelList, (arg_0, arg_1) -> VideoPlayViewModel.setSignModelList$lambda$11(setSignModelList.1.INSTANCE, arg_0, arg_1));
            for (SignModel signModel : signModelList) {
                ((Map)this.signModelMap).put(signModel.seconds, signModel);
            }
        }
    }

    public final void seek(int time) {
        block1: {
            IBJYVideoPlayer iBJYVideoPlayer = this.bjyVideoPlayer;
            if (iBJYVideoPlayer == null) break block1;
            IBJYVideoPlayer $this$seek_u24lambda_u2412 = iBJYVideoPlayer;
            boolean bl = false;
            if ($this$seek_u24lambda_u2412.getVideoType() == VideoType.ContentVideo) {
                $this$seek_u24lambda_u2412.seek(time);
            }
        }
    }

    public final void onSign(@NotNull SignModel signModel) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)signModel, (String)"signModel");
            this.signModelMap.remove(signModel.seconds);
            IBJYVideoPlayer iBJYVideoPlayer = this.bjyVideoPlayer;
            if (iBJYVideoPlayer == null) break block0;
            iBJYVideoPlayer.play();
        }
    }

    protected void onCleared() {
        super.onCleared();
        RxUtils.Companion.dispose(this.subscriptionOfVideoInfo);
        RxUtils.Companion.dispose(this.disposableOfVideoAlbumInfo);
        RxUtils.Companion.dispose(this.disposableOfVideoToken);
    }

    private static final VideoItem subscribe$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VideoItem)$tmp0.invoke(p0);
    }

    private static final boolean subscribe$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean subscribe$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final VideoItem subscribe$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VideoItem)$tmp0.invoke(p0);
    }

    private static final void subscribe$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void subscribe$lambda$5(IBJYVideoPlayer $bjyVideoPlayer, VideoPlayViewModel this$0, PlayerStatus it) {
        Intrinsics.checkNotNullParameter((Object)$bjyVideoPlayer, (String)"$bjyVideoPlayer");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (it == PlayerStatus.STATE_PREPARED) {
            int videoMemoryPoint = $bjyVideoPlayer.getVideoMemoryPoint();
            if (!((Map)this$0.signModelMap).isEmpty()) {
                Iterator<Integer> iterator = this$0.signModelMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Integer n = iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"iterator.next()");
                    int value = ((Number)n).intValue();
                    if (value >= videoMemoryPoint) continue;
                    iterator.remove();
                }
            }
        }
    }

    private static final void subscribe$lambda$6(VideoPlayViewModel this$0, IBJYVideoPlayer $bjyVideoPlayer, int currentTime, int n) {
        Integer n2;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$bjyVideoPlayer, (String)"$bjyVideoPlayer");
        if (this$0.cacheTime < currentTime) {
            this$0.cacheTime = currentTime;
        }
        if (!((Map)this$0.signModelMap).isEmpty() && ((Map)this$0.signModelMap).containsKey(n2 = Integer.valueOf(currentTime))) {
            this$0.showSignDialog.setValue((Object)this$0.signModelMap.get(currentTime));
            $bjyVideoPlayer.pause();
        }
        if (this$0.visitorModel.seconds == currentTime) {
            this$0.showVisitorDialog.setValue((Object)this$0.visitorModel);
            $bjyVideoPlayer.pause();
            this$0.visitorModel.seconds = Integer.MAX_VALUE;
        }
        this$0.playingTimeLiveData.setValue((Object)currentTime);
    }

    private static final void subscribe$lambda$7(VideoPlayViewModel this$0, IBJYVideoPlayer $bjyVideoPlayer, int beforeSeekPosition, int seekPosition) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$bjyVideoPlayer, (String)"$bjyVideoPlayer");
        this$0.playingTimeLiveData.setValue((Object)seekPosition);
        if (!((Map)this$0.signModelMap).isEmpty()) {
            for (Integer value : this$0.signModelMap.keySet()) {
                int n = beforeSeekPosition + 1;
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                int n2 = value;
                boolean bl = n <= n2 ? n2 < seekPosition : false;
                if (!bl) continue;
                this$0.showSignDialog.setValue((Object)this$0.signModelMap.get(value));
                $bjyVideoPlayer.seek(value.intValue());
                $bjyVideoPlayer.pause();
                break;
            }
        }
        if (this$0.visitorModel.seconds <= seekPosition) {
            this$0.showVisitorDialog.setValue((Object)this$0.visitorModel);
            $bjyVideoPlayer.seek(this$0.visitorModel.seconds);
            $bjyVideoPlayer.pause();
            this$0.visitorModel.seconds = Integer.MAX_VALUE;
        }
    }

    private static final void subscribe$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void subscribe$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void getPlayInfoByAlbum$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final int setSignModelList$lambda$11(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

