/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.playback.toolbox.quiz;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.WindowManager;
import android.webkit.JavascriptInterface;
import android.widget.ProgressBar;
import androidx.appcompat.app.AlertDialog;
import com.baijiayun.BJYPlayerSDK;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.constant.HostConfig;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.livebase.models.LPJsonModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.playback.util.PBJsonUtils;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.playback.toolbox.quiz.QuizDialogContract;
import com.google.gson.JsonObject;
import com.tencent.smtt.export.external.interfaces.WebResourceError;
import com.tencent.smtt.export.external.interfaces.WebResourceRequest;
import com.tencent.smtt.sdk.WebChromeClient;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class QuizDialogFragment
extends BaseDialogFragment
implements QuizDialogContract.View {
    private static final String ARGS_TYPE = "1";
    private static final String WINDOW_NAME = "bjlapp";
    private QuizDialogContract.Presenter presenter;
    private IUserModel currentUserInfo;
    private String quizId;
    private String roomToken;
    private String roomId;
    private List<LPJsonModel> signalList = new ArrayList<LPJsonModel>();
    private boolean isUrlLoaded;
    private boolean isDestroyed = false;
    private WebView webview;

    protected int getLayoutId() {
        return R.layout.bjy_pb_fragment_pb_quiz;
    }

    protected void init(Bundle savedInstanceState, Bundle arguments) {
        this.title(this.getString(R.string.live_quiz_title));
        this.initWebClient();
        this.loadUrl();
        this.setCloseBtnStatus();
    }

    public void setCloseBtnStatus() {
        if (this.presenter == null) {
            return;
        }
        this.editable(true);
        this.editText(this.getString(R.string.live_quiz_close));
        this.editClick(v -> this.showCloseDlg());
    }

    private void showCloseDlg() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        AlertDialog dialog = builder.setMessage(R.string.live_quiz_dialog_tip).setPositiveButton(R.string.live_quiz_dialog_confirm, (dialog1, which) -> {
            dialog1.dismiss();
            if (this.presenter != null) {
                this.presenter.dismissDlg();
            }
        }).setNegativeButton(R.string.live_quiz_dialog_cancel, (dialog12, which) -> dialog12.dismiss()).create();
        dialog.show();
        dialog.getButton(-1).setTextColor(this.getResources().getColor(R.color.live_blue));
        dialog.getButton(-2).setTextColor(this.getResources().getColor(R.color.live_blue));
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebClient() {
        this.webview = (WebView)this.$.id(R.id.wv_quiz_main).view();
        this.webview.getSettings().setJavaScriptEnabled(true);
        this.webview.addJavascriptInterface((Object)this, WINDOW_NAME);
        this.webview.setVerticalScrollBarEnabled(false);
        this.webview.getSettings().setDomStorageEnabled(true);
        this.webview.getSettings().setAppCacheMaxSize(0x800000L);
        String appCachePath = this.getActivity().getApplicationContext().getCacheDir().getAbsolutePath();
        this.webview.getSettings().setAppCachePath(appCachePath);
        this.webview.getSettings().setAppCacheEnabled(true);
        this.webview.getSettings().setCacheMode(-1);
        this.webview.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                ((ProgressBar)QuizDialogFragment.this.$.id(R.id.pb_web_view_quiz).view()).setProgress(newProgress);
                super.onProgressChanged(view, newProgress);
            }
        });
        this.webview.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                QuizDialogFragment.this.$.id(R.id.pb_web_view_quiz).visible();
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                if (QuizDialogFragment.this.isDestroyed) {
                    return;
                }
                QuizDialogFragment.this.isUrlLoaded = true;
                QuizDialogFragment.this.$.id(R.id.pb_web_view_quiz).gone();
                QuizDialogFragment.this.callJsInQueue();
            }

            @TargetApi(value=23)
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                if (error.getErrorCode() != -11) {
                    QuizDialogFragment.this.$.id(R.id.pb_web_view_quiz).gone();
                }
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                if (errorCode != -11) {
                    QuizDialogFragment.this.$.id(R.id.pb_web_view_quiz).gone();
                }
            }
        });
    }

    private void loadUrl() {
        try {
            this.roomToken = URLEncoder.encode(this.roomToken, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String params = "?userNumber=12580&userName=xiaoming&quizId=" + this.quizId + "&roomId=" + this.roomId + "&token=" + this.roomToken + "&argType=" + ARGS_TYPE + "&userGroup=" + this.currentUserInfo.getGroup() + "&isPlayback=1";
        String host = HostConfig.HOSTS_WEB[BJYPlayerSDK.DEPLOY_TYPE.getType()];
        String url = host.concat("/m/quiz/student").concat(params);
        LPLogger.d((String)(this.getClass().getSimpleName() + " : " + url));
        ((WebView)this.$.id(R.id.wv_quiz_main).view()).loadUrl(url);
    }

    protected void setWindowParams(WindowManager.LayoutParams windowParams) {
        windowParams.width = -1;
        windowParams.height = -1;
        windowParams.gravity = 17;
        windowParams.x = 0;
        windowParams.y = 0;
        windowParams.windowAnimations = R.style.LiveBaseSendMsgDialogAnim;
    }

    @Override
    public void setPresenter(QuizDialogContract.Presenter presenter) {
        this.presenter = presenter;
        presenter.getCurrentUser();
        this.roomToken = presenter.getRoomToken();
        this.roomId = presenter.getRoomId();
    }

    @Override
    public void onStartArrived(LPJsonModel jsonModel) {
        String key = jsonModel.data.get("message_type").getAsString();
        if (!"quiz_start".equals(key)) {
            return;
        }
        this.quizId = PBJsonUtils.isJsonNull((JsonObject)jsonModel.data, (String)"quiz_id") ? "" : jsonModel.data.get("quiz_id").getAsString();
        this.signalList.add(jsonModel);
    }

    @Override
    public void onEndArrived(LPJsonModel jsonModel) {
        String key = jsonModel.data.get("message_type").getAsString();
        if (!"quiz_end".equals(key)) {
            return;
        }
        this.signalList.add(jsonModel);
        if (this.isUrlLoaded) {
            this.callJs(jsonModel.data.toString());
        }
    }

    @Override
    public void onSolutionArrived(LPJsonModel jsonModel) {
        String key = jsonModel.data.get("message_type").getAsString();
        if (!"quiz_solution".equals(key)) {
            return;
        }
        this.quizId = PBJsonUtils.isJsonNull((JsonObject)jsonModel.data, (String)"quiz_id") ? "" : jsonModel.data.get("quiz_id").getAsString();
        this.signalList.add(jsonModel);
    }

    @Override
    public void onQuizResArrived(LPJsonModel jsonModel) {
        String key = jsonModel.data.get("message_type").getAsString();
        if (!"quiz_res".equals(key)) {
            return;
        }
        this.quizId = PBJsonUtils.isJsonNull((JsonObject)jsonModel.data, (String)"quiz_id") ? "" : jsonModel.data.get("quiz_id").getAsString();
        this.signalList.add(jsonModel);
    }

    @Override
    public void onGetCurrentUser(IUserModel userModel) {
        this.currentUserInfo = userModel;
    }

    private void callJsInQueue() {
        if (this.signalList != null && this.signalList.size() > 0) {
            for (LPJsonModel jsonModel : this.signalList) {
                this.callJs(jsonModel.data.toString());
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.isDestroyed = true;
        this.presenter = null;
        if (this.signalList != null) {
            this.signalList.clear();
        }
        if (this.webview != null) {
            this.webview.destroy();
        }
    }

    @JavascriptInterface
    public void sendMessage(String json) {
        if (!TextUtils.isEmpty((CharSequence)json)) {
            this.presenter.submitAnswer(json);
        }
    }

    private void callJs(String json) {
        ((WebView)this.$.id(R.id.wv_quiz_main).view()).loadUrl("javascript:bjlapp.receivedMessage(" + json + ")");
    }
}

