/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.component;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import com.baijiayun.videoplayer.player.PlayerStatus;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.component.BaseComponent;

public class LoadingComponent
extends BaseComponent {
    private TextView loadingTipTv;

    public LoadingComponent(Context context) {
        super(context);
        this.initView();
    }

    @Override
    protected View onCreateComponentView(Context context) {
        return View.inflate((Context)context, (int)R.layout.bjy_pb_layout_loading_component, null);
    }

    private void initView() {
        this.loadingTipTv = (TextView)this.findViewById(R.id.loading_tips_tv);
    }

    @Override
    protected void setKey() {
        this.key = "loading_component";
    }

    @Override
    public void onPlayerEvent(int eventCode, Bundle bundle) {
        block0 : switch (eventCode) {
            case -99031: {
                PlayerStatus playerStatus = (PlayerStatus)bundle.getSerializable("serializable_data");
                if (playerStatus == null) {
                    return;
                }
                switch (playerStatus) {
                    case STATE_INITIALIZED: {
                        this.setLoadingState(true);
                        break block0;
                    }
                    case STATE_ERROR: 
                    case STATE_STOPPED: 
                    case STATE_PREPARED: 
                    case STATE_PLAYBACK_COMPLETED: {
                        this.setLoadingState(false);
                        break block0;
                    }
                }
                break;
            }
            case -80010: {
                if (this.getVideoPlayer().isPlayLocalVideo()) break;
                this.setLoadingState(true);
                break;
            }
            case -80011: {
                if (this.getVideoPlayer().isPlayLocalVideo()) break;
                this.setLoadingState(false);
                break;
            }
        }
    }

    @Override
    public void onErrorEvent(int eventCode, Bundle bundle) {
        this.setLoadingState(false);
    }

    @Override
    public void onCustomEvent(int eventCode, Bundle bundle) {
        super.onCustomEvent(eventCode, bundle);
        switch (eventCode) {
            case -80018: 
            case -80012: {
                this.setLoadingState(false);
                break;
            }
            case -80017: {
                this.setLoadingState(true);
                break;
            }
        }
    }

    private void setLoadingState(boolean show) {
        this.setComponentVisibility(show ? 0 : 8);
    }

    private void setTips(String tips) {
        this.loadingTipTv.setText((CharSequence)tips);
    }
}

